/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.misc.BoofLambdas;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class MassageSingularValues {
    protected SingularValueDecomposition_F64<DMatrixRMaj> svd;
    protected DMatrixRMaj U;
    protected DMatrixRMaj W;
    protected DMatrixRMaj V;
    protected DMatrixRMaj temp0 = new DMatrixRMaj(1, 1);
    BoofLambdas.ProcessObject<DMatrixRMaj> massageSingular;

    public MassageSingularValues(SingularValueDecomposition_F64<DMatrixRMaj> svd, BoofLambdas.ProcessObject<DMatrixRMaj> massageSingular) {
        this.svd = svd;
        this.massageSingular = massageSingular;
    }

    public MassageSingularValues(BoofLambdas.ProcessObject<DMatrixRMaj> massageSingular) {
        this.svd = DecompositionFactory_DDRM.svd(true, true, true);
        this.massageSingular = massageSingular;
    }

    public MassageSingularValues() {
        this(F -> {});
    }

    public boolean process(DMatrixRMaj E) {
        return this.process(E, this.massageSingular);
    }

    public boolean process(DMatrixRMaj E, BoofLambdas.ProcessObject<DMatrixRMaj> massageSingular) {
        if (!this.svd.decompose(E)) {
            return false;
        }
        this.V = this.svd.getV(this.V, false);
        this.U = this.svd.getU(this.U, false);
        this.W = this.svd.getW(this.W);
        SingularOps_DDRM.descendingOrder(this.U, false, this.W, this.V, false);
        massageSingular.process(this.W);
        CommonOps_DDRM.mult(this.U, this.W, this.temp0);
        CommonOps_DDRM.multTransB(this.temp0, this.V, E);
        return true;
    }
}

