/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class HessianThreeDeterminant_Inner_MT {
    public static void process(GrayU8 input, GrayS16 output) {
        byte[] src = input.data;
        short[] dst = output.data;
        int width = input.getWidth();
        int height = input.getHeight() - 2;
        int stride = input.stride;
        int s2 = 2 * stride;
        BoofConcurrency.loopFor(2, height, y -> {
            int index;
            int indexOut = output.startIndex + output.stride * y + 2;
            int endX = index + width - 4;
            for (index = input.startIndex + stride * y + 2; index < endX; ++index) {
                int center = src[index] & 0xFF;
                int Lxx = (src[index - 2] & 0xFF) - 2 * center + (src[index + 2] & 0xFF);
                int Lyy = (src[index - s2] & 0xFF) - 2 * center + (src[index + s2] & 0xFF);
                int Lxy = (src[index - stride - 1] & 0xFF) + (src[index + stride + 1] & 0xFF);
                dst[indexOut++] = (short)(Lxx * Lyy - (Lxy -= (src[index - stride + 1] & 0xFF) + (src[index + stride - 1] & 0xFF)) * Lxy);
            }
        });
    }

    public static void process(GrayU8 input, GrayF32 output) {
        byte[] src = input.data;
        float[] dst = output.data;
        int width = input.getWidth();
        int height = input.getHeight() - 2;
        int stride = input.stride;
        int s2 = 2 * stride;
        BoofConcurrency.loopFor(2, height, y -> {
            int index;
            int indexOut = output.startIndex + output.stride * y + 2;
            int endX = index + width - 4;
            for (index = input.startIndex + stride * y + 2; index < endX; ++index) {
                int center = src[index] & 0xFF;
                int Lxx = (src[index - 2] & 0xFF) - 2 * center + (src[index + 2] & 0xFF);
                int Lyy = (src[index - s2] & 0xFF) - 2 * center + (src[index + s2] & 0xFF);
                int Lxy = (src[index - stride - 1] & 0xFF) + (src[index + stride + 1] & 0xFF);
                dst[indexOut++] = Lxx * Lyy - (Lxy -= (src[index - stride + 1] & 0xFF) + (src[index + stride - 1] & 0xFF)) * Lxy;
            }
        });
    }

    public static void process(GrayF32 input, GrayF32 output) {
        float[] src = input.data;
        float[] dst = output.data;
        int width = input.getWidth();
        int height = input.getHeight() - 2;
        int stride = input.stride;
        int s2 = 2 * stride;
        BoofConcurrency.loopFor(2, height, y -> {
            int index;
            int indexOut = output.startIndex + output.stride * y + 2;
            int endX = index + width - 4;
            for (index = input.startIndex + stride * y + 2; index < endX; ++index) {
                float center = src[index];
                float Lxx = src[index - 2] - 2.0f * center + src[index + 2];
                float Lyy = src[index - s2] - 2.0f * center + src[index + s2];
                float Lxy = src[index - stride - 1] + src[index + stride + 1] - (src[index - stride + 1] + src[index + stride - 1]);
                dst[indexOut++] = Lxx * Lyy - Lxy * Lxy;
            }
        });
    }
}

