/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class GradientFamilyAB_MT {
    public static void process(GrayU8 src, int kerA, int kerB, GrayS16 derivX, GrayS16 derivY) {
        byte[] data = src.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = src.getWidth();
        int height = src.getHeight() - 1;
        int strideSrc = src.getStride();
        BoofConcurrency.loopFor(1, height, y -> {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int a11 = data[indexSrc - strideSrc - 1] & 0xFF;
            int a12 = data[indexSrc - strideSrc] & 0xFF;
            int a21 = data[indexSrc - 1] & 0xFF;
            int a22 = data[indexSrc] & 0xFF;
            int a31 = data[indexSrc + strideSrc - 1] & 0xFF;
            int a32 = data[indexSrc + strideSrc] & 0xFF;
            for (indexSrc = src.startIndex + src.stride * y + 1; indexSrc < endX; ++indexSrc) {
                int a13 = data[indexSrc - strideSrc + 1] & 0xFF;
                int a23 = data[indexSrc + 1] & 0xFF;
                int a33 = data[indexSrc + strideSrc + 1] & 0xFF;
                int v = (a33 - a11) * kerA;
                int w = (a31 - a13) * kerA;
                imgY[indexY++] = (short)((a32 - a12) * kerB + v + w);
                imgX[indexX++] = (short)((a23 - a21) * kerB + v - w);
                a11 = a12;
                a12 = a13;
                a21 = a22;
                a22 = a23;
                a31 = a32;
                a32 = a33;
            }
        });
    }

    public static void process(GrayS16 src, int kerA, int kerB, GrayS16 derivX, GrayS16 derivY) {
        short[] data = src.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = src.getWidth();
        int height = src.getHeight() - 1;
        int strideSrc = src.getStride();
        BoofConcurrency.loopFor(1, height, y -> {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            short a11 = data[indexSrc - strideSrc - 1];
            short a12 = data[indexSrc - strideSrc];
            short a21 = data[indexSrc - 1];
            short a22 = data[indexSrc];
            short a31 = data[indexSrc + strideSrc - 1];
            short a32 = data[indexSrc + strideSrc];
            for (indexSrc = src.startIndex + src.stride * y + 1; indexSrc < endX; ++indexSrc) {
                short a13 = data[indexSrc - strideSrc + 1];
                short a23 = data[indexSrc + 1];
                short a33 = data[indexSrc + strideSrc + 1];
                int v = (a33 - a11) * kerA;
                int w = (a31 - a13) * kerA;
                imgY[indexY++] = (short)((a32 - a12) * kerB + v + w);
                imgX[indexX++] = (short)((a23 - a21) * kerB + v - w);
                a11 = a12;
                a12 = a13;
                a21 = a22;
                a22 = a23;
                a31 = a32;
                a32 = a33;
            }
        });
    }

    public static void process(GrayF32 src, float kerA, float kerB, GrayF32 derivX, GrayF32 derivY) {
        float[] data = src.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = src.getWidth();
        int height = src.getHeight() - 1;
        int strideSrc = src.getStride();
        BoofConcurrency.loopFor(1, height, y -> {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            float a11 = data[indexSrc - strideSrc - 1];
            float a12 = data[indexSrc - strideSrc];
            float a21 = data[indexSrc - 1];
            float a22 = data[indexSrc];
            float a31 = data[indexSrc + strideSrc - 1];
            float a32 = data[indexSrc + strideSrc];
            for (indexSrc = src.startIndex + src.stride * y + 1; indexSrc < endX; ++indexSrc) {
                float a13 = data[indexSrc - strideSrc + 1];
                float a23 = data[indexSrc + 1];
                float a33 = data[indexSrc + strideSrc + 1];
                float v = (a33 - a11) * kerA;
                float w = (a31 - a13) * kerA;
                imgY[indexY++] = (a32 - a12) * kerB + v + w;
                imgX[indexX++] = (a23 - a21) * kerB + v - w;
                a11 = a12;
                a12 = a13;
                a21 = a22;
                a22 = a23;
                a31 = a32;
                a32 = a33;
            }
        });
    }
}

