/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayU8;

public class ImplBinaryNaiveOps {
    public static void erode4(GrayU8 input, GrayU8 output) {
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; ++x) {
                if (input.get(x, y) != 0 && ImplBinaryNaiveOps.getT(input, x - 1, y) && ImplBinaryNaiveOps.getT(input, x + 1, y) && ImplBinaryNaiveOps.getT(input, x, y - 1) && ImplBinaryNaiveOps.getT(input, x, y + 1)) {
                    output.set(x, y, 1);
                    continue;
                }
                output.set(x, y, 0);
            }
        }
    }

    public static void dilate4(GrayU8 input, GrayU8 output) {
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; ++x) {
                if (input.get(x, y) != 0 || ImplBinaryNaiveOps.getF(input, x - 1, y) || ImplBinaryNaiveOps.getF(input, x + 1, y) || ImplBinaryNaiveOps.getF(input, x, y - 1) || ImplBinaryNaiveOps.getF(input, x, y + 1)) {
                    output.set(x, y, 1);
                    continue;
                }
                output.set(x, y, 0);
            }
        }
    }

    public static void edge4(GrayU8 input, GrayU8 output) {
        ImplBinaryNaiveOps.edge4(input, output, false);
    }

    public static void edge4(GrayU8 input, GrayU8 output, boolean outsideZero) {
        if (outsideZero) {
            for (int y = 0; y < input.height; ++y) {
                for (int x = 0; x < input.width; ++x) {
                    if (ImplBinaryNaiveOps.getF(input, x - 1, y) && ImplBinaryNaiveOps.getF(input, x + 1, y) && ImplBinaryNaiveOps.getF(input, x, y - 1) && ImplBinaryNaiveOps.getF(input, x, y + 1)) {
                        output.set(x, y, 0);
                        continue;
                    }
                    output.set(x, y, input.get(x, y));
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                for (int x = 0; x < input.width; ++x) {
                    if (ImplBinaryNaiveOps.getT(input, x - 1, y) && ImplBinaryNaiveOps.getT(input, x + 1, y) && ImplBinaryNaiveOps.getT(input, x, y - 1) && ImplBinaryNaiveOps.getT(input, x, y + 1)) {
                        output.set(x, y, 0);
                        continue;
                    }
                    output.set(x, y, input.get(x, y));
                }
            }
        }
    }

    public static void erode8(GrayU8 input, GrayU8 output) {
        output = InputSanityCheck.checkDeclare(input, output);
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; ++x) {
                if (input.get(x, y) != 0 && ImplBinaryNaiveOps.getT(input, x - 1, y) && ImplBinaryNaiveOps.getT(input, x + 1, y) && ImplBinaryNaiveOps.getT(input, x, y - 1) && ImplBinaryNaiveOps.getT(input, x, y + 1) && ImplBinaryNaiveOps.getT(input, x - 1, y + 1) && ImplBinaryNaiveOps.getT(input, x + 1, y + 1) && ImplBinaryNaiveOps.getT(input, x - 1, y - 1) && ImplBinaryNaiveOps.getT(input, x + 1, y - 1)) {
                    output.set(x, y, 1);
                    continue;
                }
                output.set(x, y, 0);
            }
        }
    }

    public static void dilate8(GrayU8 input, GrayU8 output) {
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; ++x) {
                if (input.get(x, y) != 0 || ImplBinaryNaiveOps.getF(input, x - 1, y) || ImplBinaryNaiveOps.getF(input, x + 1, y) || ImplBinaryNaiveOps.getF(input, x, y - 1) || ImplBinaryNaiveOps.getF(input, x, y + 1) || ImplBinaryNaiveOps.getF(input, x - 1, y + 1) || ImplBinaryNaiveOps.getF(input, x + 1, y + 1) || ImplBinaryNaiveOps.getF(input, x - 1, y - 1) || ImplBinaryNaiveOps.getF(input, x + 1, y - 1)) {
                    output.set(x, y, 1);
                    continue;
                }
                output.set(x, y, 0);
            }
        }
    }

    public static void edge8(GrayU8 input, GrayU8 output) {
        ImplBinaryNaiveOps.edge8(input, output, false);
    }

    public static void edge8(GrayU8 input, GrayU8 output, boolean outsideZero) {
        if (outsideZero) {
            for (int y = 0; y < input.height; ++y) {
                for (int x = 0; x < input.width; ++x) {
                    if (ImplBinaryNaiveOps.getF(input, x - 1, y) && ImplBinaryNaiveOps.getF(input, x + 1, y) && ImplBinaryNaiveOps.getF(input, x, y - 1) && ImplBinaryNaiveOps.getF(input, x, y + 1) && ImplBinaryNaiveOps.getF(input, x - 1, y + 1) && ImplBinaryNaiveOps.getF(input, x + 1, y + 1) && ImplBinaryNaiveOps.getF(input, x - 1, y - 1) && ImplBinaryNaiveOps.getF(input, x + 1, y - 1)) {
                        output.set(x, y, 0);
                        continue;
                    }
                    output.set(x, y, input.get(x, y));
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                for (int x = 0; x < input.width; ++x) {
                    if (ImplBinaryNaiveOps.getT(input, x - 1, y) && ImplBinaryNaiveOps.getT(input, x + 1, y) && ImplBinaryNaiveOps.getT(input, x, y - 1) && ImplBinaryNaiveOps.getT(input, x, y + 1) && ImplBinaryNaiveOps.getT(input, x - 1, y + 1) && ImplBinaryNaiveOps.getT(input, x + 1, y + 1) && ImplBinaryNaiveOps.getT(input, x - 1, y - 1) && ImplBinaryNaiveOps.getT(input, x + 1, y - 1)) {
                        output.set(x, y, 0);
                        continue;
                    }
                    output.set(x, y, input.get(x, y));
                }
            }
        }
    }

    public static void removePointNoise(GrayU8 input, GrayU8 output) {
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; ++x) {
                int num = 0;
                if (ImplBinaryNaiveOps.getF(input, x - 1, y + 1)) {
                    ++num;
                }
                if (ImplBinaryNaiveOps.getF(input, x, y + 1)) {
                    ++num;
                }
                if (ImplBinaryNaiveOps.getF(input, x + 1, y + 1)) {
                    ++num;
                }
                if (ImplBinaryNaiveOps.getF(input, x + 1, y)) {
                    ++num;
                }
                if (ImplBinaryNaiveOps.getF(input, x + 1, y - 1)) {
                    ++num;
                }
                if (ImplBinaryNaiveOps.getF(input, x, y - 1)) {
                    ++num;
                }
                if (ImplBinaryNaiveOps.getF(input, x - 1, y - 1)) {
                    ++num;
                }
                if (ImplBinaryNaiveOps.getF(input, x - 1, y)) {
                    ++num;
                }
                if (num < 2) {
                    output.set(x, y, 0);
                    continue;
                }
                if (num > 6) {
                    output.set(x, y, 1);
                    continue;
                }
                output.set(x, y, input.get(x, y));
            }
        }
    }

    public static boolean getT(GrayU8 image, int x, int y) {
        if (image.isInBounds(x, y)) {
            return image.get(x, y) != 0;
        }
        return true;
    }

    public static boolean getF(GrayU8 image, int x, int y) {
        if (image.isInBounds(x, y)) {
            return image.get(x, y) != 0;
        }
        return false;
    }
}

