/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.GaliosFieldOps;
import boofcv.alg.fiducial.qrcode.GaliosFieldTableOps;
import java.util.Arrays;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.DogArray_I8;

public class ReidSolomonCodes {
    GaliosFieldTableOps math;
    DogArray_I8 generator = new DogArray_I8();
    DogArray_I8 tmp0 = new DogArray_I8();
    DogArray_I8 tmp1 = new DogArray_I8();
    DogArray_I32 errorLocations = new DogArray_I32();
    DogArray_I8 errorLocatorPoly = new DogArray_I8();
    DogArray_I8 syndromes = new DogArray_I8();

    public ReidSolomonCodes(int numBits, int primitive) {
        this.math = new GaliosFieldTableOps(numBits, primitive);
    }

    public void setDegree(int degree) {
        this.generator(degree);
    }

    public void computeECC(DogArray_I8 input, DogArray_I8 output) {
        int N = this.generator.size - 1;
        input.extend(input.size + N);
        Arrays.fill(input.data, input.size - N, input.size, (byte)0);
        this.math.polyDivide(input, this.generator, this.tmp0, output);
        input.size -= N;
    }

    public boolean correct(DogArray_I8 input, DogArray_I8 ecc) {
        this.computeSyndromes(input, ecc, this.syndromes);
        this.findErrorLocatorPolynomialBM(this.syndromes, this.errorLocatorPoly);
        if (!this.findErrorLocations_BruteForce(this.errorLocatorPoly, input.size + ecc.size, this.errorLocations)) {
            return false;
        }
        this.correctErrors(input, input.size + ecc.size, this.syndromes, this.errorLocatorPoly, this.errorLocations);
        return true;
    }

    void computeSyndromes(DogArray_I8 input, DogArray_I8 ecc, DogArray_I8 syndromes) {
        syndromes.resize(this.syndromeLength());
        for (int i = 0; i < syndromes.size; ++i) {
            int val2 = this.math.power(2, i);
            syndromes.data[i] = (byte)this.math.polyEval(input, val2);
            syndromes.data[i] = (byte)this.math.polyEvalContinue(syndromes.data[i] & 0xFF, ecc, val2);
        }
    }

    void findErrorLocatorPolynomialBM(DogArray_I8 syndromes, DogArray_I8 errorLocator) {
        DogArray_I8 C = errorLocator;
        DogArray_I8 B = new DogArray_I8();
        this.initToOne(C, syndromes.size + 1);
        this.initToOne(B, syndromes.size + 1);
        DogArray_I8 tmp = new DogArray_I8(syndromes.size);
        int b = 1;
        for (int n = 0; n < syndromes.size; ++n) {
            int delta = syndromes.data[n] & 0xFF;
            for (int j = 1; j < C.size; ++j) {
                delta ^= this.math.multiply(C.data[C.size - j - 1] & 0xFF, syndromes.data[n - j] & 0xFF);
            }
            B.data[B.size++] = 0;
            if (delta == 0) continue;
            int scale = this.math.multiply(delta, this.math.inverse(b));
            this.math.polyAddScaleB(C, B, scale, tmp);
            if (B.size > C.size) {
                B.setTo(C);
                b = delta;
            }
            C.setTo(tmp);
        }
        this.removeLeadingZeros(C);
    }

    private void removeLeadingZeros(DogArray_I8 poly) {
        int count;
        for (count = 0; count < poly.size && poly.data[count] == 0; ++count) {
        }
        for (int i = count; i < poly.size; ++i) {
            poly.data[i - count] = poly.data[i];
        }
        poly.size -= count;
    }

    void findErrorLocatorPolynomial(int messageLength, DogArray_I32 errorLocations, DogArray_I8 errorLocator) {
        this.tmp1.resize(2);
        this.tmp1.data[1] = 1;
        errorLocator.resize(1);
        errorLocator.data[0] = 1;
        for (int i = 0; i < errorLocations.size; ++i) {
            int where = messageLength - errorLocations.get(i) - 1;
            this.tmp1.data[0] = (byte)this.math.power(2, where);
            this.tmp0.setTo(errorLocator);
            this.math.polyMult(this.tmp0, this.tmp1, errorLocator);
        }
    }

    public boolean findErrorLocations_BruteForce(DogArray_I8 errorLocator, int messageLength, DogArray_I32 locations) {
        locations.resize(0);
        for (int i = 0; i < messageLength; ++i) {
            if (this.math.polyEval_S(errorLocator, this.math.power(2, i)) != 0) continue;
            locations.add(messageLength - i - 1);
        }
        return locations.size == errorLocator.size - 1;
    }

    void correctErrors(DogArray_I8 message, int length_msg_ecc, DogArray_I8 syndromes, DogArray_I8 errorLocator, DogArray_I32 errorLocations) {
        DogArray_I8 err_eval = new DogArray_I8();
        this.findErrorEvaluator(syndromes, errorLocator, err_eval);
        DogArray_I8 X2 = DogArray_I8.zeros(errorLocations.size);
        for (int i = 0; i < errorLocations.size; ++i) {
            int coef_pos = length_msg_ecc - errorLocations.data[i] - 1;
            X2.data[i] = (byte)this.math.power(2, coef_pos);
        }
        DogArray_I8 err_loc_prime_tmp = new DogArray_I8(X2.size);
        for (int i = 0; i < X2.size; ++i) {
            int Xi = X2.data[i] & 0xFF;
            int Xi_inv = this.math.inverse(Xi);
            err_loc_prime_tmp.size = 0;
            for (int j = 0; j < X2.size; ++j) {
                if (i == j) continue;
                err_loc_prime_tmp.data[err_loc_prime_tmp.size++] = (byte)GaliosFieldOps.subtract(1, this.math.multiply(Xi_inv, X2.data[j] & 0xFF));
            }
            int err_loc_prime = 1;
            for (int j = 0; j < err_loc_prime_tmp.size; ++j) {
                err_loc_prime = this.math.multiply(err_loc_prime, err_loc_prime_tmp.data[j] & 0xFF);
            }
            int y = this.math.polyEval_S(err_eval, Xi_inv);
            y = this.math.multiply(this.math.power(Xi, 1), y);
            int magnitude = this.math.divide(y, err_loc_prime);
            int loc = errorLocations.get(i);
            if (loc >= message.size) continue;
            message.data[loc] = (byte)(message.data[loc] & 0xFF ^ magnitude);
        }
    }

    void findErrorEvaluator(DogArray_I8 syndromes, DogArray_I8 errorLocator, DogArray_I8 evaluator) {
        int i;
        this.math.polyMult_flipA(syndromes, errorLocator, evaluator);
        int N = errorLocator.size - 1;
        int offset = evaluator.size - N;
        for (i = 0; i < N; ++i) {
            evaluator.data[i] = evaluator.data[i + offset];
        }
        evaluator.data[N] = 0;
        evaluator.size = errorLocator.size;
        for (i = 0; i < evaluator.size / 2; ++i) {
            int j = evaluator.size - i - 1;
            byte tmp = evaluator.data[i];
            evaluator.data[i] = evaluator.data[j];
            evaluator.data[j] = tmp;
        }
    }

    void generator(int degree) {
        this.initToOne(this.generator, degree + 1);
        this.tmp1.resize(2);
        this.tmp1.data[0] = 1;
        for (int i = 0; i < degree; ++i) {
            this.tmp1.data[1] = (byte)this.math.power(2, i);
            this.math.polyMult(this.generator, this.tmp1, this.tmp0);
            this.generator.setTo(this.tmp0);
        }
    }

    void initToOne(DogArray_I8 poly, int length) {
        poly.reset();
        poly.reserve(length);
        poly.size = 1;
        poly.data[0] = 1;
    }

    private int syndromeLength() {
        return this.generator.size - 1;
    }
}

