/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareGraph;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.calib.squares.SquaresIntoClusters;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.DogArray;

public class SquaresIntoRegularClusters
extends SquaresIntoClusters {
    public int maxNeighbors;
    double distanceTol = 0.2;
    double maxNeighborDistanceRatio;
    private double spaceToSquareRatio;
    protected SquareGraph graph = new SquareGraph();
    private LineGeneral2D_F64 line = new LineGeneral2D_F64();
    protected LineSegment2D_F64 lineA = new LineSegment2D_F64();
    protected LineSegment2D_F64 lineB = new LineSegment2D_F64();
    protected LineSegment2D_F64 connectLine = new LineSegment2D_F64();
    private Point2D_F64 intersection = new Point2D_F64();
    private NearestNeighbor<SquareNode> nn = FactoryNearestNeighbor.kdtree(new SquareNode.KdTreeSquareNode());
    private NearestNeighbor.Search<SquareNode> search = this.nn.createSearch();
    private DogArray<NnData<SquareNode>> searchResults = new DogArray<Object>(NnData::new);

    public SquaresIntoRegularClusters(double spaceToSquareRatio, int maxNeighbors, double maxNeighborDistanceRatio) {
        this.spaceToSquareRatio = spaceToSquareRatio;
        this.maxNeighbors = maxNeighbors;
        if (this.maxNeighbors == Integer.MAX_VALUE) {
            this.maxNeighbors = 0x7FFFFFFE;
        }
        this.maxNeighborDistanceRatio = maxNeighborDistanceRatio;
    }

    public List<List<SquareNode>> process(List<Polygon2D_F64> squares) {
        this.recycleData();
        this.computeNodeInfo(squares);
        this.connectNodes();
        this.disconnectSingleConnections();
        this.findClusters();
        return this.clusters.toList();
    }

    void computeNodeInfo(List<Polygon2D_F64> squares) {
        for (int i = 0; i < squares.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.grow();
            n.reset();
            n.square = squares.get(i);
            if (n.square.size() != 4) {
                throw new RuntimeException("Squares have four corners not " + n.square.size());
            }
            this.graph.computeNodeInfo(n);
        }
    }

    void connectNodes() {
        this.setupSearch();
        for (int i = 0; i < this.nodes.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.get(i);
            double neighborDistance = n.largestSide * (1.0 + this.spaceToSquareRatio) * this.maxNeighborDistanceRatio;
            this.searchResults.reset();
            this.search.findNearest(n, neighborDistance * neighborDistance, this.maxNeighbors + 1, this.searchResults);
            for (int j = 0; j < this.searchResults.size(); ++j) {
                NnData neighbor = (NnData)this.searchResults.get(j);
                if (neighbor.point == n) continue;
                this.considerConnect(n, (SquareNode)neighbor.point);
            }
        }
    }

    void disconnectSingleConnections() {
        SquareNode n;
        int i;
        ArrayList<SquareNode> open = new ArrayList<SquareNode>();
        ArrayList<SquareNode> open2 = new ArrayList<SquareNode>();
        for (i = 0; i < this.nodes.size(); ++i) {
            n = (SquareNode)this.nodes.get(i);
            this.checkDisconnectSingleEdge(open, n);
        }
        while (!open.isEmpty()) {
            for (i = 0; i < open.size(); ++i) {
                n = (SquareNode)open.get(i);
                this.checkDisconnectSingleEdge(open2, n);
                open.clear();
                ArrayList<SquareNode> tmp = open;
                open = open2;
                open2 = tmp;
            }
        }
    }

    private void checkDisconnectSingleEdge(List<SquareNode> open, SquareNode n) {
        if (n.getNumberOfConnections() == 1) {
            for (int j = 0; j < n.square.size(); ++j) {
                if (n.edges[j] == null) continue;
                open.add((SquareNode)n.edges[j].destination(n));
                this.graph.detachEdge(n.edges[j]);
                break;
            }
        }
    }

    private void setupSearch() {
        this.nn.setPoints(this.nodes.toList(), false);
    }

    boolean areMiddlePointsClose(Point2D_F64 p0, Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3) {
        UtilLine2D_F64.convert(p0, p3, this.line);
        double tol1 = p0.distance(p1) * this.distanceTol;
        if (Distance2D_F64.distance(this.line, p1) > tol1) {
            return false;
        }
        double tol2 = p2.distance(p3) * this.distanceTol;
        if (Distance2D_F64.distance(this.lineB, p2) > tol2) {
            return false;
        }
        UtilLine2D_F64.convert(p0, p1, this.line);
        if (Distance2D_F64.distance(this.line, p2) > tol2) {
            return false;
        }
        UtilLine2D_F64.convert(p3, p2, this.line);
        return !(Distance2D_F64.distance(this.line, p1) > tol1);
    }

    void considerConnect(SquareNode node0, SquareNode node1) {
        this.lineA.a = node0.center;
        this.lineA.b = node1.center;
        int intersection0 = this.graph.findSideIntersect(node0, this.lineA, this.intersection, this.lineB);
        this.connectLine.a.setTo(this.intersection);
        int intersection1 = this.graph.findSideIntersect(node1, this.lineA, this.intersection, this.lineB);
        this.connectLine.b.setTo(this.intersection);
        if (intersection1 < 0 || intersection0 < 0) {
            return;
        }
        double side0 = node0.sideLengths[intersection0];
        double side1 = node1.sideLengths[intersection1];
        double sideLoc0 = this.connectLine.a.distance(node0.square.get(intersection0)) / side0;
        double sideLoc1 = this.connectLine.b.distance(node1.square.get(intersection1)) / side1;
        if (Math.abs(sideLoc0 - 0.5) > 0.35 || Math.abs(sideLoc1 - 0.5) > 0.35) {
            return;
        }
        double spaceDistance = this.connectLine.getLength();
        if (Math.abs(side0 - side1) / Math.max(side0, side1) > 0.25) {
            return;
        }
        if (!this.graph.almostParallel(node0, intersection0, node1, intersection1)) {
            return;
        }
        double ratio = Math.max(node0.smallestSide / node1.largestSide, node1.smallestSide / node0.largestSide);
        if (ratio > 1.3) {
            return;
        }
        this.graph.checkConnect(node0, intersection0, node1, intersection1, spaceDistance);
    }
}

