/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import georegression.metric.UtilAngle;
import georegression.struct.curve.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.List;

public class EllipseClustersIntoRegularGrid
extends EllipseClustersIntoGrid {
    @Override
    public void process(List<EllipseRotated_F64> ellipses, List<List<EllipsesIntoClusters.Node>> clusters) {
        this.foundGrids.reset();
        for (int i = 0; i < clusters.size(); ++i) {
            int j;
            List<EllipsesIntoClusters.Node> cluster = clusters.get(i);
            int clusterSize = cluster.size();
            if (clusterSize < 2) continue;
            this.computeNodeInfo(ellipses, cluster);
            if (!this.findContour(false)) {
                if (!this.verbose) continue;
                System.out.println("Contour find failed");
                continue;
            }
            EllipseClustersIntoGrid.NodeInfo corner = this.selectSeedCorner();
            corner.marked = true;
            boolean ccw = UtilAngle.distanceCCW(EllipseClustersIntoRegularGrid.direction(corner, corner.right), EllipseClustersIntoRegularGrid.direction(corner, corner.left)) > Math.PI;
            List<EllipseClustersIntoGrid.NodeInfo> cornerRow = EllipseClustersIntoRegularGrid.findLine(corner, corner.left, clusterSize, null, ccw);
            List<EllipseClustersIntoGrid.NodeInfo> cornerColumn = EllipseClustersIntoRegularGrid.findLine(corner, corner.right, clusterSize, null, !ccw);
            if (cornerRow == null || cornerColumn == null) {
                if (!this.verbose) continue;
                System.out.println("Corner row/column line find failed");
                continue;
            }
            ArrayList<List<EllipseClustersIntoGrid.NodeInfo>> gridByRows = new ArrayList<List<EllipseClustersIntoGrid.NodeInfo>>();
            gridByRows.add(cornerRow);
            boolean failed = false;
            for (j = 1; j < cornerColumn.size(); ++j) {
                List prev = (List)gridByRows.get(j - 1);
                EllipseClustersIntoGrid.NodeInfo seed = cornerColumn.get(j);
                EllipseClustersIntoGrid.NodeInfo next = EllipseClustersIntoRegularGrid.selectSeedNext((EllipseClustersIntoGrid.NodeInfo)prev.get(0), (EllipseClustersIntoGrid.NodeInfo)prev.get(1), seed, ccw);
                if (next == null) {
                    if (this.verbose) {
                        System.out.println("Outer column with a row that has only one element");
                    }
                    failed = true;
                    break;
                }
                List<EllipseClustersIntoGrid.NodeInfo> row = EllipseClustersIntoRegularGrid.findLine(seed, next, clusterSize, null, ccw);
                gridByRows.add(row);
            }
            if (failed) continue;
            if (!EllipseClustersIntoRegularGrid.checkGridSize(gridByRows, cluster.size())) {
                if (!this.verbose) continue;
                System.out.println("grid size check failed");
                for (j = 0; j < gridByRows.size(); ++j) {
                    System.out.println("  row " + ((List)gridByRows.get(j)).size());
                }
                continue;
            }
            if (this.checkDuplicates(gridByRows)) {
                if (!this.verbose) continue;
                System.out.println("contains duplicates");
                continue;
            }
            EllipseClustersIntoRegularGrid.createRegularGrid(gridByRows, (EllipseClustersIntoGrid.Grid)this.foundGrids.grow());
        }
    }

    static boolean checkGridSize(List<List<EllipseClustersIntoGrid.NodeInfo>> grid, int clusterSize) {
        int total = 0;
        int expected = grid.get(0).size();
        for (int i = 0; i < grid.size(); ++i) {
            if (expected != grid.get(i).size()) {
                return false;
            }
            total += grid.get(i).size();
        }
        return total == clusterSize;
    }

    static void createRegularGrid(List<List<EllipseClustersIntoGrid.NodeInfo>> gridByRows, EllipseClustersIntoGrid.Grid g) {
        g.reset();
        g.columns = gridByRows.get(0).size();
        g.rows = gridByRows.size();
        for (int row = 0; row < g.rows; ++row) {
            List<EllipseClustersIntoGrid.NodeInfo> list = gridByRows.get(row);
            for (int i = 0; i < g.columns; ++i) {
                g.ellipses.add(list.get((int)i).ellipse);
            }
        }
    }
}

