/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.feature.detect.chess.ChessboardCornerDistance;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerEdgeIntensity;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageGray;
import georegression.metric.UtilAngle;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class ChessboardCornerClusterFinder<T extends ImageGray<T>>
implements VerbosePrint {
    private double directionTol = 0.8;
    private double orientationTol = 0.5;
    private double ambiguousTol = 0.25;
    private int maxNeighbors = 14;
    private double maxNeighborDistance = Double.MAX_VALUE;
    private final ChessboardCornerEdgeIntensity<T> computeConnInten;
    private double thresholdEdgeIntensity = 0.05;
    private final DogArray<Vertex> vertexes = new DogArray<Vertex>(Vertex::new);
    private final DogArray<Edge> edges = new DogArray<Edge>(Edge::new);
    private final DogArray<LineInfo> lines = new DogArray<LineInfo>(LineInfo::new);
    private final NearestNeighbor<ChessboardCorner> nn = FactoryNearestNeighbor.kdtree(new ChessboardCornerDistance());
    private final NearestNeighbor.Search<ChessboardCorner> nnSearch = this.nn.createSearch();
    private final DogArray<NnData<ChessboardCorner>> nnResults = new DogArray<NnData>(NnData::new);
    private final DogArray<ChessboardCornerGraph> outputClusters = new DogArray<ChessboardCornerGraph>(ChessboardCornerGraph::new);
    private final DogArray_I32 c2n = new DogArray_I32();
    private final DogArray_I32 n2c = new DogArray_I32();
    private final DogArray_I32 open = new DogArray_I32();
    private List<ChessboardCorner> corners;
    private final List<Vertex> openVertexes = new ArrayList<Vertex>();
    private final List<Vertex> dirtyVertexes = new ArrayList<Vertex>();
    private final List<Edge> bestSolution = new ArrayList<Edge>();
    private final List<Edge> solution = new ArrayList<Edge>();
    private final DogArray<PairIdx> pairs = new DogArray<PairIdx>(PairIdx.class, () -> new PairIdx());
    private final DogArray_B matched = new DogArray_B();
    PrintStream verbose = null;

    public ChessboardCornerClusterFinder(Class<T> imageType) {
        this(new ChessboardCornerEdgeIntensity<T>(imageType));
    }

    public ChessboardCornerClusterFinder(ChessboardCornerEdgeIntensity<T> computeConnInten) {
        this.computeConnInten = computeConnInten;
        this.setDirectionTol(this.directionTol);
    }

    public void process(T image, List<ChessboardCorner> corners, int numLevels) {
        int i;
        this.corners = corners;
        ArrayList<DogArray_I32> cornersInLevel = new ArrayList<DogArray_I32>();
        this.initalizeStructures(image, corners, numLevels, cornersInLevel);
        ArrayList<ChessboardCorner> cornersUpToLevel = new ArrayList<ChessboardCorner>();
        DogArray_I32 indexesUpToLevel = new DogArray_I32();
        this.pyramidalFindNeighbors(corners, numLevels, cornersInLevel, cornersUpToLevel, indexesUpToLevel);
        BoofMiscOps.checkTrue(indexesUpToLevel.size == corners.size());
        if (this.verbose != null) {
            this.verbose.println("corners.size=" + corners.size() + " vertexes.size=" + this.vertexes.size);
            this.printDualGraph();
        }
        if (this.thresholdEdgeIntensity > 0.0) {
            this.pruneConnectionsByIntensity(corners);
        }
        this.pruneSingleConnections();
        if (this.verbose != null) {
            this.printDualGraph();
        }
        this.handleAmbiguousVertexes(corners);
        if (this.verbose != null) {
            this.verbose.println("after ambiguous vertexes.size=" + this.vertexes.size);
        }
        for (int idx = 0; idx < this.vertexes.size(); ++idx) {
            this.selectConnections((Vertex)this.vertexes.get(idx));
        }
        if (this.verbose != null) {
            this.printDualGraph();
        }
        this.dirtyVertexes.clear();
        for (i = 0; i < this.vertexes.size; ++i) {
            Vertex v = (Vertex)this.vertexes.get(i);
            int before = v.connections.size();
            v.pruneNonMutal(EdgeType.CONNECTION);
            if (before == v.connections.size()) continue;
            this.dirtyVertexes.add(v);
            v.marked = true;
        }
        if (this.verbose != null) {
            this.printDualGraph();
        }
        this.repairVertexes();
        for (i = 0; i < this.dirtyVertexes.size(); ++i) {
            this.dirtyVertexes.get(i).pruneNonMutal(EdgeType.CONNECTION);
            this.dirtyVertexes.get((int)i).marked = false;
        }
        this.disconnectInvalidVertices();
        this.convertToOutput(corners);
    }

    private void pruneSingleConnections() {
        for (int i = 0; i < this.vertexes.size; ++i) {
            Vertex va = (Vertex)this.vertexes.get(i);
            if (va.perpendicular.size() != 1) continue;
            this.removeReferences(va, EdgeType.PERPENDICULAR, true);
        }
    }

    private void pyramidalFindNeighbors(List<ChessboardCorner> corners, int numLevels, List<DogArray_I32> cornersInLevel, List<ChessboardCorner> cornersUpToLevel, DogArray_I32 indexesUpToLevel) {
        for (int level = numLevels - 1; level >= 0; --level) {
            int i;
            DogArray_I32 levelCornerIdx = cornersInLevel.get(level);
            for (i = 0; i < levelCornerIdx.size; ++i) {
                cornersUpToLevel.add(corners.get(levelCornerIdx.get(i)));
            }
            indexesUpToLevel.addAll(levelCornerIdx);
            this.nn.setPoints(cornersUpToLevel, true);
            for (i = 0; i < levelCornerIdx.size(); ++i) {
                Vertex v = (Vertex)this.vertexes.get(levelCornerIdx.get(i));
                this.findVertexNeighbors(v, indexesUpToLevel, corners);
                v.perpendicular.sortByAngle();
            }
        }
    }

    private void initalizeStructures(T image, List<ChessboardCorner> corners, int numLevels, List<DogArray_I32> cornersInLevel) {
        this.vertexes.reset();
        this.edges.reset();
        this.lines.reset();
        this.outputClusters.reset();
        this.computeConnInten.setImage(image);
        cornersInLevel.clear();
        int idx = 0;
        while (idx < corners.size()) {
            Vertex v = this.vertexes.grow();
            v.reset();
            v.index = idx++;
        }
        for (int level = 0; level < numLevels; ++level) {
            cornersInLevel.add(new DogArray_I32());
        }
        for (int i = 0; i < corners.size(); ++i) {
            ChessboardCorner c = corners.get(i);
            cornersInLevel.get(c.level2).add(i);
        }
    }

    protected void pruneConnectionsByIntensity(List<ChessboardCorner> corners) {
        for (int i = 0; i < this.lines.size; ++i) {
            LineInfo line = (LineInfo)this.lines.get(i);
            if (line.isDisconnected() || line.parallel) continue;
            Vertex va = line.endA.dst;
            Vertex vb = line.endB.dst;
            ChessboardCorner ca = corners.get(va.index);
            ChessboardCorner cb = corners.get(vb.index);
            double contrast = (ca.contrast + cb.contrast) / 2.0;
            line.intensityRaw = this.computeConnInten.process(ca, cb, line.endA.direction);
            line.intensity = line.intensityRaw / contrast;
            if (!(line.intensity < this.thresholdEdgeIntensity)) continue;
            if (!va.perpendicular.remove(line)) {
                throw new RuntimeException("BUG");
            }
            if (!vb.perpendicular.remove(line)) {
                throw new RuntimeException("BUG");
            }
            line.disconnect();
        }
    }

    public void printDualGraph() {
        this.verbose.println("============= Dual");
        int l = BoofMiscOps.numDigits(this.vertexes.size);
        String format = "%" + l + "d";
        for (Vertex n : this.vertexes.toList()) {
            ChessboardCorner c = this.corners.get(n.index);
            this.verbose.printf("[" + format + "] {%3.0f, %3.0f} ->  90[ ", n.index, c.x, c.y);
            for (int i = 0; i < n.perpendicular.size(); ++i) {
                Edge e = n.perpendicular.get(i);
                this.verbose.printf(format + " ", e.dst.index);
            }
            this.verbose.println("]");
        }
    }

    public void printConnectionGraph() {
        System.out.println("============= Connection");
        int l = BoofMiscOps.numDigits(this.vertexes.size);
        String format = "%" + l + "d";
        for (Vertex n : this.vertexes.toList()) {
            ChessboardCorner c = this.corners.get(n.index);
            System.out.printf("[" + format + "] {%3.0f, %3.0f} -> [ ", n.index, c.x, c.y);
            for (int i = 0; i < n.connections.size(); ++i) {
                Edge e = n.connections.get(i);
                System.out.printf(format + " ", e.dst.index);
            }
            System.out.println("]");
        }
    }

    void findVertexNeighbors(Vertex va, DogArray_I32 indexesUpToLevel, List<ChessboardCorner> corners) {
        ChessboardCorner targetCorner = corners.get(va.index);
        double maxDist = Double.MAX_VALUE == this.maxNeighborDistance ? this.maxNeighborDistance : this.maxNeighborDistance * this.maxNeighborDistance;
        this.nnSearch.findNearest(corners.get(va.index), maxDist, this.maxNeighbors, this.nnResults);
        for (int i = 0; i < this.nnResults.size; ++i) {
            boolean parallel;
            NnData rb = (NnData)this.nnResults.get(i);
            int cindex = indexesUpToLevel.get(rb.index);
            if (cindex == va.index) continue;
            Vertex vb = (Vertex)this.vertexes.get(cindex);
            double oriDiff = UtilAngle.distHalf(targetCorner.orientation, ((ChessboardCorner)rb.point).orientation);
            boolean bl = parallel = oriDiff <= 0.7853981633974483;
            if (parallel) continue;
            double orientationError = Math.abs(oriDiff - 1.5707963267948966);
            if (vb.perpendicular.find(va) != -1 || orientationError > this.orientationTol) continue;
            double dx = ((ChessboardCorner)rb.point).x - targetCorner.x;
            double dy = ((ChessboardCorner)rb.point).y - targetCorner.y;
            LineInfo line = this.lines.grow();
            line.reset();
            line.distance = Math.sqrt(rb.distance);
            line.parallel = parallel;
            Edge ea = this.edges.grow();
            Edge eb = this.edges.grow();
            ea.reset();
            ea.dst = vb;
            ea.direction = Math.atan2(dy, dx);
            ea.line = line;
            eb.reset();
            eb.dst = va;
            eb.direction = Math.atan2(-dy, -dx);
            eb.line = line;
            line.endA = ea;
            line.endB = eb;
            va.perpendicular.add(ea);
            vb.perpendicular.add(eb);
        }
    }

    void handleAmbiguousVertexes(List<ChessboardCorner> corners) {
        ArrayList<Vertex> candidates = new ArrayList<Vertex>();
        for (int idx = 0; idx < this.vertexes.size(); ++idx) {
            int i;
            Vertex target = (Vertex)this.vertexes.get(idx);
            if (target.perpendicular.size() == 0) continue;
            ChessboardCorner tc = corners.get(target.index);
            candidates.clear();
            for (int i2 = 0; i2 < target.perpendicular.size(); ++i2) {
                Vertex a = target.perpendicular.get((int)i2).dst;
                int targetIdx = a.perpendicular.find(target);
                double targetDir = a.perpendicular.get((int)targetIdx).direction;
                for (int j = 0; j < a.perpendicular.size(); ++j) {
                    Edge e = a.perpendicular.get(j);
                    Vertex b = e.dst;
                    ChessboardCorner tb = corners.get(b.index);
                    if (b == target) continue;
                    double acute = UtilAngle.dist(e.direction, targetDir);
                    double foo = tc.distance(tb) / e.line.distance;
                    if (!(acute < 1.0471975511965976) || !(foo < this.ambiguousTol) || candidates.contains(b)) continue;
                    candidates.add(b);
                }
            }
            if (candidates.size() == 0) continue;
            candidates.add(target);
            int bestIndex = -1;
            double bestError = 0.0;
            for (i = 0; i < candidates.size(); ++i) {
                Vertex v = (Vertex)candidates.get(i);
                ChessboardCorner a = corners.get(v.index);
                double angleError = 0.0;
                for (int j = 0; j < v.perpendicular.size(); ++j) {
                    Edge e = v.perpendicular.get(j);
                    LineInfo line = v.perpendicular.get((int)j).line;
                    ChessboardCorner b = corners.get(e.dst.index);
                    double errorA = UtilAngle.distHalf(a.orientation, e.direction);
                    double errorB = UtilAngle.distHalf(b.orientation, e.direction);
                    angleError += line.intensityRaw / (1.0 + Math.abs(errorA + errorB - 1.5707963267948966));
                }
                if (!(angleError > bestError)) continue;
                bestError = angleError;
                bestIndex = i;
            }
            for (i = 0; i < candidates.size(); ++i) {
                if (i == bestIndex) continue;
                this.removeReferences((Vertex)candidates.get(i), EdgeType.PERPENDICULAR, true);
            }
        }
    }

    void disconnectInvalidVertices() {
        int idxVert;
        this.openVertexes.clear();
        for (idxVert = 0; idxVert < this.vertexes.size; ++idxVert) {
            Vertex n = (Vertex)this.vertexes.get(idxVert);
            if (n.connections.size() != 1 && n.connections.size() != 2) continue;
            this.openVertexes.add(n);
        }
        while (!this.openVertexes.isEmpty()) {
            this.dirtyVertexes.clear();
            for (idxVert = 0; idxVert < this.openVertexes.size(); ++idxVert) {
                boolean remove = false;
                Vertex n = this.openVertexes.get(idxVert);
                if (n.connections.size() == 1) {
                    remove = true;
                } else if (n.connections.size() == 2) {
                    Edge ea = n.connections.get(0);
                    Edge eb = n.connections.get(1);
                    remove = true;
                    block3: for (int i = 0; i < ea.dst.connections.size(); ++i) {
                        Vertex va = ea.dst.connections.get((int)i).dst;
                        if (va == n) continue;
                        for (int j = 0; j < eb.dst.connections.size(); ++j) {
                            Vertex vb = ea.dst.connections.get((int)j).dst;
                            if (va != vb) continue;
                            remove = false;
                            continue block3;
                        }
                    }
                }
                if (!remove) continue;
                for (int i = 0; i < n.connections.size(); ++i) {
                    this.dirtyVertexes.add(n.connections.get((int)i).dst);
                }
                this.removeReferences(n, EdgeType.CONNECTION, false);
            }
            this.openVertexes.clear();
            this.openVertexes.addAll(this.dirtyVertexes);
        }
    }

    void removeReferences(Vertex remove, EdgeType type, boolean disconnectLines) {
        EdgeSet removeSet = remove.getEdgeSet(type);
        for (int i = removeSet.size() - 1; i >= 0; --i) {
            EdgeSet setV;
            int ridx;
            Vertex v = removeSet.get((int)i).dst;
            if (disconnectLines) {
                removeSet.get((int)i).line.disconnect();
            }
            if ((ridx = (setV = v.getEdgeSet(type)).find(remove)) == -1) {
                throw new RuntimeException("EGads");
            }
            setV.edges.remove(ridx);
        }
        removeSet.reset();
    }

    void selectConnections(Vertex target) {
        if (target.perpendicular.size() <= 1) {
            return;
        }
        this.pairs.reset();
        for (int i = 0; i < target.perpendicular.size(); ++i) {
            this.selectNext(target, i, target.perpendicular, this.pairs.grow());
        }
        int bestStart = -1;
        double bestScore = 0.0;
        this.matched.resize(this.pairs.size);
        for (int i = 0; i < this.pairs.size(); ++i) {
            this.matched.fill(false);
            double score = 0.0;
            int count = 1;
            PairIdx a = (PairIdx)this.pairs.get(i);
            if (a.score <= 0.0) continue;
            do {
                this.matched.set(a.idx0, true);
                score += a.score;
                a = (PairIdx)this.pairs.get(a.idx1);
            } while (a.idx1 >= 0 && !this.matched.get(a.idx1) && ++count < 4);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestStart = i;
        }
        if (bestStart >= 0) {
            this.matched.fill(false);
            PairIdx a = (PairIdx)this.pairs.get(bestStart);
            target.connections.add(target.perpendicular.edges.get(a.idx0));
            this.matched.set(a.idx0, true);
            do {
                this.matched.set(a.idx1, true);
                target.connections.add(target.perpendicular.edges.get(a.idx1));
                a = (PairIdx)this.pairs.get(a.idx1);
            } while (a.idx1 >= 0 && !this.matched.get(a.idx1) && target.connections.size() < 4);
        }
    }

    boolean selectNext(Vertex target, int idx0, EdgeSet connections, PairIdx output) {
        output.idx0 = idx0;
        output.idx1 = -1;
        output.score = -1.7976931348623157E308;
        Edge edge0 = connections.get(idx0);
        for (int i = 1; i < connections.size(); ++i) {
            int idx1 = (idx0 + i) % connections.size();
            Edge edge1 = connections.get(idx1);
            for (int idxA = 0; idxA < edge0.dst.perpendicular.size(); ++idxA) {
                Vertex da = edge0.dst.perpendicular.get((int)idxA).dst;
                if (da == target) continue;
                for (int idxB = 0; idxB < edge1.dst.perpendicular.size(); ++idxB) {
                    double score;
                    Vertex db = edge1.dst.perpendicular.get((int)idxB).dst;
                    if (da != db || !((score = this.score(target, idx0, idx1, da)) > output.score)) continue;
                    output.score = score;
                    output.idx1 = idx1;
                }
            }
        }
        return output.score > 0.0;
    }

    private double score(Vertex tgt, int idxA, int idxB, Vertex common) {
        double angleA = tgt.perpendicular.get((int)idxA).direction;
        double distA = tgt.perpendicular.get((int)idxA).line.distance;
        double angleB = tgt.perpendicular.get((int)idxB).direction;
        double distB = tgt.perpendicular.get((int)idxB).line.distance;
        ChessboardCorner targetCorner = this.corners.get(tgt.index);
        ChessboardCorner commonCorner = this.corners.get(common.index);
        double angleC = Math.atan2(commonCorner.y - targetCorner.y, commonCorner.x - targetCorner.x);
        double distC = targetCorner.distance(commonCorner);
        double angDistAB = UtilAngle.distanceCCW(angleB, angleA);
        double angDistAC = UtilAngle.distanceCCW(angleC, angleA);
        if (angDistAC > angDistAB) {
            return -1.7976931348623157E308;
        }
        if (angDistAB > 2.9845130209103035) {
            return -1.7976931348623157E308;
        }
        double angleScore = Math.min(angDistAC, angDistAB - angDistAC);
        double distScore = 0.1 + (Math.abs(distA - distB) + distC) / (distA + distB);
        return angleScore / distScore;
    }

    private void repairVertexes() {
        int totalDirty = this.dirtyVertexes.size();
        for (int idxV = 0; idxV < totalDirty; ++idxV) {
            Vertex v = this.dirtyVertexes.get(idxV);
            this.bestSolution.clear();
            for (int idxE = 0; idxE < v.perpendicular.size(); ++idxE) {
                Edge e = v.perpendicular.get(idxE);
                if (!e.dst.marked && -1 == v.connections.find(e.dst)) continue;
                this.solution.clear();
                this.solution.add(e);
                for (int count = 0; count < 3; ++count) {
                    Vertex va = null;
                    double dir90 = UtilAngle.bound(e.direction + 1.5707963267948966);
                    for (int i = 0; i < e.dst.connections.size(); ++i) {
                        Edge ei = e.dst.connections.get(i);
                        if (!(UtilAngle.dist(ei.direction, dir90) < 1.0471975511965976)) continue;
                        va = ei.dst;
                        break;
                    }
                    boolean matched = false;
                    for (int i = 0; i < v.perpendicular.size(); ++i) {
                        double ccw;
                        Edge ei = v.perpendicular.get(i);
                        if (e == ei || (ccw = UtilAngle.distanceCCW(e.direction, ei.direction)) > 2.827433388230814 || !ei.dst.marked && -1 == v.connections.find(ei.dst) || ei.dst.connections.find(va) == -1) continue;
                        e = ei;
                        this.solution.add(ei);
                        matched = true;
                        break;
                    }
                    if (!matched) break;
                }
                if (this.solution.size() <= this.bestSolution.size()) continue;
                this.bestSolution.clear();
                this.bestSolution.addAll(this.solution);
            }
            if (this.bestSolution.size() <= 1) continue;
            for (int i = 0; i < v.connections.edges.size(); ++i) {
                if (this.bestSolution.contains(v.connections.edges.get(i))) continue;
                Vertex ve = v.connections.edges.get((int)i).dst;
                if (ve.marked) continue;
                ve.marked = true;
                this.dirtyVertexes.add(ve);
            }
            v.connections.edges.clear();
            v.connections.edges.addAll(this.bestSolution);
        }
    }

    private void convertToOutput(List<ChessboardCorner> corners) {
        this.c2n.resize(corners.size());
        this.n2c.resize(this.vertexes.size());
        this.open.reset();
        this.n2c.fill(-1);
        this.c2n.fill(-1);
        for (int seedIdx = 0; seedIdx < this.vertexes.size; ++seedIdx) {
            ChessboardCornerGraph.Node gn;
            int i;
            Vertex seedN = (Vertex)this.vertexes.get(seedIdx);
            if (seedN.marked) continue;
            ChessboardCornerGraph graph = this.outputClusters.grow();
            graph.reset();
            this.growCluster(corners, seedN.index, graph);
            for (i = 0; i < graph.corners.size; ++i) {
                gn = (ChessboardCornerGraph.Node)graph.corners.get(i);
                Vertex n = (Vertex)this.vertexes.get(this.n2c.get(i));
                for (int j = 0; j < n.connections.size(); ++j) {
                    int edgeCornerIdx = n.connections.get((int)j).dst.index;
                    int outputIdx = this.c2n.get(edgeCornerIdx);
                    if (outputIdx == -1) {
                        throw new IllegalArgumentException("Edge to node not in the graph. n.idx=" + n.index + " conn.idx=" + edgeCornerIdx);
                    }
                    gn.edges[j] = (ChessboardCornerGraph.Node)graph.corners.get(outputIdx);
                }
            }
            for (i = 0; i < graph.corners.size; ++i) {
                gn = (ChessboardCornerGraph.Node)graph.corners.get(i);
                int indexCorner = this.n2c.get(gn.index);
                this.c2n.data[indexCorner] = -1;
                this.n2c.data[gn.index] = -1;
            }
            if (graph.corners.size > 1) continue;
            this.outputClusters.removeTail();
        }
    }

    private void growCluster(List<ChessboardCorner> corners, int seedIdx, ChessboardCornerGraph graph) {
        this.open.add(seedIdx);
        ((Vertex)this.vertexes.get((int)seedIdx)).marked = true;
        while (this.open.size > 0) {
            int cornerIdx = this.open.pop();
            Vertex v = (Vertex)this.vertexes.get(cornerIdx);
            ChessboardCornerGraph.Node gn = graph.growCorner();
            this.c2n.data[cornerIdx] = gn.index;
            this.n2c.data[gn.index] = cornerIdx;
            gn.set(corners.get(cornerIdx));
            for (int i = 0; i < v.connections.size(); ++i) {
                Vertex dst = v.connections.get((int)i).dst;
                if (dst.marked) continue;
                dst.marked = true;
                this.open.add(dst.index);
            }
        }
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public double getDirectionTol() {
        return this.directionTol;
    }

    public void setDirectionTol(double directionTol) {
        this.directionTol = directionTol;
    }

    public double getOrientationTol() {
        return this.orientationTol;
    }

    public void setOrientationTol(double orientationTol) {
        this.orientationTol = orientationTol;
    }

    public double getAmbiguousTol() {
        return this.ambiguousTol;
    }

    public void setAmbiguousTol(double ambiguousTol) {
        this.ambiguousTol = ambiguousTol;
    }

    public int getMaxNeighbors() {
        return this.maxNeighbors;
    }

    public void setMaxNeighbors(int maxNeighbors) {
        this.maxNeighbors = maxNeighbors;
    }

    public double getMaxNeighborDistance() {
        return this.maxNeighborDistance;
    }

    public void setMaxNeighborDistance(double maxNeighborDistance) {
        this.maxNeighborDistance = maxNeighborDistance;
    }

    public ChessboardCornerEdgeIntensity<T> getComputeConnInten() {
        return this.computeConnInten;
    }

    public double getThresholdEdgeIntensity() {
        return this.thresholdEdgeIntensity;
    }

    public void setThresholdEdgeIntensity(double thresholdEdgeIntensity) {
        this.thresholdEdgeIntensity = thresholdEdgeIntensity;
    }

    public DogArray<Vertex> getVertexes() {
        return this.vertexes;
    }

    public DogArray<Edge> getEdges() {
        return this.edges;
    }

    public DogArray<LineInfo> getLines() {
        return this.lines;
    }

    public DogArray<ChessboardCornerGraph> getOutputClusters() {
        return this.outputClusters;
    }

    private static class PairIdx {
        public int idx0;
        public int idx1;
        public double score;

        private PairIdx() {
        }
    }

    public static class Vertex {
        public int index;
        public EdgeSet perpendicular = new EdgeSet();
        public EdgeSet connections = new EdgeSet();
        public boolean marked;
        public double neighborDistance;

        public void reset() {
            this.index = -1;
            this.perpendicular.reset();
            this.connections.reset();
            this.marked = false;
        }

        public void pruneNonMutal(EdgeType which) {
            EdgeSet set = this.getEdgeSet(which);
            for (int i = set.edges.size() - 1; i >= 0; --i) {
                Vertex dst = set.edges.get((int)i).dst;
                EdgeSet dstSet = dst.getEdgeSet(which);
                if (-1 != dstSet.find(this)) continue;
                set.edges.remove(i);
            }
        }

        public EdgeSet getEdgeSet(EdgeType which) {
            EdgeSet edgeSet;
            switch (which) {
                case PERPENDICULAR: {
                    edgeSet = this.perpendicular;
                    break;
                }
                case CONNECTION: {
                    edgeSet = this.connections;
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            return edgeSet;
        }
    }

    public static class EdgeSet {
        public List<Edge> edges = new ArrayList<Edge>();

        public void reset() {
            this.edges.clear();
        }

        public void add(Edge e) {
            this.edges.add(e);
        }

        public Edge get(int i) {
            return this.edges.get(i);
        }

        public void set(int i, Edge e) {
            this.edges.set(i, e);
        }

        public int size() {
            return this.edges.size();
        }

        public int find(Vertex v) {
            for (int i = 0; i < this.edges.size(); ++i) {
                if (this.edges.get((int)i).dst != v) continue;
                return i;
            }
            return -1;
        }

        public int find(LineInfo line) {
            Vertex va = line.endA.dst;
            Vertex vb = line.endB.dst;
            for (int i = 0; i < this.edges.size(); ++i) {
                Edge e = this.edges.get(i);
                if (e.dst != va && e.dst != vb) continue;
                return i;
            }
            return -1;
        }

        public boolean remove(LineInfo line) {
            int idx = this.find(line);
            if (idx == -1) {
                return false;
            }
            this.edges.remove(idx);
            return true;
        }

        public void sortByAngle() {
            Collections.sort(this.edges, (o1, o2) -> Double.compare(o1.direction, o2.direction));
        }
    }

    private static enum EdgeType {
        PERPENDICULAR,
        CONNECTION;

    }

    public static class LineInfo {
        public double intensity;
        public double intensityRaw;
        public double distance;
        public boolean parallel;
        public boolean xcorner;
        public Edge endA;
        public Edge endB;

        public void reset() {
            this.invalidateIntensity();
            this.distance = Double.NaN;
            this.parallel = false;
            this.xcorner = false;
            this.endA = null;
            this.endB = null;
        }

        public boolean isIntensityInvalid() {
            return this.intensity == -1.7976931348623157E308;
        }

        public void invalidateIntensity() {
            this.intensity = -1.7976931348623157E308;
            this.intensityRaw = -1.7976931348623157E308;
        }

        public void disconnect() {
            this.endB = null;
            this.endA = null;
        }

        public boolean isDisconnected() {
            return this.endA == null;
        }
    }

    public static class Edge {
        public LineInfo line;
        public double direction;
        public Vertex dst;

        public void reset() {
            this.line = null;
            this.direction = Double.NaN;
            this.dst = null;
        }
    }

    public static class TupleI32 {
        public int a;
        public int b;
        public int c;
    }

    public static class SearchResults {
        public int index;
        public double error;
    }
}

