/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.alg.feature.orientation.OrientationAverage;
import boofcv.struct.image.GrayF32;

public class ImplOrientationAverage_F32
extends OrientationAverage<GrayF32> {
    public ImplOrientationAverage_F32(double objectToSample, boolean weighted) {
        super(objectToSample, weighted);
    }

    @Override
    public Class<GrayF32> getImageType() {
        return GrayF32.class;
    }

    @Override
    protected double computeUnweightedScore() {
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayF32)this.derivX).startIndex + ((GrayF32)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayF32)this.derivY).startIndex + ((GrayF32)this.derivY).stride * y + this.rect.x0;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                sumX += ((GrayF32)this.derivX).data[indexX];
                sumY += ((GrayF32)this.derivY).data[indexY];
                ++x;
                ++indexX;
                ++indexY;
            }
        }
        return Math.atan2(sumY, sumX);
    }

    @Override
    protected double computeWeightedScore(int c_x, int c_y) {
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayF32)this.derivX).startIndex + ((GrayF32)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayF32)this.derivY).startIndex + ((GrayF32)this.derivY).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.radiusScale) * this.weights.width + this.rect.x0 - c_x + this.radiusScale;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                float w = this.weights.data[indexW];
                sumX += w * ((GrayF32)this.derivX).data[indexX];
                sumY += w * ((GrayF32)this.derivY).data[indexY];
                ++x;
                ++indexX;
                ++indexY;
                ++indexW;
            }
        }
        return Math.atan2(sumY, sumX);
    }

    @Override
    public RegionOrientation copy() {
        ImplOrientationAverage_F32 r = new ImplOrientationAverage_F32(this.objectToSample, this.isWeighted);
        r.setSampleRadius(this.sampleRadius);
        return r;
    }
}

