/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.struct.feature.MatrixOfList;
import georegression.geometry.UtilLine2D_F32;
import georegression.metric.ClosestPoint2D_F32;
import georegression.metric.Distance2D_F32;
import georegression.metric.Intersection2D_F32;
import georegression.metric.UtilAngle;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ddogleg.sorting.QuickSort_F32;

public class LineImageOps {
    static double foo = 1.0E-4;

    public static List<LineParametric2D_F32> pruneRelativeIntensity(List<LineParametric2D_F32> lines, float[] intensity, float fraction) {
        int[] indexSort = new int[intensity.length];
        QuickSort_F32 sort = new QuickSort_F32();
        sort.sort(intensity, 0, lines.size(), indexSort);
        float threshold = intensity[indexSort[lines.size() - 1]] * fraction;
        ArrayList<LineParametric2D_F32> ret = new ArrayList<LineParametric2D_F32>();
        for (int i = 0; i < lines.size(); ++i) {
            if (!(intensity[i] >= threshold)) continue;
            ret.add(lines.get(i));
        }
        return ret;
    }

    public static List<LineParametric2D_F32> pruneSimilarLines(List<LineParametric2D_F32> lines, float[] intensity, float toleranceAngle, float toleranceDist, int imgWidth, int imgHeight) {
        int i;
        int[] indexSort = new int[intensity.length];
        QuickSort_F32 sort = new QuickSort_F32();
        sort.sort(intensity, 0, lines.size(), indexSort);
        float[] theta = new float[lines.size()];
        ArrayList<LineSegment2D_F32> segments = new ArrayList<LineSegment2D_F32>(lines.size());
        for (i = 0; i < lines.size(); ++i) {
            LineParametric2D_F32 l = lines.get(i);
            theta[i] = UtilAngle.atanSafe(l.getSlopeY(), l.getSlopeX());
            segments.add(LineImageOps.convert(l, imgWidth, imgHeight));
        }
        for (i = segments.size() - 1; i >= 0; --i) {
            LineSegment2D_F32 a = (LineSegment2D_F32)segments.get(indexSort[i]);
            if (a == null) continue;
            for (int j = i - 1; j >= 0; --j) {
                LineSegment2D_F32 b = (LineSegment2D_F32)segments.get(indexSort[j]);
                if (b == null || UtilAngle.distHalf(theta[indexSort[i]], theta[indexSort[j]]) > (double)toleranceAngle) continue;
                Point2D_F32 p = Intersection2D_F32.intersection(a, b, null);
                if (p != null && p.x >= 0.0f && p.y >= 0.0f && p.x < (float)imgWidth && p.y < (float)imgHeight) {
                    segments.set(indexSort[j], null);
                    continue;
                }
                float distA = Distance2D_F32.distance(a, b.a);
                float distB = Distance2D_F32.distance(a, b.b);
                if (!(distA <= toleranceDist) && !(distB < toleranceDist)) continue;
                segments.set(indexSort[j], null);
            }
        }
        ArrayList<LineParametric2D_F32> ret = new ArrayList<LineParametric2D_F32>();
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            if (segments.get(i2) == null) continue;
            ret.add(lines.get(i2));
        }
        return ret;
    }

    public static void pruneClutteredGrids(MatrixOfList<LineSegment2D_F32> lines, int threshold) {
        int N = lines.width * lines.height;
        for (int i = 0; i < N; ++i) {
            List l = lines.grid[i];
            if (l.size() <= threshold) continue;
            l.clear();
        }
    }

    public static void pruneSmall(List<LineSegment2D_F32> lines, float threshold) {
        threshold *= threshold;
        Iterator<LineSegment2D_F32> iter = lines.iterator();
        while (iter.hasNext()) {
            LineSegment2D_F32 l = iter.next();
            if (!(l.getLength2() <= threshold)) continue;
            iter.remove();
        }
    }

    public static void mergeSimilar(List<LineSegment2D_F32> lines, float thresholdAngle, float thresholdDist) {
        block0: for (int i = 0; i < lines.size(); ++i) {
            LineSegment2D_F32 a = lines.get(i);
            double thetaA = UtilAngle.atanSafe(a.slopeY(), a.slopeX());
            while (true) {
                int indexBest = -1;
                double distanceBest = thresholdDist;
                for (int j = i + 1; j < lines.size(); ++j) {
                    float distB;
                    float distA;
                    float dist;
                    LineSegment2D_F32 b = lines.get(j);
                    double thetaB = UtilAngle.atanSafe(b.slopeY(), b.slopeX());
                    if (UtilAngle.distHalf(thetaA, thetaB) > (double)thresholdAngle || !((double)(dist = Math.min(distA = Distance2D_F32.distance(a, b.a), distB = Distance2D_F32.distance(a, b.b))) < distanceBest)) continue;
                    distanceBest = dist;
                    indexBest = j;
                }
                if (indexBest == -1) continue block0;
                LineImageOps.mergeIntoA(a, lines.remove(indexBest));
                thetaA = UtilAngle.atanSafe(a.slopeY(), a.slopeX());
            }
        }
    }

    private static void mergeIntoA(LineSegment2D_F32 a, LineSegment2D_F32 b) {
        float min;
        LineParametric2D_F32 paraA = UtilLine2D_F32.convert(a, (LineParametric2D_F32)null);
        Point2D_F32[] pts = new Point2D_F32[4];
        float[] t = new float[4];
        pts[0] = a.a;
        pts[1] = a.b;
        pts[2] = b.a;
        pts[3] = b.b;
        for (int i = 0; i < 4; ++i) {
            t[i] = ClosestPoint2D_F32.closestPointT(paraA, pts[i]);
        }
        float max = min = t[0];
        int indexMin = 0;
        int indexMax = 0;
        for (int i = 1; i < 4; ++i) {
            float v = t[i];
            if (v < min) {
                min = v;
                indexMin = i;
            }
            if (!(v > max)) continue;
            max = v;
            indexMax = i;
        }
        a.a.setTo(pts[indexMin]);
        a.b.setTo(pts[indexMax]);
    }

    public static LineSegment2D_F32 convert(LineParametric2D_F32 l, int width, int height) {
        LineParametric2D_F32 side = new LineParametric2D_F32();
        side.p.setTo(0.0f, 0.0f);
        side.slope.setTo(1.0f, 0.0f);
        ArrayList<Point2D_F32> inside = new ArrayList<Point2D_F32>();
        Point2D_F32 a = new Point2D_F32();
        if (null != Intersection2D_F32.intersection(side, l, a)) {
            LineImageOps.checkAddInside(width, height, a, inside);
        }
        side.slope.setTo(0.0f, 1.0f);
        if (null != Intersection2D_F32.intersection(side, l, a)) {
            LineImageOps.checkAddInside(width, height, a, inside);
        }
        side.p.setTo(width - 1, height - 1);
        side.slope.setTo(-1.0f, 0.0f);
        if (null != Intersection2D_F32.intersection(side, l, a)) {
            LineImageOps.checkAddInside(width, height, a, inside);
        }
        side.slope.setTo(0.0f, -1.0f);
        if (null != Intersection2D_F32.intersection(side, l, a)) {
            LineImageOps.checkAddInside(width, height, a, inside);
        }
        if (inside.size() != 2) {
            return null;
        }
        return new LineSegment2D_F32((Point2D_F32)inside.get(0), (Point2D_F32)inside.get(1));
    }

    public static void checkAddInside(int width, int height, Point2D_F32 a, List<Point2D_F32> inside) {
        if (a.x >= 0.0f && a.x <= (float)width - 0.999f && a.y >= 0.0f && a.y <= (float)height - 0.999f) {
            for (int pointIdx = 0; pointIdx < inside.size(); ++pointIdx) {
                Point2D_F32 p = inside.get(pointIdx);
                if (!((double)p.distance(a) < foo)) continue;
                return;
            }
            inside.add(a.copy());
        }
    }
}

