/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class GeneralFeatureDetector<I extends ImageGray<I>, D extends ImageGray<D>> {
    protected QueueCorner maximums = new QueueCorner(10);
    protected QueueCorner minimums = new QueueCorner(10);
    @Nullable
    protected QueueCorner exclude;
    protected FeatureSelectLimitIntensity<Point2D_I16> selectMax;
    protected FastArray<Point2D_I16> selected = new FastArray<Point2D_I16>(Point2D_I16.class);
    protected int featureLimit;
    protected NonMaxSuppression extractorMin;
    protected NonMaxSuppression extractorMax;
    protected GeneralFeatureIntensity<I, D> intensity;
    protected QueueCorner found = new QueueCorner(10);

    public GeneralFeatureDetector(GeneralFeatureIntensity<I, D> intensity, @Nullable NonMaxSuppression extractorMin, @Nullable NonMaxSuppression extractorMax, FeatureSelectLimitIntensity<Point2D_I16> selectMax) {
        if (extractorMin == null && intensity.localMinimums()) {
            throw new IllegalArgumentException("Must provide a minimum extractor");
        }
        if (extractorMax == null && intensity.localMaximums()) {
            throw new IllegalArgumentException("Must provide a maximum extractor");
        }
        if (extractorMin != null && !extractorMin.canDetectMinimums()) {
            throw new IllegalArgumentException("The minimum extractor doesn't detect minimums");
        }
        if (extractorMax != null && !extractorMax.canDetectMaximums()) {
            throw new IllegalArgumentException("The maximum extractor doesn't detect maximums");
        }
        if (extractorMin != null && extractorMin.getUsesCandidates() && !intensity.hasCandidates()) {
            throw new IllegalArgumentException("The extractor requires candidate features, which the intensity does not provide.");
        }
        if (extractorMax != null && extractorMax.getUsesCandidates() && !intensity.hasCandidates()) {
            throw new IllegalArgumentException("The extractor requires candidate features, which the intensity does not provide.");
        }
        this.intensity = intensity;
        this.extractorMin = extractorMin;
        this.extractorMax = extractorMax;
        this.selectMax = selectMax;
        if (intensity.localMinimums() && intensity.getIgnoreBorder() > extractorMin.getIgnoreBorder()) {
            extractorMin.setIgnoreBorder(intensity.getIgnoreBorder());
        }
        if (intensity.localMaximums() && intensity.getIgnoreBorder() > extractorMax.getIgnoreBorder()) {
            extractorMax.setIgnoreBorder(intensity.getIgnoreBorder());
        }
    }

    protected GeneralFeatureDetector() {
    }

    public void process(I image, D derivX, D derivY, D derivXX, D derivYY, D derivXY) {
        this.minimums.reset();
        this.maximums.reset();
        this.intensity.process(image, derivX, derivY, derivXX, derivYY, derivXY);
        GrayF32 intensityImage = this.intensity.getIntensity();
        int limitPerSetMin = -1;
        int limitPerSetMax = -1;
        if (this.featureLimit > 0) {
            if (this.intensity.localMaximums() && this.intensity.localMinimums()) {
                limitPerSetMin = this.featureLimit / 2;
                limitPerSetMax = this.featureLimit - limitPerSetMin;
            } else if (this.intensity.localMinimums()) {
                limitPerSetMin = this.featureLimit;
            } else if (this.intensity.localMaximums()) {
                limitPerSetMax = this.featureLimit;
            }
        }
        if (this.intensity.localMinimums()) {
            this.markExcludedPixels(intensityImage, -3.4028235E38f);
            if (this.intensity.hasCandidates()) {
                this.extractorMin.process(intensityImage, this.intensity.getCandidatesMin(), null, this.found, null);
            } else {
                this.extractorMin.process(intensityImage, null, null, this.found, null);
            }
            this.resolveSelectAmbiguity(intensityImage, this.exclude, this.found, this.minimums, limitPerSetMin, false);
        }
        if (this.intensity.localMaximums()) {
            this.markExcludedPixels(intensityImage, Float.MAX_VALUE);
            if (this.intensity.hasCandidates()) {
                this.extractorMax.process(intensityImage, null, this.intensity.getCandidatesMax(), null, this.found);
            } else {
                this.extractorMax.process(intensityImage, null, null, null, this.found);
            }
            this.resolveSelectAmbiguity(intensityImage, this.exclude, this.found, this.maximums, limitPerSetMax, true);
        }
    }

    private void markExcludedPixels(GrayF32 intensityImage, float value) {
        if (this.exclude == null) {
            return;
        }
        for (int i = 0; i < this.exclude.size; ++i) {
            Point2D_I16 p = (Point2D_I16)this.exclude.get(i);
            intensityImage.unsafe_set(p.x, p.y, value);
        }
    }

    private void resolveSelectAmbiguity(GrayF32 intensity, QueueCorner excluded, QueueCorner found, QueueCorner output, int numSelect, boolean positive) {
        output.reset();
        if (numSelect > 0) {
            this.selectMax.select(intensity, -1, -1, positive, excluded, found, numSelect, this.selected);
            output.appendAll(this.selected);
        } else {
            output.appendAll(found);
        }
    }

    public boolean getRequiresGradient() {
        return this.intensity.getRequiresGradient();
    }

    public boolean getRequiresHessian() {
        return this.intensity.getRequiresHessian();
    }

    public GrayF32 getIntensity() {
        return this.intensity.getIntensity();
    }

    public void setThreshold(float threshold) {
        if (this.extractorMin != null) {
            this.extractorMin.setThresholdMinimum(-threshold);
        }
        if (this.extractorMax != null) {
            this.extractorMax.setThresholdMaximum(threshold);
        }
    }

    public float getThreshold() {
        return this.extractorMin != null ? -this.extractorMin.getThresholdMinimum() : this.extractorMax.getThresholdMaximum();
    }

    public boolean isDetectMinimums() {
        return this.intensity.localMinimums();
    }

    public boolean isDetectMaximums() {
        return this.intensity.localMaximums();
    }

    public void setSearchRadius(int radius) {
        if (this.extractorMin != null) {
            this.extractorMin.setSearchRadius(radius);
        }
        if (this.extractorMax != null) {
            this.extractorMax.setSearchRadius(radius);
        }
    }

    public int getSearchRadius() {
        return this.extractorMin != null ? this.extractorMin.getSearchRadius() : this.extractorMax.getSearchRadius();
    }

    @Nullable
    public Class<I> getImageType() {
        return this.intensity.getImageType();
    }

    @Nullable
    public Class<D> getDerivType() {
        return this.intensity.getDerivType();
    }

    public QueueCorner getMaximums() {
        return this.maximums;
    }

    public QueueCorner getMinimums() {
        return this.minimums;
    }

    @Nullable
    public QueueCorner getExclude() {
        return this.exclude;
    }

    public void setExclude(@Nullable QueueCorner exclude) {
        this.exclude = exclude;
    }

    public FeatureSelectLimitIntensity<Point2D_I16> getSelectMax() {
        return this.selectMax;
    }

    public int getFeatureLimit() {
        return this.featureLimit;
    }

    public void setFeatureLimit(int featureLimit) {
        this.featureLimit = featureLimit;
    }

    public NonMaxSuppression getExtractorMin() {
        return this.extractorMin;
    }

    public NonMaxSuppression getExtractorMax() {
        return this.extractorMax;
    }
}

