/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxCandidate;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.ListIntPoint2D;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.DogArray;
import pabeles.concurrency.GrowArray;

public class NonMaxCandidate_MT
extends NonMaxCandidate {
    final GrowArray<SearchData> searches = new GrowArray<SearchData>(this::createSearchData);

    public NonMaxCandidate_MT(NonMaxCandidate.Search search) {
        super(search);
    }

    @Override
    protected void examineMinimum(GrayF32 intensityImage, ListIntPoint2D candidates, DogArray<Point2D_I16> found) {
        found.reset();
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        BoofConcurrency.loopBlocks(0, candidates.size(), this.searches, (blockData, idx0, idx1) -> {
            Point2D_I16 pt = blockData.pt;
            QueueCorner threadCorners = blockData.corners;
            NonMaxCandidate.Search search = blockData.search;
            threadCorners.reset();
            search.initialize(intensityImage);
            for (int candidateIdx = idx0; candidateIdx < idx1; ++candidateIdx) {
                int y1;
                int x1;
                int y0;
                int x0;
                int center;
                float val2;
                candidates.get(candidateIdx, pt);
                if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val2 = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) > this.thresholdMin || val2 == -3.4028235E38f || !search.searchMin(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val2)) continue;
                threadCorners.append(pt.x, pt.y);
            }
        });
        for (int i = 0; i < this.searches.size(); ++i) {
            found.copyAll(this.searches.get((int)i).corners.toList(), (src, dst) -> dst.setTo((Point2D_I16)src));
        }
    }

    @Override
    protected void examineMaximum(GrayF32 intensityImage, ListIntPoint2D candidates, DogArray<Point2D_I16> found) {
        found.reset();
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        BoofConcurrency.loopBlocks(0, candidates.size(), this.searches, (blockData, idx0, idx1) -> {
            Point2D_I16 pt = blockData.pt;
            QueueCorner threadCorners = blockData.corners;
            NonMaxCandidate.Search search = blockData.search;
            threadCorners.reset();
            search.initialize(intensityImage);
            for (int candidateIdx = idx0; candidateIdx < idx1; ++candidateIdx) {
                int y1;
                int x1;
                int y0;
                int x0;
                int center;
                float val2;
                candidates.get(candidateIdx, pt);
                if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val2 = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) < this.thresholdMax || val2 == Float.MAX_VALUE || !search.searchMax(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val2)) continue;
                threadCorners.append(pt.x, pt.y);
            }
        });
        for (int i = 0; i < this.searches.size(); ++i) {
            found.copyAll(this.searches.get((int)i).corners.toList(), (src, dst) -> dst.setTo((Point2D_I16)src));
        }
    }

    public SearchData createSearchData() {
        return new SearchData(this.search.newInstance());
    }

    protected static class SearchData {
        public final NonMaxCandidate.Search search;
        public final QueueCorner corners = new QueueCorner();
        public final Point2D_I16 pt = new Point2D_I16();

        public SearchData(NonMaxCandidate.Search search) {
            this.search = search;
        }
    }
}

