/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detdesc;

import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;

public class DetectDescribeSurfPlanar<II extends ImageGray<II>> {
    protected FastHessianFeatureDetector<II> detector;
    protected OrientationIntegral<II> orientation;
    protected DescribePointSurfPlanar<II> describe;
    protected DogArray<TupleDesc_F64> descriptions;
    protected List<ScalePoint> foundPoints;
    protected DogArray_F64 featureAngles = new DogArray_F64(10);

    public DetectDescribeSurfPlanar(FastHessianFeatureDetector<II> detector, OrientationIntegral<II> orientation, DescribePointSurfPlanar<II> describe) {
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        this.descriptions = new DogArray<TupleDesc_F64>(() -> new TupleDesc_F64(describe.getDescriptorLength()));
    }

    public TupleDesc_F64 createDescription() {
        return this.describe.createDescription();
    }

    public TupleDesc_F64 getDescription(int index) {
        return (TupleDesc_F64)this.descriptions.get(index);
    }

    public boolean isWhite(int index) {
        return this.detector.getFoundFeatures().get((int)index).white;
    }

    public void detect(II grayII, Planar<II> colorII) {
        this.descriptions.reset();
        this.featureAngles.reset();
        this.detector.detect(grayII);
        this.foundPoints = this.detector.getFoundFeatures();
        this.descriptions.resize(this.foundPoints.size());
        this.featureAngles.resize(this.foundPoints.size());
        this.describe(grayII, colorII);
    }

    protected void describe(II grayII, Planar<II> colorII) {
        this.orientation.setImage(grayII);
        this.describe.setImage(grayII, colorII);
        for (int i = 0; i < this.foundPoints.size(); ++i) {
            ScalePoint p = this.foundPoints.get(i);
            this.orientation.setObjectRadius(p.scale);
            double angle = this.orientation.compute(p.pixel.x, p.pixel.y);
            this.describe.describe(p.pixel.x, p.pixel.y, angle, p.scale, (TupleDesc_F64)this.descriptions.get(i));
            this.featureAngles.set(i, angle);
        }
    }

    public DescribePointSurfPlanar<II> getDescribe() {
        return this.describe;
    }

    public int getNumberOfFeatures() {
        return this.foundPoints.size();
    }

    public Point2D_F64 getLocation(int featureIndex) {
        return this.foundPoints.get((int)featureIndex).pixel;
    }

    public double getRadius(int featureIndex) {
        return this.foundPoints.get((int)featureIndex).scale;
    }

    public double getOrientation(int featureIndex) {
        return this.featureAngles.get(featureIndex);
    }
}

