/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.alg.feature.associate.AssociateNearestNeighbor;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.feature.AssociatedIndex;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import pabeles.concurrency.IntRangeConsumer;

public class AssociateNearestNeighbor_MT<D>
extends AssociateNearestNeighbor<D> {
    private final List<Helper> available = new ArrayList<Helper>();
    private Class<D> descType;

    public AssociateNearestNeighbor_MT(NearestNeighbor<D> alg, Class<D> descType) {
        super(alg);
        this.descType = descType;
    }

    @Override
    public void setSource(FastAccess<D> listSrc) {
        this.sizeSrc = listSrc.size;
        this.alg.setPoints(listSrc.toList(), true);
    }

    @Override
    public void setDestination(FastAccess<D> listDst) {
        this.listDst = listDst;
    }

    @Override
    public void associate() {
        this.matchesAll.resize(this.listDst.size);
        this.matchesAll.reset();
        if (this.scoreRatioThreshold >= 1.0) {
            BoofConcurrency.loopBlocks(0, this.listDst.size, new InnerConsumer(){

                @Override
                public void innerAccept(Helper h, int index0, int index1) {
                    for (int i = index0; i < index1; ++i) {
                        if (!h.search.findNearest(AssociateNearestNeighbor_MT.this.listDst.data[i], AssociateNearestNeighbor_MT.this.maxDistance, h.result)) continue;
                        h.matches.grow().setTo(((Helper)h).result.index, i, ((Helper)h).result.distance);
                    }
                }
            });
        } else {
            BoofConcurrency.loopBlocks(0, this.listDst.size, new InnerConsumer(){

                @Override
                public void innerAccept(Helper h, int index0, int index1) {
                    for (int i = index0; i < index1; ++i) {
                        h.search.findNearest(AssociateNearestNeighbor_MT.this.listDst.data[i], AssociateNearestNeighbor_MT.this.maxDistance, 2, h.result2);
                        if (((Helper)h).result2.size == 1) {
                            NnData r = (NnData)h.result2.getTail();
                            h.matches.grow().setTo(r.index, i, r.distance);
                            continue;
                        }
                        if (((Helper)h).result2.size == 2) {
                            double foundRatio;
                            NnData r0 = (NnData)h.result2.get(0);
                            NnData r1 = (NnData)h.result2.get(1);
                            if (r0.distance > r1.distance) {
                                NnData tmp = r0;
                                r0 = r1;
                                r1 = tmp;
                            }
                            double d = foundRatio = AssociateNearestNeighbor_MT.this.ratioUsesSqrt ? Math.sqrt(r0.distance) / Math.sqrt(r1.distance) : r0.distance / r1.distance;
                            if (!(foundRatio <= AssociateNearestNeighbor_MT.this.scoreRatioThreshold)) continue;
                            h.matches.grow().setTo(r0.index, i, r0.distance);
                            continue;
                        }
                        if (((Helper)h).result2.size == 0) continue;
                        throw new RuntimeException("BUG! 0,1,2 are acceptable not " + ((Helper)h).result2.size);
                    }
                }
            });
        }
    }

    @Override
    public Class<D> getDescriptionType() {
        return this.descType;
    }

    private class Helper {
        NearestNeighbor.Search<D> search;
        DogArray<AssociatedIndex> matches = new DogArray<AssociatedIndex>(10, AssociatedIndex::new);
        private NnData<D> result = new NnData();
        private DogArray<NnData<D>> result2 = new DogArray<Object>(NnData::new);

        Helper() {
            this.search = AssociateNearestNeighbor_MT.this.alg.createSearch();
        }

        public void initialize() {
            this.matches.reset();
            this.result2.reset();
        }
    }

    private abstract class InnerConsumer
    implements IntRangeConsumer {
        private InnerConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(int index0, int index1) {
            Helper h;
            Object object = AssociateNearestNeighbor_MT.this.available;
            synchronized (object) {
                if (AssociateNearestNeighbor_MT.this.available.isEmpty()) {
                    h = new Helper();
                } else {
                    h = (Helper)AssociateNearestNeighbor_MT.this.available.remove(AssociateNearestNeighbor_MT.this.available.size() - 1);
                    h.initialize();
                }
            }
            this.innerAccept(h, index0, index1);
            object = AssociateNearestNeighbor_MT.this.matchesAll;
            synchronized (object) {
                for (int i = 0; i < h.matches.size; ++i) {
                    AssociatedIndex a = (AssociatedIndex)h.matches.get(i);
                    ((AssociatedIndex)AssociateNearestNeighbor_MT.this.matchesAll.grow()).setTo(a);
                }
            }
            object = AssociateNearestNeighbor_MT.this.available;
            synchronized (object) {
                AssociateNearestNeighbor_MT.this.available.add(h);
            }
        }

        public abstract void innerAccept(Helper var1, int var2, int var3);
    }
}

