/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.pinhole;

import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;

public class PinholeNtoP_F32
implements Point2Transform2_F32 {
    private float fx;
    private float fy;
    private float skew;
    private float cx;
    private float cy;

    public PinholeNtoP_F32(PinholeNtoP_F32 original) {
        this.fx = original.fx;
        this.fy = original.fy;
        this.skew = original.skew;
        this.cx = original.cx;
        this.cy = original.cy;
    }

    public PinholeNtoP_F32() {
    }

    public PinholeNtoP_F32 setK(CameraPinhole pinhole) {
        return this.setK(pinhole.fx, pinhole.fy, pinhole.skew, pinhole.cx, pinhole.cy);
    }

    public PinholeNtoP_F32 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = (float)fx;
        this.fy = (float)fy;
        this.skew = (float)skew;
        this.cx = (float)cx;
        this.cy = (float)cy;
        return this;
    }

    @Override
    public void compute(float x, float y, Point2D_F32 out) {
        out.x = this.fx * x + this.skew * y + this.cx;
        out.y = this.fy * y + this.cy;
    }

    @Override
    public PinholeNtoP_F32 copyConcurrent() {
        return new PinholeNtoP_F32(this);
    }
}

