/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.impl;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.impl.ImplImageDistort_PL;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.distort.FactoryDistort;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.se.Se2_F32;
import georegression.transform.ConvertTransform_F32;
import georegression.transform.InvertibleTransformSequence;

public class DistortSupport {
    public static PixelTransformAffine_F32 transformScale(ImageBase from, ImageBase to, PixelTransformAffine_F32 distort) {
        if (distort == null) {
            distort = new PixelTransformAffine_F32();
        }
        float scaleX = (float)to.width / (float)from.width;
        float scaleY = (float)to.height / (float)from.height;
        Affine2D_F32 affine = distort.getModel();
        affine.setTo(scaleX, 0.0f, 0.0f, scaleY, 0.0f, 0.0f);
        return distort;
    }

    public static PixelTransformAffine_F32 transformRotate(float x0, float y0, float x1, float y1, float angle) {
        Affine2D_F32 affine = DistortSupport.rotateCenterAffine(x0, y0, x1, y1, angle);
        PixelTransformAffine_F32 distort = new PixelTransformAffine_F32();
        distort.setTo(affine);
        return distort;
    }

    public static Affine2D_F32 rotateCenterAffine(float x0, float y0, float x1, float y1, float angle) {
        Se2_F32 imageToCenter = new Se2_F32(-x0, -y0, 0.0f);
        Se2_F32 rotate = new Se2_F32(0.0f, 0.0f, angle);
        Se2_F32 centerToImage = new Se2_F32(x1, y1, 0.0f);
        InvertibleTransformSequence<Se2_F32> sequence = new InvertibleTransformSequence<Se2_F32>();
        sequence.addTransform(true, imageToCenter);
        sequence.addTransform(true, rotate);
        sequence.addTransform(true, centerToImage);
        Se2_F32 total = new Se2_F32();
        sequence.computeTransform(total);
        Se2_F32 inv = total.invert((Se2_F32)null);
        return ConvertTransform_F32.convert(inv, (Affine2D_F32)null);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ImageDistort<Planar<Input>, Planar<Output>> createDistortPL(Class<Output> outputType, PixelTransform<Point2D_F32> dstToSrc, InterpolatePixelS<Input> interp, boolean cached) {
        ImageDistort<Input, Output> bandDistort = FactoryDistort.distortSB(cached, interp, outputType);
        bandDistort.setModel(dstToSrc);
        return new ImplImageDistort_PL<Input, Output>(bandDistort);
    }
}

