/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.abst.distort.FDistort;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;

public class RemovePerspectiveDistortion<T extends ImageBase<T>> {
    FDistort distort;
    Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyDLT(true);
    DMatrixRMaj H = new DMatrixRMaj(3, 3);
    FMatrixRMaj H32 = new FMatrixRMaj(3, 3);
    PointTransformHomography_F32 transform = new PointTransformHomography_F32();
    ArrayList<AssociatedPair> associatedPairs = new ArrayList();
    T output;

    public RemovePerspectiveDistortion(int width, int height, ImageType<T> imageType) {
        this(width, height);
        this.output = imageType.createImage(width, height);
        this.distort = new FDistort(imageType);
        this.distort.output((ImageBase)this.output);
        this.distort.interp(InterpolationType.BILINEAR).transform(this.transform);
    }

    public RemovePerspectiveDistortion(int width, int height) {
        for (int i = 0; i < 4; ++i) {
            this.associatedPairs.add(new AssociatedPair());
        }
        this.associatedPairs.get((int)0).p1.setTo(0.0, 0.0);
        this.associatedPairs.get((int)1).p1.setTo(width, 0.0);
        this.associatedPairs.get((int)2).p1.setTo(width, height);
        this.associatedPairs.get((int)3).p1.setTo(0.0, height);
    }

    public boolean apply(T input, Point2D_F64 corner0, Point2D_F64 corner1, Point2D_F64 corner2, Point2D_F64 corner3) {
        if (this.createTransform(corner0, corner1, corner2, corner3)) {
            this.distort.input((ImageBase)input).apply();
            return true;
        }
        return false;
    }

    public boolean createTransform(Point2D_F64 tl, Point2D_F64 tr, Point2D_F64 br, Point2D_F64 bl) {
        this.associatedPairs.get((int)0).p2.setTo(tl);
        this.associatedPairs.get((int)1).p2.setTo(tr);
        this.associatedPairs.get((int)2).p2.setTo(br);
        this.associatedPairs.get((int)3).p2.setTo(bl);
        if (!this.computeHomography.process(this.associatedPairs, this.H)) {
            return false;
        }
        ConvertMatrixData.convert(this.H, this.H32);
        this.transform.set(this.H32);
        return true;
    }

    public DMatrixRMaj getH() {
        return this.H;
    }

    public PointTransformHomography_F32 getTransform() {
        return this.transform;
    }

    public T getOutput() {
        return this.output;
    }
}

