/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;

public class BackgroundStationaryGaussian_IL<T extends ImageInterleaved<T>>
extends BackgroundStationaryGaussian<T> {
    protected GImageMultiBand inputWrapper;
    protected GImageMultiBand bgWrapper;
    protected float[] inputPixel;
    protected float[] bgPixel;
    InterleavedF32 background;

    public BackgroundStationaryGaussian_IL(float learnRate, float threshold, ImageType<T> imageType) {
        super(learnRate, threshold, imageType);
        int numBands = imageType.getNumBands();
        this.background = new InterleavedF32(1, 1, 2 * numBands);
        this.bgWrapper = FactoryGImageMultiBand.create(this.background.getImageType());
        this.bgWrapper.wrap(this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.inputPixel = new float[numBands];
        this.bgPixel = new float[numBands * 2];
    }

    @Override
    public void reset() {
        this.background.reshape(1, 1);
    }

    @Override
    public void updateBackground(T frame) {
        this.inputWrapper.wrap((ImageBase)frame);
        if (this.background.width == 1) {
            this.background.reshape(((ImageInterleaved)frame).width, ((ImageInterleaved)frame).height);
            for (int y = 0; y < ((ImageInterleaved)frame).height; ++y) {
                for (int x = 0; x < ((ImageInterleaved)frame).width; ++x) {
                    this.inputWrapper.get(x, y, this.inputPixel);
                    for (int i = 0; i < ((ImageInterleaved)frame).numBands; ++i) {
                        this.bgPixel[i * 2] = this.inputPixel[i];
                        this.bgPixel[i * 2 + 1] = this.initialVariance;
                    }
                    this.bgWrapper.set(x, y, this.bgPixel);
                }
            }
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame);
        int numBands = this.background.getNumBands() / 2;
        float minusLearn = 1.0f - this.learnRate;
        int indexBG = 0;
        for (int y = 0; y < this.background.height; ++y) {
            int indexInput;
            int end = indexInput + ((ImageInterleaved)frame).width * numBands;
            for (indexInput = ((ImageInterleaved)frame).startIndex + y * ((ImageInterleaved)frame).stride; indexInput < end; indexInput += ((ImageInterleaved)frame).numBands) {
                this.inputWrapper.getF(indexInput, this.inputPixel);
                for (int band = 0; band < numBands; ++band) {
                    float inputValue = this.inputPixel[band];
                    float meanBG = this.background.data[indexBG];
                    float varianceBG = this.background.data[indexBG + 1];
                    float diff = meanBG - inputValue;
                    this.background.data[indexBG++] = minusLearn * meanBG + this.learnRate * inputValue;
                    this.background.data[indexBG++] = minusLearn * varianceBG + this.learnRate * diff * diff;
                }
            }
        }
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        if (this.background.width == 1) {
            ImageMiscOps.fill(segmented, (int)this.unknownValue);
            return;
        }
        this.inputWrapper.wrap((ImageBase)frame);
        int numBands = this.background.getNumBands() / 2;
        float adjustedMinimumDifference = this.minimumDifference * (float)numBands;
        int indexBG = 0;
        for (int y = 0; y < ((ImageInterleaved)frame).height; ++y) {
            int indexInput = ((ImageInterleaved)frame).startIndex + y * ((ImageInterleaved)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + ((ImageInterleaved)frame).width * ((ImageInterleaved)frame).numBands;
            while (indexInput < end) {
                this.inputWrapper.getF(indexInput, this.inputPixel);
                float mahalanobis = 0.0f;
                for (int band = 0; band < numBands; ++band) {
                    int indexBG_band = indexBG + band * 2;
                    float meanBG = this.background.data[indexBG_band];
                    float varBG = this.background.data[indexBG_band + 1];
                    float diff = meanBG - this.inputPixel[band];
                    mahalanobis += diff * diff / varBG;
                }
                if (mahalanobis <= this.threshold) {
                    segmented.data[indexSegmented] = 0;
                } else if (this.minimumDifference == 0.0f) {
                    segmented.data[indexSegmented] = 1;
                } else {
                    float sumAbsDiff = 0.0f;
                    for (int band = 0; band < numBands; ++band) {
                        int indexBG_band = indexBG + band * 2;
                        sumAbsDiff += Math.abs(this.background.data[indexBG_band] - this.inputPixel[band]);
                    }
                    segmented.data[indexSegmented] = sumAbsDiff >= adjustedMinimumDifference ? (byte)1 : 0;
                }
                indexInput += ((ImageInterleaved)frame).numBands;
                ++indexSegmented;
                indexBG += this.background.numBands;
            }
        }
    }
}

