/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class BackgroundStationaryBasic_PL<T extends ImageGray<T>>
extends BackgroundStationaryBasic<Planar<T>> {
    protected Planar<GrayF32> background;
    protected GImageMultiBand inputWrapper;
    protected float[] inputPixels;

    public BackgroundStationaryBasic_PL(float learnRate, float threshold, ImageType<Planar<T>> imageType) {
        super(learnRate, threshold, imageType);
        int numBands = imageType.getNumBands();
        this.background = new Planar<GrayF32>(GrayF32.class, 0, 0, numBands);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.inputPixels = new float[numBands];
    }

    public Planar<GrayF32> getBackground() {
        return this.background;
    }

    @Override
    public void reset() {
        this.background.reshape(0, 0);
    }

    @Override
    public void updateBackground(Planar<T> frame) {
        if (this.background.width != frame.width) {
            this.background.reshape(frame.width, frame.height);
            GConvertImage.convert(frame, this.background);
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame);
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands();
        float minusLearn = 1.0f - this.learnRate;
        int indexBG = 0;
        for (int y = 0; y < frame.height; ++y) {
            int indexInput = frame.startIndex + y * frame.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                this.inputWrapper.getF(indexInput, this.inputPixels);
                for (int band = 0; band < numBands; ++band) {
                    GrayF32 backgroundBand = this.background.getBand(band);
                    backgroundBand.data[indexBG] = minusLearn * backgroundBand.data[indexBG] + this.learnRate * this.inputPixels[band];
                }
                ++indexInput;
                ++indexBG;
            }
        }
    }

    @Override
    public void segment(Planar<T> frame, GrayU8 segmented) {
        if (this.background.width != frame.width) {
            ImageMiscOps.fill(segmented, (int)this.unknownValue);
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame, segmented);
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands();
        float thresholdSq = (float)numBands * this.threshold * this.threshold;
        int indexBG = 0;
        for (int y = 0; y < frame.height; ++y) {
            int indexInput = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                this.inputWrapper.getF(indexInput, this.inputPixels);
                double sumErrorSq = 0.0;
                for (int band = 0; band < numBands; ++band) {
                    float diff = this.background.getBand((int)band).data[indexBG] - this.inputPixels[band];
                    sumErrorSq += (double)(diff * diff);
                }
                segmented.data[indexSegmented] = sumErrorSq <= (double)thresholdSq ? (byte)0 : 1;
                ++indexInput;
                ++indexSegmented;
                ++indexBG;
            }
        }
    }
}

