/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingBasic_SB<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingBasic<T, Motion> {
    protected GrayF32 background = new GrayF32(1, 1);
    protected InterpolatePixelS<T> interpolateInput;
    protected InterpolatePixelS<GrayF32> interpolationBG;
    protected GImageGray inputWrapper;

    public BackgroundMovingBasic_SB(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, Class<T> imageType) {
        super(learnRate, threshold, transform, ImageType.single(imageType));
        this.interpolateInput = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        this.interpolationBG = FactoryInterpolation.createPixelS(0.0, 255.0, interpType, BorderType.EXTENDED, GrayF32.class);
        this.interpolationBG.setBorder((ImageBorder<GrayF32>)FactoryImageBorder.single(BorderType.EXTENDED, GrayF32.class));
        this.interpolationBG.setImage(this.background);
        this.inputWrapper = FactoryGImageGray.create(imageType);
    }

    public GrayF32 getBackground() {
        return this.background;
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        ImageMiscOps.fill(this.background, Float.MAX_VALUE);
        this.homeToWorld.setTo(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        ImageMiscOps.fill(this.background, Float.MAX_VALUE);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.transform.setModel(this.worldToCurrent);
        this.interpolateInput.setImage(frame);
        float minusLearn = 1.0f - this.learnRate;
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0;
            int x = x0;
            while (x < x1) {
                this.transform.compute(x, y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)((ImageGray)frame).width && this.work.y >= 0.0f && this.work.y < (float)((ImageGray)frame).height) {
                    float value = this.interpolateInput.get(this.work.x, this.work.y);
                    float bg = this.background.data[indexBG];
                    this.background.data[indexBG] = bg == Float.MAX_VALUE ? value : minusLearn * bg + this.learnRate * value;
                }
                ++x;
                ++indexBG;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap((ImageGray)frame);
        float thresholdSq = this.threshold * this.threshold;
        for (int y = 0; y < ((ImageGray)frame).height; ++y) {
            int indexFrame = ((ImageGray)frame).startIndex + y * ((ImageGray)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < ((ImageGray)frame).width) {
                this.transform.compute(x, y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                    float diff;
                    float bg = this.interpolationBG.get(this.work.x, this.work.y);
                    float pixelFrame = this.inputWrapper.getF(indexFrame);
                    segmented.data[indexSegmented] = bg == Float.MAX_VALUE ? this.unknownValue : ((diff = bg - pixelFrame) * diff <= thresholdSq ? (byte)0 : 1);
                } else {
                    segmented.data[indexSegmented] = this.unknownValue;
                }
                ++x;
                ++indexFrame;
                ++indexSegmented;
            }
        }
    }
}

