/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.optimization;

import boofcv.alg.geo.ModelObservationResidualN;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.functions.FunctionNtoM;

public class ResidualsCodecToMatrix<Model, Observation>
implements FunctionNtoM {
    protected ModelCodec<Model> param;
    protected List<Observation> obs;
    protected ModelObservationResidualN<Model, Observation> residual;
    protected Model pose;

    public ResidualsCodecToMatrix(ModelCodec<Model> param, ModelObservationResidualN<Model, Observation> residual, Model storage) {
        this.param = param;
        this.residual = residual;
        this.pose = storage;
    }

    public void setObservations(List<Observation> obs) {
        this.obs = obs;
    }

    @Override
    public int getNumOfInputsN() {
        return this.param.getParamLength();
    }

    @Override
    public int getNumOfOutputsM() {
        return this.obs.size() * this.residual.getN();
    }

    @Override
    public void process(double[] input, double[] output) {
        this.param.decode(input, this.pose);
        this.residual.setModel(this.pose);
        int index = 0;
        for (int i = 0; i < this.obs.size(); ++i) {
            index = this.residual.computeResiduals(this.obs.get(i), output, index);
        }
    }
}

