/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.abst.filter.binary.BinaryContourInterface;
import boofcv.alg.filter.binary.ContourPacked;
import boofcv.alg.filter.binary.LinearExternalContours;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.ConnectRule;
import boofcv.struct.PackedSetsPoint2D_I32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class BinaryContourFinderLinearExternal
implements BinaryContourFinder,
BinaryContourInterface.Padded {
    LinearExternalContours alg;
    boolean copyForPadding = true;
    int adjustX;
    int adjustY;
    GrayU8 work = new GrayU8(1, 1);
    DogArray<ContourPacked> contours = new DogArray<ContourPacked>(ContourPacked::new);

    public BinaryContourFinderLinearExternal() {
        this.alg = new LinearExternalContours(ConnectRule.FOUR);
    }

    @Override
    public void process(GrayU8 binary) {
        if (this.copyForPadding) {
            this.work.reshape(binary.width + 2, binary.height + 2);
            ImageMiscOps.copy(0, 0, 1, 1, binary.width, binary.height, binary, this.work);
            this.alg.process(this.work, 1, 1);
        } else {
            this.alg.process(binary, this.adjustX, this.adjustY);
        }
        this.contours.reset();
        PackedSetsPoint2D_I32 points = this.alg.getExternalContours();
        int i = 0;
        while (i < points.size()) {
            ContourPacked p = this.contours.grow();
            p.externalIndex = i;
            p.id = i++;
        }
    }

    @Override
    public List<ContourPacked> getContours() {
        return this.contours.toList();
    }

    @Override
    public void loadContour(int contourID, DogArray<Point2D_I32> storage) {
        this.alg.getExternalContours().getSet(contourID, storage);
    }

    @Override
    public void writeContour(int contourID, List<Point2D_I32> storage) {
        this.alg.getExternalContours().writeOverSet(contourID, storage);
    }

    @Override
    public void setSaveInnerContour(boolean enabled) {
    }

    @Override
    public boolean isSaveInternalContours() {
        return false;
    }

    @Override
    public void setMinContour(int length) {
        this.alg.setMinContourLength(length);
    }

    @Override
    public int getMinContour() {
        return this.alg.getMinContourLength();
    }

    @Override
    public void setMaxContour(int length) {
        this.alg.setMaxContourLength(length);
    }

    @Override
    public int getMaxContour() {
        return this.alg.getMaxContourLength();
    }

    @Override
    public void setConnectRule(ConnectRule rule) {
        this.alg.setConnectRule(rule);
    }

    @Override
    public ConnectRule getConnectRule() {
        return this.alg.getConnectRule();
    }

    @Override
    public void setCreatePaddedCopy(boolean padded) {
        this.copyForPadding = padded;
    }

    @Override
    public boolean isCreatePaddedCopy() {
        return this.copyForPadding;
    }

    @Override
    public void setCoordinateAdjustment(int x, int y) {
        this.adjustX = x;
        this.adjustY = y;
    }
}

