# coding: utf-8

"""
    Yahoo!広告 検索広告 API リファレンス / Yahoo! JAPAN Ads Search Ads API Reference

    <div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_search_api.configuration import Configuration


class Feed(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'domain': 'str',
        'feed_attribute': 'list[FeedServiceAttribute]',
        'feed_id': 'int',
        'feed_name': 'str',
        'feed_track_id': 'int',
        'placeholder_type': 'FeedServicePlaceholderType'
    }

    attribute_map = {
        'account_id': 'accountId',
        'domain': 'domain',
        'feed_attribute': 'feedAttribute',
        'feed_id': 'feedId',
        'feed_name': 'feedName',
        'feed_track_id': 'feedTrackId',
        'placeholder_type': 'placeholderType'
    }

    def __init__(self, account_id=None, domain=None, feed_attribute=None, feed_id=None, feed_name=None, feed_track_id=None, placeholder_type=None, local_vars_configuration=None):  # noqa: E501
        """Feed - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._domain = None
        self._feed_attribute = None
        self._feed_id = None
        self._feed_name = None
        self._feed_track_id = None
        self._placeholder_type = None
        self.discriminator = None

        self.account_id = account_id
        self.domain = domain
        self.feed_attribute = feed_attribute
        self.feed_id = feed_id
        self.feed_name = feed_name
        self.feed_track_id = feed_track_id
        self.placeholder_type = placeholder_type

    @property
    def account_id(self):
        """Gets the account_id of this Feed.  # noqa: E501

        <div lang=\"ja\">アカウントIDです。<br> ※入稿の仕様変更により不要になりました。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Account ID.<br> *Not required by design change on editorials.　<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :return: The account_id of this Feed.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Feed.

        <div lang=\"ja\">アカウントIDです。<br> ※入稿の仕様変更により不要になりました。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Account ID.<br> *Not required by design change on editorials.　<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :param account_id: The account_id of this Feed.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def domain(self):
        """Gets the domain of this Feed.  # noqa: E501

        <div lang=\"ja\">ドメインです。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時に無視されます。</div> <div lang=\"en\">Domain.　<br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation.</div>   # noqa: E501

        :return: The domain of this Feed.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this Feed.

        <div lang=\"ja\">ドメインです。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時に無視されます。</div> <div lang=\"en\">Domain.　<br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation.</div>   # noqa: E501

        :param domain: The domain of this Feed.  # noqa: E501
        :type: str
        """

        self._domain = domain

    @property
    def feed_attribute(self):
        """Gets the feed_attribute of this Feed.  # noqa: E501


        :return: The feed_attribute of this Feed.  # noqa: E501
        :rtype: list[FeedServiceAttribute]
        """
        return self._feed_attribute

    @feed_attribute.setter
    def feed_attribute(self, feed_attribute):
        """Sets the feed_attribute of this Feed.


        :param feed_attribute: The feed_attribute of this Feed.  # noqa: E501
        :type: list[FeedServiceAttribute]
        """

        self._feed_attribute = feed_attribute

    @property
    def feed_id(self):
        """Gets the feed_id of this Feed.  # noqa: E501

        <div lang=\"ja\">FeedIDです。<br> このフィールドは、SETおよびREMOVE時に必須となり、ADD時は無視されます。</div> <div lang=\"en\">Feed ID.<br> This field is required in SET and REMOVE operation, and will be ignored in ADD operation.</div>   # noqa: E501

        :return: The feed_id of this Feed.  # noqa: E501
        :rtype: int
        """
        return self._feed_id

    @feed_id.setter
    def feed_id(self, feed_id):
        """Sets the feed_id of this Feed.

        <div lang=\"ja\">FeedIDです。<br> このフィールドは、SETおよびREMOVE時に必須となり、ADD時は無視されます。</div> <div lang=\"en\">Feed ID.<br> This field is required in SET and REMOVE operation, and will be ignored in ADD operation.</div>   # noqa: E501

        :param feed_id: The feed_id of this Feed.  # noqa: E501
        :type: int
        """

        self._feed_id = feed_id

    @property
    def feed_name(self):
        """Gets the feed_name of this Feed.  # noqa: E501

        <div lang=\"ja\">Feedのリスト名です。<br> このフィールドは、ADD時に必須となり、SETおよびREMOVE時に無視されます。</div> <div lang=\"en\">List name of Feed.<br> This field is required in ADD operation, and will be ignored in SET and REMOVE operation.</div>   # noqa: E501

        :return: The feed_name of this Feed.  # noqa: E501
        :rtype: str
        """
        return self._feed_name

    @feed_name.setter
    def feed_name(self, feed_name):
        """Sets the feed_name of this Feed.

        <div lang=\"ja\">Feedのリスト名です。<br> このフィールドは、ADD時に必須となり、SETおよびREMOVE時に無視されます。</div> <div lang=\"en\">List name of Feed.<br> This field is required in ADD operation, and will be ignored in SET and REMOVE operation.</div>   # noqa: E501

        :param feed_name: The feed_name of this Feed.  # noqa: E501
        :type: str
        """

        self._feed_name = feed_name

    @property
    def feed_track_id(self):
        """Gets the feed_track_id of this Feed.  # noqa: E501

        <div lang=\"ja\">Feedのトラッキング用IDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Tracking ID of Feed.<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :return: The feed_track_id of this Feed.  # noqa: E501
        :rtype: int
        """
        return self._feed_track_id

    @feed_track_id.setter
    def feed_track_id(self, feed_track_id):
        """Sets the feed_track_id of this Feed.

        <div lang=\"ja\">Feedのトラッキング用IDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Tracking ID of Feed.<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :param feed_track_id: The feed_track_id of this Feed.  # noqa: E501
        :type: int
        """

        self._feed_track_id = feed_track_id

    @property
    def placeholder_type(self):
        """Gets the placeholder_type of this Feed.  # noqa: E501


        :return: The placeholder_type of this Feed.  # noqa: E501
        :rtype: FeedServicePlaceholderType
        """
        return self._placeholder_type

    @placeholder_type.setter
    def placeholder_type(self, placeholder_type):
        """Sets the placeholder_type of this Feed.


        :param placeholder_type: The placeholder_type of this Feed.  # noqa: E501
        :type: FeedServicePlaceholderType
        """

        self._placeholder_type = placeholder_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Feed):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Feed):
            return True

        return self.to_dict() != other.to_dict()
