# coding: utf-8

"""
    Yahoo!広告 検索広告 API リファレンス / Yahoo! JAPAN Ads Search Ads API Reference

    <div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_search_api.configuration import Configuration


class ConversionTracker(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'all_conversion_value': 'str',
        'all_conversions': 'int',
        'app_conversion': 'ConversionTrackerServiceAppConversion',
        'app_link_conversion': 'ConversionTrackerServiceAppLinkConversion',
        'category': 'ConversionTrackerServiceCategory',
        'conversion_counting_type': 'ConversionTrackerServiceConversionCountingType',
        'conversion_tracker_id': 'int',
        'conversion_tracker_track_id': 'int',
        'conversion_tracker_name': 'str',
        'conversion_tracker_type': 'ConversionTrackerServiceConversionTrackerType',
        'conversion_value': 'str',
        'conversions': 'int',
        'exclude_from_bidding': 'ConversionTrackerServiceExcludeFromBidding',
        'measurement_period': 'int',
        'most_recent_conversion_date': 'str',
        'status': 'ConversionTrackerServiceStatus',
        'user_revenue_value': 'str',
        'web_conversion': 'ConversionTrackerServiceWebConversion'
    }

    attribute_map = {
        'account_id': 'accountId',
        'all_conversion_value': 'allConversionValue',
        'all_conversions': 'allConversions',
        'app_conversion': 'appConversion',
        'app_link_conversion': 'appLinkConversion',
        'category': 'category',
        'conversion_counting_type': 'conversionCountingType',
        'conversion_tracker_id': 'conversionTrackerId',
        'conversion_tracker_track_id': 'conversionTrackerTrackId',
        'conversion_tracker_name': 'conversionTrackerName',
        'conversion_tracker_type': 'conversionTrackerType',
        'conversion_value': 'conversionValue',
        'conversions': 'conversions',
        'exclude_from_bidding': 'excludeFromBidding',
        'measurement_period': 'measurementPeriod',
        'most_recent_conversion_date': 'mostRecentConversionDate',
        'status': 'status',
        'user_revenue_value': 'userRevenueValue',
        'web_conversion': 'webConversion'
    }

    def __init__(self, account_id=None, all_conversion_value=None, all_conversions=None, app_conversion=None, app_link_conversion=None, category=None, conversion_counting_type=None, conversion_tracker_id=None, conversion_tracker_track_id=None, conversion_tracker_name=None, conversion_tracker_type=None, conversion_value=None, conversions=None, exclude_from_bidding=None, measurement_period=None, most_recent_conversion_date=None, status=None, user_revenue_value=None, web_conversion=None, local_vars_configuration=None):  # noqa: E501
        """ConversionTracker - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._all_conversion_value = None
        self._all_conversions = None
        self._app_conversion = None
        self._app_link_conversion = None
        self._category = None
        self._conversion_counting_type = None
        self._conversion_tracker_id = None
        self._conversion_tracker_track_id = None
        self._conversion_tracker_name = None
        self._conversion_tracker_type = None
        self._conversion_value = None
        self._conversions = None
        self._exclude_from_bidding = None
        self._measurement_period = None
        self._most_recent_conversion_date = None
        self._status = None
        self._user_revenue_value = None
        self._web_conversion = None
        self.discriminator = None

        self.account_id = account_id
        self.all_conversion_value = all_conversion_value
        self.all_conversions = all_conversions
        self.app_conversion = app_conversion
        self.app_link_conversion = app_link_conversion
        self.category = category
        self.conversion_counting_type = conversion_counting_type
        self.conversion_tracker_id = conversion_tracker_id
        self.conversion_tracker_track_id = conversion_tracker_track_id
        self.conversion_tracker_name = conversion_tracker_name
        self.conversion_tracker_type = conversion_tracker_type
        self.conversion_value = conversion_value
        self.conversions = conversions
        self.exclude_from_bidding = exclude_from_bidding
        self.measurement_period = measurement_period
        self.most_recent_conversion_date = most_recent_conversion_date
        self.status = status
        self.user_revenue_value = user_revenue_value
        self.web_conversion = web_conversion

    @property
    def account_id(self):
        """Gets the account_id of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>   # noqa: E501

        :return: The account_id of this ConversionTracker.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this ConversionTracker.

        <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>   # noqa: E501

        :param account_id: The account_id of this ConversionTracker.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def all_conversion_value(self):
        """Gets the all_conversion_value of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">自動入札設定対象のコンバージョン値と、対象外のコンバージョン値の合計です。</div> <div lang=\"en\">Total value of conversions to be included to auto bidding and to be exluded from auto bidding.</div>   # noqa: E501

        :return: The all_conversion_value of this ConversionTracker.  # noqa: E501
        :rtype: str
        """
        return self._all_conversion_value

    @all_conversion_value.setter
    def all_conversion_value(self, all_conversion_value):
        """Sets the all_conversion_value of this ConversionTracker.

        <div lang=\"ja\">自動入札設定対象のコンバージョン値と、対象外のコンバージョン値の合計です。</div> <div lang=\"en\">Total value of conversions to be included to auto bidding and to be exluded from auto bidding.</div>   # noqa: E501

        :param all_conversion_value: The all_conversion_value of this ConversionTracker.  # noqa: E501
        :type: str
        """

        self._all_conversion_value = all_conversion_value

    @property
    def all_conversions(self):
        """Gets the all_conversions of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">自動入札設定対象のコンバージョン数と、対象外のコンバージョン数の合計です。</div> <div lang=\"en\">Total number of conversions to be included to auto bidding and to be excluded from auto bidding.</div>   # noqa: E501

        :return: The all_conversions of this ConversionTracker.  # noqa: E501
        :rtype: int
        """
        return self._all_conversions

    @all_conversions.setter
    def all_conversions(self, all_conversions):
        """Sets the all_conversions of this ConversionTracker.

        <div lang=\"ja\">自動入札設定対象のコンバージョン数と、対象外のコンバージョン数の合計です。</div> <div lang=\"en\">Total number of conversions to be included to auto bidding and to be excluded from auto bidding.</div>   # noqa: E501

        :param all_conversions: The all_conversions of this ConversionTracker.  # noqa: E501
        :type: int
        """

        self._all_conversions = all_conversions

    @property
    def app_conversion(self):
        """Gets the app_conversion of this ConversionTracker.  # noqa: E501


        :return: The app_conversion of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceAppConversion
        """
        return self._app_conversion

    @app_conversion.setter
    def app_conversion(self, app_conversion):
        """Sets the app_conversion of this ConversionTracker.


        :param app_conversion: The app_conversion of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceAppConversion
        """

        self._app_conversion = app_conversion

    @property
    def app_link_conversion(self):
        """Gets the app_link_conversion of this ConversionTracker.  # noqa: E501


        :return: The app_link_conversion of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceAppLinkConversion
        """
        return self._app_link_conversion

    @app_link_conversion.setter
    def app_link_conversion(self, app_link_conversion):
        """Sets the app_link_conversion of this ConversionTracker.


        :param app_link_conversion: The app_link_conversion of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceAppLinkConversion
        """

        self._app_link_conversion = app_link_conversion

    @property
    def category(self):
        """Gets the category of this ConversionTracker.  # noqa: E501


        :return: The category of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceCategory
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this ConversionTracker.


        :param category: The category of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceCategory
        """

        self._category = category

    @property
    def conversion_counting_type(self):
        """Gets the conversion_counting_type of this ConversionTracker.  # noqa: E501


        :return: The conversion_counting_type of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceConversionCountingType
        """
        return self._conversion_counting_type

    @conversion_counting_type.setter
    def conversion_counting_type(self, conversion_counting_type):
        """Sets the conversion_counting_type of this ConversionTracker.


        :param conversion_counting_type: The conversion_counting_type of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceConversionCountingType
        """

        self._conversion_counting_type = conversion_counting_type

    @property
    def conversion_tracker_id(self):
        """Gets the conversion_tracker_id of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">コンバージョントラッカーのIDです。<br> このフィールドは、SET時に必須となります。</div> <div lang=\"en\">ConversionTracker ID.<br> This field is required in SET operation.</div>   # noqa: E501

        :return: The conversion_tracker_id of this ConversionTracker.  # noqa: E501
        :rtype: int
        """
        return self._conversion_tracker_id

    @conversion_tracker_id.setter
    def conversion_tracker_id(self, conversion_tracker_id):
        """Sets the conversion_tracker_id of this ConversionTracker.

        <div lang=\"ja\">コンバージョントラッカーのIDです。<br> このフィールドは、SET時に必須となります。</div> <div lang=\"en\">ConversionTracker ID.<br> This field is required in SET operation.</div>   # noqa: E501

        :param conversion_tracker_id: The conversion_tracker_id of this ConversionTracker.  # noqa: E501
        :type: int
        """

        self._conversion_tracker_id = conversion_tracker_id

    @property
    def conversion_tracker_track_id(self):
        """Gets the conversion_tracker_track_id of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">トラッキング用コンバージョントラッカーIDです。<br> ADD時、このフィールドは省略可能となります。※conversionTrackerTypeがAPP_LINK_CONVERSIONの場合は必須です。</div> <div lang=\"en\">ConversionTracker ID for tracking.<br> This field is optional in ADD operation. *If conversionTrackerType is APP_LINK_CONVERSION, this field is required.</div>   # noqa: E501

        :return: The conversion_tracker_track_id of this ConversionTracker.  # noqa: E501
        :rtype: int
        """
        return self._conversion_tracker_track_id

    @conversion_tracker_track_id.setter
    def conversion_tracker_track_id(self, conversion_tracker_track_id):
        """Sets the conversion_tracker_track_id of this ConversionTracker.

        <div lang=\"ja\">トラッキング用コンバージョントラッカーIDです。<br> ADD時、このフィールドは省略可能となります。※conversionTrackerTypeがAPP_LINK_CONVERSIONの場合は必須です。</div> <div lang=\"en\">ConversionTracker ID for tracking.<br> This field is optional in ADD operation. *If conversionTrackerType is APP_LINK_CONVERSION, this field is required.</div>   # noqa: E501

        :param conversion_tracker_track_id: The conversion_tracker_track_id of this ConversionTracker.  # noqa: E501
        :type: int
        """

        self._conversion_tracker_track_id = conversion_tracker_track_id

    @property
    def conversion_tracker_name(self):
        """Gets the conversion_tracker_name of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">コンバージョントラッカーの名称です。<br> このフィールドは、ADD時に必須となり、SET時に省略可能となります。</div> <div lang=\"en\">ConversionTracker Name.<br> This field is required in ADD operation, and is optional in SET operation.</div>   # noqa: E501

        :return: The conversion_tracker_name of this ConversionTracker.  # noqa: E501
        :rtype: str
        """
        return self._conversion_tracker_name

    @conversion_tracker_name.setter
    def conversion_tracker_name(self, conversion_tracker_name):
        """Sets the conversion_tracker_name of this ConversionTracker.

        <div lang=\"ja\">コンバージョントラッカーの名称です。<br> このフィールドは、ADD時に必須となり、SET時に省略可能となります。</div> <div lang=\"en\">ConversionTracker Name.<br> This field is required in ADD operation, and is optional in SET operation.</div>   # noqa: E501

        :param conversion_tracker_name: The conversion_tracker_name of this ConversionTracker.  # noqa: E501
        :type: str
        """

        self._conversion_tracker_name = conversion_tracker_name

    @property
    def conversion_tracker_type(self):
        """Gets the conversion_tracker_type of this ConversionTracker.  # noqa: E501


        :return: The conversion_tracker_type of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceConversionTrackerType
        """
        return self._conversion_tracker_type

    @conversion_tracker_type.setter
    def conversion_tracker_type(self, conversion_tracker_type):
        """Sets the conversion_tracker_type of this ConversionTracker.


        :param conversion_tracker_type: The conversion_tracker_type of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceConversionTrackerType
        """

        self._conversion_tracker_type = conversion_tracker_type

    @property
    def conversion_value(self):
        """Gets the conversion_value of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">自動入札設定対象のコンバージョン値です。</div> <div lang=\"en\">Conversion value to be included to auto bidding.</div>   # noqa: E501

        :return: The conversion_value of this ConversionTracker.  # noqa: E501
        :rtype: str
        """
        return self._conversion_value

    @conversion_value.setter
    def conversion_value(self, conversion_value):
        """Sets the conversion_value of this ConversionTracker.

        <div lang=\"ja\">自動入札設定対象のコンバージョン値です。</div> <div lang=\"en\">Conversion value to be included to auto bidding.</div>   # noqa: E501

        :param conversion_value: The conversion_value of this ConversionTracker.  # noqa: E501
        :type: str
        """

        self._conversion_value = conversion_value

    @property
    def conversions(self):
        """Gets the conversions of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">自動入札設定対象のコンバージョン数です。<br> ユニークコンバージョンか総コンバージョンかは、countingTypeに依存します。</div> <div lang=\"en\">Conversions which counts as included to Auto Bidding setting.<br> countingType specifies whether one-per-click or many-per-click.</div>   # noqa: E501

        :return: The conversions of this ConversionTracker.  # noqa: E501
        :rtype: int
        """
        return self._conversions

    @conversions.setter
    def conversions(self, conversions):
        """Sets the conversions of this ConversionTracker.

        <div lang=\"ja\">自動入札設定対象のコンバージョン数です。<br> ユニークコンバージョンか総コンバージョンかは、countingTypeに依存します。</div> <div lang=\"en\">Conversions which counts as included to Auto Bidding setting.<br> countingType specifies whether one-per-click or many-per-click.</div>   # noqa: E501

        :param conversions: The conversions of this ConversionTracker.  # noqa: E501
        :type: int
        """

        self._conversions = conversions

    @property
    def exclude_from_bidding(self):
        """Gets the exclude_from_bidding of this ConversionTracker.  # noqa: E501


        :return: The exclude_from_bidding of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceExcludeFromBidding
        """
        return self._exclude_from_bidding

    @exclude_from_bidding.setter
    def exclude_from_bidding(self, exclude_from_bidding):
        """Sets the exclude_from_bidding of this ConversionTracker.


        :param exclude_from_bidding: The exclude_from_bidding of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceExcludeFromBidding
        """

        self._exclude_from_bidding = exclude_from_bidding

    @property
    def measurement_period(self):
        """Gets the measurement_period of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">コンバージョン計測期間です（単位：日)。<br> 7～90日間で設定可能です。<br>※アプリダウンロードの場合は30日間固定。<br> このフィールドは、ADDおよびSET時に省略可能となります。<br>※ADD時のデフォルト設定値は30となります。<br> ※conversionTrackerTypeがAPP_LINK_CONVERSIONの場合、ADDおよびSET時にappEventTypeがfirst_openの場合は30のみ指定可能となります。<br> appEventTypeはConversionTrackerService/getAppEventTypeで取得されるappEvent.appEventTypeで確認できます。</div> <div lang=\"en\">Counting period of conversoins (days).<br>It is available between 7 to 90 days<br> * For Mobile App Download, this period is fixed as 30 days.<br> This field is optional in ADD and SET operation.<br> * The default value in ADD operation will be 30.<br> * In ADD and SET operation, if conversionTrackerType is APP_LINK_CONVERSION and appEventType is first_open, Only 30 can be specified.<br> appEventType can be confirmed by appEvent.appEventType obtained by ConversionTrackerService/getAppEventType.</div>   # noqa: E501

        :return: The measurement_period of this ConversionTracker.  # noqa: E501
        :rtype: int
        """
        return self._measurement_period

    @measurement_period.setter
    def measurement_period(self, measurement_period):
        """Sets the measurement_period of this ConversionTracker.

        <div lang=\"ja\">コンバージョン計測期間です（単位：日)。<br> 7～90日間で設定可能です。<br>※アプリダウンロードの場合は30日間固定。<br> このフィールドは、ADDおよびSET時に省略可能となります。<br>※ADD時のデフォルト設定値は30となります。<br> ※conversionTrackerTypeがAPP_LINK_CONVERSIONの場合、ADDおよびSET時にappEventTypeがfirst_openの場合は30のみ指定可能となります。<br> appEventTypeはConversionTrackerService/getAppEventTypeで取得されるappEvent.appEventTypeで確認できます。</div> <div lang=\"en\">Counting period of conversoins (days).<br>It is available between 7 to 90 days<br> * For Mobile App Download, this period is fixed as 30 days.<br> This field is optional in ADD and SET operation.<br> * The default value in ADD operation will be 30.<br> * In ADD and SET operation, if conversionTrackerType is APP_LINK_CONVERSION and appEventType is first_open, Only 30 can be specified.<br> appEventType can be confirmed by appEvent.appEventType obtained by ConversionTrackerService/getAppEventType.</div>   # noqa: E501

        :param measurement_period: The measurement_period of this ConversionTracker.  # noqa: E501
        :type: int
        """

        self._measurement_period = measurement_period

    @property
    def most_recent_conversion_date(self):
        """Gets the most_recent_conversion_date of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">直近のコンバージョン発生日です。</div> <div lang=\"en\">The most latest date when conversion occured.</div>   # noqa: E501

        :return: The most_recent_conversion_date of this ConversionTracker.  # noqa: E501
        :rtype: str
        """
        return self._most_recent_conversion_date

    @most_recent_conversion_date.setter
    def most_recent_conversion_date(self, most_recent_conversion_date):
        """Sets the most_recent_conversion_date of this ConversionTracker.

        <div lang=\"ja\">直近のコンバージョン発生日です。</div> <div lang=\"en\">The most latest date when conversion occured.</div>   # noqa: E501

        :param most_recent_conversion_date: The most_recent_conversion_date of this ConversionTracker.  # noqa: E501
        :type: str
        """

        self._most_recent_conversion_date = most_recent_conversion_date

    @property
    def status(self):
        """Gets the status of this ConversionTracker.  # noqa: E501


        :return: The status of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ConversionTracker.


        :param status: The status of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceStatus
        """

        self._status = status

    @property
    def user_revenue_value(self):
        """Gets the user_revenue_value of this ConversionTracker.  # noqa: E501

        <div lang=\"ja\">このコンバージョントラッカーに対するユーザー指定の収益値です。<br> 1コンバージョンあたりの売上金額が固定値の場合、その金額を設定することで、売上金額をレポートなどで確認できます。<br> ADDリクエスト時に未指定の場合、0が設定されます。<br> このフィールドは、ADD時およびSET時に省略可能となります。<br> ※conversionTrackerTypeがAPP_LINK_CONVERSIONの場合、ADDおよびSET時にappEventTypeがin_app_purchaseの場合は0のみ指定可能となります。<br> appEventTypeはConversionTrackerService/getAppEventTypeで取得されるappEvent.appEventTypeで確認できます。</div> <div lang=\"en\">The value of revenue of the conversion tracker specified by user.<br> When the sales revenue of 1 conversion is fixed value, you are able to review the total sales on reports by specifying the amount on this item.<br> If it is not specified on ADD request, the value &#34;0&#34; is set.<br> This field is optional in ADD and SET operation.<br> * In ADD and SET operation, if conversionTrackerType is APP_LINK_CONVERSION and appEventType is in_app_purchase, Only 0 can be specified.<br> appEventType can be confirmed by appEvent.appEventType obtained by ConversionTrackerService/getAppEventType.</div>   # noqa: E501

        :return: The user_revenue_value of this ConversionTracker.  # noqa: E501
        :rtype: str
        """
        return self._user_revenue_value

    @user_revenue_value.setter
    def user_revenue_value(self, user_revenue_value):
        """Sets the user_revenue_value of this ConversionTracker.

        <div lang=\"ja\">このコンバージョントラッカーに対するユーザー指定の収益値です。<br> 1コンバージョンあたりの売上金額が固定値の場合、その金額を設定することで、売上金額をレポートなどで確認できます。<br> ADDリクエスト時に未指定の場合、0が設定されます。<br> このフィールドは、ADD時およびSET時に省略可能となります。<br> ※conversionTrackerTypeがAPP_LINK_CONVERSIONの場合、ADDおよびSET時にappEventTypeがin_app_purchaseの場合は0のみ指定可能となります。<br> appEventTypeはConversionTrackerService/getAppEventTypeで取得されるappEvent.appEventTypeで確認できます。</div> <div lang=\"en\">The value of revenue of the conversion tracker specified by user.<br> When the sales revenue of 1 conversion is fixed value, you are able to review the total sales on reports by specifying the amount on this item.<br> If it is not specified on ADD request, the value &#34;0&#34; is set.<br> This field is optional in ADD and SET operation.<br> * In ADD and SET operation, if conversionTrackerType is APP_LINK_CONVERSION and appEventType is in_app_purchase, Only 0 can be specified.<br> appEventType can be confirmed by appEvent.appEventType obtained by ConversionTrackerService/getAppEventType.</div>   # noqa: E501

        :param user_revenue_value: The user_revenue_value of this ConversionTracker.  # noqa: E501
        :type: str
        """

        self._user_revenue_value = user_revenue_value

    @property
    def web_conversion(self):
        """Gets the web_conversion of this ConversionTracker.  # noqa: E501


        :return: The web_conversion of this ConversionTracker.  # noqa: E501
        :rtype: ConversionTrackerServiceWebConversion
        """
        return self._web_conversion

    @web_conversion.setter
    def web_conversion(self, web_conversion):
        """Sets the web_conversion of this ConversionTracker.


        :param web_conversion: The web_conversion of this ConversionTracker.  # noqa: E501
        :type: ConversionTrackerServiceWebConversion
        """

        self._web_conversion = web_conversion

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConversionTracker):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConversionTracker):
            return True

        return self.to_dict() != other.to_dict()
