# coding: utf-8

"""
    Yahoo!広告 検索広告 API リファレンス / Yahoo! JAPAN Ads Search Ads API Reference

    <div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_search_api.configuration import Configuration


class Campaign(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'app_id': 'str',
        'app_store': 'CampaignServiceAppStore',
        'bidding_strategy_configuration': 'CampaignServiceBiddingStrategy',
        'bidding_strategy_failed_reason': 'CampaignServiceBiddingStrategyFailedReason',
        'budget': 'CampaignServiceBudget',
        'campaign_id': 'int',
        'campaign_name': 'str',
        'campaign_track_id': 'int',
        'conversion_optimizer_eligibility': 'CampaignServiceConversionOptimizerEligibility',
        'custom_parameters': 'CampaignServiceCustomParameters',
        'end_date': 'str',
        'failed_bidding_strategy_configuration': 'CampaignServiceBiddingStrategy',
        'labels': 'list[CampaignServiceLabel]',
        'serving_status': 'CampaignServiceServingStatus',
        'settings': 'list[CampaignServiceSettings]',
        'start_date': 'str',
        'tracking_url': 'str',
        'type': 'CampaignServiceType',
        'url_review_data': 'CampaignServiceUrlReviewData',
        'user_status': 'CampaignServiceUserStatus',
        'created_date': 'str'
    }

    attribute_map = {
        'account_id': 'accountId',
        'app_id': 'appId',
        'app_store': 'appStore',
        'bidding_strategy_configuration': 'biddingStrategyConfiguration',
        'bidding_strategy_failed_reason': 'biddingStrategyFailedReason',
        'budget': 'budget',
        'campaign_id': 'campaignId',
        'campaign_name': 'campaignName',
        'campaign_track_id': 'campaignTrackId',
        'conversion_optimizer_eligibility': 'conversionOptimizerEligibility',
        'custom_parameters': 'customParameters',
        'end_date': 'endDate',
        'failed_bidding_strategy_configuration': 'failedBiddingStrategyConfiguration',
        'labels': 'labels',
        'serving_status': 'servingStatus',
        'settings': 'settings',
        'start_date': 'startDate',
        'tracking_url': 'trackingUrl',
        'type': 'type',
        'url_review_data': 'urlReviewData',
        'user_status': 'userStatus',
        'created_date': 'createdDate'
    }

    def __init__(self, account_id=None, app_id=None, app_store=None, bidding_strategy_configuration=None, bidding_strategy_failed_reason=None, budget=None, campaign_id=None, campaign_name=None, campaign_track_id=None, conversion_optimizer_eligibility=None, custom_parameters=None, end_date=None, failed_bidding_strategy_configuration=None, labels=None, serving_status=None, settings=None, start_date=None, tracking_url=None, type=None, url_review_data=None, user_status=None, created_date=None, local_vars_configuration=None):  # noqa: E501
        """Campaign - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._app_id = None
        self._app_store = None
        self._bidding_strategy_configuration = None
        self._bidding_strategy_failed_reason = None
        self._budget = None
        self._campaign_id = None
        self._campaign_name = None
        self._campaign_track_id = None
        self._conversion_optimizer_eligibility = None
        self._custom_parameters = None
        self._end_date = None
        self._failed_bidding_strategy_configuration = None
        self._labels = None
        self._serving_status = None
        self._settings = None
        self._start_date = None
        self._tracking_url = None
        self._type = None
        self._url_review_data = None
        self._user_status = None
        self._created_date = None
        self.discriminator = None

        self.account_id = account_id
        self.app_id = app_id
        self.app_store = app_store
        self.bidding_strategy_configuration = bidding_strategy_configuration
        self.bidding_strategy_failed_reason = bidding_strategy_failed_reason
        self.budget = budget
        self.campaign_id = campaign_id
        self.campaign_name = campaign_name
        self.campaign_track_id = campaign_track_id
        self.conversion_optimizer_eligibility = conversion_optimizer_eligibility
        self.custom_parameters = custom_parameters
        self.end_date = end_date
        self.failed_bidding_strategy_configuration = failed_bidding_strategy_configuration
        self.labels = labels
        self.serving_status = serving_status
        self.settings = settings
        self.start_date = start_date
        self.tracking_url = tracking_url
        self.type = type
        self.url_review_data = url_review_data
        self.user_status = user_status
        self.created_date = created_date

    @property
    def account_id(self):
        """Gets the account_id of this Campaign.  # noqa: E501

        <div lang=\"ja\">アカウントIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Account ID.<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :return: The account_id of this Campaign.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Campaign.

        <div lang=\"ja\">アカウントIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Account ID.<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :param account_id: The account_id of this Campaign.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def app_id(self):
        """Gets the app_id of this Campaign.  # noqa: E501

        <div lang=\"ja\">アプリID（iOS）またはパッケージ名（Android）です。<br> ※アプリキャンペーンでiOSの場合、入力は数値のみです。<br> ADD時、campaignTypeがSTANDARD、またはDYNAMIC_ADS_FOR_SEARCH_SETTINGの場合、無視され、MOBILE_APPの場合、必須となります。</div> <div lang=\"en\">App ID (for iOS) or Package name (for Android).<br> *Input only the numbers for iOS in Mobile App Campaign.<br>  In ADD operation, this field will be ignored when campaignType is 'STANDARD' or 'DYNAMIC_ADS_FOR_SEARCH_SETTING', and is required when campaignType is MOBILE_APP.</div>   # noqa: E501

        :return: The app_id of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id):
        """Sets the app_id of this Campaign.

        <div lang=\"ja\">アプリID（iOS）またはパッケージ名（Android）です。<br> ※アプリキャンペーンでiOSの場合、入力は数値のみです。<br> ADD時、campaignTypeがSTANDARD、またはDYNAMIC_ADS_FOR_SEARCH_SETTINGの場合、無視され、MOBILE_APPの場合、必須となります。</div> <div lang=\"en\">App ID (for iOS) or Package name (for Android).<br> *Input only the numbers for iOS in Mobile App Campaign.<br>  In ADD operation, this field will be ignored when campaignType is 'STANDARD' or 'DYNAMIC_ADS_FOR_SEARCH_SETTING', and is required when campaignType is MOBILE_APP.</div>   # noqa: E501

        :param app_id: The app_id of this Campaign.  # noqa: E501
        :type: str
        """

        self._app_id = app_id

    @property
    def app_store(self):
        """Gets the app_store of this Campaign.  # noqa: E501


        :return: The app_store of this Campaign.  # noqa: E501
        :rtype: CampaignServiceAppStore
        """
        return self._app_store

    @app_store.setter
    def app_store(self, app_store):
        """Sets the app_store of this Campaign.


        :param app_store: The app_store of this Campaign.  # noqa: E501
        :type: CampaignServiceAppStore
        """

        self._app_store = app_store

    @property
    def bidding_strategy_configuration(self):
        """Gets the bidding_strategy_configuration of this Campaign.  # noqa: E501


        :return: The bidding_strategy_configuration of this Campaign.  # noqa: E501
        :rtype: CampaignServiceBiddingStrategy
        """
        return self._bidding_strategy_configuration

    @bidding_strategy_configuration.setter
    def bidding_strategy_configuration(self, bidding_strategy_configuration):
        """Sets the bidding_strategy_configuration of this Campaign.


        :param bidding_strategy_configuration: The bidding_strategy_configuration of this Campaign.  # noqa: E501
        :type: CampaignServiceBiddingStrategy
        """

        self._bidding_strategy_configuration = bidding_strategy_configuration

    @property
    def bidding_strategy_failed_reason(self):
        """Gets the bidding_strategy_failed_reason of this Campaign.  # noqa: E501


        :return: The bidding_strategy_failed_reason of this Campaign.  # noqa: E501
        :rtype: CampaignServiceBiddingStrategyFailedReason
        """
        return self._bidding_strategy_failed_reason

    @bidding_strategy_failed_reason.setter
    def bidding_strategy_failed_reason(self, bidding_strategy_failed_reason):
        """Sets the bidding_strategy_failed_reason of this Campaign.


        :param bidding_strategy_failed_reason: The bidding_strategy_failed_reason of this Campaign.  # noqa: E501
        :type: CampaignServiceBiddingStrategyFailedReason
        """

        self._bidding_strategy_failed_reason = bidding_strategy_failed_reason

    @property
    def budget(self):
        """Gets the budget of this Campaign.  # noqa: E501


        :return: The budget of this Campaign.  # noqa: E501
        :rtype: CampaignServiceBudget
        """
        return self._budget

    @budget.setter
    def budget(self, budget):
        """Sets the budget of this Campaign.


        :param budget: The budget of this Campaign.  # noqa: E501
        :type: CampaignServiceBudget
        """

        self._budget = budget

    @property
    def campaign_id(self):
        """Gets the campaign_id of this Campaign.  # noqa: E501

        <div lang=\"ja\">キャンペーンIDです。<br> SET時およびREMOVE時、このフィールドは必須です。</div> <div lang=\"en\">Campaign ID.<br> This field is required in SET and REMOVE operation.</div>   # noqa: E501

        :return: The campaign_id of this Campaign.  # noqa: E501
        :rtype: int
        """
        return self._campaign_id

    @campaign_id.setter
    def campaign_id(self, campaign_id):
        """Sets the campaign_id of this Campaign.

        <div lang=\"ja\">キャンペーンIDです。<br> SET時およびREMOVE時、このフィールドは必須です。</div> <div lang=\"en\">Campaign ID.<br> This field is required in SET and REMOVE operation.</div>   # noqa: E501

        :param campaign_id: The campaign_id of this Campaign.  # noqa: E501
        :type: int
        """

        self._campaign_id = campaign_id

    @property
    def campaign_name(self):
        """Gets the campaign_name of this Campaign.  # noqa: E501

        <div lang=\"ja\">キャンペーン名です。<br>このフィールドは、ADD時に必須となり、SET時に省略可能となります。<br> ※入力制限：50文字以内です。</div> <div lang=\"en\">Campaign name.<br> *Insert limit: Up to 50 characters.<br>This field is required in ADD operation, and will be optional in SET operation.</div>   # noqa: E501

        :return: The campaign_name of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._campaign_name

    @campaign_name.setter
    def campaign_name(self, campaign_name):
        """Sets the campaign_name of this Campaign.

        <div lang=\"ja\">キャンペーン名です。<br>このフィールドは、ADD時に必須となり、SET時に省略可能となります。<br> ※入力制限：50文字以内です。</div> <div lang=\"en\">Campaign name.<br> *Insert limit: Up to 50 characters.<br>This field is required in ADD operation, and will be optional in SET operation.</div>   # noqa: E501

        :param campaign_name: The campaign_name of this Campaign.  # noqa: E501
        :type: str
        """

        self._campaign_name = campaign_name

    @property
    def campaign_track_id(self):
        """Gets the campaign_track_id of this Campaign.  # noqa: E501

        <div lang=\"ja\">トラッキング用キャンペーンIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Campaign ID for tracking.<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :return: The campaign_track_id of this Campaign.  # noqa: E501
        :rtype: int
        """
        return self._campaign_track_id

    @campaign_track_id.setter
    def campaign_track_id(self, campaign_track_id):
        """Sets the campaign_track_id of this Campaign.

        <div lang=\"ja\">トラッキング用キャンペーンIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。</div> <div lang=\"en\">Campaign ID for tracking.<br> Although this field will be returned in the response, it will be ignored on input.</div>   # noqa: E501

        :param campaign_track_id: The campaign_track_id of this Campaign.  # noqa: E501
        :type: int
        """

        self._campaign_track_id = campaign_track_id

    @property
    def conversion_optimizer_eligibility(self):
        """Gets the conversion_optimizer_eligibility of this Campaign.  # noqa: E501


        :return: The conversion_optimizer_eligibility of this Campaign.  # noqa: E501
        :rtype: CampaignServiceConversionOptimizerEligibility
        """
        return self._conversion_optimizer_eligibility

    @conversion_optimizer_eligibility.setter
    def conversion_optimizer_eligibility(self, conversion_optimizer_eligibility):
        """Sets the conversion_optimizer_eligibility of this Campaign.


        :param conversion_optimizer_eligibility: The conversion_optimizer_eligibility of this Campaign.  # noqa: E501
        :type: CampaignServiceConversionOptimizerEligibility
        """

        self._conversion_optimizer_eligibility = conversion_optimizer_eligibility

    @property
    def custom_parameters(self):
        """Gets the custom_parameters of this Campaign.  # noqa: E501


        :return: The custom_parameters of this Campaign.  # noqa: E501
        :rtype: CampaignServiceCustomParameters
        """
        return self._custom_parameters

    @custom_parameters.setter
    def custom_parameters(self, custom_parameters):
        """Sets the custom_parameters of this Campaign.


        :param custom_parameters: The custom_parameters of this Campaign.  # noqa: E501
        :type: CampaignServiceCustomParameters
        """

        self._custom_parameters = custom_parameters

    @property
    def end_date(self):
        """Gets the end_date of this Campaign.  # noqa: E501

        <div lang=\"ja\">キャンペーンの終了日です。<br> ADD時およびSET時、このフィールドは省略可能となります。ADD時のデフォルト設定値は20371231となります。<br> 過去の日付、開始日以前の日付は指定できません。<br>※YYYYMMDD形式です。</div> <div lang=\"en\">End date of Campaign.<br> This field is optional in ADD and SET operation. The default value in ADD operation will be 20371231.<br> *Cannot set the past date and date before the start date.<br> *In YYYYMMDD format.</div>   # noqa: E501

        :return: The end_date of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this Campaign.

        <div lang=\"ja\">キャンペーンの終了日です。<br> ADD時およびSET時、このフィールドは省略可能となります。ADD時のデフォルト設定値は20371231となります。<br> 過去の日付、開始日以前の日付は指定できません。<br>※YYYYMMDD形式です。</div> <div lang=\"en\">End date of Campaign.<br> This field is optional in ADD and SET operation. The default value in ADD operation will be 20371231.<br> *Cannot set the past date and date before the start date.<br> *In YYYYMMDD format.</div>   # noqa: E501

        :param end_date: The end_date of this Campaign.  # noqa: E501
        :type: str
        """

        self._end_date = end_date

    @property
    def failed_bidding_strategy_configuration(self):
        """Gets the failed_bidding_strategy_configuration of this Campaign.  # noqa: E501


        :return: The failed_bidding_strategy_configuration of this Campaign.  # noqa: E501
        :rtype: CampaignServiceBiddingStrategy
        """
        return self._failed_bidding_strategy_configuration

    @failed_bidding_strategy_configuration.setter
    def failed_bidding_strategy_configuration(self, failed_bidding_strategy_configuration):
        """Sets the failed_bidding_strategy_configuration of this Campaign.


        :param failed_bidding_strategy_configuration: The failed_bidding_strategy_configuration of this Campaign.  # noqa: E501
        :type: CampaignServiceBiddingStrategy
        """

        self._failed_bidding_strategy_configuration = failed_bidding_strategy_configuration

    @property
    def labels(self):
        """Gets the labels of this Campaign.  # noqa: E501


        :return: The labels of this Campaign.  # noqa: E501
        :rtype: list[CampaignServiceLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Campaign.


        :param labels: The labels of this Campaign.  # noqa: E501
        :type: list[CampaignServiceLabel]
        """

        self._labels = labels

    @property
    def serving_status(self):
        """Gets the serving_status of this Campaign.  # noqa: E501


        :return: The serving_status of this Campaign.  # noqa: E501
        :rtype: CampaignServiceServingStatus
        """
        return self._serving_status

    @serving_status.setter
    def serving_status(self, serving_status):
        """Sets the serving_status of this Campaign.


        :param serving_status: The serving_status of this Campaign.  # noqa: E501
        :type: CampaignServiceServingStatus
        """

        self._serving_status = serving_status

    @property
    def settings(self):
        """Gets the settings of this Campaign.  # noqa: E501


        :return: The settings of this Campaign.  # noqa: E501
        :rtype: list[CampaignServiceSettings]
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this Campaign.


        :param settings: The settings of this Campaign.  # noqa: E501
        :type: list[CampaignServiceSettings]
        """

        self._settings = settings

    @property
    def start_date(self):
        """Gets the start_date of this Campaign.  # noqa: E501

        <div lang=\"ja\">キャンペーンの開始日です。<br> ADD時およびSET時、このフィールドは省略可能となります。ADD時のデフォルト設定値は当日日付となります。<br> 過去の日付は指定できません。<br>※配信開始済みのキャンペーンは変更できません。<br> ※YYYYMMDD形式です。</div> <div lang=\"en\">Start date of Campaign.<br> This field is optional in ADD and SET operation. The default value in ADD operation will be Today's date.<br> *Cannot set the past date.<br>*Cannot change the date to the campaign that is already active.<br> *In YYYYMMDD format.</div>   # noqa: E501

        :return: The start_date of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this Campaign.

        <div lang=\"ja\">キャンペーンの開始日です。<br> ADD時およびSET時、このフィールドは省略可能となります。ADD時のデフォルト設定値は当日日付となります。<br> 過去の日付は指定できません。<br>※配信開始済みのキャンペーンは変更できません。<br> ※YYYYMMDD形式です。</div> <div lang=\"en\">Start date of Campaign.<br> This field is optional in ADD and SET operation. The default value in ADD operation will be Today's date.<br> *Cannot set the past date.<br>*Cannot change the date to the campaign that is already active.<br> *In YYYYMMDD format.</div>   # noqa: E501

        :param start_date: The start_date of this Campaign.  # noqa: E501
        :type: str
        """

        self._start_date = start_date

    @property
    def tracking_url(self):
        """Gets the tracking_url of this Campaign.  # noqa: E501

        <div lang=\"ja\">トラッキングURLです。<br> ADD時およびSET時、このフィールドは省略可能となります。<br> ※アプリキャンペーンがAndroidの場合、設定はできません。</div> <div lang=\"en\">Tracking URL.<br> This field is optional in ADD and SET operation.<br> *Cannot set if Mobile App Campaign is in Android.</div>   # noqa: E501

        :return: The tracking_url of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._tracking_url

    @tracking_url.setter
    def tracking_url(self, tracking_url):
        """Sets the tracking_url of this Campaign.

        <div lang=\"ja\">トラッキングURLです。<br> ADD時およびSET時、このフィールドは省略可能となります。<br> ※アプリキャンペーンがAndroidの場合、設定はできません。</div> <div lang=\"en\">Tracking URL.<br> This field is optional in ADD and SET operation.<br> *Cannot set if Mobile App Campaign is in Android.</div>   # noqa: E501

        :param tracking_url: The tracking_url of this Campaign.  # noqa: E501
        :type: str
        """

        self._tracking_url = tracking_url

    @property
    def type(self):
        """Gets the type of this Campaign.  # noqa: E501


        :return: The type of this Campaign.  # noqa: E501
        :rtype: CampaignServiceType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Campaign.


        :param type: The type of this Campaign.  # noqa: E501
        :type: CampaignServiceType
        """

        self._type = type

    @property
    def url_review_data(self):
        """Gets the url_review_data of this Campaign.  # noqa: E501


        :return: The url_review_data of this Campaign.  # noqa: E501
        :rtype: CampaignServiceUrlReviewData
        """
        return self._url_review_data

    @url_review_data.setter
    def url_review_data(self, url_review_data):
        """Sets the url_review_data of this Campaign.


        :param url_review_data: The url_review_data of this Campaign.  # noqa: E501
        :type: CampaignServiceUrlReviewData
        """

        self._url_review_data = url_review_data

    @property
    def user_status(self):
        """Gets the user_status of this Campaign.  # noqa: E501


        :return: The user_status of this Campaign.  # noqa: E501
        :rtype: CampaignServiceUserStatus
        """
        return self._user_status

    @user_status.setter
    def user_status(self, user_status):
        """Sets the user_status of this Campaign.


        :param user_status: The user_status of this Campaign.  # noqa: E501
        :type: CampaignServiceUserStatus
        """

        self._user_status = user_status

    @property
    def created_date(self):
        """Gets the created_date of this Campaign.  # noqa: E501

        <div lang=\"ja\">キャンペーンが作成された日です。<br>※フォーマット：yyyyMMdd</div> <div lang=\"en\">Date of Campaign made.<br>* Format: yyyyMMdd</div>   # noqa: E501

        :return: The created_date of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """Sets the created_date of this Campaign.

        <div lang=\"ja\">キャンペーンが作成された日です。<br>※フォーマット：yyyyMMdd</div> <div lang=\"en\">Date of Campaign made.<br>* Format: yyyyMMdd</div>   # noqa: E501

        :param created_date: The created_date of this Campaign.  # noqa: E501
        :type: str
        """

        self._created_date = created_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Campaign):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Campaign):
            return True

        return self.to_dict() != other.to_dict()
