# coding: utf-8

"""
    Yahoo!広告 検索広告 API リファレンス / Yahoo! JAPAN Ads Search Ads API Reference

    <div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_search_api.configuration import Configuration


class AppLink(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'app_link_id': 'int',
        'app_vendor_id': 'str',
        'app_vendor_name_ja': 'str',
        'app_vendor_name_en': 'str',
        'app_id': 'str',
        'app_link_platform': 'AppLinkServiceAppLinkPlatform',
        'link_id': 'str',
        'link_status': 'AppLinkServiceLinkStatus',
        'sync_status': 'AppLinkServiceSyncStatus'
    }

    attribute_map = {
        'account_id': 'accountId',
        'app_link_id': 'appLinkId',
        'app_vendor_id': 'appVendorId',
        'app_vendor_name_ja': 'appVendorNameJa',
        'app_vendor_name_en': 'appVendorNameEn',
        'app_id': 'appId',
        'app_link_platform': 'appLinkPlatform',
        'link_id': 'linkId',
        'link_status': 'linkStatus',
        'sync_status': 'syncStatus'
    }

    def __init__(self, account_id=None, app_link_id=None, app_vendor_id=None, app_vendor_name_ja=None, app_vendor_name_en=None, app_id=None, app_link_platform=None, link_id=None, link_status=None, sync_status=None, local_vars_configuration=None):  # noqa: E501
        """AppLink - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._app_link_id = None
        self._app_vendor_id = None
        self._app_vendor_name_ja = None
        self._app_vendor_name_en = None
        self._app_id = None
        self._app_link_platform = None
        self._link_id = None
        self._link_status = None
        self._sync_status = None
        self.discriminator = None

        self.account_id = account_id
        self.app_link_id = app_link_id
        self.app_vendor_id = app_vendor_id
        self.app_vendor_name_ja = app_vendor_name_ja
        self.app_vendor_name_en = app_vendor_name_en
        self.app_id = app_id
        self.app_link_platform = app_link_platform
        self.link_id = link_id
        self.link_status = link_status
        self.sync_status = sync_status

    @property
    def account_id(self):
        """Gets the account_id of this AppLink.  # noqa: E501

        <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>   # noqa: E501

        :return: The account_id of this AppLink.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AppLink.

        <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>   # noqa: E501

        :param account_id: The account_id of this AppLink.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def app_link_id(self):
        """Gets the app_link_id of this AppLink.  # noqa: E501

        <div lang=\"ja\">アプリリンクIDです。<br> SETまたはREGENERATE時、このフィールドは必須となります。</div> <div lang=\"en\">App Link ID.<br> This field is required in SET or REGENERATE operation.</div>   # noqa: E501

        :return: The app_link_id of this AppLink.  # noqa: E501
        :rtype: int
        """
        return self._app_link_id

    @app_link_id.setter
    def app_link_id(self, app_link_id):
        """Sets the app_link_id of this AppLink.

        <div lang=\"ja\">アプリリンクIDです。<br> SETまたはREGENERATE時、このフィールドは必須となります。</div> <div lang=\"en\">App Link ID.<br> This field is required in SET or REGENERATE operation.</div>   # noqa: E501

        :param app_link_id: The app_link_id of this AppLink.  # noqa: E501
        :type: int
        """

        self._app_link_id = app_link_id

    @property
    def app_vendor_id(self):
        """Gets the app_vendor_id of this AppLink.  # noqa: E501

        <div lang=\"ja\">アプリ計測ベンダーIDです。<br> ADD時、このフィールドは必須となります。</div> <div lang=\"en\">App Vendor ID.<br> This field is required in ADD operation.</div>   # noqa: E501

        :return: The app_vendor_id of this AppLink.  # noqa: E501
        :rtype: str
        """
        return self._app_vendor_id

    @app_vendor_id.setter
    def app_vendor_id(self, app_vendor_id):
        """Sets the app_vendor_id of this AppLink.

        <div lang=\"ja\">アプリ計測ベンダーIDです。<br> ADD時、このフィールドは必須となります。</div> <div lang=\"en\">App Vendor ID.<br> This field is required in ADD operation.</div>   # noqa: E501

        :param app_vendor_id: The app_vendor_id of this AppLink.  # noqa: E501
        :type: str
        """

        self._app_vendor_id = app_vendor_id

    @property
    def app_vendor_name_ja(self):
        """Gets the app_vendor_name_ja of this AppLink.  # noqa: E501

        <div lang=\"ja\">アプリ計測ベンダー名（日本語）です。</div> <div lang=\"en\">App Vendor Name in Japanese.</div>   # noqa: E501

        :return: The app_vendor_name_ja of this AppLink.  # noqa: E501
        :rtype: str
        """
        return self._app_vendor_name_ja

    @app_vendor_name_ja.setter
    def app_vendor_name_ja(self, app_vendor_name_ja):
        """Sets the app_vendor_name_ja of this AppLink.

        <div lang=\"ja\">アプリ計測ベンダー名（日本語）です。</div> <div lang=\"en\">App Vendor Name in Japanese.</div>   # noqa: E501

        :param app_vendor_name_ja: The app_vendor_name_ja of this AppLink.  # noqa: E501
        :type: str
        """

        self._app_vendor_name_ja = app_vendor_name_ja

    @property
    def app_vendor_name_en(self):
        """Gets the app_vendor_name_en of this AppLink.  # noqa: E501

        <div lang=\"ja\">アプリ計測ベンダー名（英語）です。</div> <div lang=\"en\">App Vendor Name in English.</div>   # noqa: E501

        :return: The app_vendor_name_en of this AppLink.  # noqa: E501
        :rtype: str
        """
        return self._app_vendor_name_en

    @app_vendor_name_en.setter
    def app_vendor_name_en(self, app_vendor_name_en):
        """Sets the app_vendor_name_en of this AppLink.

        <div lang=\"ja\">アプリ計測ベンダー名（英語）です。</div> <div lang=\"en\">App Vendor Name in English.</div>   # noqa: E501

        :param app_vendor_name_en: The app_vendor_name_en of this AppLink.  # noqa: E501
        :type: str
        """

        self._app_vendor_name_en = app_vendor_name_en

    @property
    def app_id(self):
        """Gets the app_id of this AppLink.  # noqa: E501

        <div lang=\"ja\">アプリIDです。<br> ADD時、このフィールドは必須となります。</div> <div lang=\"en\">App ID.<br> This field is required in ADD operation.</div>   # noqa: E501

        :return: The app_id of this AppLink.  # noqa: E501
        :rtype: str
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id):
        """Sets the app_id of this AppLink.

        <div lang=\"ja\">アプリIDです。<br> ADD時、このフィールドは必須となります。</div> <div lang=\"en\">App ID.<br> This field is required in ADD operation.</div>   # noqa: E501

        :param app_id: The app_id of this AppLink.  # noqa: E501
        :type: str
        """

        self._app_id = app_id

    @property
    def app_link_platform(self):
        """Gets the app_link_platform of this AppLink.  # noqa: E501


        :return: The app_link_platform of this AppLink.  # noqa: E501
        :rtype: AppLinkServiceAppLinkPlatform
        """
        return self._app_link_platform

    @app_link_platform.setter
    def app_link_platform(self, app_link_platform):
        """Sets the app_link_platform of this AppLink.


        :param app_link_platform: The app_link_platform of this AppLink.  # noqa: E501
        :type: AppLinkServiceAppLinkPlatform
        """

        self._app_link_platform = app_link_platform

    @property
    def link_id(self):
        """Gets the link_id of this AppLink.  # noqa: E501

        <div lang=\"ja\">リンクIDです。</div> <div lang=\"en\">Link ID.</div>   # noqa: E501

        :return: The link_id of this AppLink.  # noqa: E501
        :rtype: str
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this AppLink.

        <div lang=\"ja\">リンクIDです。</div> <div lang=\"en\">Link ID.</div>   # noqa: E501

        :param link_id: The link_id of this AppLink.  # noqa: E501
        :type: str
        """

        self._link_id = link_id

    @property
    def link_status(self):
        """Gets the link_status of this AppLink.  # noqa: E501


        :return: The link_status of this AppLink.  # noqa: E501
        :rtype: AppLinkServiceLinkStatus
        """
        return self._link_status

    @link_status.setter
    def link_status(self, link_status):
        """Sets the link_status of this AppLink.


        :param link_status: The link_status of this AppLink.  # noqa: E501
        :type: AppLinkServiceLinkStatus
        """

        self._link_status = link_status

    @property
    def sync_status(self):
        """Gets the sync_status of this AppLink.  # noqa: E501


        :return: The sync_status of this AppLink.  # noqa: E501
        :rtype: AppLinkServiceSyncStatus
        """
        return self._sync_status

    @sync_status.setter
    def sync_status(self, sync_status):
        """Sets the sync_status of this AppLink.


        :param sync_status: The sync_status of this AppLink.  # noqa: E501
        :type: AppLinkServiceSyncStatus
        """

        self._sync_status = sync_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AppLink):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AppLink):
            return True

        return self.to_dict() != other.to_dict()
