# coding: utf-8

"""
    Yahoo!広告 検索広告 API リファレンス / Yahoo! JAPAN Ads Search Ads API Reference

    <div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_search_api.configuration import Configuration


class AdGroupWebpageServiceSelector(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'ad_group_ids': 'list[int]',
        'campaign_ids': 'list[int]',
        'number_results': 'int',
        'start_index': 'int',
        'target_ids': 'list[int]'
    }

    attribute_map = {
        'account_id': 'accountId',
        'ad_group_ids': 'adGroupIds',
        'campaign_ids': 'campaignIds',
        'number_results': 'numberResults',
        'start_index': 'startIndex',
        'target_ids': 'targetIds'
    }

    def __init__(self, account_id=None, ad_group_ids=None, campaign_ids=None, number_results=500, start_index=1, target_ids=None, local_vars_configuration=None):  # noqa: E501
        """AdGroupWebpageServiceSelector - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._ad_group_ids = None
        self._campaign_ids = None
        self._number_results = None
        self._start_index = None
        self._target_ids = None
        self.discriminator = None

        self.account_id = account_id
        self.ad_group_ids = ad_group_ids
        self.campaign_ids = campaign_ids
        self.number_results = number_results
        self.start_index = start_index
        self.target_ids = target_ids

    @property
    def account_id(self):
        """Gets the account_id of this AdGroupWebpageServiceSelector.  # noqa: E501

        <div lang=\"ja\">アカウントID</div> <div lang=\"en\">Account ID</div>   # noqa: E501

        :return: The account_id of this AdGroupWebpageServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AdGroupWebpageServiceSelector.

        <div lang=\"ja\">アカウントID</div> <div lang=\"en\">Account ID</div>   # noqa: E501

        :param account_id: The account_id of this AdGroupWebpageServiceSelector.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and account_id is None:  # noqa: E501
            raise ValueError("Invalid value for `account_id`, must not be `None`")  # noqa: E501

        self._account_id = account_id

    @property
    def ad_group_ids(self):
        """Gets the ad_group_ids of this AdGroupWebpageServiceSelector.  # noqa: E501

        <div lang=\"ja\">広告グループID</div> <div lang=\"en\">AdGroup ID</div>   # noqa: E501

        :return: The ad_group_ids of this AdGroupWebpageServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._ad_group_ids

    @ad_group_ids.setter
    def ad_group_ids(self, ad_group_ids):
        """Sets the ad_group_ids of this AdGroupWebpageServiceSelector.

        <div lang=\"ja\">広告グループID</div> <div lang=\"en\">AdGroup ID</div>   # noqa: E501

        :param ad_group_ids: The ad_group_ids of this AdGroupWebpageServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._ad_group_ids = ad_group_ids

    @property
    def campaign_ids(self):
        """Gets the campaign_ids of this AdGroupWebpageServiceSelector.  # noqa: E501

        <div lang=\"ja\">キャンペーンID</div> <div lang=\"en\">Campaign ID</div>   # noqa: E501

        :return: The campaign_ids of this AdGroupWebpageServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._campaign_ids

    @campaign_ids.setter
    def campaign_ids(self, campaign_ids):
        """Sets the campaign_ids of this AdGroupWebpageServiceSelector.

        <div lang=\"ja\">キャンペーンID</div> <div lang=\"en\">Campaign ID</div>   # noqa: E501

        :param campaign_ids: The campaign_ids of this AdGroupWebpageServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._campaign_ids = campaign_ids

    @property
    def number_results(self):
        """Gets the number_results of this AdGroupWebpageServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :return: The number_results of this AdGroupWebpageServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._number_results

    @number_results.setter
    def number_results(self, number_results):
        """Sets the number_results of this AdGroupWebpageServiceSelector.

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :param number_results: The number_results of this AdGroupWebpageServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results > 2000):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value less than or equal to `2000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results < 1):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value greater than or equal to `1`")  # noqa: E501

        self._number_results = number_results

    @property
    def start_index(self):
        """Gets the start_index of this AdGroupWebpageServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :return: The start_index of this AdGroupWebpageServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._start_index

    @start_index.setter
    def start_index(self, start_index):
        """Sets the start_index of this AdGroupWebpageServiceSelector.

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :param start_index: The start_index of this AdGroupWebpageServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                start_index is not None and start_index < 1):  # noqa: E501
            raise ValueError("Invalid value for `start_index`, must be a value greater than or equal to `1`")  # noqa: E501

        self._start_index = start_index

    @property
    def target_ids(self):
        """Gets the target_ids of this AdGroupWebpageServiceSelector.  # noqa: E501

        <div lang=\"ja\">配信/除外設定を識別するID</div> <div lang=\"en\">Unique ID to identify &#39;Allow&#39; or &#39;Exclude&#39; settings</div>   # noqa: E501

        :return: The target_ids of this AdGroupWebpageServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._target_ids

    @target_ids.setter
    def target_ids(self, target_ids):
        """Sets the target_ids of this AdGroupWebpageServiceSelector.

        <div lang=\"ja\">配信/除外設定を識別するID</div> <div lang=\"en\">Unique ID to identify &#39;Allow&#39; or &#39;Exclude&#39; settings</div>   # noqa: E501

        :param target_ids: The target_ids of this AdGroupWebpageServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._target_ids = target_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdGroupWebpageServiceSelector):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AdGroupWebpageServiceSelector):
            return True

        return self.to_dict() != other.to_dict()
