# coding: utf-8

"""
    Yahoo!広告 検索広告 API リファレンス / Yahoo! JAPAN Ads Search Ads API Reference

    <div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_search_api.configuration import Configuration


class AdGroupServiceSelector(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'ad_group_ids': 'list[int]',
        'bidding_strategy_ids': 'list[int]',
        'campaign_ids': 'list[int]',
        'contains_label_id': 'AdGroupServiceContainsLabelId',
        'label_ids': 'list[int]',
        'number_results': 'int',
        'start_index': 'int',
        'user_statuses': 'list[AdGroupServiceUserStatus]',
        'created_date_range': 'AdGroupServiceCreatedDateRange',
        'bidding_keyword_cpc_range': 'AdGroupServiceBiddingKeywordCpcRange'
    }

    attribute_map = {
        'account_id': 'accountId',
        'ad_group_ids': 'adGroupIds',
        'bidding_strategy_ids': 'biddingStrategyIds',
        'campaign_ids': 'campaignIds',
        'contains_label_id': 'containsLabelId',
        'label_ids': 'labelIds',
        'number_results': 'numberResults',
        'start_index': 'startIndex',
        'user_statuses': 'userStatuses',
        'created_date_range': 'createdDateRange',
        'bidding_keyword_cpc_range': 'biddingKeywordCpcRange'
    }

    def __init__(self, account_id=None, ad_group_ids=None, bidding_strategy_ids=None, campaign_ids=None, contains_label_id=None, label_ids=None, number_results=500, start_index=1, user_statuses=None, created_date_range=None, bidding_keyword_cpc_range=None, local_vars_configuration=None):  # noqa: E501
        """AdGroupServiceSelector - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._ad_group_ids = None
        self._bidding_strategy_ids = None
        self._campaign_ids = None
        self._contains_label_id = None
        self._label_ids = None
        self._number_results = None
        self._start_index = None
        self._user_statuses = None
        self._created_date_range = None
        self._bidding_keyword_cpc_range = None
        self.discriminator = None

        self.account_id = account_id
        self.ad_group_ids = ad_group_ids
        self.bidding_strategy_ids = bidding_strategy_ids
        self.campaign_ids = campaign_ids
        self.contains_label_id = contains_label_id
        self.label_ids = label_ids
        self.number_results = number_results
        self.start_index = start_index
        self.user_statuses = user_statuses
        self.created_date_range = created_date_range
        self.bidding_keyword_cpc_range = bidding_keyword_cpc_range

    @property
    def account_id(self):
        """Gets the account_id of this AdGroupServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：アカウントID</div> <div lang=\"en\">Search condition: Account ID</div>   # noqa: E501

        :return: The account_id of this AdGroupServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AdGroupServiceSelector.

        <div lang=\"ja\">検索条件：アカウントID</div> <div lang=\"en\">Search condition: Account ID</div>   # noqa: E501

        :param account_id: The account_id of this AdGroupServiceSelector.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and account_id is None:  # noqa: E501
            raise ValueError("Invalid value for `account_id`, must not be `None`")  # noqa: E501

        self._account_id = account_id

    @property
    def ad_group_ids(self):
        """Gets the ad_group_ids of this AdGroupServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：広告グループID</div> <div lang=\"en\">Search condition: Ad Group ID</div>   # noqa: E501

        :return: The ad_group_ids of this AdGroupServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._ad_group_ids

    @ad_group_ids.setter
    def ad_group_ids(self, ad_group_ids):
        """Sets the ad_group_ids of this AdGroupServiceSelector.

        <div lang=\"ja\">検索条件：広告グループID</div> <div lang=\"en\">Search condition: Ad Group ID</div>   # noqa: E501

        :param ad_group_ids: The ad_group_ids of this AdGroupServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._ad_group_ids = ad_group_ids

    @property
    def bidding_strategy_ids(self):
        """Gets the bidding_strategy_ids of this AdGroupServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：自動入札ID</div> <div lang=\"en\">Search condition: Auto Bidding ID</div>   # noqa: E501

        :return: The bidding_strategy_ids of this AdGroupServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._bidding_strategy_ids

    @bidding_strategy_ids.setter
    def bidding_strategy_ids(self, bidding_strategy_ids):
        """Sets the bidding_strategy_ids of this AdGroupServiceSelector.

        <div lang=\"ja\">検索条件：自動入札ID</div> <div lang=\"en\">Search condition: Auto Bidding ID</div>   # noqa: E501

        :param bidding_strategy_ids: The bidding_strategy_ids of this AdGroupServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._bidding_strategy_ids = bidding_strategy_ids

    @property
    def campaign_ids(self):
        """Gets the campaign_ids of this AdGroupServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：キャンペーンID</div> <div lang=\"en\">Search condition: Campaign ID</div>   # noqa: E501

        :return: The campaign_ids of this AdGroupServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._campaign_ids

    @campaign_ids.setter
    def campaign_ids(self, campaign_ids):
        """Sets the campaign_ids of this AdGroupServiceSelector.

        <div lang=\"ja\">検索条件：キャンペーンID</div> <div lang=\"en\">Search condition: Campaign ID</div>   # noqa: E501

        :param campaign_ids: The campaign_ids of this AdGroupServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._campaign_ids = campaign_ids

    @property
    def contains_label_id(self):
        """Gets the contains_label_id of this AdGroupServiceSelector.  # noqa: E501


        :return: The contains_label_id of this AdGroupServiceSelector.  # noqa: E501
        :rtype: AdGroupServiceContainsLabelId
        """
        return self._contains_label_id

    @contains_label_id.setter
    def contains_label_id(self, contains_label_id):
        """Sets the contains_label_id of this AdGroupServiceSelector.


        :param contains_label_id: The contains_label_id of this AdGroupServiceSelector.  # noqa: E501
        :type: AdGroupServiceContainsLabelId
        """

        self._contains_label_id = contains_label_id

    @property
    def label_ids(self):
        """Gets the label_ids of this AdGroupServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：ラベルID</div> <div lang=\"en\">Search condition: Label ID</div>   # noqa: E501

        :return: The label_ids of this AdGroupServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._label_ids

    @label_ids.setter
    def label_ids(self, label_ids):
        """Sets the label_ids of this AdGroupServiceSelector.

        <div lang=\"ja\">検索条件：ラベルID</div> <div lang=\"en\">Search condition: Label ID</div>   # noqa: E501

        :param label_ids: The label_ids of this AdGroupServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._label_ids = label_ids

    @property
    def number_results(self):
        """Gets the number_results of this AdGroupServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :return: The number_results of this AdGroupServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._number_results

    @number_results.setter
    def number_results(self, number_results):
        """Sets the number_results of this AdGroupServiceSelector.

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :param number_results: The number_results of this AdGroupServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results > 10000):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value less than or equal to `10000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results < 1):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value greater than or equal to `1`")  # noqa: E501

        self._number_results = number_results

    @property
    def start_index(self):
        """Gets the start_index of this AdGroupServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :return: The start_index of this AdGroupServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._start_index

    @start_index.setter
    def start_index(self, start_index):
        """Sets the start_index of this AdGroupServiceSelector.

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :param start_index: The start_index of this AdGroupServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                start_index is not None and start_index < 1):  # noqa: E501
            raise ValueError("Invalid value for `start_index`, must be a value greater than or equal to `1`")  # noqa: E501

        self._start_index = start_index

    @property
    def user_statuses(self):
        """Gets the user_statuses of this AdGroupServiceSelector.  # noqa: E501


        :return: The user_statuses of this AdGroupServiceSelector.  # noqa: E501
        :rtype: list[AdGroupServiceUserStatus]
        """
        return self._user_statuses

    @user_statuses.setter
    def user_statuses(self, user_statuses):
        """Sets the user_statuses of this AdGroupServiceSelector.


        :param user_statuses: The user_statuses of this AdGroupServiceSelector.  # noqa: E501
        :type: list[AdGroupServiceUserStatus]
        """

        self._user_statuses = user_statuses

    @property
    def created_date_range(self):
        """Gets the created_date_range of this AdGroupServiceSelector.  # noqa: E501


        :return: The created_date_range of this AdGroupServiceSelector.  # noqa: E501
        :rtype: AdGroupServiceCreatedDateRange
        """
        return self._created_date_range

    @created_date_range.setter
    def created_date_range(self, created_date_range):
        """Sets the created_date_range of this AdGroupServiceSelector.


        :param created_date_range: The created_date_range of this AdGroupServiceSelector.  # noqa: E501
        :type: AdGroupServiceCreatedDateRange
        """

        self._created_date_range = created_date_range

    @property
    def bidding_keyword_cpc_range(self):
        """Gets the bidding_keyword_cpc_range of this AdGroupServiceSelector.  # noqa: E501


        :return: The bidding_keyword_cpc_range of this AdGroupServiceSelector.  # noqa: E501
        :rtype: AdGroupServiceBiddingKeywordCpcRange
        """
        return self._bidding_keyword_cpc_range

    @bidding_keyword_cpc_range.setter
    def bidding_keyword_cpc_range(self, bidding_keyword_cpc_range):
        """Sets the bidding_keyword_cpc_range of this AdGroupServiceSelector.


        :param bidding_keyword_cpc_range: The bidding_keyword_cpc_range of this AdGroupServiceSelector.  # noqa: E501
        :type: AdGroupServiceBiddingKeywordCpcRange
        """

        self._bidding_keyword_cpc_range = bidding_keyword_cpc_range

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdGroupServiceSelector):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AdGroupServiceSelector):
            return True

        return self.to_dict() != other.to_dict()
