# coding: utf-8

"""
    Yahoo!広告 検索広告 API リファレンス / Yahoo! JAPAN Ads Search Ads API Reference

    <div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_search_api.configuration import Configuration


class AdGroupAdServiceSelector(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'ad_group_ids': 'list[int]',
        'ad_ids': 'list[int]',
        'ad_types': 'list[AdGroupAdServiceAdType]',
        'approval_statuses': 'list[AdGroupAdServiceApprovalStatus]',
        'campaign_ids': 'list[int]',
        'contains_label_id': 'AdGroupAdServiceContainsLabelId',
        'label_ids': 'list[int]',
        'number_results': 'int',
        'start_index': 'int',
        'user_statuses': 'list[AdGroupAdServiceUserStatus]',
        'created_date_range': 'AdGroupAdServiceCreatedDateRange'
    }

    attribute_map = {
        'account_id': 'accountId',
        'ad_group_ids': 'adGroupIds',
        'ad_ids': 'adIds',
        'ad_types': 'adTypes',
        'approval_statuses': 'approvalStatuses',
        'campaign_ids': 'campaignIds',
        'contains_label_id': 'containsLabelId',
        'label_ids': 'labelIds',
        'number_results': 'numberResults',
        'start_index': 'startIndex',
        'user_statuses': 'userStatuses',
        'created_date_range': 'createdDateRange'
    }

    def __init__(self, account_id=None, ad_group_ids=None, ad_ids=None, ad_types=None, approval_statuses=None, campaign_ids=None, contains_label_id=None, label_ids=None, number_results=500, start_index=1, user_statuses=None, created_date_range=None, local_vars_configuration=None):  # noqa: E501
        """AdGroupAdServiceSelector - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._ad_group_ids = None
        self._ad_ids = None
        self._ad_types = None
        self._approval_statuses = None
        self._campaign_ids = None
        self._contains_label_id = None
        self._label_ids = None
        self._number_results = None
        self._start_index = None
        self._user_statuses = None
        self._created_date_range = None
        self.discriminator = None

        self.account_id = account_id
        self.ad_group_ids = ad_group_ids
        self.ad_ids = ad_ids
        self.ad_types = ad_types
        self.approval_statuses = approval_statuses
        self.campaign_ids = campaign_ids
        self.contains_label_id = contains_label_id
        self.label_ids = label_ids
        self.number_results = number_results
        self.start_index = start_index
        self.user_statuses = user_statuses
        self.created_date_range = created_date_range

    @property
    def account_id(self):
        """Gets the account_id of this AdGroupAdServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：アカウントID</div> <div lang=\"en\">Search condition: Account ID.</div>   # noqa: E501

        :return: The account_id of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AdGroupAdServiceSelector.

        <div lang=\"ja\">検索条件：アカウントID</div> <div lang=\"en\">Search condition: Account ID.</div>   # noqa: E501

        :param account_id: The account_id of this AdGroupAdServiceSelector.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and account_id is None:  # noqa: E501
            raise ValueError("Invalid value for `account_id`, must not be `None`")  # noqa: E501

        self._account_id = account_id

    @property
    def ad_group_ids(self):
        """Gets the ad_group_ids of this AdGroupAdServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：広告グループID</div> <div lang=\"en\">Search condition: Ad group ID.<br> Ads returned will be from adgroups whose ids are included in this list.</div>   # noqa: E501

        :return: The ad_group_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._ad_group_ids

    @ad_group_ids.setter
    def ad_group_ids(self, ad_group_ids):
        """Sets the ad_group_ids of this AdGroupAdServiceSelector.

        <div lang=\"ja\">検索条件：広告グループID</div> <div lang=\"en\">Search condition: Ad group ID.<br> Ads returned will be from adgroups whose ids are included in this list.</div>   # noqa: E501

        :param ad_group_ids: The ad_group_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._ad_group_ids = ad_group_ids

    @property
    def ad_ids(self):
        """Gets the ad_ids of this AdGroupAdServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：広告ID</div> <div lang=\"en\">Search condition: Ad ID.<br> Ads will return from ads whose ids are included in this list.<br> If you omit adIds field, it will return all adIds under the adGroup.</div>   # noqa: E501

        :return: The ad_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._ad_ids

    @ad_ids.setter
    def ad_ids(self, ad_ids):
        """Sets the ad_ids of this AdGroupAdServiceSelector.

        <div lang=\"ja\">検索条件：広告ID</div> <div lang=\"en\">Search condition: Ad ID.<br> Ads will return from ads whose ids are included in this list.<br> If you omit adIds field, it will return all adIds under the adGroup.</div>   # noqa: E501

        :param ad_ids: The ad_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._ad_ids = ad_ids

    @property
    def ad_types(self):
        """Gets the ad_types of this AdGroupAdServiceSelector.  # noqa: E501


        :return: The ad_types of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: list[AdGroupAdServiceAdType]
        """
        return self._ad_types

    @ad_types.setter
    def ad_types(self, ad_types):
        """Sets the ad_types of this AdGroupAdServiceSelector.


        :param ad_types: The ad_types of this AdGroupAdServiceSelector.  # noqa: E501
        :type: list[AdGroupAdServiceAdType]
        """

        self._ad_types = ad_types

    @property
    def approval_statuses(self):
        """Gets the approval_statuses of this AdGroupAdServiceSelector.  # noqa: E501


        :return: The approval_statuses of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: list[AdGroupAdServiceApprovalStatus]
        """
        return self._approval_statuses

    @approval_statuses.setter
    def approval_statuses(self, approval_statuses):
        """Sets the approval_statuses of this AdGroupAdServiceSelector.


        :param approval_statuses: The approval_statuses of this AdGroupAdServiceSelector.  # noqa: E501
        :type: list[AdGroupAdServiceApprovalStatus]
        """

        self._approval_statuses = approval_statuses

    @property
    def campaign_ids(self):
        """Gets the campaign_ids of this AdGroupAdServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：キャンペーンID</div> <div lang=\"en\">Search condition: Campaign ID.<br> Ads returned will be from campaigns whose ids are included in this list.<br> An empty list means there are no campaign restrictions when selecting AdGroupAds.<br> * This field must contain distinct elements.<br>* This field cannot contain null elements.</div>   # noqa: E501

        :return: The campaign_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._campaign_ids

    @campaign_ids.setter
    def campaign_ids(self, campaign_ids):
        """Sets the campaign_ids of this AdGroupAdServiceSelector.

        <div lang=\"ja\">検索条件：キャンペーンID</div> <div lang=\"en\">Search condition: Campaign ID.<br> Ads returned will be from campaigns whose ids are included in this list.<br> An empty list means there are no campaign restrictions when selecting AdGroupAds.<br> * This field must contain distinct elements.<br>* This field cannot contain null elements.</div>   # noqa: E501

        :param campaign_ids: The campaign_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._campaign_ids = campaign_ids

    @property
    def contains_label_id(self):
        """Gets the contains_label_id of this AdGroupAdServiceSelector.  # noqa: E501


        :return: The contains_label_id of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: AdGroupAdServiceContainsLabelId
        """
        return self._contains_label_id

    @contains_label_id.setter
    def contains_label_id(self, contains_label_id):
        """Sets the contains_label_id of this AdGroupAdServiceSelector.


        :param contains_label_id: The contains_label_id of this AdGroupAdServiceSelector.  # noqa: E501
        :type: AdGroupAdServiceContainsLabelId
        """

        self._contains_label_id = contains_label_id

    @property
    def label_ids(self):
        """Gets the label_ids of this AdGroupAdServiceSelector.  # noqa: E501

        <div lang=\"ja\">検索条件：ラベルID</div> <div lang=\"en\">Search condition: Label ID</div>   # noqa: E501

        :return: The label_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._label_ids

    @label_ids.setter
    def label_ids(self, label_ids):
        """Sets the label_ids of this AdGroupAdServiceSelector.

        <div lang=\"ja\">検索条件：ラベルID</div> <div lang=\"en\">Search condition: Label ID</div>   # noqa: E501

        :param label_ids: The label_ids of this AdGroupAdServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._label_ids = label_ids

    @property
    def number_results(self):
        """Gets the number_results of this AdGroupAdServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :return: The number_results of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._number_results

    @number_results.setter
    def number_results(self, number_results):
        """Sets the number_results of this AdGroupAdServiceSelector.

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :param number_results: The number_results of this AdGroupAdServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results > 10000):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value less than or equal to `10000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results < 1):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value greater than or equal to `1`")  # noqa: E501

        self._number_results = number_results

    @property
    def start_index(self):
        """Gets the start_index of this AdGroupAdServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :return: The start_index of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._start_index

    @start_index.setter
    def start_index(self, start_index):
        """Sets the start_index of this AdGroupAdServiceSelector.

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :param start_index: The start_index of this AdGroupAdServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                start_index is not None and start_index < 1):  # noqa: E501
            raise ValueError("Invalid value for `start_index`, must be a value greater than or equal to `1`")  # noqa: E501

        self._start_index = start_index

    @property
    def user_statuses(self):
        """Gets the user_statuses of this AdGroupAdServiceSelector.  # noqa: E501


        :return: The user_statuses of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: list[AdGroupAdServiceUserStatus]
        """
        return self._user_statuses

    @user_statuses.setter
    def user_statuses(self, user_statuses):
        """Sets the user_statuses of this AdGroupAdServiceSelector.


        :param user_statuses: The user_statuses of this AdGroupAdServiceSelector.  # noqa: E501
        :type: list[AdGroupAdServiceUserStatus]
        """

        self._user_statuses = user_statuses

    @property
    def created_date_range(self):
        """Gets the created_date_range of this AdGroupAdServiceSelector.  # noqa: E501


        :return: The created_date_range of this AdGroupAdServiceSelector.  # noqa: E501
        :rtype: AdGroupAdServiceCreatedDateRange
        """
        return self._created_date_range

    @created_date_range.setter
    def created_date_range(self, created_date_range):
        """Sets the created_date_range of this AdGroupAdServiceSelector.


        :param created_date_range: The created_date_range of this AdGroupAdServiceSelector.  # noqa: E501
        :type: AdGroupAdServiceCreatedDateRange
        """

        self._created_date_range = created_date_range

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdGroupAdServiceSelector):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AdGroupAdServiceSelector):
            return True

        return self.to_dict() != other.to_dict()
