# openapi-client
<div lang=\"ja\">Yahoo!広告 検索広告 APIのWebサービスについて説明します。</div>
<div lang=\"en\">Search Ads API Web Services supported in Yahoo! JAPAN Ads API.</div>
<div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div>
<div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div>
<div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-search-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v6
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import yahoo_search_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import yahoo_search_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import yahoo_search_api
from yahoo_search_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://ads-search.yahooapis.jp/api/v6
# See configuration.py for a list of all supported configuration parameters.
configuration = yahoo_search_api.Configuration(
    host = "https://ads-search.yahooapis.jp/api/v6"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oAuth
configuration = yahoo_search_api.Configuration(
    host = "https://ads-search.yahooapis.jp/api/v6"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with yahoo_search_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = yahoo_search_api.AccountLinkServiceApi(api_client)
    account_link_service_selector = yahoo_search_api.AccountLinkServiceSelector() # AccountLinkServiceSelector |  (optional)

    try:
        api_response = api_instance.account_link_service_get_post(account_link_service_selector=account_link_service_selector)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccountLinkServiceApi->account_link_service_get_post: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://ads-search.yahooapis.jp/api/v6*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountLinkServiceApi* | [**account_link_service_get_post**](docs/AccountLinkServiceApi.md#account_link_service_get_post) | **POST** /AccountLinkService/get | 
*AccountManagementServiceApi* | [**account_management_service_add_post**](docs/AccountManagementServiceApi.md#account_management_service_add_post) | **POST** /AccountManagementService/add | 
*AccountManagementServiceApi* | [**account_management_service_get_post**](docs/AccountManagementServiceApi.md#account_management_service_get_post) | **POST** /AccountManagementService/get | 
*AccountManagementServiceApi* | [**account_management_service_set_post**](docs/AccountManagementServiceApi.md#account_management_service_set_post) | **POST** /AccountManagementService/set | 
*AccountServiceApi* | [**account_service_get_post**](docs/AccountServiceApi.md#account_service_get_post) | **POST** /AccountService/get | 
*AccountServiceApi* | [**account_service_set_post**](docs/AccountServiceApi.md#account_service_set_post) | **POST** /AccountService/set | 
*AccountSharedServiceApi* | [**account_shared_service_add_post**](docs/AccountSharedServiceApi.md#account_shared_service_add_post) | **POST** /AccountSharedService/add | 
*AccountSharedServiceApi* | [**account_shared_service_get_post**](docs/AccountSharedServiceApi.md#account_shared_service_get_post) | **POST** /AccountSharedService/get | 
*AccountSharedServiceApi* | [**account_shared_service_remove_post**](docs/AccountSharedServiceApi.md#account_shared_service_remove_post) | **POST** /AccountSharedService/remove | 
*AccountSharedServiceApi* | [**account_shared_service_set_post**](docs/AccountSharedServiceApi.md#account_shared_service_set_post) | **POST** /AccountSharedService/set | 
*AccountTrackingUrlServiceApi* | [**account_tracking_url_service_get_post**](docs/AccountTrackingUrlServiceApi.md#account_tracking_url_service_get_post) | **POST** /AccountTrackingUrlService/get | 
*AccountTrackingUrlServiceApi* | [**account_tracking_url_service_set_post**](docs/AccountTrackingUrlServiceApi.md#account_tracking_url_service_set_post) | **POST** /AccountTrackingUrlService/set | 
*AdGroupAdLabelServiceApi* | [**ad_group_ad_label_service_add_post**](docs/AdGroupAdLabelServiceApi.md#ad_group_ad_label_service_add_post) | **POST** /AdGroupAdLabelService/add | 
*AdGroupAdLabelServiceApi* | [**ad_group_ad_label_service_remove_post**](docs/AdGroupAdLabelServiceApi.md#ad_group_ad_label_service_remove_post) | **POST** /AdGroupAdLabelService/remove | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_add_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_add_post) | **POST** /AdGroupAdService/add | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_get_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_get_post) | **POST** /AdGroupAdService/get | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_remove_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_remove_post) | **POST** /AdGroupAdService/remove | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_set_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_set_post) | **POST** /AdGroupAdService/set | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_set_trademark_status_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_set_trademark_status_post) | **POST** /AdGroupAdService/setTrademarkStatus | 
*AdGroupBidMultiplierServiceApi* | [**ad_group_bid_multiplier_service_get_post**](docs/AdGroupBidMultiplierServiceApi.md#ad_group_bid_multiplier_service_get_post) | **POST** /AdGroupBidMultiplierService/get | 
*AdGroupBidMultiplierServiceApi* | [**ad_group_bid_multiplier_service_remove_post**](docs/AdGroupBidMultiplierServiceApi.md#ad_group_bid_multiplier_service_remove_post) | **POST** /AdGroupBidMultiplierService/remove | 
*AdGroupBidMultiplierServiceApi* | [**ad_group_bid_multiplier_service_set_post**](docs/AdGroupBidMultiplierServiceApi.md#ad_group_bid_multiplier_service_set_post) | **POST** /AdGroupBidMultiplierService/set | 
*AdGroupCriterionLabelServiceApi* | [**ad_group_criterion_label_service_add_post**](docs/AdGroupCriterionLabelServiceApi.md#ad_group_criterion_label_service_add_post) | **POST** /AdGroupCriterionLabelService/add | 
*AdGroupCriterionLabelServiceApi* | [**ad_group_criterion_label_service_remove_post**](docs/AdGroupCriterionLabelServiceApi.md#ad_group_criterion_label_service_remove_post) | **POST** /AdGroupCriterionLabelService/remove | 
*AdGroupCriterionServiceApi* | [**ad_group_criterion_service_add_post**](docs/AdGroupCriterionServiceApi.md#ad_group_criterion_service_add_post) | **POST** /AdGroupCriterionService/add | 
*AdGroupCriterionServiceApi* | [**ad_group_criterion_service_get_post**](docs/AdGroupCriterionServiceApi.md#ad_group_criterion_service_get_post) | **POST** /AdGroupCriterionService/get | 
*AdGroupCriterionServiceApi* | [**ad_group_criterion_service_remove_post**](docs/AdGroupCriterionServiceApi.md#ad_group_criterion_service_remove_post) | **POST** /AdGroupCriterionService/remove | 
*AdGroupCriterionServiceApi* | [**ad_group_criterion_service_set_post**](docs/AdGroupCriterionServiceApi.md#ad_group_criterion_service_set_post) | **POST** /AdGroupCriterionService/set | 
*AdGroupFeedServiceApi* | [**ad_group_feed_service_get_post**](docs/AdGroupFeedServiceApi.md#ad_group_feed_service_get_post) | **POST** /AdGroupFeedService/get | 
*AdGroupFeedServiceApi* | [**ad_group_feed_service_set_post**](docs/AdGroupFeedServiceApi.md#ad_group_feed_service_set_post) | **POST** /AdGroupFeedService/set | 
*AdGroupLabelServiceApi* | [**ad_group_label_service_add_post**](docs/AdGroupLabelServiceApi.md#ad_group_label_service_add_post) | **POST** /AdGroupLabelService/add | 
*AdGroupLabelServiceApi* | [**ad_group_label_service_remove_post**](docs/AdGroupLabelServiceApi.md#ad_group_label_service_remove_post) | **POST** /AdGroupLabelService/remove | 
*AdGroupRetargetingListServiceApi* | [**ad_group_retargeting_list_service_add_post**](docs/AdGroupRetargetingListServiceApi.md#ad_group_retargeting_list_service_add_post) | **POST** /AdGroupRetargetingListService/add | 
*AdGroupRetargetingListServiceApi* | [**ad_group_retargeting_list_service_get_post**](docs/AdGroupRetargetingListServiceApi.md#ad_group_retargeting_list_service_get_post) | **POST** /AdGroupRetargetingListService/get | 
*AdGroupRetargetingListServiceApi* | [**ad_group_retargeting_list_service_remove_post**](docs/AdGroupRetargetingListServiceApi.md#ad_group_retargeting_list_service_remove_post) | **POST** /AdGroupRetargetingListService/remove | 
*AdGroupRetargetingListServiceApi* | [**ad_group_retargeting_list_service_set_post**](docs/AdGroupRetargetingListServiceApi.md#ad_group_retargeting_list_service_set_post) | **POST** /AdGroupRetargetingListService/set | 
*AdGroupServiceApi* | [**ad_group_service_add_post**](docs/AdGroupServiceApi.md#ad_group_service_add_post) | **POST** /AdGroupService/add | 
*AdGroupServiceApi* | [**ad_group_service_get_post**](docs/AdGroupServiceApi.md#ad_group_service_get_post) | **POST** /AdGroupService/get | 
*AdGroupServiceApi* | [**ad_group_service_remove_post**](docs/AdGroupServiceApi.md#ad_group_service_remove_post) | **POST** /AdGroupService/remove | 
*AdGroupServiceApi* | [**ad_group_service_set_post**](docs/AdGroupServiceApi.md#ad_group_service_set_post) | **POST** /AdGroupService/set | 
*AdGroupWebpageServiceApi* | [**ad_group_webpage_service_add_post**](docs/AdGroupWebpageServiceApi.md#ad_group_webpage_service_add_post) | **POST** /AdGroupWebpageService/add | 
*AdGroupWebpageServiceApi* | [**ad_group_webpage_service_get_post**](docs/AdGroupWebpageServiceApi.md#ad_group_webpage_service_get_post) | **POST** /AdGroupWebpageService/get | 
*AdGroupWebpageServiceApi* | [**ad_group_webpage_service_remove_post**](docs/AdGroupWebpageServiceApi.md#ad_group_webpage_service_remove_post) | **POST** /AdGroupWebpageService/remove | 
*AdGroupWebpageServiceApi* | [**ad_group_webpage_service_set_post**](docs/AdGroupWebpageServiceApi.md#ad_group_webpage_service_set_post) | **POST** /AdGroupWebpageService/set | 
*AppLinkServiceApi* | [**app_link_service_add_post**](docs/AppLinkServiceApi.md#app_link_service_add_post) | **POST** /AppLinkService/add | 
*AppLinkServiceApi* | [**app_link_service_get_post**](docs/AppLinkServiceApi.md#app_link_service_get_post) | **POST** /AppLinkService/get | 
*AppLinkServiceApi* | [**app_link_service_regenerate_post**](docs/AppLinkServiceApi.md#app_link_service_regenerate_post) | **POST** /AppLinkService/regenerate | 
*AppLinkServiceApi* | [**app_link_service_set_post**](docs/AppLinkServiceApi.md#app_link_service_set_post) | **POST** /AppLinkService/set | 
*AuditLogServiceApi* | [**audit_log_service_add_job_post**](docs/AuditLogServiceApi.md#audit_log_service_add_job_post) | **POST** /AuditLogService/addJob | 
*AuditLogServiceApi* | [**audit_log_service_download_post**](docs/AuditLogServiceApi.md#audit_log_service_download_post) | **POST** /AuditLogService/download | 
*AuditLogServiceApi* | [**audit_log_service_get_post**](docs/AuditLogServiceApi.md#audit_log_service_get_post) | **POST** /AuditLogService/get | 
*BalanceServiceApi* | [**balance_service_get_post**](docs/BalanceServiceApi.md#balance_service_get_post) | **POST** /BalanceService/get | 
*BiddingStrategyServiceApi* | [**bidding_strategy_service_add_post**](docs/BiddingStrategyServiceApi.md#bidding_strategy_service_add_post) | **POST** /BiddingStrategyService/add | 
*BiddingStrategyServiceApi* | [**bidding_strategy_service_get_post**](docs/BiddingStrategyServiceApi.md#bidding_strategy_service_get_post) | **POST** /BiddingStrategyService/get | 
*BiddingStrategyServiceApi* | [**bidding_strategy_service_remove_post**](docs/BiddingStrategyServiceApi.md#bidding_strategy_service_remove_post) | **POST** /BiddingStrategyService/remove | 
*BiddingStrategyServiceApi* | [**bidding_strategy_service_set_post**](docs/BiddingStrategyServiceApi.md#bidding_strategy_service_set_post) | **POST** /BiddingStrategyService/set | 
*BudgetOrderServiceApi* | [**budget_order_service_get_post**](docs/BudgetOrderServiceApi.md#budget_order_service_get_post) | **POST** /BudgetOrderService/get | 
*BudgetOrderServiceApi* | [**budget_order_service_set_post**](docs/BudgetOrderServiceApi.md#budget_order_service_set_post) | **POST** /BudgetOrderService/set | 
*CampaignCriterionServiceApi* | [**campaign_criterion_service_add_post**](docs/CampaignCriterionServiceApi.md#campaign_criterion_service_add_post) | **POST** /CampaignCriterionService/add | 
*CampaignCriterionServiceApi* | [**campaign_criterion_service_get_post**](docs/CampaignCriterionServiceApi.md#campaign_criterion_service_get_post) | **POST** /CampaignCriterionService/get | 
*CampaignCriterionServiceApi* | [**campaign_criterion_service_remove_post**](docs/CampaignCriterionServiceApi.md#campaign_criterion_service_remove_post) | **POST** /CampaignCriterionService/remove | 
*CampaignExportServiceApi* | [**campaign_export_service_add_job_post**](docs/CampaignExportServiceApi.md#campaign_export_service_add_job_post) | **POST** /CampaignExportService/addJob | 
*CampaignExportServiceApi* | [**campaign_export_service_download_post**](docs/CampaignExportServiceApi.md#campaign_export_service_download_post) | **POST** /CampaignExportService/download | 
*CampaignExportServiceApi* | [**campaign_export_service_get_export_fields_post**](docs/CampaignExportServiceApi.md#campaign_export_service_get_export_fields_post) | **POST** /CampaignExportService/getExportFields | 
*CampaignExportServiceApi* | [**campaign_export_service_get_post**](docs/CampaignExportServiceApi.md#campaign_export_service_get_post) | **POST** /CampaignExportService/get | 
*CampaignFeedServiceApi* | [**campaign_feed_service_get_post**](docs/CampaignFeedServiceApi.md#campaign_feed_service_get_post) | **POST** /CampaignFeedService/get | 
*CampaignFeedServiceApi* | [**campaign_feed_service_set_post**](docs/CampaignFeedServiceApi.md#campaign_feed_service_set_post) | **POST** /CampaignFeedService/set | 
*CampaignLabelServiceApi* | [**campaign_label_service_add_post**](docs/CampaignLabelServiceApi.md#campaign_label_service_add_post) | **POST** /CampaignLabelService/add | 
*CampaignLabelServiceApi* | [**campaign_label_service_remove_post**](docs/CampaignLabelServiceApi.md#campaign_label_service_remove_post) | **POST** /CampaignLabelService/remove | 
*CampaignRetargetingListServiceApi* | [**campaign_retargeting_list_service_add_post**](docs/CampaignRetargetingListServiceApi.md#campaign_retargeting_list_service_add_post) | **POST** /CampaignRetargetingListService/add | 
*CampaignRetargetingListServiceApi* | [**campaign_retargeting_list_service_get_post**](docs/CampaignRetargetingListServiceApi.md#campaign_retargeting_list_service_get_post) | **POST** /CampaignRetargetingListService/get | 
*CampaignRetargetingListServiceApi* | [**campaign_retargeting_list_service_remove_post**](docs/CampaignRetargetingListServiceApi.md#campaign_retargeting_list_service_remove_post) | **POST** /CampaignRetargetingListService/remove | 
*CampaignRetargetingListServiceApi* | [**campaign_retargeting_list_service_set_post**](docs/CampaignRetargetingListServiceApi.md#campaign_retargeting_list_service_set_post) | **POST** /CampaignRetargetingListService/set | 
*CampaignServiceApi* | [**campaign_service_add_post**](docs/CampaignServiceApi.md#campaign_service_add_post) | **POST** /CampaignService/add | 
*CampaignServiceApi* | [**campaign_service_get_post**](docs/CampaignServiceApi.md#campaign_service_get_post) | **POST** /CampaignService/get | 
*CampaignServiceApi* | [**campaign_service_remove_post**](docs/CampaignServiceApi.md#campaign_service_remove_post) | **POST** /CampaignService/remove | 
*CampaignServiceApi* | [**campaign_service_set_post**](docs/CampaignServiceApi.md#campaign_service_set_post) | **POST** /CampaignService/set | 
*CampaignSharedSetServiceApi* | [**campaign_shared_set_service_add_post**](docs/CampaignSharedSetServiceApi.md#campaign_shared_set_service_add_post) | **POST** /CampaignSharedSetService/add | 
*CampaignSharedSetServiceApi* | [**campaign_shared_set_service_get_post**](docs/CampaignSharedSetServiceApi.md#campaign_shared_set_service_get_post) | **POST** /CampaignSharedSetService/get | 
*CampaignSharedSetServiceApi* | [**campaign_shared_set_service_remove_post**](docs/CampaignSharedSetServiceApi.md#campaign_shared_set_service_remove_post) | **POST** /CampaignSharedSetService/remove | 
*CampaignTargetServiceApi* | [**campaign_target_service_add_post**](docs/CampaignTargetServiceApi.md#campaign_target_service_add_post) | **POST** /CampaignTargetService/add | 
*CampaignTargetServiceApi* | [**campaign_target_service_get_post**](docs/CampaignTargetServiceApi.md#campaign_target_service_get_post) | **POST** /CampaignTargetService/get | 
*CampaignTargetServiceApi* | [**campaign_target_service_remove_post**](docs/CampaignTargetServiceApi.md#campaign_target_service_remove_post) | **POST** /CampaignTargetService/remove | 
*CampaignTargetServiceApi* | [**campaign_target_service_set_post**](docs/CampaignTargetServiceApi.md#campaign_target_service_set_post) | **POST** /CampaignTargetService/set | 
*CampaignWebpageServiceApi* | [**campaign_webpage_service_add_post**](docs/CampaignWebpageServiceApi.md#campaign_webpage_service_add_post) | **POST** /CampaignWebpageService/add | 
*CampaignWebpageServiceApi* | [**campaign_webpage_service_get_post**](docs/CampaignWebpageServiceApi.md#campaign_webpage_service_get_post) | **POST** /CampaignWebpageService/get | 
*CampaignWebpageServiceApi* | [**campaign_webpage_service_remove_post**](docs/CampaignWebpageServiceApi.md#campaign_webpage_service_remove_post) | **POST** /CampaignWebpageService/remove | 
*ConversionTrackerServiceApi* | [**conversion_tracker_service_add_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_add_post) | **POST** /ConversionTrackerService/add | 
*ConversionTrackerServiceApi* | [**conversion_tracker_service_get_app_event_type_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_get_app_event_type_post) | **POST** /ConversionTrackerService/getAppEventType | 
*ConversionTrackerServiceApi* | [**conversion_tracker_service_get_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_get_post) | **POST** /ConversionTrackerService/get | 
*ConversionTrackerServiceApi* | [**conversion_tracker_service_set_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_set_post) | **POST** /ConversionTrackerService/set | 
*DictionaryServiceApi* | [**dictionary_service_get_app_link_vendor_post**](docs/DictionaryServiceApi.md#dictionary_service_get_app_link_vendor_post) | **POST** /DictionaryService/getAppLinkVendor | 
*DictionaryServiceApi* | [**dictionary_service_get_disapproval_reason_post**](docs/DictionaryServiceApi.md#dictionary_service_get_disapproval_reason_post) | **POST** /DictionaryService/getDisapprovalReason | 
*DictionaryServiceApi* | [**dictionary_service_get_geographic_location_post**](docs/DictionaryServiceApi.md#dictionary_service_get_geographic_location_post) | **POST** /DictionaryService/getGeographicLocation | 
*FeedItemServiceApi* | [**feed_item_service_add_post**](docs/FeedItemServiceApi.md#feed_item_service_add_post) | **POST** /FeedItemService/add | 
*FeedItemServiceApi* | [**feed_item_service_get_post**](docs/FeedItemServiceApi.md#feed_item_service_get_post) | **POST** /FeedItemService/get | 
*FeedItemServiceApi* | [**feed_item_service_remove_post**](docs/FeedItemServiceApi.md#feed_item_service_remove_post) | **POST** /FeedItemService/remove | 
*FeedItemServiceApi* | [**feed_item_service_set_post**](docs/FeedItemServiceApi.md#feed_item_service_set_post) | **POST** /FeedItemService/set | 
*FeedItemServiceApi* | [**feed_item_service_set_trademark_status_post**](docs/FeedItemServiceApi.md#feed_item_service_set_trademark_status_post) | **POST** /FeedItemService/setTrademarkStatus | 
*FeedServiceApi* | [**feed_service_add_post**](docs/FeedServiceApi.md#feed_service_add_post) | **POST** /FeedService/add | 
*FeedServiceApi* | [**feed_service_get_post**](docs/FeedServiceApi.md#feed_service_get_post) | **POST** /FeedService/get | 
*FeedServiceApi* | [**feed_service_remove_post**](docs/FeedServiceApi.md#feed_service_remove_post) | **POST** /FeedService/remove | 
*FeedServiceApi* | [**feed_service_set_post**](docs/FeedServiceApi.md#feed_service_set_post) | **POST** /FeedService/set | 
*KeywordEstimatorServiceApi* | [**keyword_estimator_service_get_post**](docs/KeywordEstimatorServiceApi.md#keyword_estimator_service_get_post) | **POST** /KeywordEstimatorService/get | 
*KeywordForecastMetricsServiceApi* | [**keyword_forecast_metrics_service_get_post**](docs/KeywordForecastMetricsServiceApi.md#keyword_forecast_metrics_service_get_post) | **POST** /KeywordForecastMetricsService/get | 
*KeywordPlanIdeaServiceApi* | [**keyword_plan_idea_service_get_post**](docs/KeywordPlanIdeaServiceApi.md#keyword_plan_idea_service_get_post) | **POST** /KeywordPlanIdeaService/get | 
*LabelServiceApi* | [**label_service_add_post**](docs/LabelServiceApi.md#label_service_add_post) | **POST** /LabelService/add | 
*LabelServiceApi* | [**label_service_get_post**](docs/LabelServiceApi.md#label_service_get_post) | **POST** /LabelService/get | 
*LabelServiceApi* | [**label_service_remove_post**](docs/LabelServiceApi.md#label_service_remove_post) | **POST** /LabelService/remove | 
*LabelServiceApi* | [**label_service_set_post**](docs/LabelServiceApi.md#label_service_set_post) | **POST** /LabelService/set | 
*OfflineConversionServiceApi* | [**offline_conversion_service_download_error_file_post**](docs/OfflineConversionServiceApi.md#offline_conversion_service_download_error_file_post) | **POST** /OfflineConversionService/downloadErrorFile | 
*OfflineConversionServiceApi* | [**offline_conversion_service_download_post**](docs/OfflineConversionServiceApi.md#offline_conversion_service_download_post) | **POST** /OfflineConversionService/download | 
*OfflineConversionServiceApi* | [**offline_conversion_service_get_post**](docs/OfflineConversionServiceApi.md#offline_conversion_service_get_post) | **POST** /OfflineConversionService/get | 
*OfflineConversionServiceApi* | [**offline_conversion_service_upload_post**](docs/OfflineConversionServiceApi.md#offline_conversion_service_upload_post) | **POST** /OfflineConversionService/upload | 
*PageFeedItemServiceApi* | [**page_feed_item_service_add_download_job_post**](docs/PageFeedItemServiceApi.md#page_feed_item_service_add_download_job_post) | **POST** /PageFeedItemService/addDownloadJob | 
*PageFeedItemServiceApi* | [**page_feed_item_service_download_error_file_post**](docs/PageFeedItemServiceApi.md#page_feed_item_service_download_error_file_post) | **POST** /PageFeedItemService/downloadErrorFile | 
*PageFeedItemServiceApi* | [**page_feed_item_service_download_post**](docs/PageFeedItemServiceApi.md#page_feed_item_service_download_post) | **POST** /PageFeedItemService/download | 
*PageFeedItemServiceApi* | [**page_feed_item_service_get_job_status_post**](docs/PageFeedItemServiceApi.md#page_feed_item_service_get_job_status_post) | **POST** /PageFeedItemService/getJobStatus | 
*PageFeedItemServiceApi* | [**page_feed_item_service_get_post**](docs/PageFeedItemServiceApi.md#page_feed_item_service_get_post) | **POST** /PageFeedItemService/get | 
*PageFeedItemServiceApi* | [**page_feed_item_service_get_review_summary_post**](docs/PageFeedItemServiceApi.md#page_feed_item_service_get_review_summary_post) | **POST** /PageFeedItemService/getReviewSummary | 
*PageFeedItemServiceApi* | [**page_feed_item_service_upload_post**](docs/PageFeedItemServiceApi.md#page_feed_item_service_upload_post) | **POST** /PageFeedItemService/upload | 
*ReportDefinitionServiceApi* | [**report_definition_service_add_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_add_post) | **POST** /ReportDefinitionService/add | 
*ReportDefinitionServiceApi* | [**report_definition_service_download_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_download_post) | **POST** /ReportDefinitionService/download | 
*ReportDefinitionServiceApi* | [**report_definition_service_get_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_get_post) | **POST** /ReportDefinitionService/get | 
*ReportDefinitionServiceApi* | [**report_definition_service_get_report_fields_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_get_report_fields_post) | **POST** /ReportDefinitionService/getReportFields | 
*ReportDefinitionServiceApi* | [**report_definition_service_remove_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_remove_post) | **POST** /ReportDefinitionService/remove | 
*RetargetingListServiceApi* | [**retargeting_list_service_add_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_add_post) | **POST** /RetargetingListService/add | 
*RetargetingListServiceApi* | [**retargeting_list_service_get_custom_key_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_get_custom_key_post) | **POST** /RetargetingListService/getCustomKey | 
*RetargetingListServiceApi* | [**retargeting_list_service_get_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_get_post) | **POST** /RetargetingListService/get | 
*RetargetingListServiceApi* | [**retargeting_list_service_set_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_set_post) | **POST** /RetargetingListService/set | 
*SharedCriterionServiceApi* | [**shared_criterion_service_add_post**](docs/SharedCriterionServiceApi.md#shared_criterion_service_add_post) | **POST** /SharedCriterionService/add | 
*SharedCriterionServiceApi* | [**shared_criterion_service_get_post**](docs/SharedCriterionServiceApi.md#shared_criterion_service_get_post) | **POST** /SharedCriterionService/get | 
*SharedCriterionServiceApi* | [**shared_criterion_service_remove_post**](docs/SharedCriterionServiceApi.md#shared_criterion_service_remove_post) | **POST** /SharedCriterionService/remove | 


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountLink](docs/AccountLink.md)
 - [AccountLinkServiceAccountStatus](docs/AccountLinkServiceAccountStatus.md)
 - [AccountLinkServiceGetResponse](docs/AccountLinkServiceGetResponse.md)
 - [AccountLinkServiceLinkAccessPermission](docs/AccountLinkServiceLinkAccessPermission.md)
 - [AccountLinkServiceOwnerShipType](docs/AccountLinkServiceOwnerShipType.md)
 - [AccountLinkServicePage](docs/AccountLinkServicePage.md)
 - [AccountLinkServiceSelector](docs/AccountLinkServiceSelector.md)
 - [AccountLinkServiceValue](docs/AccountLinkServiceValue.md)
 - [AccountManagement](docs/AccountManagement.md)
 - [AccountManagementServiceAuthType](docs/AccountManagementServiceAuthType.md)
 - [AccountManagementServiceAutoTaggingEnabled](docs/AccountManagementServiceAutoTaggingEnabled.md)
 - [AccountManagementServiceClient](docs/AccountManagementServiceClient.md)
 - [AccountManagementServiceClientType](docs/AccountManagementServiceClientType.md)
 - [AccountManagementServiceDeliveryStatus](docs/AccountManagementServiceDeliveryStatus.md)
 - [AccountManagementServiceEnterpriseType](docs/AccountManagementServiceEnterpriseType.md)
 - [AccountManagementServiceEnterpriseTypePosition](docs/AccountManagementServiceEnterpriseTypePosition.md)
 - [AccountManagementServiceGetResponse](docs/AccountManagementServiceGetResponse.md)
 - [AccountManagementServiceIncludeTestAccount](docs/AccountManagementServiceIncludeTestAccount.md)
 - [AccountManagementServiceInvoice](docs/AccountManagementServiceInvoice.md)
 - [AccountManagementServiceIsAdultAccount](docs/AccountManagementServiceIsAdultAccount.md)
 - [AccountManagementServiceIsTestAccount](docs/AccountManagementServiceIsTestAccount.md)
 - [AccountManagementServiceMutateResponse](docs/AccountManagementServiceMutateResponse.md)
 - [AccountManagementServiceOperation](docs/AccountManagementServiceOperation.md)
 - [AccountManagementServicePage](docs/AccountManagementServicePage.md)
 - [AccountManagementServicePayment](docs/AccountManagementServicePayment.md)
 - [AccountManagementServicePaymentType](docs/AccountManagementServicePaymentType.md)
 - [AccountManagementServicePrefectureCode](docs/AccountManagementServicePrefectureCode.md)
 - [AccountManagementServiceReturnValue](docs/AccountManagementServiceReturnValue.md)
 - [AccountManagementServiceSelector](docs/AccountManagementServiceSelector.md)
 - [AccountManagementServiceStatus](docs/AccountManagementServiceStatus.md)
 - [AccountManagementServiceUrlType](docs/AccountManagementServiceUrlType.md)
 - [AccountManagementServiceValue](docs/AccountManagementServiceValue.md)
 - [AccountServiceAuthType](docs/AccountServiceAuthType.md)
 - [AccountServiceAutoTaggingEnabled](docs/AccountServiceAutoTaggingEnabled.md)
 - [AccountServiceDeliveryStatus](docs/AccountServiceDeliveryStatus.md)
 - [AccountServiceGetResponse](docs/AccountServiceGetResponse.md)
 - [AccountServiceIncludeManagerAccount](docs/AccountServiceIncludeManagerAccount.md)
 - [AccountServiceIncludeTestAccount](docs/AccountServiceIncludeTestAccount.md)
 - [AccountServiceIsManagerAccount](docs/AccountServiceIsManagerAccount.md)
 - [AccountServiceIsTestAccount](docs/AccountServiceIsTestAccount.md)
 - [AccountServiceMutateResponse](docs/AccountServiceMutateResponse.md)
 - [AccountServiceOperation](docs/AccountServiceOperation.md)
 - [AccountServicePage](docs/AccountServicePage.md)
 - [AccountServiceReturnValue](docs/AccountServiceReturnValue.md)
 - [AccountServiceSelector](docs/AccountServiceSelector.md)
 - [AccountServiceStatus](docs/AccountServiceStatus.md)
 - [AccountServiceType](docs/AccountServiceType.md)
 - [AccountServiceValue](docs/AccountServiceValue.md)
 - [AccountShared](docs/AccountShared.md)
 - [AccountSharedServiceGetResponse](docs/AccountSharedServiceGetResponse.md)
 - [AccountSharedServiceMutateResponse](docs/AccountSharedServiceMutateResponse.md)
 - [AccountSharedServiceOperation](docs/AccountSharedServiceOperation.md)
 - [AccountSharedServicePage](docs/AccountSharedServicePage.md)
 - [AccountSharedServiceReturnValue](docs/AccountSharedServiceReturnValue.md)
 - [AccountSharedServiceSelector](docs/AccountSharedServiceSelector.md)
 - [AccountSharedServiceValue](docs/AccountSharedServiceValue.md)
 - [AccountTrackingUrl](docs/AccountTrackingUrl.md)
 - [AccountTrackingUrlServiceGetResponse](docs/AccountTrackingUrlServiceGetResponse.md)
 - [AccountTrackingUrlServiceMutateResponse](docs/AccountTrackingUrlServiceMutateResponse.md)
 - [AccountTrackingUrlServiceOperation](docs/AccountTrackingUrlServiceOperation.md)
 - [AccountTrackingUrlServicePage](docs/AccountTrackingUrlServicePage.md)
 - [AccountTrackingUrlServiceReturnValue](docs/AccountTrackingUrlServiceReturnValue.md)
 - [AccountTrackingUrlServiceSelector](docs/AccountTrackingUrlServiceSelector.md)
 - [AccountTrackingUrlServiceUrlApprovalStatus](docs/AccountTrackingUrlServiceUrlApprovalStatus.md)
 - [AccountTrackingUrlServiceValue](docs/AccountTrackingUrlServiceValue.md)
 - [AdGroup](docs/AdGroup.md)
 - [AdGroupAd](docs/AdGroupAd.md)
 - [AdGroupAdLabel](docs/AdGroupAdLabel.md)
 - [AdGroupAdLabelServiceMutateResponse](docs/AdGroupAdLabelServiceMutateResponse.md)
 - [AdGroupAdLabelServiceOperation](docs/AdGroupAdLabelServiceOperation.md)
 - [AdGroupAdLabelServiceReturnValue](docs/AdGroupAdLabelServiceReturnValue.md)
 - [AdGroupAdLabelServiceValue](docs/AdGroupAdLabelServiceValue.md)
 - [AdGroupAdServiceAd](docs/AdGroupAdServiceAd.md)
 - [AdGroupAdServiceAdType](docs/AdGroupAdServiceAdType.md)
 - [AdGroupAdServiceAdditionalAdvancedMobileUrls](docs/AdGroupAdServiceAdditionalAdvancedMobileUrls.md)
 - [AdGroupAdServiceAdditionalAdvancedUrls](docs/AdGroupAdServiceAdditionalAdvancedUrls.md)
 - [AdGroupAdServiceAppAd](docs/AdGroupAdServiceAppAd.md)
 - [AdGroupAdServiceAppStore](docs/AdGroupAdServiceAppStore.md)
 - [AdGroupAdServiceApprovalStatus](docs/AdGroupAdServiceApprovalStatus.md)
 - [AdGroupAdServiceContainsLabelId](docs/AdGroupAdServiceContainsLabelId.md)
 - [AdGroupAdServiceCreatedDateRange](docs/AdGroupAdServiceCreatedDateRange.md)
 - [AdGroupAdServiceCustomParameter](docs/AdGroupAdServiceCustomParameter.md)
 - [AdGroupAdServiceCustomParameters](docs/AdGroupAdServiceCustomParameters.md)
 - [AdGroupAdServiceDescriptionPinnedField](docs/AdGroupAdServiceDescriptionPinnedField.md)
 - [AdGroupAdServiceDescriptionTextAsset](docs/AdGroupAdServiceDescriptionTextAsset.md)
 - [AdGroupAdServiceDevicePreference](docs/AdGroupAdServiceDevicePreference.md)
 - [AdGroupAdServiceDynamicSearchLinkedAd](docs/AdGroupAdServiceDynamicSearchLinkedAd.md)
 - [AdGroupAdServiceExtendedTextAd](docs/AdGroupAdServiceExtendedTextAd.md)
 - [AdGroupAdServiceGetResponse](docs/AdGroupAdServiceGetResponse.md)
 - [AdGroupAdServiceHeadlinePinnedField](docs/AdGroupAdServiceHeadlinePinnedField.md)
 - [AdGroupAdServiceHeadlineTextAsset](docs/AdGroupAdServiceHeadlineTextAsset.md)
 - [AdGroupAdServiceIsRemove](docs/AdGroupAdServiceIsRemove.md)
 - [AdGroupAdServiceLabel](docs/AdGroupAdServiceLabel.md)
 - [AdGroupAdServiceMutateResponse](docs/AdGroupAdServiceMutateResponse.md)
 - [AdGroupAdServiceOperation](docs/AdGroupAdServiceOperation.md)
 - [AdGroupAdServicePage](docs/AdGroupAdServicePage.md)
 - [AdGroupAdServiceResponsiveSearchAd](docs/AdGroupAdServiceResponsiveSearchAd.md)
 - [AdGroupAdServiceReturnValue](docs/AdGroupAdServiceReturnValue.md)
 - [AdGroupAdServiceSelector](docs/AdGroupAdServiceSelector.md)
 - [AdGroupAdServiceSetTrademarkStatus](docs/AdGroupAdServiceSetTrademarkStatus.md)
 - [AdGroupAdServiceSetTrademarkStatusOperation](docs/AdGroupAdServiceSetTrademarkStatusOperation.md)
 - [AdGroupAdServiceSetTrademarkStatusResponse](docs/AdGroupAdServiceSetTrademarkStatusResponse.md)
 - [AdGroupAdServiceTextAd2](docs/AdGroupAdServiceTextAd2.md)
 - [AdGroupAdServiceTextAssetApprovalStatus](docs/AdGroupAdServiceTextAssetApprovalStatus.md)
 - [AdGroupAdServiceTrademarkStatus](docs/AdGroupAdServiceTrademarkStatus.md)
 - [AdGroupAdServiceUserStatus](docs/AdGroupAdServiceUserStatus.md)
 - [AdGroupAdServiceValue](docs/AdGroupAdServiceValue.md)
 - [AdGroupBidMultiplier](docs/AdGroupBidMultiplier.md)
 - [AdGroupBidMultiplierServiceGetResponse](docs/AdGroupBidMultiplierServiceGetResponse.md)
 - [AdGroupBidMultiplierServiceMutateResponse](docs/AdGroupBidMultiplierServiceMutateResponse.md)
 - [AdGroupBidMultiplierServiceOperation](docs/AdGroupBidMultiplierServiceOperation.md)
 - [AdGroupBidMultiplierServicePage](docs/AdGroupBidMultiplierServicePage.md)
 - [AdGroupBidMultiplierServicePlatformType](docs/AdGroupBidMultiplierServicePlatformType.md)
 - [AdGroupBidMultiplierServiceReturnValue](docs/AdGroupBidMultiplierServiceReturnValue.md)
 - [AdGroupBidMultiplierServiceSelector](docs/AdGroupBidMultiplierServiceSelector.md)
 - [AdGroupBidMultiplierServiceValue](docs/AdGroupBidMultiplierServiceValue.md)
 - [AdGroupCriterion](docs/AdGroupCriterion.md)
 - [AdGroupCriterionLabel](docs/AdGroupCriterionLabel.md)
 - [AdGroupCriterionLabelServiceMutateResponse](docs/AdGroupCriterionLabelServiceMutateResponse.md)
 - [AdGroupCriterionLabelServiceOperation](docs/AdGroupCriterionLabelServiceOperation.md)
 - [AdGroupCriterionLabelServiceReturnValue](docs/AdGroupCriterionLabelServiceReturnValue.md)
 - [AdGroupCriterionLabelServiceValue](docs/AdGroupCriterionLabelServiceValue.md)
 - [AdGroupCriterionServiceAdditionalAdvancedMobileUrls](docs/AdGroupCriterionServiceAdditionalAdvancedMobileUrls.md)
 - [AdGroupCriterionServiceAdditionalAdvancedUrls](docs/AdGroupCriterionServiceAdditionalAdvancedUrls.md)
 - [AdGroupCriterionServiceAdditionalUrl](docs/AdGroupCriterionServiceAdditionalUrl.md)
 - [AdGroupCriterionServiceApprovalStatus](docs/AdGroupCriterionServiceApprovalStatus.md)
 - [AdGroupCriterionServiceBid](docs/AdGroupCriterionServiceBid.md)
 - [AdGroupCriterionServiceBidSource](docs/AdGroupCriterionServiceBidSource.md)
 - [AdGroupCriterionServiceBiddableAdGroupCriterion](docs/AdGroupCriterionServiceBiddableAdGroupCriterion.md)
 - [AdGroupCriterionServiceBiddingKeywordCpcRange](docs/AdGroupCriterionServiceBiddingKeywordCpcRange.md)
 - [AdGroupCriterionServiceContainsLabelId](docs/AdGroupCriterionServiceContainsLabelId.md)
 - [AdGroupCriterionServiceCriterion](docs/AdGroupCriterionServiceCriterion.md)
 - [AdGroupCriterionServiceCriterionType](docs/AdGroupCriterionServiceCriterionType.md)
 - [AdGroupCriterionServiceCustomParameter](docs/AdGroupCriterionServiceCustomParameter.md)
 - [AdGroupCriterionServiceCustomParameters](docs/AdGroupCriterionServiceCustomParameters.md)
 - [AdGroupCriterionServiceGetResponse](docs/AdGroupCriterionServiceGetResponse.md)
 - [AdGroupCriterionServiceIsRemove](docs/AdGroupCriterionServiceIsRemove.md)
 - [AdGroupCriterionServiceKeyword](docs/AdGroupCriterionServiceKeyword.md)
 - [AdGroupCriterionServiceKeywordMatchType](docs/AdGroupCriterionServiceKeywordMatchType.md)
 - [AdGroupCriterionServiceLabel](docs/AdGroupCriterionServiceLabel.md)
 - [AdGroupCriterionServiceMutateResponse](docs/AdGroupCriterionServiceMutateResponse.md)
 - [AdGroupCriterionServiceOperation](docs/AdGroupCriterionServiceOperation.md)
 - [AdGroupCriterionServicePage](docs/AdGroupCriterionServicePage.md)
 - [AdGroupCriterionServiceReturnValue](docs/AdGroupCriterionServiceReturnValue.md)
 - [AdGroupCriterionServiceSelector](docs/AdGroupCriterionServiceSelector.md)
 - [AdGroupCriterionServiceTrademarkStatus](docs/AdGroupCriterionServiceTrademarkStatus.md)
 - [AdGroupCriterionServiceUse](docs/AdGroupCriterionServiceUse.md)
 - [AdGroupCriterionServiceUserStatus](docs/AdGroupCriterionServiceUserStatus.md)
 - [AdGroupCriterionServiceValue](docs/AdGroupCriterionServiceValue.md)
 - [AdGroupFeed](docs/AdGroupFeed.md)
 - [AdGroupFeedServiceGetResponse](docs/AdGroupFeedServiceGetResponse.md)
 - [AdGroupFeedServiceList](docs/AdGroupFeedServiceList.md)
 - [AdGroupFeedServiceMutateResponse](docs/AdGroupFeedServiceMutateResponse.md)
 - [AdGroupFeedServiceOperation](docs/AdGroupFeedServiceOperation.md)
 - [AdGroupFeedServicePage](docs/AdGroupFeedServicePage.md)
 - [AdGroupFeedServicePlaceholderType](docs/AdGroupFeedServicePlaceholderType.md)
 - [AdGroupFeedServiceReturnValue](docs/AdGroupFeedServiceReturnValue.md)
 - [AdGroupFeedServiceSelector](docs/AdGroupFeedServiceSelector.md)
 - [AdGroupFeedServiceValue](docs/AdGroupFeedServiceValue.md)
 - [AdGroupLabel](docs/AdGroupLabel.md)
 - [AdGroupLabelServiceMutateResponse](docs/AdGroupLabelServiceMutateResponse.md)
 - [AdGroupLabelServiceOperation](docs/AdGroupLabelServiceOperation.md)
 - [AdGroupLabelServiceReturnValue](docs/AdGroupLabelServiceReturnValue.md)
 - [AdGroupLabelServiceValue](docs/AdGroupLabelServiceValue.md)
 - [AdGroupRetargetingList](docs/AdGroupRetargetingList.md)
 - [AdGroupRetargetingListServiceCriterionTargetList](docs/AdGroupRetargetingListServiceCriterionTargetList.md)
 - [AdGroupRetargetingListServiceExcludedType](docs/AdGroupRetargetingListServiceExcludedType.md)
 - [AdGroupRetargetingListServiceGetResponse](docs/AdGroupRetargetingListServiceGetResponse.md)
 - [AdGroupRetargetingListServiceMutateResponse](docs/AdGroupRetargetingListServiceMutateResponse.md)
 - [AdGroupRetargetingListServiceOperation](docs/AdGroupRetargetingListServiceOperation.md)
 - [AdGroupRetargetingListServicePage](docs/AdGroupRetargetingListServicePage.md)
 - [AdGroupRetargetingListServiceReturnValue](docs/AdGroupRetargetingListServiceReturnValue.md)
 - [AdGroupRetargetingListServiceSelector](docs/AdGroupRetargetingListServiceSelector.md)
 - [AdGroupRetargetingListServiceValue](docs/AdGroupRetargetingListServiceValue.md)
 - [AdGroupServiceAdGroupAdRotationMode](docs/AdGroupServiceAdGroupAdRotationMode.md)
 - [AdGroupServiceAdRotationMode](docs/AdGroupServiceAdRotationMode.md)
 - [AdGroupServiceBid](docs/AdGroupServiceBid.md)
 - [AdGroupServiceBidSource](docs/AdGroupServiceBidSource.md)
 - [AdGroupServiceBiddingKeywordCpcRange](docs/AdGroupServiceBiddingKeywordCpcRange.md)
 - [AdGroupServiceContainsLabelId](docs/AdGroupServiceContainsLabelId.md)
 - [AdGroupServiceCreatedDateRange](docs/AdGroupServiceCreatedDateRange.md)
 - [AdGroupServiceCriterionType](docs/AdGroupServiceCriterionType.md)
 - [AdGroupServiceCustomParameter](docs/AdGroupServiceCustomParameter.md)
 - [AdGroupServiceCustomParameters](docs/AdGroupServiceCustomParameters.md)
 - [AdGroupServiceGetResponse](docs/AdGroupServiceGetResponse.md)
 - [AdGroupServiceIsRemove](docs/AdGroupServiceIsRemove.md)
 - [AdGroupServiceLabel](docs/AdGroupServiceLabel.md)
 - [AdGroupServiceMutateResponse](docs/AdGroupServiceMutateResponse.md)
 - [AdGroupServiceOperation](docs/AdGroupServiceOperation.md)
 - [AdGroupServicePage](docs/AdGroupServicePage.md)
 - [AdGroupServiceReturnValue](docs/AdGroupServiceReturnValue.md)
 - [AdGroupServiceReviewUrl](docs/AdGroupServiceReviewUrl.md)
 - [AdGroupServiceSelector](docs/AdGroupServiceSelector.md)
 - [AdGroupServiceSettings](docs/AdGroupServiceSettings.md)
 - [AdGroupServiceTargetAll](docs/AdGroupServiceTargetAll.md)
 - [AdGroupServiceTargetingSetting](docs/AdGroupServiceTargetingSetting.md)
 - [AdGroupServiceUrlApprovalStatus](docs/AdGroupServiceUrlApprovalStatus.md)
 - [AdGroupServiceUrlReviewData](docs/AdGroupServiceUrlReviewData.md)
 - [AdGroupServiceUserStatus](docs/AdGroupServiceUserStatus.md)
 - [AdGroupServiceValue](docs/AdGroupServiceValue.md)
 - [AdGroupWebpage](docs/AdGroupWebpage.md)
 - [AdGroupWebpageServiceBid](docs/AdGroupWebpageServiceBid.md)
 - [AdGroupWebpageServiceBidSource](docs/AdGroupWebpageServiceBidSource.md)
 - [AdGroupWebpageServiceExcludedType](docs/AdGroupWebpageServiceExcludedType.md)
 - [AdGroupWebpageServiceGetResponse](docs/AdGroupWebpageServiceGetResponse.md)
 - [AdGroupWebpageServiceMutateResponse](docs/AdGroupWebpageServiceMutateResponse.md)
 - [AdGroupWebpageServiceOperation](docs/AdGroupWebpageServiceOperation.md)
 - [AdGroupWebpageServiceOperator](docs/AdGroupWebpageServiceOperator.md)
 - [AdGroupWebpageServicePage](docs/AdGroupWebpageServicePage.md)
 - [AdGroupWebpageServiceReturnValue](docs/AdGroupWebpageServiceReturnValue.md)
 - [AdGroupWebpageServiceSelector](docs/AdGroupWebpageServiceSelector.md)
 - [AdGroupWebpageServiceUserStatus](docs/AdGroupWebpageServiceUserStatus.md)
 - [AdGroupWebpageServiceValue](docs/AdGroupWebpageServiceValue.md)
 - [AdGroupWebpageServiceWebpage](docs/AdGroupWebpageServiceWebpage.md)
 - [AdGroupWebpageServiceWebpageCondition](docs/AdGroupWebpageServiceWebpageCondition.md)
 - [AdGroupWebpageServiceWebpageConditionType](docs/AdGroupWebpageServiceWebpageConditionType.md)
 - [AdGroupWebpageServiceWebpageParameter](docs/AdGroupWebpageServiceWebpageParameter.md)
 - [AppLink](docs/AppLink.md)
 - [AppLinkServiceAppLinkPlatform](docs/AppLinkServiceAppLinkPlatform.md)
 - [AppLinkServiceGetResponse](docs/AppLinkServiceGetResponse.md)
 - [AppLinkServiceLinkStatus](docs/AppLinkServiceLinkStatus.md)
 - [AppLinkServiceMutateResponse](docs/AppLinkServiceMutateResponse.md)
 - [AppLinkServiceOperation](docs/AppLinkServiceOperation.md)
 - [AppLinkServicePage](docs/AppLinkServicePage.md)
 - [AppLinkServiceReturnValue](docs/AppLinkServiceReturnValue.md)
 - [AppLinkServiceSelector](docs/AppLinkServiceSelector.md)
 - [AppLinkServiceSyncStatus](docs/AppLinkServiceSyncStatus.md)
 - [AppLinkServiceValue](docs/AppLinkServiceValue.md)
 - [AuditLogServiceAddJobResponse](docs/AuditLogServiceAddJobResponse.md)
 - [AuditLogServiceDateRange](docs/AuditLogServiceDateRange.md)
 - [AuditLogServiceDownloadSelector](docs/AuditLogServiceDownloadSelector.md)
 - [AuditLogServiceEncoding](docs/AuditLogServiceEncoding.md)
 - [AuditLogServiceEventSelector](docs/AuditLogServiceEventSelector.md)
 - [AuditLogServiceEventTypes](docs/AuditLogServiceEventTypes.md)
 - [AuditLogServiceGetResponse](docs/AuditLogServiceGetResponse.md)
 - [AuditLogServiceJob](docs/AuditLogServiceJob.md)
 - [AuditLogServiceJobStatus](docs/AuditLogServiceJobStatus.md)
 - [AuditLogServiceLang](docs/AuditLogServiceLang.md)
 - [AuditLogServiceOperation](docs/AuditLogServiceOperation.md)
 - [AuditLogServiceOutput](docs/AuditLogServiceOutput.md)
 - [AuditLogServicePage](docs/AuditLogServicePage.md)
 - [AuditLogServiceReturnValue](docs/AuditLogServiceReturnValue.md)
 - [AuditLogServiceSelector](docs/AuditLogServiceSelector.md)
 - [AuditLogServiceSourceType](docs/AuditLogServiceSourceType.md)
 - [AuditLogServiceValue](docs/AuditLogServiceValue.md)
 - [Balance](docs/Balance.md)
 - [BalanceServiceGetResponse](docs/BalanceServiceGetResponse.md)
 - [BalanceServicePage](docs/BalanceServicePage.md)
 - [BalanceServiceSelector](docs/BalanceServiceSelector.md)
 - [BalanceServiceValue](docs/BalanceServiceValue.md)
 - [BiddingStrategy](docs/BiddingStrategy.md)
 - [BiddingStrategyServiceBiddingScheme](docs/BiddingStrategyServiceBiddingScheme.md)
 - [BiddingStrategyServiceGetResponse](docs/BiddingStrategyServiceGetResponse.md)
 - [BiddingStrategyServiceMutateResponse](docs/BiddingStrategyServiceMutateResponse.md)
 - [BiddingStrategyServiceOperation](docs/BiddingStrategyServiceOperation.md)
 - [BiddingStrategyServicePage](docs/BiddingStrategyServicePage.md)
 - [BiddingStrategyServiceReturnValue](docs/BiddingStrategyServiceReturnValue.md)
 - [BiddingStrategyServiceSelector](docs/BiddingStrategyServiceSelector.md)
 - [BiddingStrategyServiceTargetCpaBiddingScheme](docs/BiddingStrategyServiceTargetCpaBiddingScheme.md)
 - [BiddingStrategyServiceTargetImpressionShareLocation](docs/BiddingStrategyServiceTargetImpressionShareLocation.md)
 - [BiddingStrategyServiceTargetImpressionShareScheme](docs/BiddingStrategyServiceTargetImpressionShareScheme.md)
 - [BiddingStrategyServiceTargetRoasBiddingScheme](docs/BiddingStrategyServiceTargetRoasBiddingScheme.md)
 - [BiddingStrategyServiceTargetSpendBiddingScheme](docs/BiddingStrategyServiceTargetSpendBiddingScheme.md)
 - [BiddingStrategyServiceType](docs/BiddingStrategyServiceType.md)
 - [BiddingStrategyServiceValue](docs/BiddingStrategyServiceValue.md)
 - [BudgetOrder](docs/BudgetOrder.md)
 - [BudgetOrderServiceAccountType](docs/BudgetOrderServiceAccountType.md)
 - [BudgetOrderServiceGetResponse](docs/BudgetOrderServiceGetResponse.md)
 - [BudgetOrderServiceLimitChargeType](docs/BudgetOrderServiceLimitChargeType.md)
 - [BudgetOrderServiceMutateResponse](docs/BudgetOrderServiceMutateResponse.md)
 - [BudgetOrderServiceOperation](docs/BudgetOrderServiceOperation.md)
 - [BudgetOrderServicePage](docs/BudgetOrderServicePage.md)
 - [BudgetOrderServiceReturnValue](docs/BudgetOrderServiceReturnValue.md)
 - [BudgetOrderServiceSelector](docs/BudgetOrderServiceSelector.md)
 - [BudgetOrderServiceValue](docs/BudgetOrderServiceValue.md)
 - [Campaign](docs/Campaign.md)
 - [CampaignCriterion](docs/CampaignCriterion.md)
 - [CampaignCriterionServiceCriterion](docs/CampaignCriterionServiceCriterion.md)
 - [CampaignCriterionServiceCriterionType](docs/CampaignCriterionServiceCriterionType.md)
 - [CampaignCriterionServiceGetResponse](docs/CampaignCriterionServiceGetResponse.md)
 - [CampaignCriterionServiceKeyword](docs/CampaignCriterionServiceKeyword.md)
 - [CampaignCriterionServiceKeywordMatchType](docs/CampaignCriterionServiceKeywordMatchType.md)
 - [CampaignCriterionServiceMutateResponse](docs/CampaignCriterionServiceMutateResponse.md)
 - [CampaignCriterionServiceOperation](docs/CampaignCriterionServiceOperation.md)
 - [CampaignCriterionServicePage](docs/CampaignCriterionServicePage.md)
 - [CampaignCriterionServiceReturnValue](docs/CampaignCriterionServiceReturnValue.md)
 - [CampaignCriterionServiceSelector](docs/CampaignCriterionServiceSelector.md)
 - [CampaignCriterionServiceUse](docs/CampaignCriterionServiceUse.md)
 - [CampaignCriterionServiceValue](docs/CampaignCriterionServiceValue.md)
 - [CampaignExportServiceAddJobResponse](docs/CampaignExportServiceAddJobResponse.md)
 - [CampaignExportServiceApprovalStatus](docs/CampaignExportServiceApprovalStatus.md)
 - [CampaignExportServiceDownloadSelector](docs/CampaignExportServiceDownloadSelector.md)
 - [CampaignExportServiceEncoding](docs/CampaignExportServiceEncoding.md)
 - [CampaignExportServiceEntityType](docs/CampaignExportServiceEntityType.md)
 - [CampaignExportServiceExportSetting](docs/CampaignExportServiceExportSetting.md)
 - [CampaignExportServiceFieldAttribute](docs/CampaignExportServiceFieldAttribute.md)
 - [CampaignExportServiceFieldValue](docs/CampaignExportServiceFieldValue.md)
 - [CampaignExportServiceGetExportFieldsResponse](docs/CampaignExportServiceGetExportFieldsResponse.md)
 - [CampaignExportServiceGetResponse](docs/CampaignExportServiceGetResponse.md)
 - [CampaignExportServiceJob](docs/CampaignExportServiceJob.md)
 - [CampaignExportServiceJobOperation](docs/CampaignExportServiceJobOperation.md)
 - [CampaignExportServiceJobStatus](docs/CampaignExportServiceJobStatus.md)
 - [CampaignExportServiceLang](docs/CampaignExportServiceLang.md)
 - [CampaignExportServiceOutput](docs/CampaignExportServiceOutput.md)
 - [CampaignExportServicePage](docs/CampaignExportServicePage.md)
 - [CampaignExportServiceReturnValue](docs/CampaignExportServiceReturnValue.md)
 - [CampaignExportServiceSelector](docs/CampaignExportServiceSelector.md)
 - [CampaignExportServiceUserStatus](docs/CampaignExportServiceUserStatus.md)
 - [CampaignExportServiceValue](docs/CampaignExportServiceValue.md)
 - [CampaignFeed](docs/CampaignFeed.md)
 - [CampaignFeedServiceGetResponse](docs/CampaignFeedServiceGetResponse.md)
 - [CampaignFeedServiceList](docs/CampaignFeedServiceList.md)
 - [CampaignFeedServiceMutateResponse](docs/CampaignFeedServiceMutateResponse.md)
 - [CampaignFeedServiceOperation](docs/CampaignFeedServiceOperation.md)
 - [CampaignFeedServicePage](docs/CampaignFeedServicePage.md)
 - [CampaignFeedServicePlaceholderType](docs/CampaignFeedServicePlaceholderType.md)
 - [CampaignFeedServiceReturnValue](docs/CampaignFeedServiceReturnValue.md)
 - [CampaignFeedServiceSelector](docs/CampaignFeedServiceSelector.md)
 - [CampaignFeedServiceValue](docs/CampaignFeedServiceValue.md)
 - [CampaignLabel](docs/CampaignLabel.md)
 - [CampaignLabelServiceMutateResponse](docs/CampaignLabelServiceMutateResponse.md)
 - [CampaignLabelServiceOperation](docs/CampaignLabelServiceOperation.md)
 - [CampaignLabelServiceReturnValue](docs/CampaignLabelServiceReturnValue.md)
 - [CampaignLabelServiceValue](docs/CampaignLabelServiceValue.md)
 - [CampaignRetargetingList](docs/CampaignRetargetingList.md)
 - [CampaignRetargetingListServiceCriterionTargetList](docs/CampaignRetargetingListServiceCriterionTargetList.md)
 - [CampaignRetargetingListServiceExcludedType](docs/CampaignRetargetingListServiceExcludedType.md)
 - [CampaignRetargetingListServiceGetResponse](docs/CampaignRetargetingListServiceGetResponse.md)
 - [CampaignRetargetingListServiceMutateResponse](docs/CampaignRetargetingListServiceMutateResponse.md)
 - [CampaignRetargetingListServiceOperation](docs/CampaignRetargetingListServiceOperation.md)
 - [CampaignRetargetingListServicePage](docs/CampaignRetargetingListServicePage.md)
 - [CampaignRetargetingListServiceReturnValue](docs/CampaignRetargetingListServiceReturnValue.md)
 - [CampaignRetargetingListServiceSelector](docs/CampaignRetargetingListServiceSelector.md)
 - [CampaignRetargetingListServiceValue](docs/CampaignRetargetingListServiceValue.md)
 - [CampaignServiceAppStore](docs/CampaignServiceAppStore.md)
 - [CampaignServiceBiddingScheme](docs/CampaignServiceBiddingScheme.md)
 - [CampaignServiceBiddingStrategy](docs/CampaignServiceBiddingStrategy.md)
 - [CampaignServiceBiddingStrategyFailedReason](docs/CampaignServiceBiddingStrategyFailedReason.md)
 - [CampaignServiceBiddingStrategySource](docs/CampaignServiceBiddingStrategySource.md)
 - [CampaignServiceBiddingStrategyType](docs/CampaignServiceBiddingStrategyType.md)
 - [CampaignServiceBudget](docs/CampaignServiceBudget.md)
 - [CampaignServiceBudgetAmountRange](docs/CampaignServiceBudgetAmountRange.md)
 - [CampaignServiceBudgetPeriod](docs/CampaignServiceBudgetPeriod.md)
 - [CampaignServiceContainsLabelId](docs/CampaignServiceContainsLabelId.md)
 - [CampaignServiceConversionOptimizerEligibility](docs/CampaignServiceConversionOptimizerEligibility.md)
 - [CampaignServiceCreatedDateRange](docs/CampaignServiceCreatedDateRange.md)
 - [CampaignServiceCustomParameter](docs/CampaignServiceCustomParameter.md)
 - [CampaignServiceCustomParameters](docs/CampaignServiceCustomParameters.md)
 - [CampaignServiceDasUseUrlsType](docs/CampaignServiceDasUseUrlsType.md)
 - [CampaignServiceDynamicAdsForSearchSetting](docs/CampaignServiceDynamicAdsForSearchSetting.md)
 - [CampaignServiceEnhancedCpcEnabled](docs/CampaignServiceEnhancedCpcEnabled.md)
 - [CampaignServiceGeoTargetType](docs/CampaignServiceGeoTargetType.md)
 - [CampaignServiceGeoTargetTypeSetting](docs/CampaignServiceGeoTargetTypeSetting.md)
 - [CampaignServiceGetResponse](docs/CampaignServiceGetResponse.md)
 - [CampaignServiceIsRemove](docs/CampaignServiceIsRemove.md)
 - [CampaignServiceLabel](docs/CampaignServiceLabel.md)
 - [CampaignServiceManualCpcBiddingScheme](docs/CampaignServiceManualCpcBiddingScheme.md)
 - [CampaignServiceMaximizeConversionValueBiddingScheme](docs/CampaignServiceMaximizeConversionValueBiddingScheme.md)
 - [CampaignServiceMaximizeConversionsBiddingScheme](docs/CampaignServiceMaximizeConversionsBiddingScheme.md)
 - [CampaignServiceMutateResponse](docs/CampaignServiceMutateResponse.md)
 - [CampaignServiceOperation](docs/CampaignServiceOperation.md)
 - [CampaignServicePage](docs/CampaignServicePage.md)
 - [CampaignServiceReturnValue](docs/CampaignServiceReturnValue.md)
 - [CampaignServiceReviewUrl](docs/CampaignServiceReviewUrl.md)
 - [CampaignServiceSelector](docs/CampaignServiceSelector.md)
 - [CampaignServiceServingStatus](docs/CampaignServiceServingStatus.md)
 - [CampaignServiceSettingType](docs/CampaignServiceSettingType.md)
 - [CampaignServiceSettings](docs/CampaignServiceSettings.md)
 - [CampaignServiceTargetAll](docs/CampaignServiceTargetAll.md)
 - [CampaignServiceTargetCpaBiddingScheme](docs/CampaignServiceTargetCpaBiddingScheme.md)
 - [CampaignServiceTargetImpressionShareLocation](docs/CampaignServiceTargetImpressionShareLocation.md)
 - [CampaignServiceTargetImpressionShareScheme](docs/CampaignServiceTargetImpressionShareScheme.md)
 - [CampaignServiceTargetRoasBiddingScheme](docs/CampaignServiceTargetRoasBiddingScheme.md)
 - [CampaignServiceTargetSpendBiddingScheme](docs/CampaignServiceTargetSpendBiddingScheme.md)
 - [CampaignServiceTargetingSetting](docs/CampaignServiceTargetingSetting.md)
 - [CampaignServiceType](docs/CampaignServiceType.md)
 - [CampaignServiceUrlApprovalStatus](docs/CampaignServiceUrlApprovalStatus.md)
 - [CampaignServiceUrlReviewData](docs/CampaignServiceUrlReviewData.md)
 - [CampaignServiceUserStatus](docs/CampaignServiceUserStatus.md)
 - [CampaignServiceValue](docs/CampaignServiceValue.md)
 - [CampaignSharedSet](docs/CampaignSharedSet.md)
 - [CampaignSharedSetServiceGetResponse](docs/CampaignSharedSetServiceGetResponse.md)
 - [CampaignSharedSetServiceMutateResponse](docs/CampaignSharedSetServiceMutateResponse.md)
 - [CampaignSharedSetServiceOperation](docs/CampaignSharedSetServiceOperation.md)
 - [CampaignSharedSetServicePage](docs/CampaignSharedSetServicePage.md)
 - [CampaignSharedSetServiceReturnValue](docs/CampaignSharedSetServiceReturnValue.md)
 - [CampaignSharedSetServiceSelector](docs/CampaignSharedSetServiceSelector.md)
 - [CampaignSharedSetServiceValue](docs/CampaignSharedSetServiceValue.md)
 - [CampaignTarget](docs/CampaignTarget.md)
 - [CampaignTargetServiceDayOfWeek](docs/CampaignTargetServiceDayOfWeek.md)
 - [CampaignTargetServiceExcludedType](docs/CampaignTargetServiceExcludedType.md)
 - [CampaignTargetServiceGetResponse](docs/CampaignTargetServiceGetResponse.md)
 - [CampaignTargetServiceLocationTarget](docs/CampaignTargetServiceLocationTarget.md)
 - [CampaignTargetServiceMinuteOfHour](docs/CampaignTargetServiceMinuteOfHour.md)
 - [CampaignTargetServiceMutateResponse](docs/CampaignTargetServiceMutateResponse.md)
 - [CampaignTargetServiceNetworkCoverageType](docs/CampaignTargetServiceNetworkCoverageType.md)
 - [CampaignTargetServiceNetworkTarget](docs/CampaignTargetServiceNetworkTarget.md)
 - [CampaignTargetServiceOperation](docs/CampaignTargetServiceOperation.md)
 - [CampaignTargetServicePage](docs/CampaignTargetServicePage.md)
 - [CampaignTargetServicePlatformTarget](docs/CampaignTargetServicePlatformTarget.md)
 - [CampaignTargetServicePlatformType](docs/CampaignTargetServicePlatformType.md)
 - [CampaignTargetServiceReturnValue](docs/CampaignTargetServiceReturnValue.md)
 - [CampaignTargetServiceScheduleTarget](docs/CampaignTargetServiceScheduleTarget.md)
 - [CampaignTargetServiceSelector](docs/CampaignTargetServiceSelector.md)
 - [CampaignTargetServiceTarget](docs/CampaignTargetServiceTarget.md)
 - [CampaignTargetServiceTargetType](docs/CampaignTargetServiceTargetType.md)
 - [CampaignTargetServiceTargetingStatus](docs/CampaignTargetServiceTargetingStatus.md)
 - [CampaignTargetServiceValue](docs/CampaignTargetServiceValue.md)
 - [CampaignWebpage](docs/CampaignWebpage.md)
 - [CampaignWebpageServiceGetResponse](docs/CampaignWebpageServiceGetResponse.md)
 - [CampaignWebpageServiceMutateResponse](docs/CampaignWebpageServiceMutateResponse.md)
 - [CampaignWebpageServiceOperation](docs/CampaignWebpageServiceOperation.md)
 - [CampaignWebpageServicePage](docs/CampaignWebpageServicePage.md)
 - [CampaignWebpageServiceReturnValue](docs/CampaignWebpageServiceReturnValue.md)
 - [CampaignWebpageServiceSelector](docs/CampaignWebpageServiceSelector.md)
 - [CampaignWebpageServiceValue](docs/CampaignWebpageServiceValue.md)
 - [CampaignWebpageServiceWebpage](docs/CampaignWebpageServiceWebpage.md)
 - [CampaignWebpageServiceWebpageCondition](docs/CampaignWebpageServiceWebpageCondition.md)
 - [CampaignWebpageServiceWebpageConditionType](docs/CampaignWebpageServiceWebpageConditionType.md)
 - [CampaignWebpageServiceWebpageOperator](docs/CampaignWebpageServiceWebpageOperator.md)
 - [CampaignWebpageServiceWebpageParameter](docs/CampaignWebpageServiceWebpageParameter.md)
 - [ConversionTracker](docs/ConversionTracker.md)
 - [ConversionTrackerServiceAppConversion](docs/ConversionTrackerServiceAppConversion.md)
 - [ConversionTrackerServiceAppConversionType](docs/ConversionTrackerServiceAppConversionType.md)
 - [ConversionTrackerServiceAppEvent](docs/ConversionTrackerServiceAppEvent.md)
 - [ConversionTrackerServiceAppEventTypePage](docs/ConversionTrackerServiceAppEventTypePage.md)
 - [ConversionTrackerServiceAppEventTypeSelector](docs/ConversionTrackerServiceAppEventTypeSelector.md)
 - [ConversionTrackerServiceAppEventTypeValue](docs/ConversionTrackerServiceAppEventTypeValue.md)
 - [ConversionTrackerServiceAppLinkConversion](docs/ConversionTrackerServiceAppLinkConversion.md)
 - [ConversionTrackerServiceAppLinkPlatform](docs/ConversionTrackerServiceAppLinkPlatform.md)
 - [ConversionTrackerServiceAppPlatform](docs/ConversionTrackerServiceAppPlatform.md)
 - [ConversionTrackerServiceAppPostbackUrl](docs/ConversionTrackerServiceAppPostbackUrl.md)
 - [ConversionTrackerServiceAppPostbackUrlClearFlag](docs/ConversionTrackerServiceAppPostbackUrlClearFlag.md)
 - [ConversionTrackerServiceCategory](docs/ConversionTrackerServiceCategory.md)
 - [ConversionTrackerServiceConversionCountingType](docs/ConversionTrackerServiceConversionCountingType.md)
 - [ConversionTrackerServiceConversionDateRange](docs/ConversionTrackerServiceConversionDateRange.md)
 - [ConversionTrackerServiceConversionTrackerType](docs/ConversionTrackerServiceConversionTrackerType.md)
 - [ConversionTrackerServiceExcludeFromBidding](docs/ConversionTrackerServiceExcludeFromBidding.md)
 - [ConversionTrackerServiceGetAppEventTypeResponse](docs/ConversionTrackerServiceGetAppEventTypeResponse.md)
 - [ConversionTrackerServiceGetResponse](docs/ConversionTrackerServiceGetResponse.md)
 - [ConversionTrackerServiceMarkupLanguage](docs/ConversionTrackerServiceMarkupLanguage.md)
 - [ConversionTrackerServiceMutateResponse](docs/ConversionTrackerServiceMutateResponse.md)
 - [ConversionTrackerServiceOperation](docs/ConversionTrackerServiceOperation.md)
 - [ConversionTrackerServicePage](docs/ConversionTrackerServicePage.md)
 - [ConversionTrackerServiceReturnValue](docs/ConversionTrackerServiceReturnValue.md)
 - [ConversionTrackerServiceSelector](docs/ConversionTrackerServiceSelector.md)
 - [ConversionTrackerServiceStatus](docs/ConversionTrackerServiceStatus.md)
 - [ConversionTrackerServiceTrackingCodeType](docs/ConversionTrackerServiceTrackingCodeType.md)
 - [ConversionTrackerServiceValue](docs/ConversionTrackerServiceValue.md)
 - [ConversionTrackerServiceWebConversion](docs/ConversionTrackerServiceWebConversion.md)
 - [DictionaryServiceAppLinkVendor](docs/DictionaryServiceAppLinkVendor.md)
 - [DictionaryServiceAppLinkVendorPage](docs/DictionaryServiceAppLinkVendorPage.md)
 - [DictionaryServiceAppLinkVendorSelector](docs/DictionaryServiceAppLinkVendorSelector.md)
 - [DictionaryServiceAppLinkVendorValue](docs/DictionaryServiceAppLinkVendorValue.md)
 - [DictionaryServiceDisapprovalReason](docs/DictionaryServiceDisapprovalReason.md)
 - [DictionaryServiceDisapprovalReasonPage](docs/DictionaryServiceDisapprovalReasonPage.md)
 - [DictionaryServiceDisapprovalReasonSelector](docs/DictionaryServiceDisapprovalReasonSelector.md)
 - [DictionaryServiceDisapprovalReasonValue](docs/DictionaryServiceDisapprovalReasonValue.md)
 - [DictionaryServiceGeographicLocation](docs/DictionaryServiceGeographicLocation.md)
 - [DictionaryServiceGeographicLocationPage](docs/DictionaryServiceGeographicLocationPage.md)
 - [DictionaryServiceGeographicLocationSelector](docs/DictionaryServiceGeographicLocationSelector.md)
 - [DictionaryServiceGeographicLocationStatus](docs/DictionaryServiceGeographicLocationStatus.md)
 - [DictionaryServiceGeographicLocationValue](docs/DictionaryServiceGeographicLocationValue.md)
 - [DictionaryServiceGetAppLinkVendorResponse](docs/DictionaryServiceGetAppLinkVendorResponse.md)
 - [DictionaryServiceGetDisapprovalReasonResponse](docs/DictionaryServiceGetDisapprovalReasonResponse.md)
 - [DictionaryServiceGetGeographicLocationResponse](docs/DictionaryServiceGetGeographicLocationResponse.md)
 - [DictionaryServiceLang](docs/DictionaryServiceLang.md)
 - [Error](docs/Error.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [Feed](docs/Feed.md)
 - [FeedItem](docs/FeedItem.md)
 - [FeedItemServiceApprovalStatus](docs/FeedItemServiceApprovalStatus.md)
 - [FeedItemServiceAttribute](docs/FeedItemServiceAttribute.md)
 - [FeedItemServiceCriterionTypeFeedItem](docs/FeedItemServiceCriterionTypeFeedItem.md)
 - [FeedItemServiceCustomParameter](docs/FeedItemServiceCustomParameter.md)
 - [FeedItemServiceCustomParameters](docs/FeedItemServiceCustomParameters.md)
 - [FeedItemServiceDayOfWeek](docs/FeedItemServiceDayOfWeek.md)
 - [FeedItemServiceDevicePreference](docs/FeedItemServiceDevicePreference.md)
 - [FeedItemServiceFeedAttributeValue](docs/FeedItemServiceFeedAttributeValue.md)
 - [FeedItemServiceGeoRestriction](docs/FeedItemServiceGeoRestriction.md)
 - [FeedItemServiceGetResponse](docs/FeedItemServiceGetResponse.md)
 - [FeedItemServiceIsRemove](docs/FeedItemServiceIsRemove.md)
 - [FeedItemServiceKeywordMatchType](docs/FeedItemServiceKeywordMatchType.md)
 - [FeedItemServiceLocation](docs/FeedItemServiceLocation.md)
 - [FeedItemServiceMinuteOfHour](docs/FeedItemServiceMinuteOfHour.md)
 - [FeedItemServiceMultipleFeedItemAttribute](docs/FeedItemServiceMultipleFeedItemAttribute.md)
 - [FeedItemServiceMutateResponse](docs/FeedItemServiceMutateResponse.md)
 - [FeedItemServiceOperation](docs/FeedItemServiceOperation.md)
 - [FeedItemServicePage](docs/FeedItemServicePage.md)
 - [FeedItemServicePlaceholderField](docs/FeedItemServicePlaceholderField.md)
 - [FeedItemServicePlaceholderType](docs/FeedItemServicePlaceholderType.md)
 - [FeedItemServiceReturnValue](docs/FeedItemServiceReturnValue.md)
 - [FeedItemServiceSchedule](docs/FeedItemServiceSchedule.md)
 - [FeedItemServiceScheduling](docs/FeedItemServiceScheduling.md)
 - [FeedItemServiceSelector](docs/FeedItemServiceSelector.md)
 - [FeedItemServiceSetTrademarkStatus](docs/FeedItemServiceSetTrademarkStatus.md)
 - [FeedItemServiceSetTrademarkStatusOperation](docs/FeedItemServiceSetTrademarkStatusOperation.md)
 - [FeedItemServiceSetTrademarkStatusResponse](docs/FeedItemServiceSetTrademarkStatusResponse.md)
 - [FeedItemServiceSimpleFeedItemAttribute](docs/FeedItemServiceSimpleFeedItemAttribute.md)
 - [FeedItemServiceTargetingAdGroup](docs/FeedItemServiceTargetingAdGroup.md)
 - [FeedItemServiceTargetingCampaign](docs/FeedItemServiceTargetingCampaign.md)
 - [FeedItemServiceTargetingKeyword](docs/FeedItemServiceTargetingKeyword.md)
 - [FeedItemServiceTrademarkStatus](docs/FeedItemServiceTrademarkStatus.md)
 - [FeedItemServiceValue](docs/FeedItemServiceValue.md)
 - [FeedServiceAttribute](docs/FeedServiceAttribute.md)
 - [FeedServiceGetResponse](docs/FeedServiceGetResponse.md)
 - [FeedServiceMutateResponse](docs/FeedServiceMutateResponse.md)
 - [FeedServiceOperation](docs/FeedServiceOperation.md)
 - [FeedServicePage](docs/FeedServicePage.md)
 - [FeedServicePlaceholderField](docs/FeedServicePlaceholderField.md)
 - [FeedServicePlaceholderType](docs/FeedServicePlaceholderType.md)
 - [FeedServiceReturnValue](docs/FeedServiceReturnValue.md)
 - [FeedServiceSelector](docs/FeedServiceSelector.md)
 - [FeedServiceValue](docs/FeedServiceValue.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [KeywordEstimatorServiceAdGroupEstimateRequest](docs/KeywordEstimatorServiceAdGroupEstimateRequest.md)
 - [KeywordEstimatorServiceCampaignEstimateRequest](docs/KeywordEstimatorServiceCampaignEstimateRequest.md)
 - [KeywordEstimatorServiceEstimateKeyword](docs/KeywordEstimatorServiceEstimateKeyword.md)
 - [KeywordEstimatorServiceEstimateResult](docs/KeywordEstimatorServiceEstimateResult.md)
 - [KeywordEstimatorServiceGetResponse](docs/KeywordEstimatorServiceGetResponse.md)
 - [KeywordEstimatorServiceIsNegativeBool](docs/KeywordEstimatorServiceIsNegativeBool.md)
 - [KeywordEstimatorServiceKeywordEstimateRequest](docs/KeywordEstimatorServiceKeywordEstimateRequest.md)
 - [KeywordEstimatorServiceKeywordMatchType](docs/KeywordEstimatorServiceKeywordMatchType.md)
 - [KeywordEstimatorServicePage](docs/KeywordEstimatorServicePage.md)
 - [KeywordEstimatorServiceResult](docs/KeywordEstimatorServiceResult.md)
 - [KeywordEstimatorServiceSelector](docs/KeywordEstimatorServiceSelector.md)
 - [KeywordEstimatorServiceValue](docs/KeywordEstimatorServiceValue.md)
 - [KeywordForecastMetrics](docs/KeywordForecastMetrics.md)
 - [KeywordForecastMetricsServiceDateInterval](docs/KeywordForecastMetricsServiceDateInterval.md)
 - [KeywordForecastMetricsServiceGetResponse](docs/KeywordForecastMetricsServiceGetResponse.md)
 - [KeywordForecastMetricsServiceKeywordPlanAdGroup](docs/KeywordForecastMetricsServiceKeywordPlanAdGroup.md)
 - [KeywordForecastMetricsServiceKeywordPlanAdGroupKeyword](docs/KeywordForecastMetricsServiceKeywordPlanAdGroupKeyword.md)
 - [KeywordForecastMetricsServiceKeywordPlanCampaign](docs/KeywordForecastMetricsServiceKeywordPlanCampaign.md)
 - [KeywordForecastMetricsServiceKeywordPlanNetwork](docs/KeywordForecastMetricsServiceKeywordPlanNetwork.md)
 - [KeywordForecastMetricsServiceMatchType](docs/KeywordForecastMetricsServiceMatchType.md)
 - [KeywordForecastMetricsServicePage](docs/KeywordForecastMetricsServicePage.md)
 - [KeywordForecastMetricsServiceSelector](docs/KeywordForecastMetricsServiceSelector.md)
 - [KeywordForecastMetricsServiceValue](docs/KeywordForecastMetricsServiceValue.md)
 - [KeywordPlanIdea](docs/KeywordPlanIdea.md)
 - [KeywordPlanIdeaServiceGetResponse](docs/KeywordPlanIdeaServiceGetResponse.md)
 - [KeywordPlanIdeaServiceKeywordAndUrlSeed](docs/KeywordPlanIdeaServiceKeywordAndUrlSeed.md)
 - [KeywordPlanIdeaServiceKeywordSeed](docs/KeywordPlanIdeaServiceKeywordSeed.md)
 - [KeywordPlanIdeaServicePage](docs/KeywordPlanIdeaServicePage.md)
 - [KeywordPlanIdeaServiceSeed](docs/KeywordPlanIdeaServiceSeed.md)
 - [KeywordPlanIdeaServiceSeedType](docs/KeywordPlanIdeaServiceSeedType.md)
 - [KeywordPlanIdeaServiceSelector](docs/KeywordPlanIdeaServiceSelector.md)
 - [KeywordPlanIdeaServiceSiteSeed](docs/KeywordPlanIdeaServiceSiteSeed.md)
 - [KeywordPlanIdeaServiceUrlSeed](docs/KeywordPlanIdeaServiceUrlSeed.md)
 - [KeywordPlanIdeaServiceValue](docs/KeywordPlanIdeaServiceValue.md)
 - [Label](docs/Label.md)
 - [LabelServiceCountLabeledEntity](docs/LabelServiceCountLabeledEntity.md)
 - [LabelServiceGetResponse](docs/LabelServiceGetResponse.md)
 - [LabelServiceMutateResponse](docs/LabelServiceMutateResponse.md)
 - [LabelServiceOperation](docs/LabelServiceOperation.md)
 - [LabelServicePage](docs/LabelServicePage.md)
 - [LabelServiceReturnValue](docs/LabelServiceReturnValue.md)
 - [LabelServiceSelector](docs/LabelServiceSelector.md)
 - [LabelServiceValue](docs/LabelServiceValue.md)
 - [OfflineConversionFile](docs/OfflineConversionFile.md)
 - [OfflineConversionServiceDownloadSelector](docs/OfflineConversionServiceDownloadSelector.md)
 - [OfflineConversionServiceGetResponse](docs/OfflineConversionServiceGetResponse.md)
 - [OfflineConversionServicePage](docs/OfflineConversionServicePage.md)
 - [OfflineConversionServiceProcessStatus](docs/OfflineConversionServiceProcessStatus.md)
 - [OfflineConversionServiceSelector](docs/OfflineConversionServiceSelector.md)
 - [OfflineConversionServiceSort](docs/OfflineConversionServiceSort.md)
 - [OfflineConversionServiceSortField](docs/OfflineConversionServiceSortField.md)
 - [OfflineConversionServiceSortType](docs/OfflineConversionServiceSortType.md)
 - [OfflineConversionServiceUploadResponse](docs/OfflineConversionServiceUploadResponse.md)
 - [OfflineConversionServiceUploadReturnValue](docs/OfflineConversionServiceUploadReturnValue.md)
 - [OfflineConversionServiceUploadSourceType](docs/OfflineConversionServiceUploadSourceType.md)
 - [OfflineConversionServiceUploadType](docs/OfflineConversionServiceUploadType.md)
 - [OfflineConversionServiceValue](docs/OfflineConversionServiceValue.md)
 - [PageFeedItem](docs/PageFeedItem.md)
 - [PageFeedItemServiceAddDownloadJobResponse](docs/PageFeedItemServiceAddDownloadJobResponse.md)
 - [PageFeedItemServiceApprovalStatus](docs/PageFeedItemServiceApprovalStatus.md)
 - [PageFeedItemServiceBulkEncoding](docs/PageFeedItemServiceBulkEncoding.md)
 - [PageFeedItemServiceBulkLang](docs/PageFeedItemServiceBulkLang.md)
 - [PageFeedItemServiceBulkOutput](docs/PageFeedItemServiceBulkOutput.md)
 - [PageFeedItemServiceDownloadJob](docs/PageFeedItemServiceDownloadJob.md)
 - [PageFeedItemServiceDownloadJobOperation](docs/PageFeedItemServiceDownloadJobOperation.md)
 - [PageFeedItemServiceDownloadJobReturnValue](docs/PageFeedItemServiceDownloadJobReturnValue.md)
 - [PageFeedItemServiceDownloadJobStatus](docs/PageFeedItemServiceDownloadJobStatus.md)
 - [PageFeedItemServiceDownloadJobValue](docs/PageFeedItemServiceDownloadJobValue.md)
 - [PageFeedItemServiceDownloadSelector](docs/PageFeedItemServiceDownloadSelector.md)
 - [PageFeedItemServiceGetJobStatusResponse](docs/PageFeedItemServiceGetJobStatusResponse.md)
 - [PageFeedItemServiceGetResponse](docs/PageFeedItemServiceGetResponse.md)
 - [PageFeedItemServiceGetReviewSummaryResponse](docs/PageFeedItemServiceGetReviewSummaryResponse.md)
 - [PageFeedItemServiceJobStatusPage](docs/PageFeedItemServiceJobStatusPage.md)
 - [PageFeedItemServiceJobStatusSelector](docs/PageFeedItemServiceJobStatusSelector.md)
 - [PageFeedItemServiceJobType](docs/PageFeedItemServiceJobType.md)
 - [PageFeedItemServiceJobValue](docs/PageFeedItemServiceJobValue.md)
 - [PageFeedItemServiceMatchType](docs/PageFeedItemServiceMatchType.md)
 - [PageFeedItemServicePage](docs/PageFeedItemServicePage.md)
 - [PageFeedItemServicePageFeedUrl](docs/PageFeedItemServicePageFeedUrl.md)
 - [PageFeedItemServiceReturnValue](docs/PageFeedItemServiceReturnValue.md)
 - [PageFeedItemServiceReviewSummary](docs/PageFeedItemServiceReviewSummary.md)
 - [PageFeedItemServiceReviewSummaryPage](docs/PageFeedItemServiceReviewSummaryPage.md)
 - [PageFeedItemServiceReviewSummarySelector](docs/PageFeedItemServiceReviewSummarySelector.md)
 - [PageFeedItemServiceReviewSummaryValue](docs/PageFeedItemServiceReviewSummaryValue.md)
 - [PageFeedItemServiceSelector](docs/PageFeedItemServiceSelector.md)
 - [PageFeedItemServiceUploadJob](docs/PageFeedItemServiceUploadJob.md)
 - [PageFeedItemServiceUploadJobStatus](docs/PageFeedItemServiceUploadJobStatus.md)
 - [PageFeedItemServiceUploadResponse](docs/PageFeedItemServiceUploadResponse.md)
 - [PageFeedItemServiceUploadReturnValue](docs/PageFeedItemServiceUploadReturnValue.md)
 - [PageFeedItemServiceUploadValue](docs/PageFeedItemServiceUploadValue.md)
 - [ReportDefinition](docs/ReportDefinition.md)
 - [ReportDefinitionServiceDownloadSelector](docs/ReportDefinitionServiceDownloadSelector.md)
 - [ReportDefinitionServiceFieldValue](docs/ReportDefinitionServiceFieldValue.md)
 - [ReportDefinitionServiceFilterOperator](docs/ReportDefinitionServiceFilterOperator.md)
 - [ReportDefinitionServiceGetReportFields](docs/ReportDefinitionServiceGetReportFields.md)
 - [ReportDefinitionServiceGetReportFieldsResponse](docs/ReportDefinitionServiceGetReportFieldsResponse.md)
 - [ReportDefinitionServiceGetResponse](docs/ReportDefinitionServiceGetResponse.md)
 - [ReportDefinitionServiceMutateResponse](docs/ReportDefinitionServiceMutateResponse.md)
 - [ReportDefinitionServiceOperation](docs/ReportDefinitionServiceOperation.md)
 - [ReportDefinitionServicePage](docs/ReportDefinitionServicePage.md)
 - [ReportDefinitionServiceReportCompressType](docs/ReportDefinitionServiceReportCompressType.md)
 - [ReportDefinitionServiceReportDateRange](docs/ReportDefinitionServiceReportDateRange.md)
 - [ReportDefinitionServiceReportDateRangeType](docs/ReportDefinitionServiceReportDateRangeType.md)
 - [ReportDefinitionServiceReportDecimalPartDisplayType](docs/ReportDefinitionServiceReportDecimalPartDisplayType.md)
 - [ReportDefinitionServiceReportDownloadEncode](docs/ReportDefinitionServiceReportDownloadEncode.md)
 - [ReportDefinitionServiceReportDownloadFormat](docs/ReportDefinitionServiceReportDownloadFormat.md)
 - [ReportDefinitionServiceReportFieldAttribute](docs/ReportDefinitionServiceReportFieldAttribute.md)
 - [ReportDefinitionServiceReportFilter](docs/ReportDefinitionServiceReportFilter.md)
 - [ReportDefinitionServiceReportIncludeDeleted](docs/ReportDefinitionServiceReportIncludeDeleted.md)
 - [ReportDefinitionServiceReportJobStatus](docs/ReportDefinitionServiceReportJobStatus.md)
 - [ReportDefinitionServiceReportLanguage](docs/ReportDefinitionServiceReportLanguage.md)
 - [ReportDefinitionServiceReportSkipColumnHeader](docs/ReportDefinitionServiceReportSkipColumnHeader.md)
 - [ReportDefinitionServiceReportSkipReportSummary](docs/ReportDefinitionServiceReportSkipReportSummary.md)
 - [ReportDefinitionServiceReportSortField](docs/ReportDefinitionServiceReportSortField.md)
 - [ReportDefinitionServiceReportSortType](docs/ReportDefinitionServiceReportSortType.md)
 - [ReportDefinitionServiceReportType](docs/ReportDefinitionServiceReportType.md)
 - [ReportDefinitionServiceReturnValue](docs/ReportDefinitionServiceReturnValue.md)
 - [ReportDefinitionServiceSelector](docs/ReportDefinitionServiceSelector.md)
 - [ReportDefinitionServiceValue](docs/ReportDefinitionServiceValue.md)
 - [RetargetingListServiceClosingReason](docs/RetargetingListServiceClosingReason.md)
 - [RetargetingListServiceCustomKey](docs/RetargetingListServiceCustomKey.md)
 - [RetargetingListServiceCustomKeyPage](docs/RetargetingListServiceCustomKeyPage.md)
 - [RetargetingListServiceCustomKeyRuleItem](docs/RetargetingListServiceCustomKeyRuleItem.md)
 - [RetargetingListServiceDefaultTargetList](docs/RetargetingListServiceDefaultTargetList.md)
 - [RetargetingListServiceGetCustomKeyResponse](docs/RetargetingListServiceGetCustomKeyResponse.md)
 - [RetargetingListServiceGetCustomKeySelector](docs/RetargetingListServiceGetCustomKeySelector.md)
 - [RetargetingListServiceGetResponse](docs/RetargetingListServiceGetResponse.md)
 - [RetargetingListServiceIsAllVisitorRule](docs/RetargetingListServiceIsAllVisitorRule.md)
 - [RetargetingListServiceIsDateSpecificRule](docs/RetargetingListServiceIsDateSpecificRule.md)
 - [RetargetingListServiceLogicalCondition](docs/RetargetingListServiceLogicalCondition.md)
 - [RetargetingListServiceLogicalGroup](docs/RetargetingListServiceLogicalGroup.md)
 - [RetargetingListServiceLogicalRuleOperand](docs/RetargetingListServiceLogicalRuleOperand.md)
 - [RetargetingListServiceLogicalTargetList](docs/RetargetingListServiceLogicalTargetList.md)
 - [RetargetingListServiceMutateResponse](docs/RetargetingListServiceMutateResponse.md)
 - [RetargetingListServiceOperation](docs/RetargetingListServiceOperation.md)
 - [RetargetingListServicePage](docs/RetargetingListServicePage.md)
 - [RetargetingListServiceReachStorageStatus](docs/RetargetingListServiceReachStorageStatus.md)
 - [RetargetingListServiceRetargetingAccountStatus](docs/RetargetingListServiceRetargetingAccountStatus.md)
 - [RetargetingListServiceReturnValue](docs/RetargetingListServiceReturnValue.md)
 - [RetargetingListServiceReviewStatus](docs/RetargetingListServiceReviewStatus.md)
 - [RetargetingListServiceRuleBaseTargetList](docs/RetargetingListServiceRuleBaseTargetList.md)
 - [RetargetingListServiceRuleGroup](docs/RetargetingListServiceRuleGroup.md)
 - [RetargetingListServiceRuleItem](docs/RetargetingListServiceRuleItem.md)
 - [RetargetingListServiceRuleOperator](docs/RetargetingListServiceRuleOperator.md)
 - [RetargetingListServiceRuleType](docs/RetargetingListServiceRuleType.md)
 - [RetargetingListServiceSelector](docs/RetargetingListServiceSelector.md)
 - [RetargetingListServiceTag](docs/RetargetingListServiceTag.md)
 - [RetargetingListServiceTargetListOwner](docs/RetargetingListServiceTargetListOwner.md)
 - [RetargetingListServiceTargetListType](docs/RetargetingListServiceTargetListType.md)
 - [RetargetingListServiceTargetingList](docs/RetargetingListServiceTargetingList.md)
 - [RetargetingListServiceUrlRuleItem](docs/RetargetingListServiceUrlRuleItem.md)
 - [RetargetingListServiceUrlRuleKey](docs/RetargetingListServiceUrlRuleKey.md)
 - [RetargetingListServiceValue](docs/RetargetingListServiceValue.md)
 - [SharedCriterion](docs/SharedCriterion.md)
 - [SharedCriterionServiceGetResponse](docs/SharedCriterionServiceGetResponse.md)
 - [SharedCriterionServiceKeywordMatchType](docs/SharedCriterionServiceKeywordMatchType.md)
 - [SharedCriterionServiceMutateResponse](docs/SharedCriterionServiceMutateResponse.md)
 - [SharedCriterionServiceOperation](docs/SharedCriterionServiceOperation.md)
 - [SharedCriterionServicePage](docs/SharedCriterionServicePage.md)
 - [SharedCriterionServiceReturnValue](docs/SharedCriterionServiceReturnValue.md)
 - [SharedCriterionServiceSelector](docs/SharedCriterionServiceSelector.md)
 - [SharedCriterionServiceUse](docs/SharedCriterionServiceUse.md)
 - [SharedCriterionServiceValue](docs/SharedCriterionServiceValue.md)


## Documentation For Authorization


## oAuth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://biz-oauth.yahoo.co.jp/oauth/v1/authorize
- **Scopes**: 
 - **yahooads**: アプリケーションを経由したYahoo!広告の各機能の操作/Operation by each function of Yahoo! JAPAN Ads via applications.


## Author




