# Generated by Django 4.0.5 on 2022-06-24 09:13

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('extras', '0073_journalentry_tags_custom_fields'),
        ('ipam', '0057_created_datetimefield'),
        ('tenancy', '0007_contact_link'),
        ('dcim', '0153_created_datetimefield'),
    ]

    operations = [
        migrations.CreateModel(
            name='VpnConnection',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('remote_organisation', models.CharField(max_length=100)),
                ('comments', models.TextField(blank=True)),
                ('change_id', models.CharField(blank=True, max_length=100, null=True)),
                ('ordered_by', models.CharField(blank=True, max_length=100, null=True)),
                ('status', models.CharField(default='active', max_length=50)),
                ('active_since', models.DateField(blank=True, null=True)),
                ('remote_gateway_ip', models.GenericIPAddressField(blank=True, null=True)),
                ('nat_traversal', models.CharField(default='disable', max_length=50)),
                ('dead_pear_detection', models.CharField(default='disable', max_length=50)),
                ('auth_method', models.CharField(default='pre-shared key', max_length=50)),
                ('pre_shared_key', models.CharField(blank=True, max_length=100, null=True)),
                ('ike_version', models.CharField(default='V2', max_length=50)),
                ('accept_types', models.CharField(default='any peer id', max_length=50)),
                ('accept_peer_id', models.CharField(blank=True, max_length=100, null=True)),
                ('encrytion', models.CharField(default='AES256', max_length=50)),
                ('authentication', models.CharField(default='AES256', max_length=50)),
                ('dh_group', models.CharField(blank=True, max_length=50, null=True)),
                ('key_lifetime', models.CharField(default='3600', max_length=100)),
                ('local_id', models.CharField(blank=True, max_length=100, null=True)),
                ('customer_contact', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='tenancy.contact')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='tenancy.tenant')),
                ('vpn_endpoint', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='dcim.device')),
            ],
            options={
                'ordering': ('remote_organisation',),
            },
        ),
        migrations.CreateModel(
            name='VpnConnectionPhase2',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('name', models.CharField(max_length=50)),
                ('remote_address', models.CharField(max_length=50)),
                ('encrytion', models.CharField(default='AES256', max_length=50)),
                ('authentication', models.CharField(default='AES256', max_length=50)),
                ('dh_group', models.CharField(blank=True, max_length=50, null=True)),
                ('key_lifetime', models.CharField(default='3600', max_length=100)),
                ('local_address', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='ipam.prefix')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('vpn_connection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='phase2', to='netbox_vpn_plugin.vpnconnection')),
            ],
            options={
                'ordering': ('vpn_connection', 'name'),
            },
        ),
    ]
