# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MosaicAddressRestrictionTransactionBodyDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'mosaic_id': 'str',
        'restriction_key': 'str',
        'previous_restriction_value': 'str',
        'new_restriction_value': 'str',
        'target_address': 'str'
    }

    attribute_map = {
        'mosaic_id': 'mosaicId',
        'restriction_key': 'restrictionKey',
        'previous_restriction_value': 'previousRestrictionValue',
        'new_restriction_value': 'newRestrictionValue',
        'target_address': 'targetAddress'
    }

    def __init__(self, mosaic_id=None, restriction_key=None, previous_restriction_value=None, new_restriction_value=None, target_address=None, local_vars_configuration=None):  # noqa: E501
        """MosaicAddressRestrictionTransactionBodyDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._mosaic_id = None
        self._restriction_key = None
        self._previous_restriction_value = None
        self._new_restriction_value = None
        self._target_address = None
        self.discriminator = None

        self.mosaic_id = mosaic_id
        self.restriction_key = restriction_key
        self.previous_restriction_value = previous_restriction_value
        self.new_restriction_value = new_restriction_value
        self.target_address = target_address

    @property
    def mosaic_id(self):
        """Gets the mosaic_id of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501

        Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier.   # noqa: E501

        :return: The mosaic_id of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._mosaic_id

    @mosaic_id.setter
    def mosaic_id(self, mosaic_id):
        """Sets the mosaic_id of this MosaicAddressRestrictionTransactionBodyDTO.

        Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier.   # noqa: E501

        :param mosaic_id: The mosaic_id of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and mosaic_id is None:  # noqa: E501
            raise ValueError("Invalid value for `mosaic_id`, must not be `None`")  # noqa: E501

        self._mosaic_id = mosaic_id

    @property
    def restriction_key(self):
        """Gets the restriction_key of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501

        Restriction key.  # noqa: E501

        :return: The restriction_key of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._restriction_key

    @restriction_key.setter
    def restriction_key(self, restriction_key):
        """Sets the restriction_key of this MosaicAddressRestrictionTransactionBodyDTO.

        Restriction key.  # noqa: E501

        :param restriction_key: The restriction_key of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and restriction_key is None:  # noqa: E501
            raise ValueError("Invalid value for `restriction_key`, must not be `None`")  # noqa: E501

        self._restriction_key = restriction_key

    @property
    def previous_restriction_value(self):
        """Gets the previous_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501

        Restriction value.  # noqa: E501

        :return: The previous_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._previous_restriction_value

    @previous_restriction_value.setter
    def previous_restriction_value(self, previous_restriction_value):
        """Sets the previous_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.

        Restriction value.  # noqa: E501

        :param previous_restriction_value: The previous_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and previous_restriction_value is None:  # noqa: E501
            raise ValueError("Invalid value for `previous_restriction_value`, must not be `None`")  # noqa: E501

        self._previous_restriction_value = previous_restriction_value

    @property
    def new_restriction_value(self):
        """Gets the new_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501

        Restriction value.  # noqa: E501

        :return: The new_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._new_restriction_value

    @new_restriction_value.setter
    def new_restriction_value(self, new_restriction_value):
        """Sets the new_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.

        Restriction value.  # noqa: E501

        :param new_restriction_value: The new_restriction_value of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and new_restriction_value is None:  # noqa: E501
            raise ValueError("Invalid value for `new_restriction_value`, must not be `None`")  # noqa: E501

        self._new_restriction_value = new_restriction_value

    @property
    def target_address(self):
        """Gets the target_address of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501

        Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1.   # noqa: E501

        :return: The target_address of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._target_address

    @target_address.setter
    def target_address(self, target_address):
        """Sets the target_address of this MosaicAddressRestrictionTransactionBodyDTO.

        Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1.   # noqa: E501

        :param target_address: The target_address of this MosaicAddressRestrictionTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and target_address is None:  # noqa: E501
            raise ValueError("Invalid value for `target_address`, must not be `None`")  # noqa: E501

        self._target_address = target_address

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MosaicAddressRestrictionTransactionBodyDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MosaicAddressRestrictionTransactionBodyDTO):
            return True

        return self.to_dict() != other.to_dict()
