"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudscapeReactTsWebsiteProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const web_1 = require("projen/lib/web");
/**
 * Synthesizes a Cloudscape React Typescript Website Project.
 *
 * @pjid cloudscape-react-ts-website
 */
class CloudscapeReactTsWebsiteProject extends web_1.ReactTypeScriptProject {
    constructor(options) {
        super({
            ...options,
            defaultReleaseBranch: options.defaultReleaseBranch,
            name: options.name,
            sampleCode: false,
            readme: {
                contents: fs
                    .readFileSync(path.resolve(__dirname, "../README.md"))
                    .toString(),
            },
            gitignore: ["runtime-config.json"],
        });
        this.addDevDeps("@babel/plugin-proposal-private-property-in-object");
        this.addDeps("@cloudscape-design/global-styles", "@cloudscape-design/components", "@cloudscape-design/collection-hooks", "react-router-dom", "aws-amplify", "@aws-amplify/ui-react", "aws4fetch");
        this.testTask.reset();
        const lintTask = this.tasks.tryFind("eslint");
        lintTask && this.testTask.spawn(lintTask);
        this.testTask.exec("react-scripts test --watchAll=false --passWithNoTests");
        this.applicationName = options.applicationName ?? "Sample App";
        this.publicDir = options.publicDir ?? "public";
        const srcDir = path.resolve(__dirname, "../samples/src");
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                ...Object.fromEntries(this.buildSampleDirEntries(srcDir)),
                "config.json": JSON.stringify({
                    applicationName: this.applicationName,
                }, undefined, 2),
            },
        });
        const publicDir = path.resolve(__dirname, "../samples/public");
        new projen_1.SampleDir(this, this.publicDir, {
            sourceDir: publicDir,
            files: {
                // override index.html to pass through applicationName
                "index.html": fs
                    .readFileSync(`${publicDir}/index.html`)
                    .toString()
                    .replace("<title></title>", `<title>${this.applicationName}</title>`),
            },
        });
    }
    buildSampleDirEntries(dir, pathPrefixes = []) {
        return fs
            .readdirSync(dir, { withFileTypes: true })
            .filter((f) => f.name !== "config.json")
            .flatMap((f) => f.isDirectory()
            ? this.buildSampleDirEntries(`${dir}/${f.name}`, [
                ...pathPrefixes,
                f.name,
            ])
            : [
                [
                    `${path.join(...pathPrefixes, f.name)}`,
                    fs.readFileSync(`${dir}/${f.name}`).toString(),
                ],
            ]);
    }
}
exports.CloudscapeReactTsWebsiteProject = CloudscapeReactTsWebsiteProject;
_a = JSII_RTTI_SYMBOL_1;
CloudscapeReactTsWebsiteProject[_a] = { fqn: "@aws-prototyping-sdk/cloudscape-react-ts-website.CloudscapeReactTsWebsiteProject", version: "0.8.4" };
//# sourceMappingURL=data:application/json;base64,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