# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class DirectPayment(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'direct_payment_type': 'str',
        'direct_payment_amount': 'Currency'
    }

    attribute_map = {
        'direct_payment_type': 'DirectPaymentType',
        'direct_payment_amount': 'DirectPaymentAmount'
    }

    def __init__(self, direct_payment_type=None, direct_payment_amount=None):  # noqa: E501
        """DirectPayment - a model defined in Swagger"""  # noqa: E501
        self._direct_payment_type = None
        self._direct_payment_amount = None
        self.discriminator = None
        if direct_payment_type is not None:
            self.direct_payment_type = direct_payment_type
        if direct_payment_amount is not None:
            self.direct_payment_amount = direct_payment_amount

    @property
    def direct_payment_type(self):
        """Gets the direct_payment_type of this DirectPayment.  # noqa: E501

        The type of payment.  Possible values:  * StoredValueCardRevenue - The amount that is deducted from the seller's account because the seller received money through a stored value card.  * StoredValueCardRefund - The amount that Amazon returns to the seller if the order that is bought using a stored value card is refunded.  * PrivateLabelCreditCardRevenue - The amount that is deducted from the seller's account because the seller received money through a private label credit card offered by Amazon.  * PrivateLabelCreditCardRefund - The amount that Amazon returns to the seller if the order that is bought using a private label credit card offered by Amazon is refunded.  * CollectOnDeliveryRevenue - The COD amount that the seller collected directly from the buyer.  * CollectOnDeliveryRefund - The amount that Amazon refunds to the buyer if an order paid for by COD is refunded.  # noqa: E501

        :return: The direct_payment_type of this DirectPayment.  # noqa: E501
        :rtype: str
        """
        return self._direct_payment_type

    @direct_payment_type.setter
    def direct_payment_type(self, direct_payment_type):
        """Sets the direct_payment_type of this DirectPayment.

        The type of payment.  Possible values:  * StoredValueCardRevenue - The amount that is deducted from the seller's account because the seller received money through a stored value card.  * StoredValueCardRefund - The amount that Amazon returns to the seller if the order that is bought using a stored value card is refunded.  * PrivateLabelCreditCardRevenue - The amount that is deducted from the seller's account because the seller received money through a private label credit card offered by Amazon.  * PrivateLabelCreditCardRefund - The amount that Amazon returns to the seller if the order that is bought using a private label credit card offered by Amazon is refunded.  * CollectOnDeliveryRevenue - The COD amount that the seller collected directly from the buyer.  * CollectOnDeliveryRefund - The amount that Amazon refunds to the buyer if an order paid for by COD is refunded.  # noqa: E501

        :param direct_payment_type: The direct_payment_type of this DirectPayment.  # noqa: E501
        :type: str
        """

        self._direct_payment_type = direct_payment_type

    @property
    def direct_payment_amount(self):
        """Gets the direct_payment_amount of this DirectPayment.  # noqa: E501


        :return: The direct_payment_amount of this DirectPayment.  # noqa: E501
        :rtype: Currency
        """
        return self._direct_payment_amount

    @direct_payment_amount.setter
    def direct_payment_amount(self, direct_payment_amount):
        """Sets the direct_payment_amount of this DirectPayment.


        :param direct_payment_amount: The direct_payment_amount of this DirectPayment.  # noqa: E501
        :type: Currency
        """

        self._direct_payment_amount = direct_payment_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DirectPayment, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DirectPayment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
