# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['layeredimage']

package_data = \
{'': ['*']}

install_requires = \
['defusedxml>=0.6.0,<0.7.0',
 'metprint>=2020.5,<2021.0',
 'pillow>=7.1.1,<8.0.0',
 'pyora>=0.3.0,<0.4.0']

setup_kwargs = {
    'name': 'layeredimage',
    'version': '2020.1',
    'description': 'Use this module to read, and write to a number of layered image formats',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/[codacy-proj-id].svg?style=for-the-badge)](https://www.codacy.com/manual/FHPythonUtils/LayeredImage)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/layeredimage.svg?style=for-the-badge)](https://pypi.org/project/layeredimage/)\n[![PyPI Version](https://img.shields.io/pypi/v/layeredimage.svg?style=for-the-badge)](https://pypi.org/project/layeredimage/)\n\n<!-- omit in TOC -->\n# LayeredImage\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nUse this module to read, and write to a number of layered image formats\n\n- [Compatibility](#compatibility)\n\t- [Overview](#overview)\n\t\t- [Key](#key)\n\t- [Reading](#reading)\n\t\t- [Group](#group)\n\t\t- [Layer](#layer)\n\t- [Writing](#writing)\n\t\t- [Group](#group-1)\n\t\t- [Layer](#layer-1)\n- [Example Usage](#example-usage)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [How to update, build and publish](#how-to-update-build-and-publish)\n- [Download](#download-1)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\n## Compatibility\n\nBear in mind that the tables below may not be completely accurate. If that is\nthe case, please open an issue and I will fix the tables.\n\n### Overview\n\n#### Key\n- :heavy_check_mark: - Supported\n- :warning: - Things will look the same, but data is lost\n- :x: - This is not supported and will cause loss of data\n- N/A - The source format does not support this so treat this as a :heavy_check_mark:\n\n|Format|.ora|.pdn|.xcf|.psd|.tiff/ .tif|\n|------|----|----|----|----|-----|\n|Read  |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Layers|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Groups|:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A|\n|Write |:heavy_check_mark:|:x:  |:x:  |:x:  |:warning:|\n\n### Reading\n\n#### Group\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|\n|----------|----|----|----|----|-----|\n|Name      |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |\n|Dimensions|:warning:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |\n|Offsets   |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |\n|Opacity   |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |\n|Visibility|:heavy_check_mark:|N/A |:x:  |:heavy_check_mark:|N/A |\n\n#### Layer\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|\n|----------|----|----|----|----|-----|\n|Name      |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Dimensions|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Offsets   |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Opacity   |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|N/A |\n|Visibility|:heavy_check_mark:|:heavy_check_mark:|:x:  |:heavy_check_mark:|N/A |\n\n### Writing\n\n#### Group\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|\n|----------|----|----|----|----|-----|\n|Name      |:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n|Dimensions|:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n|Offsets   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n|Opacity   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n|Visibility|:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n\n```none\nLayers are extracted from groups and saved to TIFF\n```\n\n#### Layer\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|\n|----------|----|----|----|----|-----|\n|Name      |:heavy_check_mark:|:x:|:x:|:x:|:x:|\n|Dimensions|:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n|Offsets   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n|Opacity   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n|Visibility|:heavy_check_mark:|:x:|:x:|:x:|:warning:|\n\n```none\nLayers are rasterized before being written to TIFF\n```\n\n## Example Usage\n\nHere\'s some basic example usage below.\n\n```python\n"""Example module """\nfrom pathlib import Path\nTHISDIR = str(Path(__file__).resolve().parent)\nimport layeredimage.io\n\n# Do stuff\nora = layeredimage.io.openLayerImage(THISDIR + "/image.ora")\n\nimageDimensions = ora.dimensions\n# There are a load of handy functions for getting layers, and adding new\n# layers, but here we will act directly on the object\nlayer = ora.layersAndGroups[0] # For the sake of the e.g. this is a layer\n\n# Lets overwrite the layer with a transparent image (bit boring I know...)\nlayer.image = Image.new("RGBA", imageDimensions)\n\n# And let\'s save\nlayeredimage.io.saveLayerImage(THISDIR + "/image(modified).ora", ora)\n\n# Let\'s save a flattened version too\nora.getFlattenLayers().save(THISDIR + "/image(modified).png")\n\n# Doing stuff with a group\ngroup = ora.getLayerOrGroup(1) # For the sake of the e.g. this is a group\ngroup.layers[0].image.show() # Open the image of the first layer of the group\n\n# Deleting a layer/ group\nora.removeLayerOrGroup(2)\n```\n\nImages are PIL.Image (s) and so you can use the power of Pillow to apply\nfilters, and other modifications to the images.\n\nAnd for those who would rather not read the test file, here are the tests. Not\ngoing to get 100% coverage anytime soon but hopefully this will help a little.\n\n```python\n"""Test module """\n\nimport sys\nimport os\nfrom pathlib import Path\nTHISDIR = str(Path(__file__).resolve().parent)\nsys.path.insert(0, os.path.dirname(THISDIR))\nimport layeredimage.io\n\n# ORA\nora = layeredimage.io.openLayerImage(THISDIR + "/base24.ora")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(ora).ora", ora)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(ora).tiff", ora)\nora.getFlattenLayers().save(THISDIR + "/base24(ora).png")\n\n# PSD\npsd = layeredimage.io.openLayerImage(THISDIR + "/base24.psd")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(psd).ora", psd)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(psd).tiff", psd)\npsd.getFlattenLayers().save(THISDIR + "/base24(psd).png")\n\n# PDN\nif sys.version_info[0] >= 3 and sys.version_info[1] < 8:\n\tpdn = layeredimage.io.openLayerImage(THISDIR + "/base24.pdn")\n\tlayeredimage.io.saveLayerImage(THISDIR + "/base24(pdn).ora", pdn)\n\tlayeredimage.io.saveLayerImage(THISDIR + "/base24(pdn).tiff", pdn)\n\tpdn.getFlattenLayers().save(THISDIR + "/base24(pdn).png")\n\n# XCF\nxcf = layeredimage.io.openLayerImage(THISDIR + "/base24.xcf")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(xcf).ora", xcf)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(xcf).tiff", xcf)\nxcf.getFlattenLayers().save(THISDIR + "/base24(xcf).png")\n\n# TIFF\ntiff = layeredimage.io.openLayerImage(THISDIR + "/base24.tiff")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(tiff).ora", tiff)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(tiff).tiff", tiff)\ntiff.getFlattenLayers().save(THISDIR + "/base24(tiff).png")\n```\n\n## Install With PIP\n\n```python\npip install layeredimage\n```\n\nHead to https://pypi.org/project/layeredimage/ for more info\n\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## How to update, build and publish\n\n1. Ensure you have installed the following dependencies\n\tLinux\n\t```bash\n\twget dephell.org/install | python3.8\n\twget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python3.8\n\t```\n\tWindows\n\t```powershell\n\t(wget dephell.org/install -UseBasicParsing).Content | python\n\t(wget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py -UseBasicParsing).Content | python\n\t```\n2. Use poetry for the heavy lifting and dephell to generate requirements\n\t```bash\n\tpoetry update\n\tdephell deps convert\n\t```\n3. Build/ Publish\n\t```bash\n\tpoetry build\n\tpoetry publish\n\t```\n\tor\n\t```bash\n\tpoetry publish --build\n\t```\n\n\n## Download\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/LayeredImage\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nIn the interest of fostering an open and welcoming environment, we\nas contributors and maintainers pledge to make participation in our\nproject and our community a harassment-free experience for everyone.\nPlease see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md) for more information.\n\n### Contributing\nContributions are welcome, please see the [Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md) for more information.\n\n### Security\nThank you for improving the security of the project, please see the [Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md) for more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/LayeredImage',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
