"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BottleRocketImage = exports.BottlerocketEcsVariant = exports.EcsOptimizedAmi = exports.InstanceArchitecture = exports.AmiHardwareType = exports.AmazonLinuxGeneration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
/**
 * @stability stable
 */
var AmazonLinuxGeneration;
(function (AmazonLinuxGeneration) {
    AmazonLinuxGeneration[AmazonLinuxGeneration["AMAZON_LINUX"] = 0] = "AMAZON_LINUX";
    AmazonLinuxGeneration[AmazonLinuxGeneration["AMAZON_LINUX_2"] = 1] = "AMAZON_LINUX_2";
})(AmazonLinuxGeneration = exports.AmazonLinuxGeneration || (exports.AmazonLinuxGeneration = {}));
/**
 * @stability stable
 */
var AmiHardwareType;
(function (AmiHardwareType) {
    AmiHardwareType["STANDARD"] = "Standard";
    AmiHardwareType["GPU"] = "GPU";
    AmiHardwareType["ARM"] = "ARM64";
})(AmiHardwareType = exports.AmiHardwareType || (exports.AmiHardwareType = {}));
/**
 * Identifies an instance's CPU architecture.
 *
 * @stability stable
 */
var InstanceArchitecture;
(function (InstanceArchitecture) {
    InstanceArchitecture["ARM_64"] = "arm64";
    InstanceArchitecture["X86_64"] = "x86_64";
})(InstanceArchitecture = exports.InstanceArchitecture || (exports.InstanceArchitecture = {}));
/**
 * @stability stable
 */
class EcsOptimizedAmi {
    /**
     * @stability stable
     */
    constructor(scope, props) {
        var _c, _d;
        this.generation = (_c = props === null || props === void 0 ? void 0 : props.generation) !== null && _c !== void 0 ? _c : AmazonLinuxGeneration.AMAZON_LINUX_2,
            this.hwType = (_d = props === null || props === void 0 ? void 0 : props.hwtype) !== null && _d !== void 0 ? _d : AmiHardwareType.STANDARD,
            this.scope = scope;
        // set the SSM parameter name
        this.amiParameterName = '/aws/service/ecs/optimized-ami/'
            + (this.generation === AmazonLinuxGeneration.AMAZON_LINUX ? 'amazon-linux/' : '')
            + (this.generation === AmazonLinuxGeneration.AMAZON_LINUX_2 ? 'amazon-linux-2/' : '')
            + (this.hwType === AmiHardwareType.GPU ? 'gpu/' : '')
            + (this.hwType === AmiHardwareType.ARM ? 'arm64/' : '')
            + 'recommended/image_id';
    }
    /**
     * Return the correct image.
     *
     * @stability stable
     */
    get amiId() {
        return lookupImage(this.scope, 'EcsOptimizedAmiId', this.amiParameterName);
    }
}
exports.EcsOptimizedAmi = EcsOptimizedAmi;
_a = JSII_RTTI_SYMBOL_1;
EcsOptimizedAmi[_a] = { fqn: "@pahud/cdktf-aws-ecs.EcsOptimizedAmi", version: "0.1.73" };
/**
 * Amazon ECS variant
 */
var BottlerocketEcsVariant;
(function (BottlerocketEcsVariant) {
    BottlerocketEcsVariant["AWS_ECS_1"] = "aws-ecs-1";
})(BottlerocketEcsVariant = exports.BottlerocketEcsVariant || (exports.BottlerocketEcsVariant = {}));
/**
 * Construct an Bottlerocket image from the latest AMI published in SSM.
 *
 * @stability stable
 */
class BottleRocketImage {
    /**
     * Constructs a new instance of the BottleRocketImage class.
     *
     * @stability stable
     */
    constructor(scope, props = {}) {
        var _c, _d;
        this.scope = scope;
        this.variant = (_c = props.variant) !== null && _c !== void 0 ? _c : BottlerocketEcsVariant.AWS_ECS_1;
        this.architecture = (_d = props.architecture) !== null && _d !== void 0 ? _d : InstanceArchitecture.X86_64;
        // set the SSM parameter name
        this.amiParameterName = `/aws/service/bottlerocket/${this.variant}/${this.architecture}/latest/image_id`;
    }
    /**
     * Return the correct image.
     *
     * @stability stable
     */
    get amiId() {
        return lookupImage(this.scope, 'BottlerocketAmiId', this.amiParameterName);
    }
}
exports.BottleRocketImage = BottleRocketImage;
_b = JSII_RTTI_SYMBOL_1;
BottleRocketImage[_b] = { fqn: "@pahud/cdktf-aws-ecs.BottleRocketImage", version: "0.1.73" };
function lookupImage(scope, id, parameterName) {
    return _1.StringParameter.valueFromLookup(scope, id, parameterName);
}
//# sourceMappingURL=data:application/json;base64,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