# Generated by Django 2.2.8 on 2022-06-10 15:49

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('departments', '0010_auto_20220524_1515'),
    ]

    operations = [
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('name', models.CharField(max_length=32, unique=True, verbose_name='岗位名称')),
                ('desc', models.CharField(blank=True, max_length=255, null=True, verbose_name='岗位描述')),
                ('organization_id', models.IntegerField(verbose_name='组织id')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='是否删除，默认不删除')),
                ('is_edited', models.BooleanField(default=True, verbose_name='是否可以被删除，编辑')),
            ],
            options={
                'verbose_name': '岗位',
                'db_table': 'middle_position',
                'unique_together': {('name', 'organization_id')},
            },
        ),
        migrations.AddField(
            model_name='role',
            name='is_enabled',
            field=models.BooleanField(default=True, verbose_name='是否被启用，默认被启用'),
        ),
        migrations.AlterField(
            model_name='role',
            name='code',
            field=models.CharField(max_length=32, null=True, verbose_name='角色code'),
        ),
        migrations.AlterField(
            model_name='role',
            name='is_deleted',
            field=models.BooleanField(default=False, verbose_name='是否被删除，默认没有被删除'),
        ),
        migrations.AlterField(
            model_name='role',
            name='is_edited',
            field=models.BooleanField(default=True, verbose_name='是否可以被删除，编辑'),
        ),
        migrations.AlterUniqueTogether(
            name='role',
            unique_together={('name', 'organization_id')},
        ),
        migrations.AlterUniqueTogether(
            name='userrole',
            unique_together={('user_id', 'role')},
        ),
        migrations.CreateModel(
            name='UserPosition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('user_id', models.IntegerField(verbose_name='用户id')),
                ('position', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='departments.Position', verbose_name='岗位')),
            ],
            options={
                'verbose_name': '用户岗位关系表',
                'db_table': 'middle_user_position',
                'unique_together': {('user_id', 'position')},
            },
        ),
    ]
