# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository   # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class AliasVerificationResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'alias_id': 'str',
        'is_verified': 'bool',
        'message': 'str'
    }

    attribute_map = {
        'alias_id': 'aliasId',
        'is_verified': 'isVerified',
        'message': 'message'
    }

    def __init__(self, alias_id=None, is_verified=None, message=None, local_vars_configuration=None):  # noqa: E501
        """AliasVerificationResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._alias_id = None
        self._is_verified = None
        self._message = None
        self.discriminator = None

        self.alias_id = alias_id
        self.is_verified = is_verified
        if message is not None:
            self.message = message

    @property
    def alias_id(self):
        """Gets the alias_id of this AliasVerificationResult.  # noqa: E501


        :return: The alias_id of this AliasVerificationResult.  # noqa: E501
        :rtype: str
        """
        return self._alias_id

    @alias_id.setter
    def alias_id(self, alias_id):
        """Sets the alias_id of this AliasVerificationResult.


        :param alias_id: The alias_id of this AliasVerificationResult.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and alias_id is None:  # noqa: E501
            raise ValueError("Invalid value for `alias_id`, must not be `None`")  # noqa: E501

        self._alias_id = alias_id

    @property
    def is_verified(self):
        """Gets the is_verified of this AliasVerificationResult.  # noqa: E501


        :return: The is_verified of this AliasVerificationResult.  # noqa: E501
        :rtype: bool
        """
        return self._is_verified

    @is_verified.setter
    def is_verified(self, is_verified):
        """Sets the is_verified of this AliasVerificationResult.


        :param is_verified: The is_verified of this AliasVerificationResult.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_verified is None:  # noqa: E501
            raise ValueError("Invalid value for `is_verified`, must not be `None`")  # noqa: E501

        self._is_verified = is_verified

    @property
    def message(self):
        """Gets the message of this AliasVerificationResult.  # noqa: E501


        :return: The message of this AliasVerificationResult.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this AliasVerificationResult.


        :param message: The message of this AliasVerificationResult.  # noqa: E501
        :type: str
        """

        self._message = message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AliasVerificationResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AliasVerificationResult):
            return True

        return self.to_dict() != other.to_dict()
