# -*- coding: utf-8 -*-
#
# Vanilla documentation build configuration file, created by
# sphinx-quickstart on Tue Feb 24 16:28:50 2009.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# The contents of this file are pickled, so don't put values in the namespace
# that aren't pickleable (module imports are okay, they're removed automatically).
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os

# If your extensions are in another directory, add it here. If the directory
# is relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
#sys.path.append(os.path.abspath('.'))

sys.path.insert(0, os.path.abspath('../../Lib'))


# General configuration
# ---------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ['sphinx.ext.autodoc']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Vanilla'
copyright = u'2009, Tal Leming, Just van Rossum'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '0.1'
# The full version, including alpha/beta/rc tags.
release = '0.1'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = []

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# Options for HTML output
# -----------------------

# The style sheet to use for HTML and HTML Help pages. A file of that name
# must exist either in Sphinx' static/ path, or in one of the custom paths
# given in html_static_path.
# html_style = 'default.css'

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']

# html_theme = "nature"

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_use_modindex = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
#html_copy_source = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'Vanilladoc'


# Options for LaTeX output
# ------------------------

# The paper size ('letter' or 'a4').
#latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, document class [howto/manual]).
latex_documents = [
  ('index', 'Vanilla.tex', 'Vanilla Documentation', 'Tal Leming', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_use_modindex = True

# mock some modules for read the docs

class MetaMock(type):

    __slots__ = []

    def __getattr__(self, name):
        return self

    def _operation(self, name):
        return self

    __add__ = __radd__ = __iadd__ = _operation
    __sub__ = __rsub__ = __isub__ = _operation
    __mul__ = __rmul__ = __imul__ = _operation
    __div__ = __rdiv__ = __idiv__ = _operation
    __truediv__ = __rtruediv__ = __itruediv__ = _operation
    __and__ = __rand__ = __iand__ = _operation
    __or__ = __ror__ = __ior__ = _operation
    __mod__ = __rmod__ = __imod__ = _operation

class Mock(object, metaclass=MetaMock):

    def __init__(self, *args, **kwargs):
        pass

    def __call__(self, *args, **kwargs):
        return Mock()

    @classmethod
    def __getattr__(cls, name):
        if name in ('__file__', '__path__'):
            return '/dev/null'
        else:
            return Mock

    __all__ = [
            # ignore objc imports
            'selector',
            # ignore all import from Foundation
            'NSMaxXEdge', 'NSMaxYEdge', 'NSMinXEdge', 'NSMinYEdge', 'NSKeyValueObservingOptionNew', 'NSKeyValueObservingOptionOld', 'NSNotFound',
            # ignore all imports from AppKit
            'NSAEDescriptorTranslator', 'NSAKDeserializer', 'NSAKDeserializerStream', 'NSAKSerializer', 'NSAKSerializerStream', 'NSAMPMDesignation', 'NSASCIIStringEncoding', 'NSATSGlyphStorage', 'NSATSLineFragment', 'NSATSTypesetter', 'NSATSUStyleObject', 'NSAWTEventType', 'NSAbortModalException', 'NSAbortPrintingException', 'NSAboutURLProtocol', 'NSAboveBottom', 'NSAboveTop', 'NSAccessibilityAXUIElementWrapper', 'NSAccessibilityActionDescription', 'NSAccessibilityAllowedValuesAttribute', 'NSAccessibilityApplicationActivatedNotification', 'NSAccessibilityApplicationDeactivatedNotification', 'NSAccessibilityApplicationHiddenNotification', 'NSAccessibilityApplicationRole', 'NSAccessibilityApplicationShownNotification', 'NSAccessibilityAscendingSortDirectionValue', 'NSAccessibilityAttachmentTextAttribute', 'NSAccessibilityAttributedStringForRangeParameterizedAttribute', 'NSAccessibilityBackgroundColorTextAttribute', 'NSAccessibilityBoundsForRangeParameterizedAttribute', 'NSAccessibilityBrowserRole', 'NSAccessibilityBusyIndicatorRole', 'NSAccessibilityButtonRole', 'NSAccessibilityCancelAction', 'NSAccessibilityCancelButtonAttribute', 'NSAccessibilityCellForColumnAndRowParameterizedAttribute', 'NSAccessibilityCellRole', 'NSAccessibilityCenterTabStopMarkerTypeValue', 'NSAccessibilityCentimetersUnitValue', 'NSAccessibilityCheckBoxRole', 'NSAccessibilityChildrenAttribute', 'NSAccessibilityClearButtonAttribute', 'NSAccessibilityCloseButtonAttribute', 'NSAccessibilityCloseButtonSubrole', 'NSAccessibilityColorButtonMockUIElement', 'NSAccessibilityColorWellRole', 'NSAccessibilityColumnCountAttribute', 'NSAccessibilityColumnHeaderUIElementsAttribute', 'NSAccessibilityColumnIndexRangeAttribute', 'NSAccessibilityColumnRole', 'NSAccessibilityColumnTitlesAttribute', 'NSAccessibilityColumnsAttribute', 'NSAccessibilityComboBoxRole', 'NSAccessibilityConfirmAction', 'NSAccessibilityContentListSubrole', 'NSAccessibilityContentsAttribute', 'NSAccessibilityCreatedNotification', 'NSAccessibilityCriticalValueAttribute', 'NSAccessibilityDecimalTabStopMarkerTypeValue', 'NSAccessibilityDecrementAction', 'NSAccessibilityDecrementArrowSubrole', 'NSAccessibilityDecrementButtonAttribute', 'NSAccessibilityDecrementPageSubrole', 'NSAccessibilityDefaultButtonAttribute', 'NSAccessibilityDefinitionListSubrole', 'NSAccessibilityDeleteAction', 'NSAccessibilityDescendingSortDirectionValue', 'NSAccessibilityDescriptionAttribute', 'NSAccessibilityDialogSubrole', 'NSAccessibilityDisclosedByRowAttribute', 'NSAccessibilityDisclosedRowsAttribute', 'NSAccessibilityDisclosingAttribute', 'NSAccessibilityDisclosureLevelAttribute', 'NSAccessibilityDisclosureTriangleRole', 'NSAccessibilityDocumentAttribute', 'NSAccessibilityDrawerCreatedNotification', 'NSAccessibilityDrawerRole', 'NSAccessibilityEditedAttribute', 'NSAccessibilityEnabledAttribute', 'NSAccessibilityErrorCodeExceptionInfo', 'NSAccessibilityException', 'NSAccessibilityExpandedAttribute', 'NSAccessibilityFilenameAttribute', 'NSAccessibilityFirstLineIndentMarkerTypeValue', 'NSAccessibilityFloatingWindowSubrole', 'NSAccessibilityFocusedAttribute', 'NSAccessibilityFocusedUIElementAttribute', 'NSAccessibilityFocusedUIElementChangedNotification', 'NSAccessibilityFocusedWindowAttribute', 'NSAccessibilityFocusedWindowChangedNotification', 'NSAccessibilityFontFamilyKey', 'NSAccessibilityFontNameKey', 'NSAccessibilityFontSizeKey', 'NSAccessibilityFontTextAttribute', 'NSAccessibilityForegroundColorTextAttribute', 'NSAccessibilityFrontmostAttribute', 'NSAccessibilityGridRole', 'NSAccessibilityGroupRole', 'NSAccessibilityGrowAreaAttribute', 'NSAccessibilityGrowAreaRole', 'NSAccessibilityHandleRole', 'NSAccessibilityHandlesAttribute', 'NSAccessibilityHeadIndentMarkerTypeValue', 'NSAccessibilityHeaderAttribute', 'NSAccessibilityHelpAttribute', 'NSAccessibilityHelpTagCreatedNotification', 'NSAccessibilityHelpTagRole', 'NSAccessibilityHiddenAttribute', 'NSAccessibilityHorizontalOrientationValue', 'NSAccessibilityHorizontalScrollBarAttribute', 'NSAccessibilityHorizontalUnitDescriptionAttribute', 'NSAccessibilityHorizontalUnitsAttribute', 'NSAccessibilityImageMockUIElement', 'NSAccessibilityImageRole', 'NSAccessibilityInchesUnitValue', 'NSAccessibilityIncrementAction', 'NSAccessibilityIncrementArrowSubrole', 'NSAccessibilityIncrementButtonAttribute', 'NSAccessibilityIncrementPageSubrole', 'NSAccessibilityIncrementorRole', 'NSAccessibilityIndexAttribute', 'NSAccessibilityIndexedMockUIElement', 'NSAccessibilityInsertionPointLineNumberAttribute', 'NSAccessibilityLabelUIElementsAttribute', 'NSAccessibilityLabelValueAttribute', 'NSAccessibilityLayoutAreaRole', 'NSAccessibilityLayoutItemRole', 'NSAccessibilityLayoutPointForScreenPointParameterizedAttribute', 'NSAccessibilityLayoutSizeForScreenSizeParameterizedAttribute', 'NSAccessibilityLeftTabStopMarkerTypeValue', 'NSAccessibilityLevelIndicatorRole', 'NSAccessibilityLineForIndexParameterizedAttribute', 'NSAccessibilityLinkRole', 'NSAccessibilityLinkTextAttribute', 'NSAccessibilityLinkedUIElementsAttribute', 'NSAccessibilityListRole', 'NSAccessibilityMainAttribute', 'NSAccessibilityMainWindowAttribute', 'NSAccessibilityMainWindowChangedNotification', 'NSAccessibilityMarkerGroupUIElementAttribute', 'NSAccessibilityMarkerTypeAttribute', 'NSAccessibilityMarkerTypeDescriptionAttribute', 'NSAccessibilityMarkerUIElementsAttribute', 'NSAccessibilityMarkerValuesAttribute', 'NSAccessibilityMatteContentUIElementAttribute', 'NSAccessibilityMatteHoleAttribute', 'NSAccessibilityMatteRole', 'NSAccessibilityMaxValueAttribute', 'NSAccessibilityMenuBarAttribute', 'NSAccessibilityMenuBarRole', 'NSAccessibilityMenuButtonRole', 'NSAccessibilityMenuItemRole', 'NSAccessibilityMenuRole', 'NSAccessibilityMinValueAttribute', 'NSAccessibilityMinimizeButtonAttribute', 'NSAccessibilityMinimizeButtonSubrole', 'NSAccessibilityMinimizedAttribute', 'NSAccessibilityMisspelledTextAttribute', 'NSAccessibilityMockUIElement', 'NSAccessibilityModalAttribute', 'NSAccessibilityMovedNotification', 'NSAccessibilityNextContentsAttribute', 'NSAccessibilityNotifier', 'NSAccessibilityNumberOfCharactersAttribute', 'NSAccessibilityOrderedByRowAttribute', 'NSAccessibilityOrientationAttribute', 'NSAccessibilityOutlineRole', 'NSAccessibilityOutlineRowSubrole', 'NSAccessibilityOverflowButtonAttribute', 'NSAccessibilityParentAttribute', 'NSAccessibilityPathComponent', 'NSAccessibilityPicasUnitValue', 'NSAccessibilityPickAction', 'NSAccessibilityPlaceholderValueAttribute', 'NSAccessibilityPointsUnitValue', 'NSAccessibilityPopUpButtonRole', 'NSAccessibilityPositionAttribute', 'NSAccessibilityPostNotification', 'NSAccessibilityPressAction', 'NSAccessibilityPreviousContentsAttribute', 'NSAccessibilityProgressIndicatorRole', 'NSAccessibilityProxy', 'NSAccessibilityProxyAttribute', 'NSAccessibilityRTFForRangeParameterizedAttribute', 'NSAccessibilityRadioButtonRole', 'NSAccessibilityRadioGroupRole', 'NSAccessibilityRaiseAction', 'NSAccessibilityRaiseBadArgumentException', 'NSAccessibilityRangeForIndexParameterizedAttribute', 'NSAccessibilityRangeForLineParameterizedAttribute', 'NSAccessibilityRangeForPositionParameterizedAttribute', 'NSAccessibilityRatingIndicatorSubrole', 'NSAccessibilityRelevanceIndicatorRole', 'NSAccessibilityRemoteUIElement', 'NSAccessibilityReparentingCellProxy', 'NSAccessibilityReparentingProxy', 'NSAccessibilityResizedNotification', 'NSAccessibilityRightTabStopMarkerTypeValue', 'NSAccessibilityRoleAttribute', 'NSAccessibilityRoleDescription', 'NSAccessibilityRoleDescriptionAttribute', 'NSAccessibilityRoleDescriptionForUIElement', 'NSAccessibilityRowCollapsedNotification', 'NSAccessibilityRowCountAttribute', 'NSAccessibilityRowCountChangedNotification', 'NSAccessibilityRowExpandedNotification', 'NSAccessibilityRowHeaderUIElementsAttribute', 'NSAccessibilityRowIndexRangeAttribute', 'NSAccessibilityRowRole', 'NSAccessibilityRowsAttribute', 'NSAccessibilityRulerMarker', 'NSAccessibilityRulerMarkerRole', 'NSAccessibilityRulerRole', 'NSAccessibilityScreenPointForLayoutPointParameterizedAttribute', 'NSAccessibilityScreenSizeForLayoutSizeParameterizedAttribute', 'NSAccessibilityScrollAreaRole', 'NSAccessibilityScrollBarRole', 'NSAccessibilityScrollerPart', 'NSAccessibilitySearchButtonAttribute', 'NSAccessibilitySearchFieldSubrole', 'NSAccessibilitySearchMenuAttribute', 'NSAccessibilitySecureTextFieldSubrole', 'NSAccessibilitySegment', 'NSAccessibilitySelectedAttribute', 'NSAccessibilitySelectedCellsAttribute', 'NSAccessibilitySelectedCellsChangedNotification', 'NSAccessibilitySelectedChildrenAttribute', 'NSAccessibilitySelectedChildrenChangedNotification', 'NSAccessibilitySelectedChildrenMovedNotification', 'NSAccessibilitySelectedColumnsAttribute', 'NSAccessibilitySelectedColumnsChangedNotification', 'NSAccessibilitySelectedRowsAttribute', 'NSAccessibilitySelectedRowsChangedNotification', 'NSAccessibilitySelectedTextAttribute', 'NSAccessibilitySelectedTextChangedNotification', 'NSAccessibilitySelectedTextRangeAttribute', 'NSAccessibilitySelectedTextRangesAttribute', 'NSAccessibilityServesAsTitleForUIElementsAttribute', 'NSAccessibilityShadowTextAttribute', 'NSAccessibilitySharedCharacterRangeAttribute', 'NSAccessibilitySharedTextUIElementsAttribute', 'NSAccessibilitySheetCreatedNotification', 'NSAccessibilitySheetRole', 'NSAccessibilityShowMenuAction', 'NSAccessibilityShownMenuAttribute', 'NSAccessibilitySizeAttribute', 'NSAccessibilitySliderRole', 'NSAccessibilitySliderValueIndicator', 'NSAccessibilitySortButtonRole', 'NSAccessibilitySortButtonSubrole', 'NSAccessibilitySortDirectionAttribute', 'NSAccessibilitySplitGroupRole', 'NSAccessibilitySplitterRole', 'NSAccessibilitySplittersAttribute', 'NSAccessibilityStandardWindowSubrole', 'NSAccessibilityStaticTextRole', 'NSAccessibilityStepperArrowButton', 'NSAccessibilityStrikethroughColorTextAttribute', 'NSAccessibilityStrikethroughTextAttribute', 'NSAccessibilityStringForRangeParameterizedAttribute', 'NSAccessibilityStyleRangeForIndexParameterizedAttribute', 'NSAccessibilitySubroleAttribute', 'NSAccessibilitySuperscriptTextAttribute', 'NSAccessibilitySystemDialogSubrole', 'NSAccessibilitySystemFloatingWindowSubrole', 'NSAccessibilitySystemWideRole', 'NSAccessibilityTabGroupRole', 'NSAccessibilityTableHeaderCellProxy', 'NSAccessibilityTableRole', 'NSAccessibilityTableRowSubrole', 'NSAccessibilityTabsAttribute', 'NSAccessibilityTailIndentMarkerTypeValue', 'NSAccessibilityTextAreaRole', 'NSAccessibilityTextAttachmentSubrole', 'NSAccessibilityTextFieldRole', 'NSAccessibilityTextLink', 'NSAccessibilityTextLinkSubrole', 'NSAccessibilityTimelineSubrole', 'NSAccessibilityTitleAttribute', 'NSAccessibilityTitleChangedNotification', 'NSAccessibilityTitleUIElementAttribute', 'NSAccessibilityToolbarButtonAttribute', 'NSAccessibilityToolbarButtonSubrole', 'NSAccessibilityToolbarRole', 'NSAccessibilityTopLevelUIElementAttribute', 'NSAccessibilityUIElementDestroyedNotification', 'NSAccessibilityURLAttribute', 'NSAccessibilityUnderlineColorTextAttribute', 'NSAccessibilityUnderlineTextAttribute', 'NSAccessibilityUnignoredAncestor', 'NSAccessibilityUnignoredChildren', 'NSAccessibilityUnignoredChildrenForOnlyChild', 'NSAccessibilityUnignoredDescendant', 'NSAccessibilityUnitDescriptionAttribute', 'NSAccessibilityUnitsAttribute', 'NSAccessibilityUnitsChangedNotification', 'NSAccessibilityUnknownMarkerTypeValue', 'NSAccessibilityUnknownOrientationValue', 'NSAccessibilityUnknownRole', 'NSAccessibilityUnknownSortDirectionValue', 'NSAccessibilityUnknownSubrole', 'NSAccessibilityUnknownUnitValue', 'NSAccessibilityValueAttribute', 'NSAccessibilityValueChangedNotification', 'NSAccessibilityValueDescriptionAttribute', 'NSAccessibilityValueIndicatorRole', 'NSAccessibilityVerticalOrientationValue', 'NSAccessibilityVerticalScrollBarAttribute', 'NSAccessibilityVerticalUnitDescriptionAttribute', 'NSAccessibilityVerticalUnitsAttribute', 'NSAccessibilityVisibleCellsAttribute', 'NSAccessibilityVisibleCharacterRangeAttribute', 'NSAccessibilityVisibleChildrenAttribute', 'NSAccessibilityVisibleColumnsAttribute', 'NSAccessibilityVisibleNameKey', 'NSAccessibilityVisibleRowsAttribute', 'NSAccessibilityWarningValueAttribute', 'NSAccessibilityWindowAttribute', 'NSAccessibilityWindowCreatedNotification', 'NSAccessibilityWindowDeminiaturizedNotification', 'NSAccessibilityWindowGrowBox', 'NSAccessibilityWindowMiniaturizedNotification', 'NSAccessibilityWindowMovedNotification', 'NSAccessibilityWindowResizedNotification', 'NSAccessibilityWindowRole', 'NSAccessibilityWindowsAttribute', 'NSAccessibilityZoomButtonAttribute', 'NSAccessibilityZoomButtonSubrole', 'NSAccessoryWindow', 'NSAccessoryWindowContentView', 'NSActionBinder', 'NSActionCell', 'NSAddTraitFontAction', 'NSAddressCheckingResult', 'NSAdminApplicationDirectory', 'NSAdobeCNS1CharacterCollection', 'NSAdobeGB1CharacterCollection', 'NSAdobeJapan1CharacterCollection', 'NSAdobeJapan2CharacterCollection', 'NSAdobeKorea1CharacterCollection', 'NSAffineTransform', 'NSAffineTransformStruct', 'NSAggregateExpression', 'NSAggregateExpressionType', 'NSAlert', 'NSAlertAlternateReturn', 'NSAlertDefaultReturn', 'NSAlertErrorReturn', 'NSAlertFirstButtonReturn', 'NSAlertOtherReturn', 'NSAlertSecondButtonReturn', 'NSAlertThirdButtonReturn', 'NSAlignmentBinding', 'NSAllApplicationsDirectory', 'NSAllDescendantPathsEnumerator', 'NSAllDomainsMask', 'NSAllHashTableObjects', 'NSAllLibrariesDirectory', 'NSAllMapTableKeys', 'NSAllMapTableValues', 'NSAllPredicateModifier', 'NSAllRomanInputSourcesLocaleIdentifier', 'NSAllScrollerParts', 'NSAllocateObject', 'NSAllowsEditingMultipleValuesSelectionBindingOption', 'NSAllowsNullArgumentBindingOption', 'NSAlphaFirstBitmapFormat', 'NSAlphaNonpremultipliedBitmapFormat', 'NSAlphaShiftKeyMask', 'NSAlternateImageBinding', 'NSAlternateKeyMask', 'NSAlternateTitleBinding', 'NSAlwaysPresentsApplicationModalAlertsBindingOption', 'NSAnchoredSearch', 'NSAndPredicateType', 'NSAnimateBinding', 'NSAnimation', 'NSAnimationBlocking', 'NSAnimationContext', 'NSAnimationDelayBinding', 'NSAnimationEaseIn', 'NSAnimationEaseInOut', 'NSAnimationEaseOut', 'NSAnimationEffectDisappearingItemDefault', 'NSAnimationEffectPoof', 'NSAnimationHelper', 'NSAnimationInfo', 'NSAnimationLinear', 'NSAnimationManager', 'NSAnimationNonblocking', 'NSAnimationNonblockingThreaded', 'NSAnimationProgressMark', 'NSAnimationProgressMarkNotification', 'NSAnimationTriggerOrderIn', 'NSAnimationTriggerOrderOut', 'NSAntialiasThresholdChangedNotification', 'NSAnyEventMask', 'NSAnyKeyExpression', 'NSAnyPredicateModifier', 'NSAnyType', 'NSApp', 'NSAppKitDefined', 'NSAppKitDefinedMask', 'NSAppKitIgnoredException', 'NSAppKitVersionNumber', 'NSAppKitVersionNumber10_0', 'NSAppKitVersionNumber10_1', 'NSAppKitVersionNumber10_2', 'NSAppKitVersionNumber10_2_3', 'NSAppKitVersionNumber10_3', 'NSAppKitVersionNumber10_3_2', 'NSAppKitVersionNumber10_3_3', 'NSAppKitVersionNumber10_3_5', 'NSAppKitVersionNumber10_3_7', 'NSAppKitVersionNumber10_3_9', 'NSAppKitVersionNumber10_4', 'NSAppKitVersionNumber10_4_1', 'NSAppKitVersionNumber10_4_3', 'NSAppKitVersionNumber10_4_4', 'NSAppKitVersionNumber10_4_7', 'NSAppKitVersionNumber10_5', 'NSAppKitVersionNumber10_5_2', 'NSAppKitVersionNumber10_5_3', 'NSAppKitVersionNumberWithColumnResizingBrowser', 'NSAppKitVersionNumberWithContinuousScrollingBrowser', 'NSAppKitVersionNumberWithCursorSizeSupport', 'NSAppKitVersionNumberWithCustomSheetPosition', 'NSAppKitVersionNumberWithDeferredWindowDisplaySupport', 'NSAppKitVersionNumberWithDirectionalTabs', 'NSAppKitVersionNumberWithDockTilePlugInSupport', 'NSAppKitVersionNumberWithPatternColorLeakFix', 'NSAppKitVirtualMemoryException', 'NSAppleEventDescriptor', 'NSAppleEventHandling', 'NSAppleEventManager', 'NSAppleEventManagerSuspensionID', 'NSAppleEventManagerWillProcessFirstEventNotification', 'NSAppleEventTimeOutDefault', 'NSAppleEventTimeOutNone', 'NSAppleScript', 'NSAppleScriptErrorAppName', 'NSAppleScriptErrorBriefMessage', 'NSAppleScriptErrorMessage', 'NSAppleScriptErrorNumber', 'NSAppleScriptErrorRange', 'NSApplication', 'NSApplicationActivateAllWindows', 'NSApplicationActivateIgnoringOtherApps', 'NSApplicationActivatedEventType', 'NSApplicationActivationPolicyAccessory', 'NSApplicationActivationPolicyProhibited', 'NSApplicationActivationPolicyRegular', 'NSApplicationBundlePresenter', 'NSApplicationDeactivatedEventType', 'NSApplicationDefined', 'NSApplicationDefinedMask', 'NSApplicationDelegateReplyCancel', 'NSApplicationDelegateReplyFailure', 'NSApplicationDelegateReplySuccess', 'NSApplicationDidBecomeActiveNotification', 'NSApplicationDidChangeScreenParametersNotification', 'NSApplicationDidFinishLaunchingNotification', 'NSApplicationDidHideNotification', 'NSApplicationDidResignActiveNotification', 'NSApplicationDidUnhideNotification', 'NSApplicationDidUpdateNotification', 'NSApplicationDirectory', 'NSApplicationFileType', 'NSApplicationLoad', 'NSApplicationMain', 'NSApplicationPresentationAutoHideDock', 'NSApplicationPresentationAutoHideMenuBar', 'NSApplicationPresentationDefault', 'NSApplicationPresentationDisableAppleMenu', 'NSApplicationPresentationDisableForceQuit', 'NSApplicationPresentationDisableHideApplication', 'NSApplicationPresentationDisableProcessSwitching', 'NSApplicationPresentationDisableSessionTermination', 'NSApplicationPresentationHideDock', 'NSApplicationPresentationHideMenuBar', 'NSApplicationSupportDirectory', 'NSApplicationWillBecomeActiveNotification', 'NSApplicationWillFinishLaunchingNotification', 'NSApplicationWillHideNotification', 'NSApplicationWillResignActiveNotification', 'NSApplicationWillTerminateNotification', 'NSApplicationWillUnhideNotification', 'NSApplicationWillUpdateNotification', 'NSAquaUserInterfaceTheme', 'NSArchiver', 'NSArgumentBinding', 'NSArgumentDomain', 'NSArgumentEvaluationScriptError', 'NSArgumentsWrongScriptError', 'NSArray', 'NSArrayController', 'NSArrayDetailBinder', 'NSAscendingPageOrder', 'NSAsciiWithDoubleByteEUCGlyphPacking', 'NSAssertionHandler', 'NSAssertionHandlerKey', 'NSAtBottom', 'NSAtTop', 'NSAtomicStore', 'NSAtomicStoreCacheNode', 'NSAtomicWrite', 'NSAttachmentAttributeName', 'NSAttachmentCharacter', 'NSAttachmentTextStorage', 'NSAttributeDescription', 'NSAttributeDictionary', 'NSAttributeDictionaryEnumerator', 'NSAttributeStoreMapping', 'NSAttributedString', 'NSAttributedStringBinding', 'NSAttributedStringEnumerationLongestEffectiveRangeNotRequired', 'NSAttributedStringEnumerationReverse', 'NSAuthorDocumentAttribute', 'NSAutoCalendar', 'NSAutoContentAccessingProxy', 'NSAutoLocale', 'NSAutoPagination', 'NSAutoreleasePool', 'NSAutoresizingMaskLayoutConstraint', 'NSAutosaveOperation', 'NSAutosavedInformationDirectory', 'NSAutounbinder', 'NSAutounbinderBinding', 'NSAutounbinderObservance', 'NSAvailableWindowDepths', 'NSAverageKeyValueOperator', 'NSBMPFileType', 'NSBackTabCharacter', 'NSBackgroundColorAttributeName', 'NSBackgroundColorDocumentAttribute', 'NSBackgroundColorView', 'NSBackgroundStyleDark', 'NSBackgroundStyleLight', 'NSBackgroundStyleLowered', 'NSBackgroundStyleRaised', 'NSBackgroundTab', 'NSBackingStoreBuffered', 'NSBackingStoreNonretained', 'NSBackingStoreRetained', 'NSBackspaceCharacter', 'NSBacktabTextMovement', 'NSBackwardsSearch', 'NSBadBitmapParametersException', 'NSBadComparisonException', 'NSBadRTFColorTableException', 'NSBadRTFDirectiveException', 'NSBadRTFFontTableException', 'NSBadRTFStyleSheetException', 'NSBaseURLDocumentOption', 'NSBaselineNotSet', 'NSBaselineOffsetAttributeName', 'NSBasicObjectID', 'NSBeep', 'NSBeginAlertSheet', 'NSBeginCriticalAlertSheet', 'NSBeginFunctionKey', 'NSBeginInformationalAlertSheet', 'NSBeginsWithComparison', 'NSBeginsWithPredicateOperatorType', 'NSBelowBottom', 'NSBelowTop', 'NSBestDepth', 'NSBetweenPredicateOperator', 'NSBetweenPredicateOperatorType', 'NSBevelLineJoinStyle', 'NSBezelBorder', 'NSBezierPath', 'NSBigMutableString', 'NSBinaryObjectStore', 'NSBinaryObjectStoreFile', 'NSBinarySearchingFirstEqual', 'NSBinarySearchingInsertionIndex', 'NSBinarySearchingLastEqual', 'NSBinder', 'NSBitmapGraphicsContext', 'NSBitmapImageRep', 'NSBitsPerPixelFromDepth', 'NSBitsPerSampleFromDepth', 'NSBlack', 'NSBlock', 'NSBlockExpression', 'NSBlockExpressionType', 'NSBlockOperation', 'NSBlockPredicate', 'NSBlueControlTint', 'NSBoldFontMask', 'NSBorderlessWindowMask', 'NSBottomMarginDocumentAttribute', 'NSBottomTabsBezelBorder', 'NSBox', 'NSBoxAuxiliary', 'NSBoxCustom', 'NSBoxOldStyle', 'NSBoxPrimary', 'NSBoxSecondary', 'NSBoxSeparator', 'NSBreakFunctionKey', 'NSBrowser', 'NSBrowserAutoColumnResizing', 'NSBrowserBinder', 'NSBrowserCell', 'NSBrowserColumnConfigurationDidChangeNotification', 'NSBrowserColumnViewController', 'NSBrowserDropAbove', 'NSBrowserDropOn', 'NSBrowserIllegalDelegateException', 'NSBrowserNoColumnResizing', 'NSBrowserTableView', 'NSBrowserUserColumnResizing', 'NSBuddhistCalendar', 'NSBuiltinCharacterSet', 'NSBundle', 'NSBundleDidLoadNotification', 'NSBundleExecutableArchitectureI386', 'NSBundleExecutableArchitecturePPC', 'NSBundleExecutableArchitecturePPC64', 'NSBundleExecutableArchitectureX86_64', 'NSButtLineCapStyle', 'NSButton', 'NSButtonCell', 'NSButtonImageSource', 'NSByteCountFormatter', 'NSCFArray', 'NSCFAttributedString', 'NSCFBoolean', 'NSCFCharacterSet', 'NSCFData', 'NSCFDictionary', 'NSCFError', 'NSCFInputStream', 'NSCFNumber', 'NSCFOutputStream', 'NSCFSet', 'NSCFTimer', 'NSCFType', 'NSCFURLProtocol', 'NSCGImageRep', 'NSCGImageSnapshotRep', 'NSCGSContext', 'NSCIDGlyphInfo', 'NSCIImageRep', 'NSCMYKColorSpaceModel', 'NSCMYKModeColorPanel', 'NSCMYKSliders', 'NSCTFont', 'NSCTFontCollection', 'NSCTFontDescriptor', 'NSCTGlyphInfo', 'NSCache', 'NSCachedColorSpaceColor', 'NSCachedDeviceRGBColor', 'NSCachedDeviceWhiteColor', 'NSCachedImageRep', 'NSCachedRGBColor', 'NSCachedTableCellView', 'NSCachedTableRowView', 'NSCachedURLResponse', 'NSCachedURLResponseInternal', 'NSCachedWhiteColor', 'NSCachesDirectory', 'NSCalculationDivideByZero', 'NSCalculationLossOfPrecision', 'NSCalculationNoError', 'NSCalculationOverflow', 'NSCalculationUnderflow', 'NSCalendar', 'NSCalendarDate', 'NSCalibratedBlackColorSpace', 'NSCalibratedRGBColor', 'NSCalibratedRGBColorSpace', 'NSCalibratedWhiteColor', 'NSCalibratedWhiteColorSpace', 'NSCallbackDictionary', 'NSCancelButton', 'NSCancelTextMovement', 'NSCandidateTextCell', 'NSCandidateTextField', 'NSCannotCreateScriptCommandError', 'NSCarbonMenuImpl', 'NSCarbonMenuWindow', 'NSCarbonWindow', 'NSCarbonWindowContentView', 'NSCarbonWindowFrame', 'NSCarriageReturnCharacter', 'NSCaseInsensitivePredicateOption', 'NSCaseInsensitiveSearch', 'NSCatalogColor', 'NSCategoryDocumentAttribute', 'NSCell', 'NSCellAllowsMixedState', 'NSCellAuxiliary', 'NSCellChangesContents', 'NSCellDisabled', 'NSCellEditable', 'NSCellHasImageHorizontal', 'NSCellHasImageOnLeftOrBottom', 'NSCellHasOverlappingImage', 'NSCellHighlighted', 'NSCellHitContentArea', 'NSCellHitEditableTextArea', 'NSCellHitNone', 'NSCellHitTrackableArea', 'NSCellIsBordered', 'NSCellIsInsetButton', 'NSCellLightsByBackground', 'NSCellLightsByContents', 'NSCellLightsByGray', 'NSCellState', 'NSCellUndoManager', 'NSCellView', 'NSCenterTabStopType', 'NSTextAlignmentCenter', 'NSChangeAutosaved', 'NSChangeBackgroundCell', 'NSChangeBackgroundCellMask', 'NSChangeCleared', 'NSChangeDone', 'NSChangeGrayCell', 'NSChangeGrayCellMask', 'NSChangeReadOtherContents', 'NSChangeRedone', 'NSChangeUndone', 'NSCharacterConversionException', 'NSCharacterEncodingDocumentAttribute', 'NSCharacterEncodingDocumentOption', 'NSCharacterSet', 'NSCharacterShapeAttributeName', 'NSCheapMutableString', 'NSChineseCalendar', 'NSCircularBezelStyle', 'NSCircularSlider', 'NSClassDescription', 'NSClassDescriptionNeededForClassNotification', 'NSClassFromString', 'NSClassSwapper', 'NSClassicHashTable', 'NSClassicMapTable', 'NSClearControlTint', 'NSClearDisplayFunctionKey', 'NSClearLineFunctionKey', 'NSClipPagination', 'NSClipView', 'NSClockAndCalendarDatePickerStyle', 'NSCloneCommand', 'NSClosableWindowMask', 'NSCloseCommand', 'NSClosePathBezierPathElement', 'NSCocoaErrorDomain', 'NSCocoaVersionDocumentAttribute', 'NSCoder', 'NSCoercionHandler', 'NSCollectionView', 'NSCollectionViewBinder', 'NSCollectionViewDropBefore', 'NSCollectionViewDropOn', 'NSCollectionViewItem', 'NSCollectorDisabledOption', 'NSColor', 'NSColorList', 'NSColorListAuxiliary', 'NSColorListDidChangeNotification', 'NSColorListIOException', 'NSColorListModeColorPanel', 'NSColorListNotEditableException', 'NSColorPanel', 'NSColorPanelAllModesMask', 'NSColorPanelCMYKModeMask', 'NSColorPanelColorDidChangeNotification', 'NSColorPanelColorListModeMask', 'NSColorPanelColorWell', 'NSColorPanelCrayonModeMask', 'NSColorPanelCustomPaletteModeMask', 'NSColorPanelGrayModeMask', 'NSColorPanelHSBModeMask', 'NSColorPanelRGBModeMask', 'NSColorPanelResizeDimple', 'NSColorPanelTextController', 'NSColorPanelWheelModeMask', 'NSColorPboardType', 'NSColorPicker', 'NSColorPickerColorSpacePopUp', 'NSColorPickerCrayon', 'NSColorPickerCrayonView', 'NSColorPickerMatrixView', 'NSColorPickerPageableNameList', 'NSColorPickerPageableNameListScrollView', 'NSColorPickerSliders', 'NSColorPickerUser', 'NSColorPickerUserView', 'NSColorPickerWheel', 'NSColorPickerWheelView', 'NSColorPopoverController', 'NSColorProfile', 'NSColorRenderingIntentAbsoluteColorimetric', 'NSColorRenderingIntentDefault', 'NSColorRenderingIntentPerceptual', 'NSColorRenderingIntentRelativeColorimetric', 'NSColorRenderingIntentSaturation', 'NSColorScaleSlider', 'NSColorScaleSliderCell', 'NSColorSpace', 'NSColorSpaceColor', 'NSColorSpaceFromDepth', 'NSColorSpaceSliders', 'NSColorSwatch', 'NSColorSwatchCell', 'NSColorWell', 'NSComboBox', 'NSComboBoxButtonCell', 'NSComboBoxCell', 'NSComboBoxSelectionDidChangeNotification', 'NSComboBoxSelectionIsChangingNotification', 'NSComboBoxTableColumn', 'NSComboBoxWillDismissNotification', 'NSComboBoxWillPopUpNotification', 'NSComboBoxWindow', 'NSComboTableView', 'NSCommandKeyMask', 'NSCommentDocumentAttribute', 'NSCompanyDocumentAttribute', 'NSCompareHashTables', 'NSCompareMapTables', 'NSComparisonPredicate', 'NSComparisonPredicateOperator', 'NSComplexOrthography', 'NSComplexRegularExpressionCheckingResult', 'NSCompositeClear', 'NSCompositeCopy', 'NSCompositeDestinationAtop', 'NSCompositeDestinationIn', 'NSCompositeDestinationOut', 'NSCompositeDestinationOver', 'NSCompositeHighlight', 'NSCompositeImageRep', 'NSCompositePlusDarker', 'NSCompositePlusLighter', 'NSCompositeSourceAtop', 'NSCompositeSourceIn', 'NSCompositeSourceOut', 'NSCompositeSourceOver', 'NSCompositeXOR', 'NSCompoundPredicate', 'NSCompoundPredicateOperator', 'NSCompressedFontMask', 'NSConcreteAttributedString', 'NSConcreteData', 'NSConcreteDistantObjectRequest', 'NSConcreteFileHandle', 'NSConcreteGlyphGenerator', 'NSConcreteHashTable', 'NSConcreteMapTable', 'NSConcreteMapTableValueEnumerator', 'NSConcreteMutableAttributedString', 'NSConcreteMutableData', 'NSConcreteNotification', 'NSConcreteNotifyingMutableAttributedString', 'NSConcretePipe', 'NSConcretePointerArray', 'NSConcretePointerFunctions', 'NSConcretePortCoder', 'NSConcretePrintOperation', 'NSConcreteProtocolChecker', 'NSConcreteScanner', 'NSConcreteTask', 'NSConcreteTextStorage', 'NSConcreteValue', 'NSCondensedFontMask', 'NSCondition', 'NSConditionLock', 'NSConditionallySetsEditableBindingOption', 'NSConditionallySetsEnabledBindingOption', 'NSConditionallySetsHiddenBindingOption', 'NSConnection', 'NSConnectionDidDieNotification', 'NSConnectionDidInitializeNotification', 'NSConnectionHelper', 'NSConnectionReplyMode', 'NSConstantString', 'NSConstantValueExpression', 'NSConstantValueExpressionType', 'NSContainerSpecifierError', 'NSContainsComparison', 'NSContainsPredicateOperatorType', 'NSContainsRect', 'NSContentArrayBinding', 'NSContentArrayForMultipleSelectionBinding', 'NSContentBinding', 'NSContentDictionaryBinding', 'NSContentHeightBinding', 'NSContentObjectBinding', 'NSContentObjectsBinding', 'NSContentPlacementTagBindingOption', 'NSContentSetBinding', 'NSContentSizeLayoutConstraint', 'NSContentValuesBinding', 'NSContentWidthBinding', 'NSContentsCellMask', 'NSContextHelpModeDidActivateNotification', 'NSContextHelpModeDidDeactivateNotification', 'NSContinuousCapacityLevelIndicatorStyle', 'NSContinuouslyUpdatesValueBindingOption', 'NSControl', 'NSControlGlyph', 'NSControlKeyMask', 'NSControlTextDidBeginEditingNotification', 'NSControlTextDidChangeNotification', 'NSControlTextDidEndEditingNotification', 'NSControlTintDidChangeNotification', 'NSController', 'NSControllerConfigurationBinder', 'NSConvertGlyphsToPackedGlyphs', 'NSConvertHostDoubleToSwapped', 'NSConvertHostFloatToSwapped', 'NSConvertSwappedDoubleToHost', 'NSConvertSwappedFloatToHost', 'NSConvertedDocumentAttribute', 'NSCopyBits', 'NSCopyHashTableWithZone', 'NSCopyMapTableWithZone', 'NSCopyObject', 'NSCopyrightDocumentAttribute', 'NSCoreDragManager', 'NSCoreServiceDirectory', 'NSCoreUIImageRep', 'NSCorrectionCheckingResult', 'NSCorrectionPanel', 'NSCorrectionShadowView', 'NSCorrectionSubPanel', 'NSCorrectionTextFieldContainer', 'NSCorrectionTextView', 'NSCorrectionTypedTextHighlightView', 'NSCountCommand', 'NSCountHashTable', 'NSCountKeyValueOperator', 'NSCountMapTable', 'NSCountWindows', 'NSCountWindowsForContext', 'NSCountedSet', 'NSCrayon', 'NSCrayonModeColorPanel', 'NSCrayonRow', 'NSCreateCommand', 'NSCreateCommandMoreIVars', 'NSCreateFileContentsPboardType', 'NSCreateFilenamePboardType', 'NSCreateHashTable', 'NSCreateHashTableWithZone', 'NSCreateMapTable', 'NSCreateMapTableWithZone', 'NSCreateZone', 'NSCreatesSortDescriptorBindingOption', 'NSCreationTimeDocumentAttribute', 'NSCriticalAlertStyle', 'NSCriticalRequest', 'NSCriticalValueBinding', 'NSCurrencySymbol', 'NSCurrentLocaleDidChangeNotification', 'NSCursor', 'NSCursorAttributeName', 'NSCursorPointingDevice', 'NSCursorUpdate', 'NSCursorUpdateMask', 'NSCurveToBezierPathElement', 'NSCustomColorSpace', 'NSCustomImageRep', 'NSCustomObject', 'NSCustomPaletteModeColorPanel', 'NSCustomPredicateOperator', 'NSCustomReleaseData', 'NSCustomResource', 'NSCustomSelectorPredicateOperatorType', 'NSCustomView', 'NSDOStreamData', 'NSDarkGray', 'NSDashCheckingResult', 'NSData', 'NSDataBinding', 'NSDataDetectionIndicatorMenu', 'NSDataDetectionIndicatorView', 'NSDataDetector', 'NSDataReadingMapped', 'NSDataReadingUncached', 'NSDataSearchAnchored', 'NSDataSearchBackwards', 'NSDataWritingAtomic', 'NSDate', 'NSDateCheckingResult', 'NSDateComponents', 'NSDateFormatString', 'NSDateFormatter', 'NSDateFormatterBehavior10_0', 'NSDateFormatterBehavior10_4', 'NSDateFormatterBehaviorDefault', 'NSDateFormatterFullStyle', 'NSDateFormatterLongStyle', 'NSDateFormatterMediumStyle', 'NSDateFormatterNoStyle', 'NSDateFormatterShortStyle', 'NSDatePicker', 'NSDatePickerCell', 'NSDateTimeOrdering', 'NSDayCalendarUnit', 'NSDeallocateObject', 'NSDebugString', 'NSDecimal', 'NSDecimalAdd', 'NSDecimalCompact', 'NSDecimalCompare', 'NSDecimalCopy', 'NSDecimalDigits', 'NSDecimalDivide', 'NSDecimalIsNotANumber', 'NSDecimalMaxSize', 'NSDecimalMultiply', 'NSDecimalNoScale', 'NSDecimalNormalize', 'NSDecimalNumber', 'NSDecimalNumberDivideByZeroException', 'NSDecimalNumberExactnessException', 'NSDecimalNumberHandler', 'NSDecimalNumberOverflowException', 'NSDecimalNumberPlaceholder', 'NSDecimalNumberUnderflowException', 'NSDecimalPower', 'NSDecimalRound', 'NSDecimalSeparator', 'NSDecimalString', 'NSDecimalSubtract', 'NSDecimalTabStopType', 'NSDecrementExtraRefCountWasZero', 'NSDefaultAttributesDocumentOption', 'NSDefaultControlTint', 'NSDefaultMallocZone', 'NSDefaultRunLoopMode', 'NSDefaultTabIntervalDocumentAttribute', 'NSDefaultTokenStyle', 'NSDefinitionPresentationTypeDictionaryApplication', 'NSDefinitionPresentationTypeKey', 'NSDefinitionPresentationTypeOverlay', 'NSDeleteCharFunctionKey', 'NSDeleteCharacter', 'NSDeleteCommand', 'NSDeleteFunctionKey', 'NSDeleteLineFunctionKey', 'NSDeletesObjectsOnRemoveBindingsOption', 'NSDemoApplicationDirectory', 'NSDescendingPageOrder', 'NSDeserializer', 'NSDesktopDirectory', 'NSDestinationInvalidException', 'NSDeveloperApplicationDirectory', 'NSDeveloperDirectory', 'NSDeviceBitsPerSample', 'NSDeviceBlackColorSpace', 'NSDeviceCMYKColor', 'NSDeviceCMYKColorSpace', 'NSDeviceColorSpaceName', 'NSDeviceIndependentModifierFlagsMask', 'NSDeviceIsPrinter', 'NSDeviceIsScreen', 'NSDeviceNColorSpaceModel', 'NSDeviceRGBColor', 'NSDeviceRGBColorSpace', 'NSDeviceResolution', 'NSDeviceSize', 'NSDeviceWhiteColor', 'NSDeviceWhiteColorSpace', 'NSDiacriticInsensitivePredicateOption', 'NSDiacriticInsensitiveSearch', 'NSDictionary', 'NSDictionaryController', 'NSDictionaryDetailBinder', 'NSDictionaryEntry', 'NSDictionaryMapNode', 'NSDictionaryStoreMap', 'NSDidBecomeSingleThreadedNotification', 'NSDirInfo', 'NSDirInfoDeserializer', 'NSDirInfoSerializer', 'NSDirectPredicateModifier', 'NSDirectSelection', 'NSDirectoryEnumerationSkipsHiddenFiles', 'NSDirectoryEnumerationSkipsPackageDescendants', 'NSDirectoryEnumerationSkipsSubdirectoryDescendants', 'NSDirectoryEnumerator', 'NSDirectoryFileType', 'NSDirectorySubpathsOperation', 'NSDirectoryTraversalOperation', 'NSDisableScreenUpdates', 'NSDisabledSuddenTermination', 'NSDisclosureBezelStyle', 'NSDisclosureButtonCell', 'NSDiscreteCapacityLevelIndicatorStyle', 'NSDisplayFontBinder', 'NSDisplayNameBindingOption', 'NSDisplayPatternBinder', 'NSDisplayPatternBindingOption', 'NSDisplayPatternTitleBinder', 'NSDisplayPatternTitleBinding', 'NSDisplayPatternValueBinding', 'NSDisplayWindowRunLoopOrdering', 'NSDistantObject', 'NSDistantObjectRequest', 'NSDistantObjectTableEntry', 'NSDistinctUnionOfArraysKeyValueOperator', 'NSDistinctUnionOfObjectsKeyValueOperator', 'NSDistinctUnionOfSetsKeyValueOperator', 'NSDistributedLock', 'NSDistributedNotificationCenter', 'NSDistributedObjectsStatistics', 'NSDivideRect', 'NSDocFormatReader', 'NSDocFormatTextDocumentType', 'NSDocFormatWriter', 'NSDocInfo', 'NSDocModalWindowMask', 'NSDockFrameView', 'NSDockMiniContentView', 'NSDockMiniViewController', 'NSDockMiniViewWindow', 'NSDockTile', 'NSDockWindowLevel', 'NSDocument', 'NSDocumentController', 'NSDocumentControllerMoreIVars', 'NSDocumentControllerOpenRecentMenuDelegate', 'NSDocumentControllerOpening', 'NSDocumentControllerPersistentRestoration', 'NSDocumentDeserializer', 'NSDocumentDirectory', 'NSDocumentDragButton', 'NSDocumentEditedBinding', 'NSDocumentErrorRecoveryAttempter', 'NSDocumentMoreIVars', 'NSDocumentRevisionsButtonCell', 'NSDocumentRevisionsButtonGroup', 'NSDocumentRevisionsButtonGroupCell', 'NSDocumentRevisionsController', 'NSDocumentRevisionsLabel', 'NSDocumentRevisionsPlaceholderDocument', 'NSDocumentRevisionsPlaceholderView', 'NSDocumentRevisionsProgressIndicator', 'NSDocumentRevisionsTimelineView', 'NSDocumentRevisionsTimelineWindow', 'NSDocumentRevisionsView', 'NSDocumentRevisionsWindow', 'NSDocumentRevisionsWindowTransformAnimation', 'NSDocumentRevisionsWindowTransformAnimationGroup', 'NSDocumentRevisionsWindowWatcher', 'NSDocumentSerializer', 'NSDocumentTextAttachmentScrollView', 'NSDocumentTypeDescription', 'NSDocumentTypeDocumentAttribute', 'NSDocumentTypeDocumentOption', 'NSDocumentationDirectory', 'NSDottedFrameRect', 'NSDoubleClickActionBinder', 'NSDoubleClickArgumentBinding', 'NSDoubleClickTargetBinding', 'NSDoubleType', 'NSDownArrowFunctionKey', 'NSDownTextMovement', 'NSDownloadController', 'NSDownloadsDirectory', 'NSDragDestination', 'NSDragOperationAll', 'NSDragOperationAll_Obsolete', 'NSDragOperationCopy', 'NSDragOperationDelete', 'NSDragOperationEvery', 'NSDragOperationGeneric', 'NSDragOperationLink', 'NSDragOperationMove', 'NSDragOperationNone', 'NSDragOperationPrivate', 'NSDragPboard', 'NSDraggingDestinationView', 'NSDraggingException', 'NSDraggingImageComponent', 'NSDraggingItem', 'NSDraggingSession', 'NSDrawBitmap', 'NSDrawButton', 'NSDrawColorTiledRects', 'NSDrawDarkBezel', 'NSDrawGrayBezel', 'NSDrawGroove', 'NSDrawLightBezel', 'NSDrawNinePartImage', 'NSDrawThreePartImage', 'NSDrawTiledRects', 'NSDrawWhiteBezel', 'NSDrawWindowBackground', 'NSDrawer', 'NSDrawerBinder', 'NSDrawerClosedState', 'NSDrawerClosingState', 'NSDrawerDidCloseNotification', 'NSDrawerDidOpenNotification', 'NSDrawerFrame', 'NSDrawerOpenState', 'NSDrawerOpeningState', 'NSDrawerWillCloseNotification', 'NSDrawerWillOpenNotification', 'NSDrawerWindow', 'NSDynamicSystemColor', 'NSEPSImageRep', 'NSEagerTrackingCell', 'NSEarlierTimeDesignations', 'NSEditableBinder', 'NSEditableBinding', 'NSEditorBinder', 'NSEditorDocumentAttribute', 'NSEnableScreenUpdates', 'NSEnabledBinding', 'NSEndFunctionKey', 'NSEndsWithComparison', 'NSEndsWithPredicateOperatorType', 'NSEnterCharacter', 'NSEntityDescription', 'NSEntityMapping', 'NSEntityMigrationPolicy', 'NSEntityStoreMapping', 'NSEnumerateHashTable', 'NSEnumerateMapTable', 'NSEnumerationConcurrent', 'NSEnumerationReverse', 'NSEnumerator', 'NSEqualPoints', 'NSEqualRanges', 'NSEqualRects', 'NSEqualSizes', 'NSEqualToComparison', 'NSEqualToPredicateOperatorType', 'NSEqualityPredicateOperator', 'NSEraCalendarUnit', 'NSEraDatePickerElementFlag', 'NSEraseRect', 'NSEraserPointingDevice', 'NSError', 'NSErrorFailingURLStringKey', 'NSEvaluatedObjectExpressionType', 'NSEvenOddWindingRule', 'NSEvent', 'NSEventAuxiliary', 'NSEventMaskBeginGesture', 'NSEventMaskEndGesture', 'NSEventMaskFromType', 'NSEventMaskGesture', 'NSEventMaskMagnify', 'NSEventMaskRotate', 'NSEventMaskSwipe', 'NSEventTrackingRunLoopMode', 'NSEventTypeBeginGesture', 'NSEventTypeEndGesture', 'NSEventTypeGesture', 'NSEventTypeMagnify', 'NSEventTypeRotate', 'NSEventTypeSwipe', 'NSEverySubelement', 'NSException', 'NSExceptionAlertController', 'NSExceptionHandlingRecursiveLock', 'NSExclude10_4ElementsIconCreationOption', 'NSExcludeQuickDrawElementsIconCreationOption', 'NSExcludedElementsDocumentAttribute', 'NSExcludedKeysBinding', 'NSExecutableArchitectureMismatchError', 'NSExecutableErrorMaximum', 'NSExecutableErrorMinimum', 'NSExecutableLinkError', 'NSExecutableLoadError', 'NSExecutableNotLoadableError', 'NSExecutableRuntimeMismatchError', 'NSExecuteFunctionKey', 'NSExistsCommand', 'NSExpandedFontMask', 'NSExpansionAttributeName', 'NSExpression', 'NSExpressionDescription', 'NSExtendedRegularExpressionCheckingResult', 'NSExternalRefCountedData', 'NSExtraLMData', 'NSExtraMICData', 'NSExtraMIData', 'NSExtraRefCount', 'NSF10FunctionKey', 'NSF11FunctionKey', 'NSF12FunctionKey', 'NSF13FunctionKey', 'NSF14FunctionKey', 'NSF15FunctionKey', 'NSF16FunctionKey', 'NSF17FunctionKey', 'NSF18FunctionKey', 'NSF19FunctionKey', 'NSF1FunctionKey', 'NSF20FunctionKey', 'NSF21FunctionKey', 'NSF22FunctionKey', 'NSF23FunctionKey', 'NSF24FunctionKey', 'NSF25FunctionKey', 'NSF26FunctionKey', 'NSF27FunctionKey', 'NSF28FunctionKey', 'NSF29FunctionKey', 'NSF2FunctionKey', 'NSF30FunctionKey', 'NSF31FunctionKey', 'NSF32FunctionKey', 'NSF33FunctionKey', 'NSF34FunctionKey', 'NSF35FunctionKey', 'NSF3FunctionKey', 'NSF4FunctionKey', 'NSF5FunctionKey', 'NSF6FunctionKey', 'NSF7FunctionKey', 'NSF8FunctionKey', 'NSF9FunctionKey', 'NSFPCurrentField', 'NSFPPreviewButton', 'NSFPPreviewField', 'NSFPRevertButton', 'NSFPSetButton', 'NSFPSizeField', 'NSFPSizeTitle', 'NSFTPPropertyActiveTransferModeKey', 'NSFTPPropertyFTPProxy', 'NSFTPPropertyFileOffsetKey', 'NSFTPPropertyUserLoginKey', 'NSFTPPropertyUserPasswordKey', 'NSFTPURLHandle', 'NSFailedAuthenticationException', 'NSFalsePredicate', 'NSFaultHandler', 'NSFetchRequest', 'NSFetchRequestExpression', 'NSFetchedPropertyDescription', 'NSFileAccessArbiter', 'NSFileAccessArbiterProxy', 'NSFileAccessClaim', 'NSFileAccessNode', 'NSFileAppendOnly', 'NSFileAttributes', 'NSFileBusy', 'NSFileContentsPboardType', 'NSFileCoordinator', 'NSFileCreationDate', 'NSFileDeviceIdentifier', 'NSFileDragSource', 'NSFileErrorMaximum', 'NSFileErrorMinimum', 'NSFileExtensionHidden', 'NSFileGroupOwnerAccountID', 'NSFileGroupOwnerAccountName', 'NSFileHFSCreatorCode', 'NSFileHFSTypeCode', 'NSFileHandle', 'NSFileHandleConnectionAcceptedNotification', 'NSFileHandleDataAvailableNotification', 'NSFileHandleNotificationDataItem', 'NSFileHandleNotificationFileHandleItem', 'NSFileHandleNotificationMonitorModes', 'NSFileHandleOperationException', 'NSFileHandleReadCompletionNotification', 'NSFileHandleReadToEndOfFileCompletionNotification', 'NSFileHandlingPanelCancelButton', 'NSFileHandlingPanelOKButton', 'NSFileImmutable', 'NSFileLocationComponent', 'NSFileLocator', 'NSFileLockingError', 'NSFileManager', 'NSFileManagerItemReplacementUsingNewMetadataOnly', 'NSFileManagerItemReplacementWithoutDeletingBackupItem', 'NSFileModificationDate', 'NSFileNoSuchFileError', 'NSFileOwnerAccountID', 'NSFileOwnerAccountName', 'NSFilePathErrorKey', 'NSFilePosixPermissions', 'NSFilePresenterProxy', 'NSFilePresenterRelinquishment', 'NSFilePromiseDragSource', 'NSFileProviderProxy', 'NSFileReactorProxy', 'NSFileReadCorruptFileError', 'NSFileReadInapplicableStringEncodingError', 'NSFileReadInvalidFileNameError', 'NSFileReadNoPermissionError', 'NSFileReadNoSuchFileError', 'NSFileReadTooLargeError', 'NSFileReadUnknownError', 'NSFileReadUnknownStringEncodingError', 'NSFileReadUnsupportedSchemeError', 'NSFileReadingClaim', 'NSFileReadingWritingClaim', 'NSFileReferenceCount', 'NSFileSecurity', 'NSFileSize', 'NSFileSpecifier', 'NSFileSubarbitrationClaim', 'NSFileSystemFileNumber', 'NSFileSystemFreeNodes', 'NSFileSystemFreeSize', 'NSFileSystemNodes', 'NSFileSystemNumber', 'NSFileSystemSize', 'NSFileType', 'NSFileTypeBlockSpecial', 'NSFileTypeCharacterSpecial', 'NSFileTypeDirectory', 'NSFileTypeDocumentAttribute', 'NSFileTypeDocumentOption', 'NSFileTypeForHFSTypeCode', 'NSFileTypeRegular', 'NSFileTypeSocket', 'NSFileTypeSymbolicLink', 'NSFileTypeUnknown', 'NSFileURLHandle', 'NSFileVersion', 'NSFileWatcher', 'NSFileWatcherObservations', 'NSFileWrapper', 'NSFileWrapperMoreIVars', 'NSFileWrapperReadingImmediate', 'NSFileWrapperReadingWithoutMapping', 'NSFileWrapperWritingAtomic', 'NSFileWrapperWritingWithNameUpdating', 'NSFileWriteInapplicableStringEncodingError', 'NSFileWriteInvalidFileNameError', 'NSFileWriteNoPermissionError', 'NSFileWriteOutOfSpaceError', 'NSFileWriteUnknownError', 'NSFileWriteUnsupportedSchemeError', 'NSFileWriteVolumeReadOnlyError', 'NSFileWritingClaim', 'NSFileWritingWritingClaim', 'NSFilenamesPboardType', 'NSFilesPromisePboardType', 'NSFilesystemFileType', 'NSFilesystemItemCopyOperation', 'NSFilesystemItemLinkOperation', 'NSFilesystemItemMoveOperation', 'NSFilesystemItemRemoveOperation', 'NSFilterPredicateBinding', 'NSFilterServicesPasteboard', 'NSFindFunctionKey', 'NSFindIndicator', 'NSFindPanel', 'NSFindPanelActionNext', 'NSFindPanelActionPrevious', 'NSFindPanelActionReplace', 'NSFindPanelActionReplaceAll', 'NSFindPanelActionReplaceAllInSelection', 'NSFindPanelActionReplaceAndFind', 'NSFindPanelActionSelectAll', 'NSFindPanelActionSelectAllInSelection', 'NSFindPanelActionSetFindString', 'NSFindPanelActionShowFindPanel', 'NSFindPanelCaseInsensitiveSearch', 'NSFindPanelSearchOptionsPboardType', 'NSFindPanelSubstringMatch', 'NSFindPanelSubstringMatchTypeContains', 'NSFindPanelSubstringMatchTypeEndsWith', 'NSFindPanelSubstringMatchTypeFullWord', 'NSFindPanelSubstringMatchTypeStartsWith', 'NSFindPattern', 'NSFindPatternAttachment', 'NSFindPatternAttachmentCell', 'NSFindPatternComboBox', 'NSFindPatternFieldEditor', 'NSFindPatternSearchField', 'NSFindPatternTextField', 'NSFindPboard', 'NSFitPagination', 'NSFixedPitchFontMask', 'NSFlagsChanged', 'NSFlagsChangedMask', 'NSFlippableView', 'NSFloatType', 'NSFloatingPointSamplesBitmapFormat', 'NSFloatingWindowLevel', 'NSFocusRingAbove', 'NSFocusRingBelow', 'NSFocusRingOnly', 'NSFocusRingTypeDefault', 'NSFocusRingTypeExterior', 'NSFocusRingTypeNone', 'NSFocusStack', 'NSFocusState', 'NSFont', 'NSFontAntialiasedIntegerAdvancementsRenderingMode', 'NSFontAntialiasedRenderingMode', 'NSFontAttributeName', 'NSFontBinding', 'NSFontBoldBinding', 'NSFontBoldTrait', 'NSFontCascadeListAttribute', 'NSFontCharacterSetAttribute', 'NSFontClarendonSerifsClass', 'NSFontCollection', 'NSFontCollectionApplicationOnlyMask', 'NSFontColorAttribute', 'NSFontCondensedTrait', 'NSFontDefaultRenderingMode', 'NSFontDescriptor', 'NSFontEffectsBox', 'NSFontExpandedTrait', 'NSFontFaceAttribute', 'NSFontFamilyAttribute', 'NSFontFamilyClassMask', 'NSFontFamilyNameBinding', 'NSFontFeatureSelectorIdentifierKey', 'NSFontFeatureSettingsAttribute', 'NSFontFeatureTypeIdentifierKey', 'NSFontFixedAdvanceAttribute', 'NSFontFreeformSerifsClass', 'NSFontIdentityMatrix', 'NSFontIntegerAdvancementsRenderingMode', 'NSFontItalicBinding', 'NSFontItalicTrait', 'NSFontManager', 'NSFontMatrixAttribute', 'NSFontModernSerifsClass', 'NSFontMonoSpaceTrait', 'NSFontNameAttribute', 'NSFontNameBinding', 'NSFontOldStyleSerifsClass', 'NSFontOptions', 'NSFontOptionsColorWell', 'NSFontOptionsPreviewBox', 'NSFontOrnamentalsClass', 'NSFontPanel', 'NSFontPanelAllEffectsModeMask', 'NSFontPanelAllModesMask', 'NSFontPanelCollectionModeMask', 'NSFontPanelDocumentColorEffectModeMask', 'NSFontPanelEffectsSliderCell', 'NSFontPanelFaceModeMask', 'NSFontPanelImagePopUpButtonCell', 'NSFontPanelShadowEffectModeMask', 'NSFontPanelSizeModeMask', 'NSFontPanelSplitView', 'NSFontPanelStandardModesMask', 'NSFontPanelStrikethroughEffectModeMask', 'NSFontPanelTableView', 'NSFontPanelTextColorEffectModeMask', 'NSFontPanelUnderlineEffectModeMask', 'NSFontPboard', 'NSFontPboardType', 'NSFontSansSerifClass', 'NSFontScriptsClass', 'NSFontSetChangedNotification', 'NSFontSizeAttribute', 'NSFontSizeBinding', 'NSFontSlabSerifsClass', 'NSFontSlantTrait', 'NSFontSymbolicClass', 'NSFontSymbolicTrait', 'NSFontTraitsAttribute', 'NSFontTransitionalSerifsClass', 'NSFontUIOptimizedTrait', 'NSFontUnavailableException', 'NSFontUnknownClass', 'NSFontVariationAttribute', 'NSFontVariationAxisDefaultValueKey', 'NSFontVariationAxisIdentifierKey', 'NSFontVariationAxisMaximumValueKey', 'NSFontVariationAxisMinimumValueKey', 'NSFontVariationAxisNameKey', 'NSFontVerticalTrait', 'NSFontVisibleNameAttribute', 'NSFontWeightTrait', 'NSFontWidthTrait', 'NSForcedOrderingSearch', 'NSForegroundColorAttributeName', 'NSForm', 'NSFormCell', 'NSFormFeedCharacter', 'NSFormatter', 'NSFormattingError', 'NSFormattingErrorMaximum', 'NSFormattingErrorMinimum', 'NSFoundationVersionNumber', 'NSFoundationVersionNumber10_0', 'NSFoundationVersionNumber10_1', 'NSFoundationVersionNumber10_1_1', 'NSFoundationVersionNumber10_1_2', 'NSFoundationVersionNumber10_1_3', 'NSFoundationVersionNumber10_1_4', 'NSFoundationVersionNumber10_2', 'NSFoundationVersionNumber10_2_1', 'NSFoundationVersionNumber10_2_2', 'NSFoundationVersionNumber10_2_3', 'NSFoundationVersionNumber10_2_4', 'NSFoundationVersionNumber10_2_5', 'NSFoundationVersionNumber10_2_6', 'NSFoundationVersionNumber10_2_7', 'NSFoundationVersionNumber10_2_8', 'NSFoundationVersionNumber10_3', 'NSFoundationVersionNumber10_3_1', 'NSFoundationVersionNumber10_3_2', 'NSFoundationVersionNumber10_3_3', 'NSFoundationVersionNumber10_3_4', 'NSFoundationVersionNumber10_3_5', 'NSFoundationVersionNumber10_3_6', 'NSFoundationVersionNumber10_3_7', 'NSFoundationVersionNumber10_3_8', 'NSFoundationVersionNumber10_3_9', 'NSFoundationVersionNumber10_4', 'NSFoundationVersionNumber10_4_1', 'NSFoundationVersionNumber10_4_10', 'NSFoundationVersionNumber10_4_11', 'NSFoundationVersionNumber10_4_2', 'NSFoundationVersionNumber10_4_3', 'NSFoundationVersionNumber10_4_4_Intel', 'NSFoundationVersionNumber10_4_4_PowerPC', 'NSFoundationVersionNumber10_4_5', 'NSFoundationVersionNumber10_4_6', 'NSFoundationVersionNumber10_4_7', 'NSFoundationVersionNumber10_4_8', 'NSFoundationVersionNumber10_4_9', 'NSFoundationVersionNumber10_5', 'NSFoundationVersionNumber10_5_1', 'NSFoundationVersionNumber10_5_2', 'NSFoundationVersionNumber10_5_3', 'NSFoundationVersionNumber10_5_4', 'NSFoundationVersionNumber10_5_5', 'NSFoundationVersionNumber10_5_6', 'NSFoundationVersionWithFileManagerResourceForkSupport', 'NSFourByteGlyphPacking', 'NSFrameRect', 'NSFrameRectWithWidth', 'NSFrameRectWithWidthUsingOperation', 'NSFrameView', 'NSFreeHashTable', 'NSFreeMapTable', 'NSFullScreenModeAllScreens', 'NSFullScreenModeSetting', 'NSFullScreenModeWindowLevel', 'NSFullUserName', 'NSFunctionExpression', 'NSFunctionExpressionType', 'NSFunctionKeyMask', 'NSGEOMETRY_TYPES_SAME_AS_CGGEOMETRY_TYPES', 'NSGIFFileType', 'NSGZipDecoder', 'NSGarbageCollector', 'NSGeneralPboard', 'NSGenericException', 'NSGetAlertPanel', 'NSGetCommand', 'NSGetCriticalAlertPanel', 'NSGetFileType', 'NSGetFileTypes', 'NSGetInformationalAlertPanel', 'NSGetSizeAndAlignment', 'NSGetWindowServerMemory', 'NSGlobalDomain', 'NSGlyphAbove', 'NSGlyphAttributeBidiLevel', 'NSGlyphAttributeElastic', 'NSGlyphAttributeInscribe', 'NSGlyphAttributeSoft', 'NSGlyphBelow', 'NSGlyphGenerator', 'NSGlyphInfo', 'NSGlyphInfoAttributeName', 'NSGlyphInscribeAbove', 'NSGlyphInscribeBase', 'NSGlyphInscribeBelow', 'NSGlyphInscribeOverBelow', 'NSGlyphInscribeOverstrike', 'NSGlyphLayoutAgainstAPoint', 'NSGlyphLayoutAtAPoint', 'NSGlyphLayoutWithPrevious', 'NSGlyphNameGlyphInfo', 'NSGradient', 'NSGradientColor', 'NSGradientConcaveStrong', 'NSGradientConcaveWeak', 'NSGradientConvexStrong', 'NSGradientConvexWeak', 'NSGradientDrawsAfterEndingLocation', 'NSGradientDrawsBeforeStartingLocation', 'NSGradientNone', 'NSGradientPatternColor', 'NSGrammarCheckingResult', 'NSGrammarCorrections', 'NSGrammarRange', 'NSGrammarUserDescription', 'NSGraphicCell', 'NSGraphicsContext', 'NSGraphicsContextDestinationAttributeName', 'NSGraphicsContextPDFFormat', 'NSGraphicsContextPSFormat', 'NSGraphicsContextRepresentationFormatAttributeName', 'NSGraphiteControlTint', 'NSGrayColorSpaceModel', 'NSGrayFrame', 'NSGrayModeColorPanel', 'NSGreaterThanComparison', 'NSGreaterThanOrEqualToComparison', 'NSGreaterThanOrEqualToPredicateOperatorType', 'NSGreaterThanPredicateOperatorType', 'NSGregorianCalendar', 'NSGreySliders', 'NSGrooveBorder', 'NSHFSFTypeCodeFromFileType', 'NSHFSTypeCodeFromFileType', 'NSHFSTypeOfFile', 'NSHIObject', 'NSHPUXOperatingSystem', 'NSHSBModeColorPanel', 'NSHSBSliders', 'NSHTMLPboardType', 'NSHTMLReader', 'NSHTMLTextDocumentType', 'NSHTMLWebDelegate', 'NSHTMLWriter', 'NSHTTPCookie', 'NSHTTPCookieAcceptPolicyAlways', 'NSHTTPCookieAcceptPolicyNever', 'NSHTTPCookieAcceptPolicyOnlyFromMainDocumentDomain', 'NSHTTPCookieComment', 'NSHTTPCookieCommentURL', 'NSHTTPCookieDiscard', 'NSHTTPCookieDomain', 'NSHTTPCookieExpires', 'NSHTTPCookieManagerAcceptPolicyChangedNotification', 'NSHTTPCookieManagerCookiesChangedNotification', 'NSHTTPCookieMaximumAge', 'NSHTTPCookieName', 'NSHTTPCookieOriginURL', 'NSHTTPCookiePath', 'NSHTTPCookiePort', 'NSHTTPCookieSecure', 'NSHTTPCookieStorage', 'NSHTTPCookieStorageInternal', 'NSHTTPCookieValue', 'NSHTTPCookieVersion', 'NSHTTPPropertyErrorPageDataKey', 'NSHTTPPropertyHTTPProxy', 'NSHTTPPropertyRedirectionHeadersKey', 'NSHTTPPropertyServerHTTPVersionKey', 'NSHTTPPropertyStatusCodeKey', 'NSHTTPPropertyStatusReasonKey', 'NSHTTPURLHandle', 'NSHTTPURLRequestParameters', 'NSHTTPURLResponse', 'NSHTTPURLResponseInternal', 'NSHUDWindowMask', 'NSHandlesContentAsCompoundValueBindingOption', 'NSHashTable', 'NSHashTableCopyIn', 'NSHashTableObjectPointerPersonality', 'NSHashTableStrongMemory', 'NSHashTableZeroingWeakMemory', 'NSHeaderTitleBinding', 'NSHeavierFontAction', 'NSHebrewCalendar', 'NSHeight', 'NSHelpAnchorErrorKey', 'NSHelpAttachment', 'NSHelpButtonBezelStyle', 'NSHelpFunctionKey', 'NSHelpKeyMask', 'NSHelpManager', 'NSHiddenBinding', 'NSHighlightModeMatrix', 'NSHighlightRect', 'NSHomeDirectory', 'NSHomeDirectoryForUser', 'NSHomeFunctionKey', 'NSHorizontalRuler', 'NSHost', 'NSHostByteOrder', 'NSHourCalendarUnit', 'NSHourMinuteDatePickerElementFlag', 'NSHourMinuteSecondDatePickerElementFlag', 'NSHourNameDesignations', 'NSHyphenationFactorDocumentAttribute', 'NSHyphenator', 'NSIBHelpConnector', 'NSIBObjectData', 'NSIBObjectDataAuxilary', 'NSIBSortedEncodingMutableSet', 'NSIBUserDefinedRuntimeAttributesConnector', 'NSINTEGER_DEFINED', 'NSISEngine', 'NSISLinearExpression', 'NSISNonNegativeMarkerVariable', 'NSISNonNegativeMarkerVariableToBeMinimized', 'NSISNonNegativeVariable', 'NSISNonNegativeVariableToBeMinimized', 'NSISNonNegativeVariableWithDelegate', 'NSISNonNegativeVariableWithDelegateToBeMinimized', 'NSISO2022JPStringEncoding', 'NSISO8601Calendar', 'NSISOLatin1StringEncoding', 'NSISOLatin2StringEncoding', 'NSISObjectiveLinearExpression', 'NSISObjectiveVariable', 'NSISPureMarkerVariable', 'NSISVariable', 'NSISVariableWithDelegate', 'NSIconRefBitmapImageRep', 'NSIconRefImageRep', 'NSIconView', 'NSIconViewCell', 'NSIdRunStorage', 'NSIdentityGlyphInfo', 'NSIdentityMappingCharacterCollection', 'NSIllegalSelectorException', 'NSIllegalTextMovement', 'NSImage', 'NSImageAbove', 'NSImageAlignBottom', 'NSImageAlignBottomLeft', 'NSImageAlignBottomRight', 'NSImageAlignCenter', 'NSImageAlignLeft', 'NSImageAlignRight', 'NSImageAlignTop', 'NSImageAlignTopLeft', 'NSImageAlignTopRight', 'NSImageBelow', 'NSImageBinding', 'NSImageCacheAlways', 'NSImageCacheBySize', 'NSImageCacheDefault', 'NSImageCacheException', 'NSImageCacheNever', 'NSImageCacheView', 'NSImageCell', 'NSImageCellType', 'NSImageColorSyncProfileData', 'NSImageCompressionFactor', 'NSImageCompressionMethod', 'NSImageCurrentFrame', 'NSImageCurrentFrameDuration', 'NSImageDitherTransparency', 'NSImageEXIFData', 'NSImageFallbackBackgroundColor', 'NSImageFrameButton', 'NSImageFrameCount', 'NSImageFrameGrayBezel', 'NSImageFrameGroove', 'NSImageFrameNone', 'NSImageFramePhoto', 'NSImageGamma', 'NSImageHintCTM', 'NSImageHintInterpolation', 'NSImageIconRefRepProvider', 'NSImageInterlaced', 'NSImageInterpolationDefault', 'NSImageInterpolationHigh', 'NSImageInterpolationLow', 'NSImageInterpolationMedium', 'NSImageInterpolationNone', 'NSImageKitViewTextAttachmentCell', 'NSImageKitViewTextAttachmentCellHelper', 'NSImageLeft', 'NSImageLoadStatusCancelled', 'NSImageLoadStatusCompleted', 'NSImageLoadStatusInvalidData', 'NSImageLoadStatusReadError', 'NSImageLoadStatusUnexpectedEOF', 'NSImageLoopCount', 'NSImageMultiURLReferencingRepProvider', 'NSImageNameActionTemplate', 'NSImageNameAddTemplate', 'NSImageNameAdvanced', 'NSImageNameApplicationIcon', 'NSImageNameBluetoothTemplate', 'NSImageNameBonjour', 'NSImageNameBookmarksTemplate', 'NSImageNameCaution', 'NSImageNameColorPanel', 'NSImageNameColumnViewTemplate', 'NSImageNameComputer', 'NSImageNameDotMac', 'NSImageNameEnterFullScreenTemplate', 'NSImageNameEveryone', 'NSImageNameExitFullScreenTemplate', 'NSImageNameFlowViewTemplate', 'NSImageNameFolder', 'NSImageNameFolderBurnable', 'NSImageNameFolderSmart', 'NSImageNameFollowLinkFreestandingTemplate', 'NSImageNameFontPanel', 'NSImageNameGoLeftTemplate', 'NSImageNameGoRightTemplate', 'NSImageNameHomeTemplate', 'NSImageNameIChatTheaterTemplate', 'NSImageNameIconViewTemplate', 'NSImageNameInfo', 'NSImageNameInvalidDataFreestandingTemplate', 'NSImageNameLeftFacingTriangleTemplate', 'NSImageNameListViewTemplate', 'NSImageNameLockLockedTemplate', 'NSImageNameLockUnlockedTemplate', 'NSImageNameMenuMixedStateTemplate', 'NSImageNameMenuOnStateTemplate', 'NSImageNameMobileMe', 'NSImageNameMultipleDocuments', 'NSImageNameNetwork', 'NSImageNamePathTemplate', 'NSImageNamePreferencesGeneral', 'NSImageNameQuickLookTemplate', 'NSImageNameRefreshFreestandingTemplate', 'NSImageNameRefreshTemplate', 'NSImageNameRemoveTemplate', 'NSImageNameRevealFreestandingTemplate', 'NSImageNameRightFacingTriangleTemplate', 'NSImageNameSlideshowTemplate', 'NSImageNameSmartBadgeTemplate', 'NSImageNameStatusAvailable', 'NSImageNameStatusNone', 'NSImageNameStatusPartiallyAvailable', 'NSImageNameStatusUnavailable', 'NSImageNameStopProgressFreestandingTemplate', 'NSImageNameStopProgressTemplate', 'NSImageNameTrashEmpty', 'NSImageNameTrashFull', 'NSImageNameUser', 'NSImageNameUserAccounts', 'NSImageNameUserGroup', 'NSImageNameUserGuest', 'NSImageOnly', 'NSImageOverlaps', 'NSImageProgressive', 'NSImageRGBColorTable', 'NSImageRep', 'NSImageRepLoadStatusCompleted', 'NSImageRepLoadStatusInvalidData', 'NSImageRepLoadStatusReadingHeader', 'NSImageRepLoadStatusUnexpectedEOF', 'NSImageRepLoadStatusUnknownType', 'NSImageRepLoadStatusWillNeedAllData', 'NSImageRepMatchesDevice', 'NSImageRepRegistryChangedNotification', 'NSImageRepRegistryDidChangeNotification', 'NSImageRight', 'NSImageScaleAxesIndependently', 'NSImageScaleNone', 'NSImageScaleProportionallyDown', 'NSImageScaleProportionallyUpOrDown', 'NSImageTextFieldCell', 'NSImageURLReferencingRepProvider', 'NSImageView', 'NSImageViewTextAttachmentCell', 'NSInFlightAnimation', 'NSInPredicateOperator', 'NSInPredicateOperatorType', 'NSIncludedKeysBinding', 'NSInconsistentArchiveException', 'NSIncrementExtraRefCount', 'NSIncrementalStore', 'NSIncrementalStoreNode', 'NSIndexPath', 'NSIndexSet', 'NSIndexSpecifier', 'NSIndexSubelement', 'NSIndexedColorSpaceModel', 'NSIndianCalendar', 'NSInformationalAlertStyle', 'NSInformationalRequest', 'NSInitialKeyBinding', 'NSInitialValueBinding', 'NSInkTextPboardType', 'NSInputClientWrapper', 'NSInputContext', 'NSInputManager', 'NSInputMethodsDirectory', 'NSInputServer', 'NSInputStream', 'NSInsertCharFunctionKey', 'NSInsertFunctionKey', 'NSInsertLineFunctionKey', 'NSInsertionPointHelper', 'NSInsertsNullPlaceholderBindingOption', 'NSInsetRect', 'NSInspectorBar', 'NSInspectorBarItem', 'NSIntType', 'NSIntegerMax', 'NSIntegerMin', 'NSIntegralRect', 'NSInterfaceStyleDefault', 'NSInterfaceStyleForKey', 'NSInternalInconsistencyException', 'NSInternalScriptError', 'NSInternalSpecifierError', 'NSInternationalCurrencyString', 'NSIntersectSetExpressionType', 'NSIntersectionRange', 'NSIntersectionRect', 'NSIntersectsRect', 'NSInvalidArchiveOperationException', 'NSInvalidArgumentException', 'NSInvalidIndexSpecifierError', 'NSInvalidReceivePortException', 'NSInvalidSendPortException', 'NSInvalidUnarchiveOperationException', 'NSInvocation', 'NSInvocationOperation', 'NSInvocationOperationCancelledException', 'NSInvocationOperationVoidResultException', 'NSInvokesSeparatelyWithArrayObjectsBindingOption', 'NSIsControllerMarker', 'NSIsEmptyRect', 'NSIsFreedObject', 'NSIsIndeterminateBinding', 'NSIsNilTransformerName', 'NSIsNotNilTransformerName', 'NSIslamicCalendar', 'NSIslamicCivilCalendar', 'NSItalicFontMask', 'NSItemReplacementDirectory', 'NSJPEG2000FileType', 'NSJPEGFileType', 'NSJSONSerialization', 'NSJapaneseCalendar', 'NSJapaneseEUCGlyphPacking', 'NSJapaneseEUCStringEncoding', 'NSJavaBundleCleanup', 'NSJavaBundleSetup', 'NSJavaClasses', 'NSJavaClassesForBundle', 'NSJavaClassesFromPath', 'NSJavaDidCreateVirtualMachineNotification', 'NSJavaDidSetupVirtualMachineNotification', 'NSJavaLibraryPath', 'NSJavaNeedsToLoadClasses', 'NSJavaNeedsVirtualMachine', 'NSJavaObjectNamedInPath', 'NSJavaOwnVirtualMachine', 'NSJavaPath', 'NSJavaPathSeparator', 'NSJavaProvidesClasses', 'NSJavaRoot', 'NSJavaSetup', 'NSJavaSetupVirtualMachine', 'NSJavaUserPath', 'NSJavaWillCreateVirtualMachineNotification', 'NSJavaWillSetupVirtualMachineNotification', 'NSJoin', 'NSTextAlignmentJustified', 'NSKernAttributeName', 'NSKeyBinding', 'NSKeyBindingAtom', 'NSKeyBindingManager', 'NSKeyDown', 'NSKeyDownMask', 'NSKeyGetBinding', 'NSKeyPathExpression', 'NSKeyPathExpressionType', 'NSKeyPathSpecifierExpression', 'NSKeySetBinding', 'NSKeySpecifierEvaluationScriptError', 'NSKeyUp', 'NSKeyUpMask', 'NSKeyValueAccessor', 'NSKeyValueArray', 'NSKeyValueChangeDictionary', 'NSKeyValueChangeIndexesKey', 'NSKeyValueChangeInsertion', 'NSKeyValueChangeKindKey', 'NSKeyValueChangeNewKey', 'NSKeyValueChangeNotificationIsPriorKey', 'NSKeyValueChangeOldKey', 'NSKeyValueChangeRemoval', 'NSKeyValueChangeReplacement', 'NSKeyValueChangeSetting', 'NSKeyValueCollectionGetter', 'NSKeyValueComputedProperty', 'NSKeyValueContainerClass', 'NSKeyValueFastMutableArray', 'NSKeyValueFastMutableArray1', 'NSKeyValueFastMutableArray2', 'NSKeyValueFastMutableCollection1Getter', 'NSKeyValueFastMutableCollection2Getter', 'NSKeyValueFastMutableOrderedSet', 'NSKeyValueFastMutableOrderedSet1', 'NSKeyValueFastMutableOrderedSet2', 'NSKeyValueFastMutableSet', 'NSKeyValueFastMutableSet1', 'NSKeyValueFastMutableSet2', 'NSKeyValueGetter', 'NSKeyValueIntersectSetMutation', 'NSKeyValueIvarGetter', 'NSKeyValueIvarMutableArray', 'NSKeyValueIvarMutableCollectionGetter', 'NSKeyValueIvarMutableOrderedSet', 'NSKeyValueIvarMutableSet', 'NSKeyValueIvarSetter', 'NSKeyValueMethodGetter', 'NSKeyValueMethodSetter', 'NSKeyValueMinusSetMutation', 'NSKeyValueMutableArray', 'NSKeyValueMutableOrderedSet', 'NSKeyValueMutableSet', 'NSKeyValueMutatingArrayMethodSet', 'NSKeyValueMutatingCollectionMethodSet', 'NSKeyValueMutatingOrderedSetMethodSet', 'NSKeyValueMutatingSetMethodSet', 'NSKeyValueNestedProperty', 'NSKeyValueNilOrderedSetEnumerator', 'NSKeyValueNilSetEnumerator', 'NSKeyValueNonmutatingArrayMethodSet', 'NSKeyValueNonmutatingCollectionMethodSet', 'NSKeyValueNonmutatingOrderedSetMethodSet', 'NSKeyValueNonmutatingSetMethodSet', 'NSKeyValueNotifyingMutableArray', 'NSKeyValueNotifyingMutableCollectionGetter', 'NSKeyValueNotifyingMutableOrderedSet', 'NSKeyValueNotifyingMutableSet', 'NSKeyValueObservance', 'NSKeyValueObservationInfo', 'NSKeyValueObservingOptionInitial', 'NSKeyValueObservingOptionNew', 'NSKeyValueObservingOptionOld', 'NSKeyValueObservingOptionPrior', 'NSKeyValueOrderedSet', 'NSKeyValueProperty', 'NSKeyValueProxyGetter', 'NSKeyValueProxyShareKey', 'NSKeyValueSet', 'NSKeyValueSetSetMutation', 'NSKeyValueSetter', 'NSKeyValueShareableObservanceKey', 'NSKeyValueShareableObservationInfoKey', 'NSKeyValueSlowGetter', 'NSKeyValueSlowMutableArray', 'NSKeyValueSlowMutableCollectionGetter', 'NSKeyValueSlowMutableOrderedSet', 'NSKeyValueSlowMutableSet', 'NSKeyValueSlowSetter', 'NSKeyValueUndefinedGetter', 'NSKeyValueUndefinedSetter', 'NSKeyValueUnionSetMutation', 'NSKeyValueUnnestedProperty', 'NSKeyValueValidationError', 'NSKeyboardShortcut', 'NSKeyedArchiver', 'NSKeyedArchiverWrapper', 'NSKeyedPortCoder', 'NSKeyedUnarchiveFromDataTransformerName', 'NSKeyedUnarchiver', 'NSKeyedUnarchiverWrapper', 'NSKeywordsDocumentAttribute', 'NSKitPanelController', 'NSKnownKeysDictionary', 'NSKnownKeysDictionary1', 'NSKnownKeysDictionary2', 'NSKnownKeysMappingStrategy', 'NSKnownKeysMappingStrategy1', 'NSKnownKeysMappingStrategy2', 'NSLABColorSpaceModel', 'NSLSNotificationHelper', 'NSLSNotificationHelperCountedSet', 'NSLSNotificationHelperWeakArray', 'NSLabelBinding', 'NSLabelView', 'NSLabelViewCell', 'NSLandscapeOrientation', 'NSLanguageContext', 'NSLaterTimeDesignations', 'NSLayoutCantFit', 'NSLayoutConstraint', 'NSLayoutConstraintParser', 'NSLayoutDone', 'NSLayoutLeftToRight', 'NSLayoutManager', 'NSLayoutManagerTextBlockHelper', 'NSLayoutManagerTextBlockRowArrayCache', 'NSLayoutNotDone', 'NSLayoutOutOfGlyphs', 'NSLayoutRightToLeft', 'NSLazyBrowserCell', 'NSLazyBrowserList', 'NSLeafProxy', 'NSLeftArrowFunctionKey', 'NSLeftMarginDocumentAttribute', 'NSLeftMouseDown', 'NSLeftMouseDownMask', 'NSLeftMouseDragged', 'NSLeftMouseDraggedMask', 'NSLeftMouseUp', 'NSLeftMouseUpMask', 'NSLeftTabStopType', 'NSLeftTabsBezelBorder', 'NSTextAlignmentLeft', 'NSLeftTextMovement', 'NSLegacyScrollerImp', 'NSLessThanComparison', 'NSLessThanOrEqualToComparison', 'NSLessThanOrEqualToPredicateOperatorType', 'NSLessThanPredicateOperatorType', 'NSLevelIndicator', 'NSLevelIndicatorCell', 'NSLibraryDirectory', 'NSLigatureAttributeName', 'NSLightGray', 'NSLighterFontAction', 'NSLikePredicateOperator', 'NSLikePredicateOperatorType', 'NSLineBorder', 'NSLineBreakByCharWrapping', 'NSLineBreakByClipping', 'NSLineBreakByTruncatingHead', 'NSLineBreakByTruncatingMiddle', 'NSLineBreakByTruncatingTail', 'NSLineBreakByWordWrapping', 'NSLineDoesntMove', 'NSLineFragmentRenderingContext', 'NSLineHeightFormatter', 'NSLineMovesDown', 'NSLineMovesLeft', 'NSLineMovesRight', 'NSLineMovesUp', 'NSLineSeparatorCharacter', 'NSLineSweepDown', 'NSLineSweepLeft', 'NSLineSweepRight', 'NSLineSweepUp', 'NSLineToBezierPathElement', 'NSLinearSlider', 'NSLinguisticTagger', 'NSLinkAttributeName', 'NSLinkCheckingResult', 'NSListModeMatrix', 'NSLiteralSearch', 'NSLoadedClasses', 'NSLocalDomainMask', 'NSLocalInputServer', 'NSLocalNotificationCenterType', 'NSLocalWindowWrappingRemoteWindow', 'NSLocale', 'NSLocaleAlternateQuotationBeginDelimiterKey', 'NSLocaleAlternateQuotationEndDelimiterKey', 'NSLocaleCalendar', 'NSLocaleCollationIdentifier', 'NSLocaleCollatorIdentifier', 'NSLocaleCountryCode', 'NSLocaleCurrencyCode', 'NSLocaleCurrencySymbol', 'NSLocaleDecimalSeparator', 'NSLocaleExemplarCharacterSet', 'NSLocaleGroupingSeparator', 'NSLocaleIdentifier', 'NSLocaleLanguageCode', 'NSLocaleLanguageDirectionBottomToTop', 'NSLocaleLanguageDirectionLeftToRight', 'NSLocaleLanguageDirectionRightToLeft', 'NSLocaleLanguageDirectionTopToBottom', 'NSLocaleLanguageDirectionUnknown', 'NSLocaleMeasurementSystem', 'NSLocaleQuotationBeginDelimiterKey', 'NSLocaleQuotationEndDelimiterKey', 'NSLocaleScriptCode', 'NSLocaleUsesMetricSystem', 'NSLocaleVariantCode', 'NSLocalizedDescriptionKey', 'NSLocalizedFailureReasonErrorKey', 'NSLocalizedKeyDictionaryBinding', 'NSLocalizedRecoveryOptionsErrorKey', 'NSLocalizedRecoverySuggestionErrorKey', 'NSLocalizedString', 'NSLocalizedStringFromTable', 'NSLocalizedStringFromTableInBundle', 'NSLocalizedStringWithDefaultValue', 'NSLocationInRange', 'NSLock', 'NSLog', 'NSLogPageSize', 'NSLogicalTest', 'NSMACHOperatingSystem', 'NSMacOSRomanStringEncoding', 'NSMacSimpleTextDocumentType', 'NSMachBootstrapServer', 'NSMachErrorDomain', 'NSMachPort', 'NSMachPortDeallocateNone', 'NSMachPortDeallocateReceiveRight', 'NSMachPortDeallocateSendRight', 'NSMacintoshInterfaceStyle', 'NSMagnifierWindowContentView', 'NSMainMenuWindowLevel', 'NSMakeCollectable', 'NSMakePoint', 'NSMakeRange', 'NSMakeRect', 'NSMakeSize', 'NSMallocException', 'NSManagedObject', 'NSManagedObjectContext', 'NSManagedObjectContextBinding', 'NSManagedObjectID', 'NSManagedObjectModel', 'NSManagedObjectModelBundle', 'NSManagerDocumentAttribute', 'NSMapTable', 'NSMapTableCopyIn', 'NSMapTableObjectPointerPersonality', 'NSMapTableStrongMemory', 'NSMapTableZeroingWeakMemory', 'NSMappedObjectStore', 'NSMappedRead', 'NSMappingModel', 'NSMarkedClauseSegmentAttributeName', 'NSMatchesPredicateOperatorType', 'NSMatchingPredicateOperator', 'NSMatrix', 'NSMaxRange', 'NSMaxValueBinding', 'NSMaxWidthBinding', 'NSMaxX', 'NSMaxXEdge', 'NSMaxY', 'NSMaxYEdge', 'NSMaximumKeyValueOperator', 'NSMaximumRecentsBinding', 'NSMaximumStringLength', 'NSMemoryObjectStore', 'NSMemoryStoreEqualityPredicateOperator', 'NSMemoryStoreInPredicateOperator', 'NSMenu', 'NSMenuCustomCarbonEventHandler', 'NSMenuDidAddItemNotification', 'NSMenuDidBeginTrackingNotification', 'NSMenuDidChangeItemNotification', 'NSMenuDidEndTrackingNotification', 'NSMenuDidRemoveItemNotification', 'NSMenuDidSendActionNotification', 'NSMenuFunctionKey', 'NSMenuHighlightView', 'NSMenuItem', 'NSMenuItemCell', 'NSMenuItemHighlightColor', 'NSMenuItemViewer', 'NSMenuKEUniquer', 'NSMenuPropertyItemAccessibilityDescription', 'NSMenuPropertyItemAttributedTitle', 'NSMenuPropertyItemEnabled', 'NSMenuPropertyItemImage', 'NSMenuPropertyItemKeyEquivalent', 'NSMenuPropertyItemTitle', 'NSMenuTemplate', 'NSMenuWillSendActionNotification', 'NSMergeConflict', 'NSMergePolicy', 'NSMergedPolicyLocalizationPolicy', 'NSMessageBuilder', 'NSMessagePort', 'NSMessagePortNameServer', 'NSMetadataItem', 'NSMetadataQuery', 'NSMetadataQueryAttributeValueTuple', 'NSMetadataQueryDidFinishGatheringNotification', 'NSMetadataQueryDidStartGatheringNotification', 'NSMetadataQueryDidUpdateNotification', 'NSMetadataQueryGatheringProgressNotification', 'NSMetadataQueryLocalComputerScope', 'NSMetadataQueryNetworkScope', 'NSMetadataQueryResultContentRelevanceAttribute', 'NSMetadataQueryResultGroup', 'NSMetadataQueryUserHomeScope', 'NSMetalPatternColor', 'NSMethodSignature', 'NSMidX', 'NSMidY', 'NSMiddleSpecifier', 'NSMiddleSubelement', 'NSMigrationContext', 'NSMigrationManager', 'NSMinValueBinding', 'NSMinWidthBinding', 'NSMinX', 'NSMinXEdge', 'NSMinY', 'NSMinYEdge', 'NSMiniControlSize', 'NSMiniaturizableWindowMask', 'NSMinimumKeyValueOperator', 'NSMinusSetExpressionType', 'NSMinuteCalendarUnit', 'NSMiterLineJoinStyle', 'NSMixedState', 'NSMixedStateImageBinding', 'NSModalPanelRunLoopMode', 'NSModalPanelWindowLevel', 'NSModalSession', 'NSModeSwitchFunctionKey', 'NSModificationTimeDocumentAttribute', 'NSMomentaryChangeButton', 'NSMomentaryLight', 'NSMomentaryLightButton', 'NSMomentaryPushButton', 'NSMomentaryPushInButton', 'NSMonthCalendarUnit', 'NSMonthNameArray', 'NSMouseEntered', 'NSMouseEnteredMask', 'NSMouseEventSubtype', 'NSMouseExited', 'NSMouseExitedMask', 'NSMouseInRect', 'NSMouseMoved', 'NSMouseMovedMask', 'NSMouseTracker', 'NSMoveCommand', 'NSMoveHelper', 'NSMoveToBezierPathElement', 'NSMovie', 'NSMovieViewTextAttachmentCell', 'NSMoviesDirectory', 'NSMultiProxyDelegate', 'NSMultiReadUniWriteLock', 'NSMultiplePagePDFImageView', 'NSMultiplePagePDFImageViewTextAttachmentCell', 'NSMultipleSelectionBinder', 'NSMultipleTextSelectionPboardType', 'NSMultipleValuesMarker', 'NSMultipleValuesPlaceholderBindingOption', 'NSMusicDirectory', 'NSMutableArray', 'NSMutableAttributedString', 'NSMutableCharacterSet', 'NSMutableData', 'NSMutableDictionary', 'NSMutableFontCollection', 'NSMutableFontDescriptor', 'NSMutableIndexSet', 'NSMutableOrderedSet', 'NSMutableParagraphStyle', 'NSMutableRLEArray', 'NSMutableRangeArray', 'NSMutableSet', 'NSMutableString', 'NSMutableStringProxy', 'NSMutableStringProxyForMutableAttributedString', 'NSMutableURLRequest', 'NSNEXTSTEPStringEncoding', 'NSNameSpecifier', 'NSNamedColorSpace', 'NSNarrowFontMask', 'NSNativeShortGlyphPacking', 'NSTextAlignmentNatural', 'NSNavAdvancedSearchController', 'NSNavBannerButtonCell', 'NSNavBannerView', 'NSNavBox', 'NSNavBrowser', 'NSNavBrowserCell', 'NSNavBrowserDelegate', 'NSNavBrowserTableView', 'NSNavButton', 'NSNavCell', 'NSNavDataSource', 'NSNavDisplayNameFilePropertySortDescriptor', 'NSNavExpansionButtonCell', 'NSNavFBENetworkNode', 'NSNavFBENode', 'NSNavFBENodePreviewHelper', 'NSNavFBENodeTask', 'NSNavFBEQueryChildNode', 'NSNavFBEQueryNode', 'NSNavFBETopLevelNode', 'NSNavFileListDelegate', 'NSNavFilePropertySortDescriptor', 'NSNavFileSizeFormatter', 'NSNavFilepathInputController', 'NSNavFinderViewFileBrowser', 'NSNavFlippedView', 'NSNavHistoryState', 'NSNavIconView', 'NSNavIconViewCell', 'NSNavIconViewDelegate', 'NSNavLayoutView', 'NSNavMatrix', 'NSNavMediaBrowserDelegate', 'NSNavMediaNode', 'NSNavNameFieldFormatter', 'NSNavNaughtDelegate', 'NSNavNewFolderController', 'NSNavNode', 'NSNavNodePopUpButton', 'NSNavNodePreviewController', 'NSNavNodePreviewHelper', 'NSNavNodeSharedServerController', 'NSNavNodeTask', 'NSNavODSAskToUseTask', 'NSNavOutlineCell', 'NSNavOutlineDateCell', 'NSNavOutlineDelegate', 'NSNavOutlineHeaderCell', 'NSNavOutlineView', 'NSNavPreviewController', 'NSNavProgressErrorViewController', 'NSNavProgressStatusViewController', 'NSNavProgressWindow', 'NSNavProgressWindowController', 'NSNavRuleEditor', 'NSNavScopeButton', 'NSNavScopeButtonCell', 'NSNavScopeView', 'NSNavSegmentSwitchControl', 'NSNavSegmentedCell', 'NSNavSharedServerController', 'NSNavSidebarController', 'NSNavSimpleButtonCell', 'NSNavSizePropertySortDescriptor', 'NSNavSortingContext', 'NSNavSplitView', 'NSNavSplitViewController', 'NSNavView', 'NSNavViewController', 'NSNavVirtualNode', 'NSNegateBooleanTransformerName', 'NSNegativeCurrencyFormatString', 'NSNetService', 'NSNetServiceBrowser', 'NSNetServiceNoAutoRename', 'NSNetServicesActivityInProgress', 'NSNetServicesBadArgumentError', 'NSNetServicesCancelledError', 'NSNetServicesCollisionError', 'NSNetServicesErrorCode', 'NSNetServicesErrorDomain', 'NSNetServicesInvalidError', 'NSNetServicesNotFoundError', 'NSNetServicesTimeoutError', 'NSNetServicesUnknownError', 'NSNetworkDomainMask', 'NSNetworkSettings', 'NSNetworkSettingsInternal', 'NSNewlineCharacter', 'NSNextDayDesignations', 'NSNextFunctionKey', 'NSNextNextDayDesignations', 'NSNextStepFrame', 'NSNextStepInterfaceStyle', 'NSNib', 'NSNibAXAttributeConnector', 'NSNibAXRelationshipConnector', 'NSNibBindingConnector', 'NSNibConnector', 'NSNibControlConnector', 'NSNibLoadingException', 'NSNibOutletCollectionConnector', 'NSNibOutletConnector', 'NSNibOwner', 'NSNibTopLevelObjects', 'NSNoBorder', 'NSNoCellMask', 'NSNoFontChangeAction', 'NSNoImage', 'NSNoInterfaceStyle', 'NSNoModeColorPanel', 'NSNoScriptError', 'NSNoScrollerParts', 'NSNoSelectionMarker', 'NSNoSelectionPlaceholderBindingOption', 'NSNoSpecifierError', 'NSNoSubelement', 'NSNoTabsBezelBorder', 'NSNoTabsLineBorder', 'NSNoTabsNoBorder', 'NSNoTitle', 'NSNoTopLevelContainersSpecifierError', 'NSNoUnderlineStyle', 'NSNonLossyASCIIStringEncoding', 'NSNonStandardCharacterSetFontMask', 'NSNonZeroWindingRule', 'NSNonactivatingPanelMask', 'NSNormalWindowLevel', 'NSNotApplicableMarker', 'NSNotApplicablePlaceholderBindingOption', 'NSNotEqualToPredicateOperatorType', 'NSNotFound', 'NSNotPredicateType', 'NSNotification', 'NSNotificationCenter', 'NSNotificationCoalescingOnName', 'NSNotificationCoalescingOnSender', 'NSNotificationDeliverImmediately', 'NSNotificationNoCoalescing', 'NSNotificationPostToAllSessions', 'NSNotificationQueue', 'NSNotificationSuspensionBehaviorCoalesce', 'NSNotificationSuspensionBehaviorDeliverImmediately', 'NSNotificationSuspensionBehaviorDrop', 'NSNotificationSuspensionBehaviorHold', 'NSNull', 'NSNullCellType', 'NSNullFileHandle', 'NSNullGlyph', 'NSNullPlaceholderBindingOption', 'NSNumber', 'NSNumberFormatter', 'NSNumberFormatterBehavior10_0', 'NSNumberFormatterBehavior10_4', 'NSNumberFormatterBehaviorDefault', 'NSNumberFormatterCurrencyStyle', 'NSNumberFormatterDecimalStyle', 'NSNumberFormatterNoStyle', 'NSNumberFormatterPadAfterPrefix', 'NSNumberFormatterPadAfterSuffix', 'NSNumberFormatterPadBeforePrefix', 'NSNumberFormatterPadBeforeSuffix', 'NSNumberFormatterPercentStyle', 'NSNumberFormatterRoundCeiling', 'NSNumberFormatterRoundDown', 'NSNumberFormatterRoundFloor', 'NSNumberFormatterRoundHalfDown', 'NSNumberFormatterRoundHalfEven', 'NSNumberFormatterRoundHalfUp', 'NSNumberFormatterRoundUp', 'NSNumberFormatterScientificStyle', 'NSNumberFormatterSpellOutStyle', 'NSNumberOfColorComponents', 'NSNumericPadKeyMask', 'NSNumericSearch', 'NSODContext', 'NSODNode', 'NSODQuery', 'NSODRecord', 'NSODSession', 'NSOKButton', 'NSOPENGL_CURRENT_VERSION', 'NSOSF1OperatingSystem', 'NSOSStatusErrorDomain', 'NSOVShowMoreButtonCell', 'NSOVTrackingAreaOwner', 'NSOVWrapperButton', 'NSObject', 'NSObjectAutoreleasedEvent', 'NSObjectController', 'NSObjectDetailBinder', 'NSObjectExtraRefDecrementedEvent', 'NSObjectExtraRefIncrementedEvent', 'NSObjectInaccessibleException', 'NSObjectInternalRefDecrementedEvent', 'NSObjectInternalRefIncrementedEvent', 'NSObjectNotAvailableException', 'NSObjectParameterBinder', 'NSObjectSpecifier', 'NSObliquenessAttributeName', 'NSObservedKeyPathKey', 'NSObservedObjectKey', 'NSObsoleteBitmap', 'NSOffState', 'NSOffStateImageBinding', 'NSOfficeOpenXMLTextDocumentType', 'NSOffsetRect', 'NSOldStyleException', 'NSOnOffButton', 'NSOnState', 'NSOnStateImageBinding', 'NSOneByteGlyphPacking', 'NSOneLevelViewBuffer', 'NSOnlyScrollerArrows', 'NSOpenDocumentReader', 'NSOpenDocumentTextDocumentType', 'NSOpenDocumentWriter', 'NSOpenGLCPRasterizationEnable', 'NSOpenGLCPStateValidation', 'NSOpenGLCPSurfaceOpacity', 'NSOpenGLCPSurfaceOrder', 'NSOpenGLCPSwapInterval', 'NSOpenGLCPSwapRectangle', 'NSOpenGLCPSwapRectangleEnable', 'NSOpenGLContext', 'NSOpenGLGOClearFormatCache', 'NSOpenGLGOFormatCacheSize', 'NSOpenGLGOResetLibrary', 'NSOpenGLGORetainRenderers', 'NSOpenGLGetOption', 'NSOpenGLGetVersion', 'NSOpenGLLayer', 'NSOpenGLPFAAccelerated', 'NSOpenGLPFAAcceleratedCompute', 'NSOpenGLPFAAccumSize', 'NSOpenGLPFAAllRenderers', 'NSOpenGLPFAAllowOfflineRenderers', 'NSOpenGLPFAAlphaSize', 'NSOpenGLPFAAuxBuffers', 'NSOpenGLPFAAuxDepthStencil', 'NSOpenGLPFABackingStore', 'NSOpenGLPFAClosestPolicy', 'NSOpenGLPFAColorFloat', 'NSOpenGLPFAColorSize', 'NSOpenGLPFACompliant', 'NSOpenGLPFADepthSize', 'NSOpenGLPFADoubleBuffer', 'NSOpenGLPFAFullScreen', 'NSOpenGLPFAMPSafe', 'NSOpenGLPFAMaximumPolicy', 'NSOpenGLPFAMinimumPolicy', 'NSOpenGLPFAMultiScreen', 'NSOpenGLPFAMultisample', 'NSOpenGLPFANoRecovery', 'NSOpenGLPFAOffScreen', 'NSOpenGLPFAPixelBuffer', 'NSOpenGLPFARemotePixelBuffer', 'NSOpenGLPFARendererID', 'NSOpenGLPFARobust', 'NSOpenGLPFASampleAlpha', 'NSOpenGLPFASampleBuffers', 'NSOpenGLPFASamples', 'NSOpenGLPFAScreenMask', 'NSOpenGLPFASingleRenderer', 'NSOpenGLPFAStencilSize', 'NSOpenGLPFAStereo', 'NSOpenGLPFASupersample', 'NSOpenGLPFAVirtualScreenCount', 'NSOpenGLPFAWindow', 'NSOpenGLPixelBuffer', 'NSOpenGLPixelFormat', 'NSOpenGLSetOption', 'NSOpenGLView', 'NSOpenPanel', 'NSOpenStepRootDirectory', 'NSOpenStepUnicodeReservedBase', 'NSOperation', 'NSOperationNotSupportedForKeyException', 'NSOperationNotSupportedForKeyScriptError', 'NSOperationNotSupportedForKeySpecifierError', 'NSOperationQueue', 'NSOperationQueueDefaultMaxConcurrentOperationCount', 'NSOperationQueuePriorityHigh', 'NSOperationQueuePriorityLow', 'NSOperationQueuePriorityNormal', 'NSOperationQueuePriorityVeryHigh', 'NSOperationQueuePriorityVeryLow', 'NSOptionsKey', 'NSOrPredicateType', 'NSOrderedAscending', 'NSOrderedDescending', 'NSOrderedSame', 'NSOrderedSet', 'NSOrthography', 'NSOrthographyCheckingResult', 'NSOtherMouseDown', 'NSOtherMouseDownMask', 'NSOtherMouseDragged', 'NSOtherMouseDraggedMask', 'NSOtherMouseUp', 'NSOtherMouseUpMask', 'NSOtherTextMovement', 'NSOutlineButtonCell', 'NSOutlineColumnMockGroup', 'NSOutlineMockDisclosureTriangle', 'NSOutlineRow', 'NSOutlineView', 'NSOutlineViewBinder', 'NSOutlineViewColumnDidMoveNotification', 'NSOutlineViewColumnDidResizeNotification', 'NSOutlineViewDropOnItemIndex', 'NSOutlineViewItemDidCollapseNotification', 'NSOutlineViewItemDidExpandNotification', 'NSOutlineViewItemWillCollapseNotification', 'NSOutlineViewItemWillExpandNotification', 'NSOutlineViewSelectionDidChangeNotification', 'NSOutlineViewSelectionIsChangingNotification', 'NSOutputStream', 'NSOverlayScrollerImp', 'NSPDFImageRep', 'NSPDFPboardType', 'NSPICTImageRep', 'NSPICTPboardType', 'NSPNGFileType', 'NSPOSIXErrorDomain', 'NSPPDIncludeNotFoundException', 'NSPPDIncludeStackOverflowException', 'NSPPDIncludeStackUnderflowException', 'NSPPDParse', 'NSPPDParseException', 'NSPSMatrix', 'NSPageData', 'NSPageDownFunctionKey', 'NSPageLayout', 'NSPageSize', 'NSPageUpFunctionKey', 'NSPageableTableView', 'NSPanel', 'NSPanelController', 'NSPaperSizeDocumentAttribute', 'NSParagraphSeparatorCharacter', 'NSParagraphStyle', 'NSParagraphStyleAttributeName', 'NSParagraphStyleExtraData', 'NSParseErrorException', 'NSPasteboard', 'NSPasteboardCommunicationException', 'NSPasteboardFilter', 'NSPasteboardItem', 'NSPasteboardReadingAsData', 'NSPasteboardReadingAsKeyedArchive', 'NSPasteboardReadingAsPropertyList', 'NSPasteboardReadingAsString', 'NSPasteboardTypeColor', 'NSPasteboardTypeFindPanelSearchOptions', 'NSPasteboardTypeFont', 'NSPasteboardTypeHTML', 'NSPasteboardTypeMultipleTextSelection', 'NSPasteboardTypePDF', 'NSPasteboardTypePNG', 'NSPasteboardTypeRTF', 'NSPasteboardTypeRTFD', 'NSPasteboardTypeRuler', 'NSPasteboardTypeSound', 'NSPasteboardTypeString', 'NSPasteboardTypeTIFF', 'NSPasteboardTypeTabularText', 'NSPasteboardURLReadingContentsConformToTypesKey', 'NSPasteboardURLReadingFileURLsOnlyKey', 'NSPasteboardWritingPromised', 'NSPathCell', 'NSPathComponentCell', 'NSPathControl', 'NSPathControlDragContext', 'NSPathStore2', 'NSPathStyleNavigationBar', 'NSPathStylePopUp', 'NSPathStyleStandard', 'NSPatternColor', 'NSPatternColorSpace', 'NSPatternColorSpaceModel', 'NSPauseFunctionKey', 'NSPenLowerSideMask', 'NSPenPointingDevice', 'NSPenTipMask', 'NSPenUpperSideMask', 'NSPerformService', 'NSPeriodic', 'NSPeriodicMask', 'NSPersianCalendar', 'NSPersistentDocument', 'NSPersistentStore', 'NSPersistentStoreCache', 'NSPersistentStoreCoordinator', 'NSPersistentStoreMap', 'NSPersistentStoreRequest', 'NSPersistentUIBucket', 'NSPersistentUIEncodedReference', 'NSPersistentUIManager', 'NSPersistentUIRecord', 'NSPersistentUIUnarchiver', 'NSPersistentUIWindowInfo', 'NSPersistentUIWindowRestoration', 'NSPhoneNumberCheckingResult', 'NSPicturesDirectory', 'NSPipe', 'NSPlaceholderMutableString', 'NSPlaceholderNumber', 'NSPlaceholderString', 'NSPlaceholderValue', 'NSPlainFileType', 'NSPlainTextDocumentType', 'NSPlainTextTokenStyle', 'NSPlanarFromDepth', 'NSPoint', 'NSPointFromCGPoint', 'NSPointFromString', 'NSPointInRect', 'NSPointToCGPoint', 'NSPointerArray', 'NSPointerFunctions', 'NSPointerFunctionsCStringPersonality', 'NSPointerFunctionsCopyIn', 'NSPointerFunctionsIntegerPersonality', 'NSPointerFunctionsMachVirtualMemory', 'NSPointerFunctionsMallocMemory', 'NSPointerFunctionsObjectPersonality', 'NSPointerFunctionsObjectPointerPersonality', 'NSPointerFunctionsOpaqueMemory', 'NSPointerFunctionsOpaquePersonality', 'NSPointerFunctionsStrongMemory', 'NSPointerFunctionsStructPersonality', 'NSPointerFunctionsZeroingWeakMemory', 'NSPoofView', 'NSPopUpArrowAtBottom', 'NSPopUpArrowAtCenter', 'NSPopUpButton', 'NSPopUpButtonCell', 'NSPopUpButtonCellWillPopUpNotification', 'NSPopUpButtonWillPopUpNotification', 'NSPopUpMenuWindowLevel', 'NSPopUpNoArrow', 'NSPopover', 'NSPopoverBinder', 'NSPopoverColorWell', 'NSPopoverFrame', 'NSPort', 'NSPortCoder', 'NSPortDidBecomeInvalidNotification', 'NSPortMessage', 'NSPortNameServer', 'NSPortReceiveException', 'NSPortSendException', 'NSPortTimeoutException', 'NSPortraitOrientation', 'NSPositionAfter', 'NSPositionBefore', 'NSPositionBeginning', 'NSPositionEnd', 'NSPositionReplace', 'NSPositionalSpecifier', 'NSPositionalSpecifierMoreIVars', 'NSPositiveCurrencyFormatString', 'NSPositiveDoubleType', 'NSPositiveFloatType', 'NSPositiveIntType', 'NSPostASAP', 'NSPostNow', 'NSPostScriptPboardType', 'NSPostWhenIdle', 'NSPosterFontMask', 'NSPowerOffEventType', 'NSPredicate', 'NSPredicateBinding', 'NSPredicateEditor', 'NSPredicateEditorRowTemplate', 'NSPredicateFormatBindingOption', 'NSPredicateOperator', 'NSPreferencePanesDirectory', 'NSPreferences', 'NSPreferencesModule', 'NSPrefixSpacesDocumentAttribute', 'NSPressedTab', 'NSPrevFunctionKey', 'NSPrintAllPages', 'NSPrintAllPresetsJobStyleHint', 'NSPrintBottomMargin', 'NSPrintCancelJob', 'NSPrintCopies', 'NSPrintCopyingGraphicsContext', 'NSPrintDetailedErrorReporting', 'NSPrintFaxCoverSheetName', 'NSPrintFaxHighResolution', 'NSPrintFaxJob', 'NSPrintFaxModem', 'NSPrintFaxNumber', 'NSPrintFaxReceiverNames', 'NSPrintFaxReceiverNumbers', 'NSPrintFaxReturnReceipt', 'NSPrintFaxSendTime', 'NSPrintFaxTrimPageEnds', 'NSPrintFaxUseCoverSheet', 'NSPrintFirstPage', 'NSPrintFormName', 'NSPrintFunctionKey', 'NSPrintHeaderAndFooter', 'NSPrintHorizontalPagination', 'NSPrintHorizontallyCentered', 'NSPrintInfo', 'NSPrintInfoAdditionalIVars', 'NSPrintInfoDictionaryProxy', 'NSPrintJobDisposition', 'NSPrintJobFeatures', 'NSPrintJobSavingFileNameExtensionHidden', 'NSPrintJobSavingURL', 'NSPrintLastPage', 'NSPrintLeftMargin', 'NSPrintManualFeed', 'NSPrintMustCollate', 'NSPrintNoPresetsJobStyleHint', 'NSPrintOperation', 'NSPrintOperationExistsException', 'NSPrintOperationPrintEventRetrofitInfo', 'NSPrintOrientation', 'NSPrintPackageException', 'NSPrintPagesAcross', 'NSPrintPagesDown', 'NSPrintPagesPerSheet', 'NSPrintPanel', 'NSPrintPanelAccessorySummaryItemDescriptionKey', 'NSPrintPanelAccessorySummaryItemNameKey', 'NSPrintPanelOldAccessoryController', 'NSPrintPanelShowsCopies', 'NSPrintPanelShowsOrientation', 'NSPrintPanelShowsPageRange', 'NSPrintPanelShowsPageSetupAccessory', 'NSPrintPanelShowsPaperSize', 'NSPrintPanelShowsPreview', 'NSPrintPanelShowsPrintSelection', 'NSPrintPanelShowsScaling', 'NSPrintPaperFeed', 'NSPrintPaperName', 'NSPrintPaperSize', 'NSPrintPhotoJobStyleHint', 'NSPrintPreviewController', 'NSPrintPreviewGraphicsContext', 'NSPrintPreviewJob', 'NSPrintPrinter', 'NSPrintPrinterName', 'NSPrintReversePageOrder', 'NSPrintRightMargin', 'NSPrintSaveJob', 'NSPrintSavePath', 'NSPrintScalingFactor', 'NSPrintScreenFunctionKey', 'NSPrintSelectionOnly', 'NSPrintSpoolJob', 'NSPrintSpoolingGraphicsContext', 'NSPrintThumbnailView', 'NSPrintTime', 'NSPrintTopMargin', 'NSPrintVerticalPagination', 'NSPrintVerticallyCentered', 'NSPrinter', 'NSPrinterDescriptionDirectory', 'NSPrinterTableError', 'NSPrinterTableNotFound', 'NSPrinterTableOK', 'NSPrintingCancelled', 'NSPrintingCommunicationException', 'NSPrintingFailure', 'NSPrintingReplyLater', 'NSPrintingSuccess', 'NSPriorDayDesignations', 'NSPrivateCoreDataClassForFindingBundle', 'NSProcessInfo', 'NSProgressIndicator', 'NSProgressIndicatorBarStyle', 'NSProgressIndicatorBinder', 'NSProgressIndicatorPreferredAquaThickness', 'NSProgressIndicatorPreferredLargeThickness', 'NSProgressIndicatorPreferredSmallThickness', 'NSProgressIndicatorPreferredThickness', 'NSProgressIndicatorSpinningStyle', 'NSProgressPanel', 'NSPropertyDescription', 'NSPropertyListBinaryFormat_v1_0', 'NSPropertyListErrorMaximum', 'NSPropertyListErrorMinimum', 'NSPropertyListImmutable', 'NSPropertyListMutableContainers', 'NSPropertyListMutableContainersAndLeaves', 'NSPropertyListOpenStepFormat', 'NSPropertyListReadCorruptError', 'NSPropertyListReadStreamError', 'NSPropertyListReadUnknownVersionError', 'NSPropertyListSerialization', 'NSPropertyListWriteStreamError', 'NSPropertyListXMLFormat_v1_0', 'NSPropertyMapping', 'NSPropertySpecifier', 'NSPropertyStoreMapping', 'NSPropertyTransform', 'NSProprietaryStringEncoding', 'NSProtocolChecker', 'NSProtocolFromString', 'NSProxy', 'NSPurgeableData', 'NSPushInCell', 'NSPushInCellMask', 'NSPushOnPushOffButton', 'NSQLPreviewTitleCell', 'NSQLPreviewTitlebarView', 'NSQLPreviewWindowCloseButtonCell', 'NSQTMovieLoopingBackAndForthPlayback', 'NSQTMovieLoopingPlayback', 'NSQTMovieNormalPlayback', 'NSQuarterCalendarUnit', 'NSQuickLookWrapperDocument', 'NSQuitCommand', 'NSQuoteCheckingResult', 'NSRGBColorSpaceModel', 'NSRGBModeColorPanel', 'NSRGBSliders', 'NSRLEArray', 'NSRTFD', 'NSRTFDPboardType', 'NSRTFDTextDocumentType', 'NSRTFPboardType', 'NSRTFPropertyStackOverflowException', 'NSRTFReader', 'NSRTFReaderTableState', 'NSRTFTextDocumentType', 'NSRTFWriter', 'NSRadioButton', 'NSRadioModeMatrix', 'NSRaisesForNotApplicableKeysBindingOption', 'NSRandomSpecifier', 'NSRandomSubelement', 'NSRange', 'NSRangeDateMode', 'NSRangeException', 'NSRangeFromString', 'NSRangeSpecifier', 'NSRatingLevelIndicatorStyle', 'NSReadOnlyDocumentAttribute', 'NSReadPixel', 'NSRealMemoryAvailable', 'NSReceiverEvaluationScriptError', 'NSReceiversCantHandleCommandScriptError', 'NSRecentSearchesBinding', 'NSRecessedBezelStyle', 'NSRecordAllocationEvent', 'NSRecoveryAttempterErrorKey', 'NSRect', 'NSRectClip', 'NSRectClipList', 'NSRectFill', 'NSRectFillList', 'NSRectFillListUsingOperation', 'NSRectFillListWithColors', 'NSRectFillListWithColorsUsingOperation', 'NSRectFillListWithGrays', 'NSRectFillUsingOperation', 'NSRectFromCGRect', 'NSRectFromString', 'NSRectSet', 'NSRectToCGRect', 'NSRecursiveLock', 'NSRecycleZone', 'NSRedoFunctionKey', 'NSRefreshRequest', 'NSRegion', 'NSRegisterServicesProvider', 'NSRegistrationDomain', 'NSRegularControlSize', 'NSRegularExpression', 'NSRegularExpressionCheckingResult', 'NSRegularLegacyScrollerImp', 'NSRegularOverlayScrollerImp', 'NSRegularSquareBezelStyle', 'NSRelationshipDescription', 'NSRelationshipStoreMapping', 'NSRelativeAfter', 'NSRelativeBefore', 'NSRelativeSpecifier', 'NSReleaseAlertPanel', 'NSRelevancyLevelIndicatorStyle', 'NSRemoteAccessoryView', 'NSRemoteInputServer', 'NSRemoteOpenPanel', 'NSRemoteResponderProxyObject', 'NSRemoteSavePanel', 'NSRemoteSavePanelOrderingContext', 'NSRemoteServiceConnection', 'NSRemoteServiceMessage', 'NSRemoteServiceReply', 'NSRemoteServiceRequest', 'NSRemoteWindowController', 'NSRemoveTraitFontAction', 'NSReplacementCheckingResult', 'NSRepresentedFilenameBinding', 'NSRepublicOfChinaCalendar', 'NSRequiredArgumentsMissingScriptError', 'NSResetCursorRectsRunLoopOrdering', 'NSResetFunctionKey', 'NSResetHashTable', 'NSResetMapTable', 'NSResizableWindowMask', 'NSResponder', 'NSReturnTextMovement', 'NSRightArrowFunctionKey', 'NSRightMarginDocumentAttribute', 'NSRightMouseDown', 'NSRightMouseDownMask', 'NSRightMouseDragged', 'NSRightMouseDraggedMask', 'NSRightMouseUp', 'NSRightMouseUpMask', 'NSRightTabStopType', 'NSRightTabsBezelBorder', 'NSTextAlignmentRight', 'NSRightTextMovement', 'NSRoundBankers', 'NSRoundDown', 'NSRoundDownToMultipleOfPageSize', 'NSRoundLineCapStyle', 'NSRoundLineJoinStyle', 'NSRoundPlain', 'NSRoundRectBezelStyle', 'NSRoundUp', 'NSRoundUpToMultipleOfPageSize', 'NSRoundedBezelStyle', 'NSRoundedDisclosureBezelStyle', 'NSRoundedTokenStyle', 'NSRowClipView', 'NSRowHeightBinding', 'NSRuleEditor', 'NSRuleEditorButton', 'NSRuleEditorButtonCell', 'NSRuleEditorLocalizer', 'NSRuleEditorNestingModeCompound', 'NSRuleEditorNestingModeList', 'NSRuleEditorNestingModeSimple', 'NSRuleEditorNestingModeSingle', 'NSRuleEditorPopupButton', 'NSRuleEditorPopupButtonCell', 'NSRuleEditorPredicateComparisonModifier', 'NSRuleEditorPredicateCompoundType', 'NSRuleEditorPredicateCustomSelector', 'NSRuleEditorPredicateLeftExpression', 'NSRuleEditorPredicateOperatorType', 'NSRuleEditorPredicateOptions', 'NSRuleEditorPredicateRightExpression', 'NSRuleEditorRowTypeCompound', 'NSRuleEditorRowTypeSimple', 'NSRuleEditorRowsDidChangeNotification', 'NSRuleEditorTextField', 'NSRuleEditorTextFieldCell', 'NSRuleEditorViewSlice', 'NSRuleEditorViewSliceDropSeparator', 'NSRuleEditorViewSliceRow', 'NSRulerLabelCell', 'NSRulerMarker', 'NSRulerMarkerPanel', 'NSRulerMarkerView', 'NSRulerPboard', 'NSRulerPboardType', 'NSRulerView', 'NSRulerViewAccessibilityPanelController', 'NSRulerViewPrivateData', 'NSRunAbortedResponse', 'NSRunAlertPanel', 'NSRunAlertPanelRelativeToWindow', 'NSRunContinuesResponse', 'NSRunCriticalAlertPanel', 'NSRunCriticalAlertPanelRelativeToWindow', 'NSRunInformationalAlertPanel', 'NSRunInformationalAlertPanelRelativeToWindow', 'NSRunLoop', 'NSRunLoopCommonModes', 'NSRunStoppedResponse', 'NSRunStorage', 'NSRunningApplication', 'NSSQLAdapter', 'NSSQLAdapterOperation', 'NSSQLAliasGenerator', 'NSSQLAttribute', 'NSSQLBindVariable', 'NSSQLChannel', 'NSSQLColumn', 'NSSQLCompoundWhereIntermediate', 'NSSQLConnection', 'NSSQLConstantValueIntermediate', 'NSSQLCore', 'NSSQLCorrelation', 'NSSQLEntity', 'NSSQLEntityKey', 'NSSQLExistenceSubqueryWhereIntermediate', 'NSSQLExpressionIntermediate', 'NSSQLFetchCountIntermediate', 'NSSQLFetchDictionaryCountIntermediate', 'NSSQLFetchIntermediate', 'NSSQLForeignEntityKey', 'NSSQLForeignKey', 'NSSQLForeignKeyIntermediate', 'NSSQLForeignOrderKey', 'NSSQLFunctionExpressionIntermediate', 'NSSQLGenerator', 'NSSQLGroupByIntermediate', 'NSSQLHavingIntermediate', 'NSSQLIntermediate', 'NSSQLJoinIntermediate', 'NSSQLKeypathExpressionIntermediate', 'NSSQLLimitIntermediate', 'NSSQLManyToMany', 'NSSQLModel', 'NSSQLOffsetIntermediate', 'NSSQLOperation', 'NSSQLOptLockKey', 'NSSQLOrderIntermediate', 'NSSQLPredicateAnalyser', 'NSSQLPrimaryKey', 'NSSQLProperty', 'NSSQLReadOnlySelectIntermediate', 'NSSQLRelationship', 'NSSQLRow', 'NSSQLRowCache', 'NSSQLSelectIntermediate', 'NSSQLSimpleWhereIntermediate', 'NSSQLStatement', 'NSSQLStoreMappingGenerator', 'NSSQLSubqueryExpressionIntermediate', 'NSSQLTernaryExpressionIntermediate', 'NSSQLToMany', 'NSSQLToOne', 'NSSQLWhereIntermediate', 'NSSQLiteAdapter', 'NSSQLiteConnection', 'NSSQLiteInPlaceMigrationManager', 'NSSQLiteStatement', 'NSSaveAsOperation', 'NSSaveChangesRequest', 'NSSaveOperation', 'NSSaveOptionsAsk', 'NSSaveOptionsNo', 'NSSaveOptionsYes', 'NSSavePanel', 'NSSavePanelAlertStyleContentView', 'NSSavePanelAuxiliary', 'NSSavePanelNameFieldCell', 'NSSaveToOperation', 'NSScalarObjectID48', 'NSScalarObjectID64', 'NSScaleNone', 'NSScaleProportionally', 'NSScaleToFit', 'NSScannedOption', 'NSScanner', 'NSScreen', 'NSScreenAux', 'NSScreenChangedEventType', 'NSScreenColorSpaceDidChangeNotification', 'NSScreenSaverWindowLevel', 'NSScriptArgumentDescription', 'NSScriptAttributeDescription', 'NSScriptClassDescription', 'NSScriptClassDescriptionMoreIVars', 'NSScriptCoercionHandler', 'NSScriptCommand', 'NSScriptCommandConstructionContext', 'NSScriptCommandDescription', 'NSScriptCommandDescriptionMoreIVars', 'NSScriptCommandMoreIVars', 'NSScriptComplexTypeDescription', 'NSScriptDeclaredRecordTypeDescription', 'NSScriptEnumerationDescription', 'NSScriptEnumeratorDescription', 'NSScriptExecutionContext', 'NSScriptExecutionContextMoreIVars', 'NSScriptFakeObjectTypeDescription', 'NSScriptListTypeDescription', 'NSScriptObjectSpecifier', 'NSScriptObjectTypeDescription', 'NSScriptPropertiesRecordTypeDescription', 'NSScriptPropertyDescription', 'NSScriptRecordFieldDescription', 'NSScriptRecordTypeDescription', 'NSScriptSDEFElement', 'NSScriptSDEFParser', 'NSScriptSuiteDescription', 'NSScriptSuiteRegistry', 'NSScriptSynonymDescription', 'NSScriptToManyRelationshipDescription', 'NSScriptToOneRelationshipDescription', 'NSScriptTypeDescription', 'NSScriptValueTypeDescription', 'NSScriptWhoseTest', 'NSScriptingAppleEventHandler', 'NSScrollAnimationHelper', 'NSScrollLockFunctionKey', 'NSScrollView', 'NSScrollWheel', 'NSScrollWheelMask', 'NSScroller', 'NSScrollerArrowsDefaultSetting', 'NSScrollerArrowsMaxEnd', 'NSScrollerArrowsMinEnd', 'NSScrollerArrowsNone', 'NSScrollerDecrementArrow', 'NSScrollerDecrementLine', 'NSScrollerDecrementPage', 'NSScrollerImp', 'NSScrollerImpPair', 'NSScrollerIncrementArrow', 'NSScrollerIncrementLine', 'NSScrollerIncrementPage', 'NSScrollerKnob', 'NSScrollerKnobSlot', 'NSScrollerNoPart', 'NSSearchButtonCellProxy', 'NSSearchField', 'NSSearchFieldBinder', 'NSSearchFieldCell', 'NSSearchFieldClearRecentsMenuItemTag', 'NSSearchFieldNoRecentsMenuItemTag', 'NSSearchFieldRecentsMenuItemTag', 'NSSearchFieldRecentsTitleMenuItemTag', 'NSSearchPathForDirectoriesInDomains', 'NSSecondCalendarUnit', 'NSSecureStringWrapper', 'NSSecureTextField', 'NSSecureTextFieldCell', 'NSSecureTextStorage', 'NSSecureTextView', 'NSSegmentItem', 'NSSegmentStyleAutomatic', 'NSSegmentStyleCapsule', 'NSSegmentStyleRoundRect', 'NSSegmentStyleRounded', 'NSSegmentStyleSmallSquare', 'NSSegmentStyleTexturedRounded', 'NSSegmentStyleTexturedSquare', 'NSSegmentSwitchTrackingMomentary', 'NSSegmentSwitchTrackingSelectAny', 'NSSegmentSwitchTrackingSelectOne', 'NSSegmentedCell', 'NSSegmentedControl', 'NSSegmentedControlBinder', 'NSSelectByCharacter', 'NSSelectByParagraph', 'NSSelectByWord', 'NSSelectFunctionKey', 'NSSelectedIdentifierBinding', 'NSSelectedIndexBinding', 'NSSelectedLabelBinding', 'NSSelectedObjectBinding', 'NSSelectedObjectsBinding', 'NSSelectedTab', 'NSSelectedTagBinding', 'NSSelectedValueBinding', 'NSSelectedValuesBinding', 'NSSelectingNext', 'NSSelectingPrevious', 'NSSelectionAffinityDownstream', 'NSSelectionAffinityUpstream', 'NSSelectionArray', 'NSSelectionBinder', 'NSSelectionIndexPathsBinding', 'NSSelectionIndexesBinding', 'NSSelectorFromString', 'NSSelectorNameBindingOption', 'NSSelectsAllWhenSettingContentBindingOption', 'NSSelfExpression', 'NSSerializer', 'NSServiceApplicationLaunchFailedError', 'NSServiceApplicationNotFoundError', 'NSServiceErrorMaximum', 'NSServiceErrorMinimum', 'NSServiceInvalidPasteboardDataError', 'NSServiceListener', 'NSServiceMalformedServiceDictionaryError', 'NSServiceMaster', 'NSServiceMiscellaneousError', 'NSServiceRequestTimedOutError', 'NSServicesMenuHandler', 'NSSet', 'NSSetCommand', 'NSSetExpression', 'NSSetFocusRingStyle', 'NSSetShowsServicesMenuItem', 'NSSetZoneName', 'NSShadow', 'NSShadowAttributeName', 'NSShadowSurface', 'NSShadowlessSquareBezelStyle', 'NSSharedPublicDirectory', 'NSSharedWindowController', 'NSShellCommandFileType', 'NSShiftJISStringEncoding', 'NSShiftKeyMask', 'NSShortDateFormatString', 'NSShortMonthNameArray', 'NSShortTimeDateFormatString', 'NSShortWeekDayNameArray', 'NSShouldRetainWithZone', 'NSShowAnimationEffect', 'NSShowControlGlyphs', 'NSShowInvisibleGlyphs', 'NSShowsServicesMenuItem', 'NSSidebarImage', 'NSSidebarImageCell', 'NSSimpleAttributeDictionary', 'NSSimpleAttributeDictionaryEnumerator', 'NSSimpleCString', 'NSSimpleOrthography', 'NSSimpleRegularExpressionCheckingResult', 'NSSingleDateMode', 'NSSingleLineTypesetter', 'NSSingleUnderlineStyle', 'NSSize', 'NSSizeDownFontAction', 'NSSizeFromCGSize', 'NSSizeFromString', 'NSSizeToCGSize', 'NSSizeUpFontAction', 'NSSlider', 'NSSliderCell', 'NSSmallCapsFontMask', 'NSSmallControlSize', 'NSSmallIconButtonBezelStyle', 'NSSmallLegacyScrollerImp', 'NSSmallOverlayScrollerImp', 'NSSmallSquareBezelStyle', 'NSSnapshotBitmapGraphicsContext', 'NSSnapshotContextSignature', 'NSSocketPort', 'NSSocketPortNameServer', 'NSSolarisOperatingSystem', 'NSSortConcurrent', 'NSSortDescriptor', 'NSSortDescriptorsBinding', 'NSSortStable', 'NSSortedArray', 'NSSound', 'NSSoundPboardType', 'NSSourceListBackgroundColor', 'NSSpecialPageOrder', 'NSSpecifierTest', 'NSSpeechCharacterModeProperty', 'NSSpeechCommandDelimiterProperty', 'NSSpeechCommandPrefix', 'NSSpeechCommandSuffix', 'NSSpeechCurrentVoiceProperty', 'NSSpeechDictionaryAbbreviations', 'NSSpeechDictionaryEntryPhonemes', 'NSSpeechDictionaryEntrySpelling', 'NSSpeechDictionaryLocaleIdentifier', 'NSSpeechDictionaryModificationDate', 'NSSpeechDictionaryPronunciations', 'NSSpeechErrorCount', 'NSSpeechErrorNewestCharacterOffset', 'NSSpeechErrorNewestCode', 'NSSpeechErrorOldestCharacterOffset', 'NSSpeechErrorOldestCode', 'NSSpeechErrorsProperty', 'NSSpeechImmediateBoundary', 'NSSpeechInputModeProperty', 'NSSpeechModeLiteral', 'NSSpeechModeNormal', 'NSSpeechModePhoneme', 'NSSpeechModeText', 'NSSpeechNumberModeProperty', 'NSSpeechOutputToFileURLProperty', 'NSSpeechPhonemeInfoExample', 'NSSpeechPhonemeInfoHiliteEnd', 'NSSpeechPhonemeInfoHiliteStart', 'NSSpeechPhonemeInfoOpcode', 'NSSpeechPhonemeInfoSymbol', 'NSSpeechPhonemeSymbolsProperty', 'NSSpeechPitchBaseProperty', 'NSSpeechPitchModProperty', 'NSSpeechRateProperty', 'NSSpeechRecentSyncProperty', 'NSSpeechRecognizer', 'NSSpeechRecognizerVars', 'NSSpeechResetProperty', 'NSSpeechSentenceBoundary', 'NSSpeechStatusNumberOfCharactersLeft', 'NSSpeechStatusOutputBusy', 'NSSpeechStatusOutputPaused', 'NSSpeechStatusPhonemeCode', 'NSSpeechStatusProperty', 'NSSpeechSynthesizer', 'NSSpeechSynthesizerInfoIdentifier', 'NSSpeechSynthesizerInfoProperty', 'NSSpeechSynthesizerInfoVersion', 'NSSpeechSynthesizerVars', 'NSSpeechVolumeProperty', 'NSSpeechWordBoundary', 'NSSpellChecker', 'NSSpellCheckingResult', 'NSSpellServer', 'NSSpellingLanguageTableView', 'NSSpellingPanel', 'NSSpellingStateAttributeName', 'NSSpellingStateGrammarFlag', 'NSSpellingStateSpellingFlag', 'NSSpellingSubstring', 'NSSplitView', 'NSSplitViewDidResizeSubviewsNotification', 'NSSplitViewDividerDragParams', 'NSSplitViewDividerStylePaneSplitter', 'NSSplitViewDividerStyleThick', 'NSSplitViewDividerStyleThin', 'NSSplitViewSplitter', 'NSSplitViewVariables', 'NSSplitViewWillResizeSubviewsNotification', 'NSSquareLineCapStyle', 'NSSquareStatusItemLength', 'NSStatusBar', 'NSStatusBarButton', 'NSStatusBarButtonCell', 'NSStatusBarWindow', 'NSStatusItem', 'NSStatusWindowLevel', 'NSStepper', 'NSStepperCell', 'NSStopFunctionKey', 'NSStopTouchingMeBox', 'NSStorage', 'NSStoreMapNode', 'NSStoreMapping', 'NSStoreMappingGenerator', 'NSStoreMigrationPolicy', 'NSStream', 'NSStreamDataWrittenToMemoryStreamKey', 'NSStreamEventEndEncountered', 'NSStreamEventErrorOccurred', 'NSStreamEventHasBytesAvailable', 'NSStreamEventHasSpaceAvailable', 'NSStreamEventNone', 'NSStreamEventOpenCompleted', 'NSStreamFileCurrentOffsetKey', 'NSStreamSOCKSErrorDomain', 'NSStreamSOCKSProxyConfigurationKey', 'NSStreamSOCKSProxyHostKey', 'NSStreamSOCKSProxyPasswordKey', 'NSStreamSOCKSProxyPortKey', 'NSStreamSOCKSProxyUserKey', 'NSStreamSOCKSProxyVersion4', 'NSStreamSOCKSProxyVersion5', 'NSStreamSOCKSProxyVersionKey', 'NSStreamSocketSSLErrorDomain', 'NSStreamSocketSecurityLevelKey', 'NSStreamSocketSecurityLevelNegotiatedSSL', 'NSStreamSocketSecurityLevelNone', 'NSStreamSocketSecurityLevelSSLv2', 'NSStreamSocketSecurityLevelSSLv3', 'NSStreamSocketSecurityLevelTLSv1', 'NSStreamStatusAtEnd', 'NSStreamStatusClosed', 'NSStreamStatusError', 'NSStreamStatusNotOpen', 'NSStreamStatusOpen', 'NSStreamStatusOpening', 'NSStreamStatusReading', 'NSStreamStatusWriting', 'NSStrikethroughColorAttributeName', 'NSStrikethroughStyleAttributeName', 'NSString', 'NSStringDrawingDisableScreenFontSubstitution', 'NSStringDrawingOneShot', 'NSStringDrawingTextStorage', 'NSStringDrawingTruncatesLastVisibleLine', 'NSStringDrawingUsesDeviceMetrics', 'NSStringDrawingUsesFontLeading', 'NSStringDrawingUsesLineFragmentOrigin', 'NSStringEncodingConversionAllowLossy', 'NSStringEncodingConversionExternalRepresentation', 'NSStringEncodingErrorKey', 'NSStringEnumerationByComposedCharacterSequences', 'NSStringEnumerationByLines', 'NSStringEnumerationByParagraphs', 'NSStringEnumerationBySentences', 'NSStringEnumerationByWords', 'NSStringEnumerationLocalized', 'NSStringEnumerationReverse', 'NSStringEnumerationSubstringNotRequired', 'NSStringFromClass', 'NSStringFromHashTable', 'NSStringFromMapTable', 'NSStringFromPoint', 'NSStringFromProtocol', 'NSStringFromRange', 'NSStringFromRect', 'NSStringFromSelector', 'NSStringFromSize', 'NSStringPboardType', 'NSStringPredicateOperator', 'NSStrokeColorAttributeName', 'NSStrokeWidthAttributeName', 'NSSubTextStorage', 'NSSubjectDocumentAttribute', 'NSSubmenuWindowLevel', 'NSSubqueryExpression', 'NSSubqueryExpressionType', 'NSSubrangeData', 'NSSubrectImageRep', 'NSSubstituteWebResource', 'NSSubstitutionCheckingResult', 'NSSubstringPredicateOperator', 'NSSumKeyValueOperator', 'NSSunOSOperatingSystem', 'NSSuperscriptAttributeName', 'NSSurface', 'NSSwapBigDoubleToHost', 'NSSwapBigFloatToHost', 'NSSwapBigIntToHost', 'NSSwapBigLongLongToHost', 'NSSwapBigLongToHost', 'NSSwapBigShortToHost', 'NSSwapDouble', 'NSSwapFloat', 'NSSwapHostDoubleToBig', 'NSSwapHostDoubleToLittle', 'NSSwapHostFloatToBig', 'NSSwapHostFloatToLittle', 'NSSwapHostIntToBig', 'NSSwapHostIntToLittle', 'NSSwapHostLongLongToBig', 'NSSwapHostLongLongToLittle', 'NSSwapHostLongToBig', 'NSSwapHostLongToLittle', 'NSSwapHostShortToBig', 'NSSwapHostShortToLittle', 'NSSwapInt', 'NSSwapLittleDoubleToHost', 'NSSwapLittleFloatToHost', 'NSSwapLittleIntToHost', 'NSSwapLittleLongLongToHost', 'NSSwapLittleLongToHost', 'NSSwapLittleShortToHost', 'NSSwapLong', 'NSSwapLongLong', 'NSSwapShort', 'NSSwappedDouble', 'NSSwappedFloat', 'NSSwitchButton', 'NSSymbolStringEncoding', 'NSSymbolicExpression', 'NSSynchronousURLConnectionDelegate', 'NSSysReqFunctionKey', 'NSSystemClockDidChangeNotification', 'NSSystemColorsDidChangeNotification', 'NSSystemDefined', 'NSSystemDefinedMask', 'NSSystemDomainMask', 'NSSystemFunctionKey', 'NSSystemInfoPanel', 'NSSystemStatusBar', 'NSSystemTimeZoneDidChangeNotification', 'NSTIFFCompressionCCITTFAX3', 'NSTIFFCompressionCCITTFAX4', 'NSTIFFCompressionJPEG', 'NSTIFFCompressionLZW', 'NSTIFFCompressionNEXT', 'NSTIFFCompressionNone', 'NSTIFFCompressionOldJPEG', 'NSTIFFCompressionPackBits', 'NSTIFFException', 'NSTIFFFileType', 'NSTIFFPboardType', 'NSTabCharacter', 'NSTabColumnTerminatorsAttributeName', 'NSTabTextMovement', 'NSTabView', 'NSTabViewBinder', 'NSTabViewItem', 'NSTabWell', 'NSTableAssociation', 'NSTableBackgroundView', 'NSTableBinder', 'NSTableCellView', 'NSTableCellViewAux', 'NSTableColumn', 'NSTableColumnAutoresizingMask', 'NSTableColumnBinder', 'NSTableColumnDragInfo', 'NSTableColumnNoResizing', 'NSTableColumnUserResizingMask', 'NSTableDragInfo', 'NSTableHeaderCell', 'NSTableHeaderCellView', 'NSTableHeaderData', 'NSTableHeaderView', 'NSTableOptions', 'NSTableOptionsPanel', 'NSTableOverlappingColumnClipHelper', 'NSTableRow', 'NSTableRowAndCellTracker', 'NSTableRowData', 'NSTableRowView', 'NSTableUpdateData', 'NSTableUpdateDeleteItem', 'NSTableUpdateInsertItem', 'NSTableUpdateItem2', 'NSTableUpdateMoveItem', 'NSTableView', 'NSTableViewCellMockElement', 'NSTableViewCellProxy', 'NSTableViewChildCellProxy', 'NSTableViewColumnDidMoveNotification', 'NSTableViewColumnDidResizeNotification', 'NSTableViewDraggingDestinationFeedbackStyleNone', 'NSTableViewDraggingDestinationFeedbackStyleRegular', 'NSTableViewDraggingDestinationFeedbackStyleSourceList', 'NSTableViewDropAbove', 'NSTableViewDropFeedbackData', 'NSTableViewDropOn', 'NSTableViewDynamicToolTipManager', 'NSTableViewFirstColumnOnlyAutoresizingStyle', 'NSTableViewGridNone', 'NSTableViewLastColumnOnlyAutoresizingStyle', 'NSTableViewListCellMockElement', 'NSTableViewListCellProxy', 'NSTableViewNoColumnAutoresizing', 'NSTableViewReverseSequentialColumnAutoresizingStyle', 'NSTableViewSelectionDidChangeNotification', 'NSTableViewSelectionHighlightStyleNone', 'NSTableViewSelectionHighlightStyleRegular', 'NSTableViewSelectionHighlightStyleSourceList', 'NSTableViewSelectionIsChangingNotification', 'NSTableViewSequentialColumnAutoresizingStyle', 'NSTableViewSolidHorizontalGridLineMask', 'NSTableViewSolidVerticalGridLineMask', 'NSTableViewUniformColumnAutoresizingStyle', 'NSTabletPoint', 'NSTabletPointEventSubtype', 'NSTabletPointMask', 'NSTabletProximity', 'NSTabletProximityEventSubtype', 'NSTabletProximityMask', 'NSTabularTextPboardType', 'NSTargetAnimationInfo', 'NSTargetBinding', 'NSTask', 'NSTaskDidTerminateNotification', 'NSTaskTerminationReasonExit', 'NSTaskTerminationReasonUncaughtSignal', 'NSTempAttributeDictionary', 'NSTemplatizingImageRep', 'NSTemporaryDirectory', 'NSTemporaryObjectID', 'NSTerminateCancel', 'NSTerminateLater', 'NSTerminateNow', 'NSTernaryExpression', 'NSText', 'NSTextAttachment', 'NSTextAttachmentCell', 'NSTextAttachmentEditor', 'NSTextAttachmentImageView', 'NSTextBlock', 'NSTextBlockAbsoluteValueType', 'NSTextBlockBaselineAlignment', 'NSTextBlockBorder', 'NSTextBlockBottomAlignment', 'NSTextBlockHeight', 'NSTextBlockLayoutHelper', 'NSTextBlockMargin', 'NSTextBlockMaximumHeight', 'NSTextBlockMaximumWidth', 'NSTextBlockMiddleAlignment', 'NSTextBlockMinimumHeight', 'NSTextBlockMinimumWidth', 'NSTextBlockPadding', 'NSTextBlockPercentageValueType', 'NSTextBlockTopAlignment', 'NSTextBlockWidth', 'NSTextCellType', 'NSTextCheckingAllCustomTypes', 'NSTextCheckingAllSystemTypes', 'NSTextCheckingAllTypes', 'NSTextCheckingCityKey', 'NSTextCheckingCountryKey', 'NSTextCheckingDocumentAuthorKey', 'NSTextCheckingDocumentTitleKey', 'NSTextCheckingDocumentURLKey', 'NSTextCheckingJobTitleKey', 'NSTextCheckingNameKey', 'NSTextCheckingOperation', 'NSTextCheckingOrganizationKey', 'NSTextCheckingOrthographyKey', 'NSTextCheckingPhoneKey', 'NSTextCheckingQuotesKey', 'NSTextCheckingReferenceDateKey', 'NSTextCheckingReferenceTimeZoneKey', 'NSTextCheckingReplacementsKey', 'NSTextCheckingResult', 'NSTextCheckingStateKey', 'NSTextCheckingStreetKey', 'NSTextCheckingTypeAddress', 'NSTextCheckingTypeCorrection', 'NSTextCheckingTypeDash', 'NSTextCheckingTypeDate', 'NSTextCheckingTypeGrammar', 'NSTextCheckingTypeLink', 'NSTextCheckingTypeOrthography', 'NSTextCheckingTypeQuote', 'NSTextCheckingTypeReplacement', 'NSTextCheckingTypeSpelling', 'NSTextCheckingZIPKey', 'NSTextColorBinder', 'NSTextColorBinding', 'NSTextContainer', 'NSTextDidBeginEditingNotification', 'NSTextDidChangeNotification', 'NSTextDidEndEditingNotification', 'NSTextDragInfo', 'NSTextEncodingNameDocumentAttribute', 'NSTextEncodingNameDocumentOption', 'NSTextField', 'NSTextFieldAndStepperDatePickerStyle', 'NSTextFieldCell', 'NSTextFieldDatePickerStyle', 'NSTextFieldRoundedBezel', 'NSTextFieldSquareBezel', 'NSTextFinder', 'NSTextFinderAsyncSearch', 'NSTextFinderBarSearchField', 'NSTextFinderBarSearchFieldCell', 'NSTextFinderBarTextField', 'NSTextFinderBarTextFieldCell', 'NSTextFinderBarView', 'NSTextFinderIndicatorManager', 'NSTextInputContext', 'NSTextInputContextKeyboardSelectionDidChangeNotification', 'NSTextLineTooLongException', 'NSTextList', 'NSTextListPrependEnclosingMarker', 'NSTextNoSelectionException', 'NSTextReadException', 'NSTextReadInapplicableDocumentTypeError', 'NSTextReadWriteErrorMaximum', 'NSTextReadWriteErrorMinimum', 'NSTextReplacementNode', 'NSTextRulerOptions', 'NSTextSizeMultiplierDocumentOption', 'NSTextStorage', 'NSTextStorageCharacterArray', 'NSTextStorageDidProcessEditingNotification', 'NSTextStorageEditedAttributes', 'NSTextStorageEditedCharacters', 'NSTextStorageElementArray', 'NSTextStorageWillProcessEditingNotification', 'NSTextTab', 'NSTextTable', 'NSTextTableAutomaticLayoutAlgorithm', 'NSTextTableBlock', 'NSTextTableFixedLayoutAlgorithm', 'NSTextTemplate', 'NSTextValueBinder', 'NSTextView', 'NSTextViewAttachmentEditCompletionAnimation', 'NSTextViewCompletionController', 'NSTextViewCompletionTableView', 'NSTextViewCompletionWindow', 'NSTextViewDidChangeSelectionNotification', 'NSTextViewDidChangeTypingAttributesNotification', 'NSTextViewIvars', 'NSTextViewSharedData', 'NSTextViewTemplate', 'NSTextViewWillChangeNotifyingTextViewNotification', 'NSTextWriteException', 'NSTextWriteInapplicableDocumentTypeError', 'NSTextWritingDirectionEmbedding', 'NSTextWritingDirectionOverride', 'NSTexturedBackgroundWindowMask', 'NSTexturedComboBoxCell', 'NSTexturedRoundedBezelStyle', 'NSTexturedSquareBezelStyle', 'NSThemeAutosaveButton', 'NSThemeAutosaveButtonCell', 'NSThemeDocumentButton', 'NSThemeDocumentButtonCell', 'NSThemeDocumentButtonPopUpMenuProxy', 'NSThemeFrame', 'NSThickSquareBezelStyle', 'NSThickerSquareBezelStyle', 'NSThisDayDesignations', 'NSThousandsSeparator', 'NSThread', 'NSThreadWillExitNotification', 'NSTickMarkAbove', 'NSTickMarkBelow', 'NSTickMarkLeft', 'NSTickMarkRight', 'NSTimeDateFormatString', 'NSTimeFormatString', 'NSTimeIntervalSince1970', 'NSTimeZone', 'NSTimeZoneDatePickerElementFlag', 'NSTimeZoneNameStyleDaylightSaving', 'NSTimeZoneNameStyleGeneric', 'NSTimeZoneNameStyleShortDaylightSaving', 'NSTimeZoneNameStyleShortGeneric', 'NSTimeZoneNameStyleShortStandard', 'NSTimeZoneNameStyleStandard', 'NSTimeoutDocumentOption', 'NSTimer', 'NSTitleBinder', 'NSTitleBinding', 'NSTitleDocumentAttribute', 'NSTitledFrame', 'NSTitledWindowMask', 'NSToggleButton', 'NSTokenAttachment', 'NSTokenAttachmentCell', 'NSTokenField', 'NSTokenFieldCell', 'NSTokenTextView', 'NSToolTip', 'NSToolTipAttributeName', 'NSToolTipBinding', 'NSToolTipManager', 'NSToolTipPanel', 'NSToolTipStringDrawingLayoutManager', 'NSToolbar', 'NSToolbarButton', 'NSToolbarClippedItemsIndicator', 'NSToolbarConfigPanel', 'NSToolbarCustomizeToolbarItemIdentifier', 'NSToolbarDidRemoveItemNotification', 'NSToolbarDisplayModeDefault', 'NSToolbarDisplayModeIconAndLabel', 'NSToolbarDisplayModeIconOnly', 'NSToolbarDisplayModeLabelOnly', 'NSToolbarFlexibleSpaceItem', 'NSToolbarFlexibleSpaceItemIdentifier', 'NSToolbarFullScreenContentView', 'NSToolbarFullScreenResetableAnimation', 'NSToolbarFullScreenWindow', 'NSToolbarFullScreenWindowManager', 'NSToolbarGroupView', 'NSToolbarItem', 'NSToolbarItemConfigWrapper', 'NSToolbarItemGroup', 'NSToolbarItemViewer', 'NSToolbarItemVisibilityPriorityHigh', 'NSToolbarItemVisibilityPriorityLow', 'NSToolbarItemVisibilityPriorityStandard', 'NSToolbarItemVisibilityPriorityUser', 'NSToolbarPoofAnimator', 'NSToolbarPrintItemIdentifier', 'NSToolbarSeparatorItem', 'NSToolbarSeparatorItemIdentifier', 'NSToolbarShowColorsItemIdentifier', 'NSToolbarShowFontsItemIdentifier', 'NSToolbarSizeModeDefault', 'NSToolbarSizeModeRegular', 'NSToolbarSizeModeSmall', 'NSToolbarSpaceItem', 'NSToolbarSpaceItemIdentifier', 'NSToolbarView', 'NSToolbarWillAddItemNotification', 'NSTopMarginDocumentAttribute', 'NSTopTabsBezelBorder', 'NSTornOffMenuWindowLevel', 'NSTouch', 'NSTouchPhaseAny', 'NSTouchPhaseBegan', 'NSTouchPhaseCancelled', 'NSTouchPhaseEnded', 'NSTouchPhaseMoved', 'NSTouchPhaseStationary', 'NSTouchPhaseTouching', 'NSTracer', 'NSTrackModeMatrix', 'NSTrackableOutlineView', 'NSTrackingActiveAlways', 'NSTrackingActiveInActiveApp', 'NSTrackingActiveInKeyWindow', 'NSTrackingActiveWhenFirstResponder', 'NSTrackingArea', 'NSTrackingAssumeInside', 'NSTrackingCursorUpdate', 'NSTrackingEnabledDuringMouseDrag', 'NSTrackingInVisibleRect', 'NSTrackingInfoImpl', 'NSTrackingMouseEnteredAndExited', 'NSTrackingMouseMoved', 'NSTransitInformationCheckingResult', 'NSTransparentBinding', 'NSTreeController', 'NSTreeControllerTreeNode', 'NSTreeDetailBinder', 'NSTreeNode', 'NSTruePredicate', 'NSTwoByteGlyphPacking', 'NSTypeSelectBackgroundView', 'NSTypeSelectPanel', 'NSTypedStreamVersionException', 'NSTypesetter', 'NSTypesetterBehavior_10_2', 'NSTypesetterBehavior_10_2_WithCompatibility', 'NSTypesetterBehavior_10_3', 'NSTypesetterBehavior_10_4', 'NSTypesetterContainerBreakAction', 'NSTypesetterHorizontalTabAction', 'NSTypesetterLatestBehavior', 'NSTypesetterLineBreakAction', 'NSTypesetterOriginalBehavior', 'NSTypesetterParagraphBreakAction', 'NSTypesetterWhitespaceAction', 'NSTypesetterZeroAdvancementAction', 'NSUIHeartBeat', 'NSUIntegerMax', 'NSURL', 'NSURLAttributeModificationDateKey', 'NSURLAuthenticationChallenge', 'NSURLAuthenticationChallengeInternal', 'NSURLAuthenticationMethodClientCertificate', 'NSURLAuthenticationMethodDefault', 'NSURLAuthenticationMethodHTMLForm', 'NSURLAuthenticationMethodHTTPBasic', 'NSURLAuthenticationMethodHTTPDigest', 'NSURLAuthenticationMethodServerTrust', 'NSURLBookmarkCreationMinimalBookmark', 'NSURLBookmarkCreationPreferFileIDResolution', 'NSURLBookmarkCreationSuitableForBookmarkFile', 'NSURLBookmarkResolutionWithoutMounting', 'NSURLBookmarkResolutionWithoutUI', 'NSURLCache', 'NSURLCacheInternal', 'NSURLCacheNode', 'NSURLCacheStorageAllowed', 'NSURLCacheStorageAllowedInMemoryOnly', 'NSURLCacheStorageNotAllowed', 'NSURLConnection', 'NSURLConnectionDelegateProxy', 'NSURLConnectionHandle', 'NSURLConnectionInternal', 'NSURLContentAccessDateKey', 'NSURLContentModificationDateKey', 'NSURLCreationDateKey', 'NSURLCredential', 'NSURLCredentialPersistenceForSession', 'NSURLCredentialPersistenceNone', 'NSURLCredentialPersistencePermanent', 'NSURLCredentialStorage', 'NSURLCredentialStorageChangedNotification', 'NSURLCustomIconKey', 'NSURLDirectoryEnumerator', 'NSURLDownload', 'NSURLDownloadInternal', 'NSURLEffectiveIconKey', 'NSURLError', 'NSURLErrorBadServerResponse', 'NSURLErrorBadURL', 'NSURLErrorCancelled', 'NSURLErrorCannotCloseFile', 'NSURLErrorCannotConnectToHost', 'NSURLErrorCannotCreateFile', 'NSURLErrorCannotDecodeContentData', 'NSURLErrorCannotDecodeRawData', 'NSURLErrorCannotFindHost', 'NSURLErrorCannotLoadFromNetwork', 'NSURLErrorCannotMoveFile', 'NSURLErrorCannotOpenFile', 'NSURLErrorCannotParseResponse', 'NSURLErrorCannotRemoveFile', 'NSURLErrorCannotWriteToFile', 'NSURLErrorClientCertificateRejected', 'NSURLErrorClientCertificateRequired', 'NSURLErrorDNSLookupFailed', 'NSURLErrorDataLengthExceedsMaximum', 'NSURLErrorDomain', 'NSURLErrorDownloadDecodingFailedMidStream', 'NSURLErrorDownloadDecodingFailedToComplete', 'NSURLErrorFailingURLErrorKey', 'NSURLErrorFailingURLPeerTrustErrorKey', 'NSURLErrorFailingURLStringErrorKey', 'NSURLErrorFileDoesNotExist', 'NSURLErrorFileIsDirectory', 'NSURLErrorHTTPTooManyRedirects', 'NSURLErrorKey', 'NSURLErrorNetworkConnectionLost', 'NSURLErrorNoPermissionsToReadFile', 'NSURLErrorNotConnectedToInternet', 'NSURLErrorRedirectToNonExistentLocation', 'NSURLErrorResourceUnavailable', 'NSURLErrorSecureConnectionFailed', 'NSURLErrorServerCertificateHasBadDate', 'NSURLErrorServerCertificateHasUnknownRoot', 'NSURLErrorServerCertificateNotYetValid', 'NSURLErrorServerCertificateUntrusted', 'NSURLErrorTimedOut', 'NSURLErrorUnknown', 'NSURLErrorUnsupportedURL', 'NSURLErrorUserAuthenticationRequired', 'NSURLErrorUserCancelledAuthentication', 'NSURLErrorZeroByteResource', 'NSURLFileAllocatedSizeKey', 'NSURLFileScheme', 'NSURLFileSizeKey', 'NSURLFileTypeMappings', 'NSURLFileTypeMappingsInternal', 'NSURLHandle', 'NSURLHandleLoadFailed', 'NSURLHandleLoadInProgress', 'NSURLHandleLoadSucceeded', 'NSURLHandleNotLoaded', 'NSURLHandleProtocol', 'NSURLHasHiddenExtensionKey', 'NSURLHostNameAddressInfo', 'NSURLIsAliasFileKey', 'NSURLIsDirectoryKey', 'NSURLIsHiddenKey', 'NSURLIsPackageKey', 'NSURLIsRegularFileKey', 'NSURLIsSymbolicLinkKey', 'NSURLIsSystemImmutableKey', 'NSURLIsUserImmutableKey', 'NSURLIsVolumeKey', 'NSURLKeyValuePair', 'NSURLLabelColorKey', 'NSURLLabelNumberKey', 'NSURLLinkCountKey', 'NSURLLocalizedLabelKey', 'NSURLLocalizedNameKey', 'NSURLLocalizedTypeDescriptionKey', 'NSURLNameKey', 'NSURLParentDirectoryURLKey', 'NSURLPboardType', 'NSURLProtectionSpace', 'NSURLProtectionSpaceFTPProxy', 'NSURLProtectionSpaceHTTPProxy', 'NSURLProtectionSpaceHTTPSProxy', 'NSURLProtectionSpaceSOCKSProxy', 'NSURLProtocol', 'NSURLProtocolInternal', 'NSURLQueue', 'NSURLQueueNode', 'NSURLRequest', 'NSURLRequestInternal', 'NSURLRequestReloadIgnoringCacheData', 'NSURLRequestReloadIgnoringLocalAndRemoteCacheData', 'NSURLRequestReloadIgnoringLocalCacheData', 'NSURLRequestReloadRevalidatingCacheData', 'NSURLRequestReturnCacheDataDontLoad', 'NSURLRequestReturnCacheDataElseLoad', 'NSURLRequestUseProtocolCachePolicy', 'NSURLResponse', 'NSURLResponseInternal', 'NSURLResponseUnknownLength', 'NSURLTypeIdentifierKey', 'NSURLUpload', 'NSURLUploadAuthenticationChallenge', 'NSURLVolumeAvailableCapacityKey', 'NSURLVolumeIsJournalingKey', 'NSURLVolumeLocalizedFormatDescriptionKey', 'NSURLVolumeResourceCountKey', 'NSURLVolumeSupportsCasePreservedNamesKey', 'NSURLVolumeSupportsCaseSensitiveNamesKey', 'NSURLVolumeSupportsHardLinksKey', 'NSURLVolumeSupportsJournalingKey', 'NSURLVolumeSupportsPersistentIDsKey', 'NSURLVolumeSupportsSparseFilesKey', 'NSURLVolumeSupportsSymbolicLinksKey', 'NSURLVolumeSupportsZeroRunsKey', 'NSURLVolumeTotalCapacityKey', 'NSURLVolumeURLKey', 'NSUTF16BigEndianStringEncoding', 'NSUTF16LittleEndianStringEncoding', 'NSUTF16StringEncoding', 'NSUTF32BigEndianStringEncoding', 'NSUTF32LittleEndianStringEncoding', 'NSUTF32StringEncoding', 'NSUTF8StringEncoding', 'NSUbiquitousKeyValueStore', 'NSUnarchiveFromDataTransformerName', 'NSUnarchiver', 'NSUnboldFontMask', 'NSUncachedRead', 'NSUndefinedDateComponent', 'NSUndefinedKeyException', 'NSUnderlineByWordMask', 'NSUnderlineColorAttributeName', 'NSUnderlinePatternDash', 'NSUnderlinePatternDashDot', 'NSUnderlinePatternDashDotDot', 'NSUnderlinePatternDot', 'NSUnderlinePatternSolid', 'NSUnderlineStrikethroughMask', 'NSUnderlineStyleAttributeName', 'NSUnderlineStyleDouble', 'NSUnderlineStyleNone', 'NSUnderlineStyleSingle', 'NSUnderlineStyleThick', 'NSUnderlyingErrorKey', 'NSUndoCloseGroupingRunLoopOrdering', 'NSUndoFunctionKey', 'NSUndoManager', 'NSUndoManagerCheckpointNotification', 'NSUndoManagerDidOpenUndoGroupNotification', 'NSUndoManagerDidRedoChangeNotification', 'NSUndoManagerDidUndoChangeNotification', 'NSUndoManagerProxy', 'NSUndoManagerWillCloseUndoGroupNotification', 'NSUndoManagerWillRedoChangeNotification', 'NSUndoManagerWillUndoChangeNotification', 'NSUndoReplaceCharacters', 'NSUndoSetAttributes', 'NSUndoTextOperation', 'NSUndoTyping', 'NSUnicodeStringEncoding', 'NSUnifiedTitleAndToolbarWindowMask', 'NSUnionOfArraysKeyValueOperator', 'NSUnionOfObjectsKeyValueOperator', 'NSUnionOfSetsKeyValueOperator', 'NSUnionRange', 'NSUnionRect', 'NSUnionSetExpressionType', 'NSUniqueIDSpecifier', 'NSUnitalicFontMask', 'NSUnkeyedPortCoder', 'NSUnknownColorSpaceModel', 'NSUnknownKeyScriptError', 'NSUnknownKeySpecifierError', 'NSUnknownPageOrder', 'NSUnknownPointingDevice', 'NSUnregisterServicesProvider', 'NSUnscaledWindowMask', 'NSUpArrowFunctionKey', 'NSUpTextMovement', 'NSUpdateDynamicServices', 'NSUpdateWindowsRunLoopOrdering', 'NSUserCancelledError', 'NSUserDefaults', 'NSUserDefaultsController', 'NSUserDefaultsDidChangeNotification', 'NSUserDirectory', 'NSUserDomainMask', 'NSUserFunctionKey', 'NSUserInterfaceLayoutDirectionLeftToRight', 'NSUserInterfaceLayoutDirectionRightToLeft', 'NSUserInterfaceTheme', 'NSUserName', 'NSUtilityWindowMask', 'NSVCardPboardType', 'NSValidatesImmediatelyBindingOption', 'NSValidationErrorLocalizationPolicy', 'NSValidationErrorMaximum', 'NSValidationErrorMinimum', 'NSValue', 'NSValueBinder', 'NSValueBinding', 'NSValuePathBinding', 'NSValueTransformer', 'NSValueTransformerBindingOption', 'NSValueTransformerNameBindingOption', 'NSValueURLBinding', 'NSVariableAssignmentExpression', 'NSVariableExpression', 'NSVariableExpressionType', 'NSVariableStatusItemLength', 'NSVerticalRuler', 'NSViaPanelFontAction', 'NSView', 'NSViewAnimation', 'NSViewAnimationEffectKey', 'NSViewAnimationEndFrameKey', 'NSViewAnimationFadeInEffect', 'NSViewAnimationFadeOutEffect', 'NSViewAnimationStartFrameKey', 'NSViewAnimationTargetKey', 'NSViewBoundsDidChangeNotification', 'NSViewBuffer', 'NSViewController', 'NSViewDidUpdateTrackingAreasNotification', 'NSViewDynamicToolTipManager', 'NSViewFocusDidChangeNotification', 'NSViewFrameDidChangeNotification', 'NSViewGlobalFrameDidChangeNotification', 'NSViewHeightSizable', 'NSViewHierarchyLock', 'NSViewLayerContentsPlacementBottom', 'NSViewLayerContentsPlacementBottomLeft', 'NSViewLayerContentsPlacementBottomRight', 'NSViewLayerContentsPlacementCenter', 'NSViewLayerContentsPlacementLeft', 'NSViewLayerContentsPlacementRight', 'NSViewLayerContentsPlacementScaleAxesIndependently', 'NSViewLayerContentsPlacementScaleProportionallyToFill', 'NSViewLayerContentsPlacementScaleProportionallyToFit', 'NSViewLayerContentsPlacementTop', 'NSViewLayerContentsPlacementTopLeft', 'NSViewLayerContentsPlacementTopRight', 'NSViewLayerContentsRedrawBeforeViewResize', 'NSViewLayerContentsRedrawDuringViewResize', 'NSViewLayerContentsRedrawNever', 'NSViewLayerContentsRedrawOnSetNeedsDisplay', 'NSViewMaxXMargin', 'NSViewMaxYMargin', 'NSViewMinXMargin', 'NSViewMinYMargin', 'NSViewModeDocumentAttribute', 'NSViewMultiClipDrawingHelper', 'NSViewNotSizable', 'NSViewSizeDocumentAttribute', 'NSViewStateBinder', 'NSViewTemplate', 'NSViewTextAttachmentCell', 'NSViewTextAttachmentCellHelper', 'NSViewWidthSizable', 'NSViewWindowBackingStoreBuffer', 'NSViewZoomDocumentAttribute', 'NSVisibleBinding', 'NSVoiceAge', 'NSVoiceDemoText', 'NSVoiceGender', 'NSVoiceGenderFemale', 'NSVoiceGenderMale', 'NSVoiceGenderNeuter', 'NSVoiceIdentifier', 'NSVoiceIndividuallySpokenCharacters', 'NSVoiceLanguage', 'NSVoiceLocaleIdentifier', 'NSVoiceName', 'NSVoiceSupportedCharacters', 'NSVolumeEnumerationProduceFileReferenceURLs', 'NSVolumeEnumerationSkipHiddenVolumes', 'NSWantsBidiLevels', 'NSWarningAlertStyle', 'NSWarningValueBinding', 'NSWeakCallback', 'NSWeakPointerValue', 'NSWebArchiveTextDocumentType', 'NSWebPreferencesDocumentOption', 'NSWebResourceLoadDelegateDocumentOption', 'NSWeekCalendarUnit', 'NSWeekDayNameArray', 'NSWeekdayCalendarUnit', 'NSWeekdayOrdinalCalendarUnit', 'NSWheelModeColorPanel', 'NSWhite', 'NSWhoseSpecifier', 'NSWhoseTest', 'NSWidth', 'NSWidthBinding', 'NSWidthInsensitiveSearch', 'NSWillBecomeMultiThreadedNotification', 'NSWindow', 'NSWindowAbove', 'NSWindowAnchorInfo', 'NSWindowAuxiliary', 'NSWindowBackingLocationDefault', 'NSWindowBackingLocationMainMemory', 'NSWindowBackingLocationVideoMemory', 'NSWindowBelow', 'NSWindowBinder', 'NSWindowCloseButton', 'NSWindowCollectionBehaviorCanJoinAllSpaces', 'NSWindowCollectionBehaviorDefault', 'NSWindowCollectionBehaviorIgnoresCycle', 'NSWindowCollectionBehaviorManaged', 'NSWindowCollectionBehaviorMoveToActiveSpace', 'NSWindowCollectionBehaviorParticipatesInCycle', 'NSWindowCollectionBehaviorStationary', 'NSWindowCollectionBehaviorTransient', 'NSWindowController', 'NSWindowControllerMoreIVars', 'NSWindowDepthOnehundredtwentyeightBitRGB', 'NSWindowDepthSixtyfourBitRGB', 'NSWindowDepthTwentyfourBitRGB', 'NSWindowDidBecomeKeyNotification', 'NSWindowDidBecomeMainNotification', 'NSWindowDidChangeScreenNotification', 'NSWindowDidChangeScreenProfileNotification', 'NSWindowDidDeminiaturizeNotification', 'NSWindowDidEndLiveResizeNotification', 'NSWindowDidEndSheetNotification', 'NSWindowDidExposeNotification', 'NSWindowDidMiniaturizeNotification', 'NSWindowDidMoveNotification', 'NSWindowDidResignKeyNotification', 'NSWindowDidResignMainNotification', 'NSWindowDidResizeNotification', 'NSWindowDidUpdateNotification', 'NSWindowDocumentIconButton', 'NSWindowExposedEventType', 'NSWindowFullScreenController', 'NSWindowGraphicsContext', 'NSWindowList', 'NSWindowListForContext', 'NSWindowMenuItem', 'NSWindowMiniaturizeButton', 'NSWindowMovedEventType', 'NSWindowNumberListAllApplications', 'NSWindowNumberListAllSpaces', 'NSWindowOut', 'NSWindowScaleAnimation', 'NSWindowServerCommunicationException', 'NSWindowSharingNone', 'NSWindowSharingReadOnly', 'NSWindowSharingReadWrite', 'NSWindowTemplate', 'NSWindowTitleBinder', 'NSWindowToolbarButton', 'NSWindowWillBeginSheetNotification', 'NSWindowWillCloseNotification', 'NSWindowWillMiniaturizeNotification', 'NSWindowWillMoveNotification', 'NSWindowWillStartLiveResizeNotification', 'NSWindowZoomButton', 'NSWindows95InterfaceStyle', 'NSWindows95OperatingSystem', 'NSWindowsCP1250StringEncoding', 'NSWindowsCP1251StringEncoding', 'NSWindowsCP1252StringEncoding', 'NSWindowsCP1253StringEncoding', 'NSWindowsCP1254StringEncoding', 'NSWindowsNTOperatingSystem', 'NSWordMLReader', 'NSWordMLTextDocumentType', 'NSWordMLWriter', 'NSWordTablesReadException', 'NSWordTablesWriteException', 'NSWorkspace', 'NSWorkspaceActiveSpaceDidChangeNotification', 'NSWorkspaceApplicationKVOHelper', 'NSWorkspaceApplicationKey', 'NSWorkspaceCompressOperation', 'NSWorkspaceCopyOperation', 'NSWorkspaceDecompressOperation', 'NSWorkspaceDecryptOperation', 'NSWorkspaceDesktopImageAllowClippingKey', 'NSWorkspaceDesktopImageFillColorKey', 'NSWorkspaceDesktopImageScalingKey', 'NSWorkspaceDestroyOperation', 'NSWorkspaceDidActivateApplicationNotification', 'NSWorkspaceDidChangeFileLabelsNotification', 'NSWorkspaceDidDeactivateApplicationNotification', 'NSWorkspaceDidHideApplicationNotification', 'NSWorkspaceDidLaunchApplicationNotification', 'NSWorkspaceDidMountNotification', 'NSWorkspaceDidPerformFileOperationNotification', 'NSWorkspaceDidRenameVolumeNotification', 'NSWorkspaceDidTerminateApplicationNotification', 'NSWorkspaceDidUnhideApplicationNotification', 'NSWorkspaceDidUnmountNotification', 'NSWorkspaceDidWakeNotification', 'NSWorkspaceDuplicateOperation', 'NSWorkspaceEncryptOperation', 'NSWorkspaceLaunchAllowingClassicStartup', 'NSWorkspaceLaunchAndHide', 'NSWorkspaceLaunchAndHideOthers', 'NSWorkspaceLaunchAndPrint', 'NSWorkspaceLaunchAsync', 'NSWorkspaceLaunchConfigurationAppleEvent', 'NSWorkspaceLaunchConfigurationArchitecture', 'NSWorkspaceLaunchConfigurationArguments', 'NSWorkspaceLaunchConfigurationEnvironment', 'NSWorkspaceLaunchDefault', 'NSWorkspaceLaunchInhibitingBackgroundOnly', 'NSWorkspaceLaunchNewInstance', 'NSWorkspaceLaunchPreferringClassic', 'NSWorkspaceLaunchWithoutActivation', 'NSWorkspaceLaunchWithoutAddingToRecents', 'NSWorkspaceLinkOperation', 'NSWorkspaceMoveOperation', 'NSWorkspaceNotificationCenter', 'NSWorkspaceRecycleOperation', 'NSWorkspaceScreensDidSleepNotification', 'NSWorkspaceScreensDidWakeNotification', 'NSWorkspaceSessionDidBecomeActiveNotification', 'NSWorkspaceSessionDidResignActiveNotification', 'NSWorkspaceVolumeLocalizedNameKey', 'NSWorkspaceVolumeOldLocalizedNameKey', 'NSWorkspaceVolumeOldURLKey', 'NSWorkspaceVolumeURLKey', 'NSWorkspaceWillLaunchApplicationNotification', 'NSWorkspaceWillPowerOffNotification', 'NSWorkspaceWillSleepNotification', 'NSWorkspaceWillUnmountNotification', 'NSWrapCalendarComponents', 'NSWrapperCellView', 'NSWritingDirectionAttributeName', 'NSWritingDirectionLeftToRight', 'NSWritingDirectionNatural', 'NSWritingDirectionRightToLeft', 'NSXMLAttributeCDATAKind', 'NSXMLAttributeDeclaration', 'NSXMLAttributeDeclarationKind', 'NSXMLAttributeEntitiesKind', 'NSXMLAttributeEntityKind', 'NSXMLAttributeEnumerationKind', 'NSXMLAttributeIDKind', 'NSXMLAttributeIDRefKind', 'NSXMLAttributeIDRefsKind', 'NSXMLAttributeKind', 'NSXMLAttributeNMTokenKind', 'NSXMLAttributeNMTokensKind', 'NSXMLAttributeNotationKind', 'NSXMLChildren', 'NSXMLCommentKind', 'NSXMLContext', 'NSXMLDTD', 'NSXMLDTDKind', 'NSXMLDTDNode', 'NSXMLDocument', 'NSXMLDocumentHTMLKind', 'NSXMLDocumentIncludeContentTypeDeclaration', 'NSXMLDocumentKind', 'NSXMLDocumentMap', 'NSXMLDocumentMapNode', 'NSXMLDocumentTextKind', 'NSXMLDocumentTidyHTML', 'NSXMLDocumentTidyXML', 'NSXMLDocumentValidate', 'NSXMLDocumentXHTMLKind', 'NSXMLDocumentXInclude', 'NSXMLDocumentXMLKind', 'NSXMLElement', 'NSXMLElementDeclarationAnyKind', 'NSXMLElementDeclarationContent', 'NSXMLElementDeclarationElementKind', 'NSXMLElementDeclarationEmptyKind', 'NSXMLElementDeclarationKind', 'NSXMLElementDeclarationMixedKind', 'NSXMLElementDeclarationUndefinedKind', 'NSXMLElementKind', 'NSXMLEntityDeclarationKind', 'NSXMLEntityGeneralKind', 'NSXMLEntityParameterKind', 'NSXMLEntityParsedKind', 'NSXMLEntityPredefined', 'NSXMLEntityUnparsedKind', 'NSXMLFidelityElement', 'NSXMLFidelityNode', 'NSXMLInvalidKind', 'NSXMLNSArrayTransformerName', 'NSXMLNSDataTransformerName', 'NSXMLNSDateTransformerName', 'NSXMLNSNumberTransformerName', 'NSXMLNSURLTransformerName', 'NSXMLNamedFidelityNode', 'NSXMLNamedNode', 'NSXMLNamespaceKind', 'NSXMLNode', 'NSXMLNodeCompactEmptyElement', 'NSXMLNodeExpandEmptyElement', 'NSXMLNodeIsCDATA', 'NSXMLNodeOptionsNone', 'NSXMLNodePreserveAll', 'NSXMLNodePreserveAttributeOrder', 'NSXMLNodePreserveCDATA', 'NSXMLNodePreserveCharacterReferences', 'NSXMLNodePreserveDTD', 'NSXMLNodePreserveEmptyElements', 'NSXMLNodePreserveEntities', 'NSXMLNodePreserveNamespaceOrder', 'NSXMLNodePreservePrefixes', 'NSXMLNodePreserveQuotes', 'NSXMLNodePreserveWhitespace', 'NSXMLNodePrettyPrint', 'NSXMLNodeUseDoubleQuotes', 'NSXMLNodeUseSingleQuotes', 'NSXMLNotationDeclarationKind', 'NSXMLObjectStore', 'NSXMLObjectStore2', 'NSXMLObjectStoreCacheNode2', 'NSXMLParser', 'NSXMLParserAttributeHasNoValueError', 'NSXMLParserAttributeListNotFinishedError', 'NSXMLParserAttributeListNotStartedError', 'NSXMLParserAttributeNotFinishedError', 'NSXMLParserAttributeNotStartedError', 'NSXMLParserAttributeRedefinedError', 'NSXMLParserCDATANotFinishedError', 'NSXMLParserCharacterRefAtEOFError', 'NSXMLParserCharacterRefInDTDError', 'NSXMLParserCharacterRefInEpilogError', 'NSXMLParserCharacterRefInPrologError', 'NSXMLParserCommentContainsDoubleHyphenError', 'NSXMLParserCommentNotFinishedError', 'NSXMLParserConditionalSectionNotFinishedError', 'NSXMLParserConditionalSectionNotStartedError', 'NSXMLParserDOCTYPEDeclNotFinishedError', 'NSXMLParserDelegateAbortedParseError', 'NSXMLParserDocumentStartError', 'NSXMLParserElementContentDeclNotFinishedError', 'NSXMLParserElementContentDeclNotStartedError', 'NSXMLParserEmptyDocumentError', 'NSXMLParserEncodingNotSupportedError', 'NSXMLParserEntityBoundaryError', 'NSXMLParserEntityIsExternalError', 'NSXMLParserEntityIsParameterError', 'NSXMLParserEntityNotFinishedError', 'NSXMLParserEntityNotStartedError', 'NSXMLParserEntityRefAtEOFError', 'NSXMLParserEntityRefInDTDError', 'NSXMLParserEntityRefInEpilogError', 'NSXMLParserEntityRefInPrologError', 'NSXMLParserEntityRefLoopError', 'NSXMLParserEntityReferenceMissingSemiError', 'NSXMLParserEntityReferenceWithoutNameError', 'NSXMLParserEntityValueRequiredError', 'NSXMLParserEqualExpectedError', 'NSXMLParserErrorDomain', 'NSXMLParserExternalStandaloneEntityError', 'NSXMLParserExternalSubsetNotFinishedError', 'NSXMLParserExtraContentError', 'NSXMLParserGTRequiredError', 'NSXMLParserInternalError', 'NSXMLParserInvalidCharacterError', 'NSXMLParserInvalidCharacterInEntityError', 'NSXMLParserInvalidCharacterRefError', 'NSXMLParserInvalidConditionalSectionError', 'NSXMLParserInvalidDecimalCharacterRefError', 'NSXMLParserInvalidEncodingError', 'NSXMLParserInvalidEncodingNameError', 'NSXMLParserInvalidHexCharacterRefError', 'NSXMLParserInvalidURIError', 'NSXMLParserLTRequiredError', 'NSXMLParserLTSlashRequiredError', 'NSXMLParserLessThanSymbolInAttributeError', 'NSXMLParserLiteralNotFinishedError', 'NSXMLParserLiteralNotStartedError', 'NSXMLParserMisplacedCDATAEndStringError', 'NSXMLParserMisplacedXMLDeclarationError', 'NSXMLParserMixedContentDeclNotFinishedError', 'NSXMLParserMixedContentDeclNotStartedError', 'NSXMLParserNAMERequiredError', 'NSXMLParserNMTOKENRequiredError', 'NSXMLParserNamespaceDeclarationError', 'NSXMLParserNoDTDError', 'NSXMLParserNotWellBalancedError', 'NSXMLParserNotationNotFinishedError', 'NSXMLParserNotationNotStartedError', 'NSXMLParserOutOfMemoryError', 'NSXMLParserPCDATARequiredError', 'NSXMLParserParsedEntityRefAtEOFError', 'NSXMLParserParsedEntityRefInEpilogError', 'NSXMLParserParsedEntityRefInInternalError', 'NSXMLParserParsedEntityRefInInternalSubsetError', 'NSXMLParserParsedEntityRefInPrologError', 'NSXMLParserParsedEntityRefMissingSemiError', 'NSXMLParserParsedEntityRefNoNameError', 'NSXMLParserPrematureDocumentEndError', 'NSXMLParserProcessingInstructionNotFinishedError', 'NSXMLParserProcessingInstructionNotStartedError', 'NSXMLParserPublicIdentifierRequiredError', 'NSXMLParserSeparatorRequiredError', 'NSXMLParserSpaceRequiredError', 'NSXMLParserStandaloneValueError', 'NSXMLParserStringNotClosedError', 'NSXMLParserStringNotStartedError', 'NSXMLParserTagNameMismatchError', 'NSXMLParserURIFragmentError', 'NSXMLParserURIRequiredError', 'NSXMLParserUndeclaredEntityError', 'NSXMLParserUnfinishedTagError', 'NSXMLParserUnknownEncodingError', 'NSXMLParserUnparsedEntityError', 'NSXMLParserXMLDeclNotFinishedError', 'NSXMLParserXMLDeclNotStartedError', 'NSXMLProcessingInstructionKind', 'NSXMLSAXParser', 'NSXMLSchemaType', 'NSXMLTextKind', 'NSXMLTidy', 'NSXMLTreeReader', 'NSXPCConnection', 'NSXPCObjCServer', 'NSXPCServer', 'NSYearCalendarUnit', 'NSYearMonthDatePickerElementFlag', 'NSYearMonthDayDatePickerElementFlag', 'NSYearMonthWeekDesignations', 'NSZeroPoint', 'NSZeroRect', 'NSZeroSize', 'NSZipFileArchive', 'NSZipTextReader', 'NSZone*', 'NSZoneName', 'NS_BigEndian', 'NS_LittleEndian', 'NS_UNICHAR_IS_EIGHT_BIT', 'NS_UnknownByteOrder'
            ]


MOCK_MODULES = [
            'AppKit', 'objc', 'Foundation',
            ]

for mod_name in MOCK_MODULES:
    sys.modules[mod_name] = Mock()

# autodoc_mock_imports = ['AppKit', 'objc', 'Foundation']