'''
exact masses, isotopologues, covalences and isotopic abundances 
last update masses and isotopic abundances from NIST(07/18/2019):
https://www.nist.gov/pml/atomic-weights-and-isotopic-compositions-relative-atomic-masses
 '''

__author__ = 'Yuri E. Corilo'
__date__ = 'Jun 12, 2019'

class Labels: #pragma: no cover
    
    mz = "m/z"
    abundance = "Peak Height"
    rp = "Resolving Power"
    s2n = "S/N"

    label = 'label'
    bruker_profile = 'Bruker_Profile'
    thermo_profile = 'Thermo_Profile'
    simulated_profile = 'Simulated Profile'
    booster_profile = 'Booster Profile'
    bruker_frequency = 'Bruker_Frequency'
    midas_frequency = 'Midas_Frequency'
    thermo_centroid = 'Thermo_Centroid'
    corems_centroid = 'CoreMS_Centroid'
    gcms_centroid = 'Thermo_Centroid'
    
    unassigned = 'unassigned'

    radical_ion = 'RADICAL'
    protonated_de_ion = 'DE_OR_PROTONATED'
    protonated = "protonated"
    de_protonated = "de-protonated"
    adduct_ion = "ADDUCT"
    ion_type = 'IonType'

    ion_type_translate = { 'protonated': 'DE_OR_PROTONATED',
                          'de-protonated': 'DE_OR_PROTONATED',
                          'radical': 'RADICAL',
                          'adduct': 'ADDUCT'}
class Atoms: #pragma: no cover

    electron_mass = 0.0005485

    atomic_masses = {'H': 1.007825032239,
                     'D': 2.0141017781212,
                     'T': 3.016049277924,
                     '3He': 3.016029320125,
                     'He': 4.002603254136,
                     '6Li': 6.015122887416,
                     '7Li': 7.016003436645,
                     '9Be': 9.01218306582,
                     '10B': 10.0129369541,
                     '11B': 11.0093053645,
                     'C': 12.0,
                     '13C': 13.0033548350723,
                     '14C': 14.00324198844,
                     'N': 14.003074004432,
                     '15N': 15.0001088988864,
                     'O': 15.9949146195717,
                     '17O': 16.9991317565069,
                     '18O': 17.9991596128676,
                     'F': 18.9984031627392,
                     '20Ne': 19.992440176217,
                     '21Ne': 20.99384668541,
                     '22Ne': 21.99138511418,
                     'Na': 22.989769282019,
                     '24Mg': 23.98504169714,
                     '25Mg': 24.9858369765,
                     '26Mg': 25.98259296831,
                     '27Al': 26.9815385311,
                     '28Si': 27.9769265346544,
                     '29Si': 28.9764946649052,
                     '30Si': 29.97377013623,
                     'P': 30.973761998427,
                     'S': 31.972071174414,
                     '33S': 32.971458909815,
                     '34S': 33.96786700447,
                     '36S': 35.967080712,
                     'Cl': 34.96885268237,
                     '37Cl': 36.96590260255,
                     '36Ar': 35.96754510528,
                     '38Ar': 37.9627321121,
                     '40Ar': 39.962383123724,
                     'K': 38.963706486449,
                     '40K': 39.9639981666,
                     '41K': 40.961825257941,
                     'Ca': 39.96259086322,
                     '42Ca': 41.9586178316,
                     '43Ca': 42.9587664424,
                     '44Ca': 43.9554815635,
                     '46Ca': 45.953689024,
                     '48Ca': 47.9525227613,
                     '45Sc': 44.9559082877,
                     '46Ti': 45.9526277235,
                     '47Ti': 46.9517587938,
                     '48Ti': 47.9479419838,
                     '49Ti': 48.9478656839,
                     '50Ti': 49.9447868939,
                     '50V': 49.9471560195,
                     'V': 50.9439570494,
                     '50Cr': 49.9460418394,
                     '52Cr': 51.9405062363,
                     '53Cr': 52.9406481562,
                     '54Cr': 53.9388791661,
                     '55Mn': 54.9380439148,
                     '54Fe': 53.9396089953,
                     'Fe': 55.9349363349,
                     '57Fe': 56.9353928449,
                     '58Fe': 57.9332744353,
                     '59Co': 58.9331942956,
                     '58Ni': 57.9353424152,
                     '60Ni': 59.9307858852,
                     '61Ni': 60.9310555752,
                     '62Ni': 61.9283453755,
                     '64Ni': 63.9279668258,
                     'Cu': 62.9295977256,
                     '65Cu': 64.9277897071,
                     '64Zn': 63.9291420171,
                     '66Zn': 65.9260338194,
                     '67Zn': 66.9271277596,
                     '68Zn': 67.9248445598,
                     '70Zn': 69.925319221,
                     '69Ga': 68.925573513,
                     '71Ga': 70.9247025887,
                     '70Ge': 69.924248759,
                     '72Ge': 71.92207582681,
                     '73Ge': 72.92345895661,
                     '74Ge': 73.92117776113,
                     '76Ge': 75.92140272619,
                     '75As': 74.9215945795,
                     '74Se': 73.92247593415,
                     '76Se': 75.91921370417,
                     '77Se': 76.91991415467,
                     '78Se': 77.917309282,
                     'Se': 79.916521813,
                     '82Se': 81.916699515,
                     'Br': 78.918337614,
                     '81Br': 80.916289714,
                     '78Kr': 77.9203649476,
                     '80Kr': 79.9163780875,
                     '82Kr': 81.9134827394,
                     '83Kr': 82.9141271632,
                     '84Kr': 83.911497728244,
                     '86Kr': 85.910610626941,
                     '85Rb': 84.911789737954,
                     '87Rb': 86.90918053106,
                     '84Sr': 83.913419113,
                     '86Sr': 85.909260612,
                     '87Sr': 86.908877512,
                     '88Sr': 87.905612512,
                     '89Y': 88.905840324,
                     '90Zr': 89.90469772,
                     '91Zr': 90.90563962,
                     '92Zr': 91.90503472,
                     '94Zr': 93.90631082,
                     '96Zr': 95.908271421,
                     '93Nb': 92.90637302,
                     '92Mo': 91.9068079684,
                     '94Mo': 93.9050849048,
                     '95Mo': 94.9058387747,
                     '96Mo': 95.9046761247,
                     '97Mo': 96.9060181249,
                     '98Mo': 97.9054048249,
                     '100Mo': 99.907471811,
                     '97Tc': 96.90636674,
                     '98Tc': 97.907212436,
                     '99Tc': 98.90625081,
                     '96Ru': 95.9075902549,
                     '98Ru': 97.905286869,
                     '99Ru': 98.905934111,
                     '100Ru': 99.904214311,
                     '101Ru': 100.905576912,
                     '102Ru': 101.904344112,
                     '104Ru': 103.905427528,
                     '103Rh': 102.905498026,
                     '102Pd': 101.905602228,
                     '104Pd': 103.904030514,
                     '105Pd': 104.905079612,
                     '106Pd': 105.903480412,
                     '108Pd': 107.903891612,
                     '110Pd': 109.9051722075,
                     '107Ag': 106.905091626,
                     '109Ag': 108.904755314,
                     '106Cd': 105.906459912,
                     '108Cd': 107.904183412,
                     '110Cd': 109.9030066161,
                     '111Cd': 110.9041828761,
                     '112Cd': 111.902762876,
                     '113Cd': 112.9044081345,
                     '114Cd': 113.9033650943,
                     '116Cd': 115.9047631517,
                     '113In': 112.9040618491,
                     '115In': 114.90387877612,
                     '112Sn': 111.9048238761,
                     '114Sn': 113.90278271,
                     '115Sn': 114.90334469916,
                     '116Sn': 115.901742801,
                     '117Sn': 116.9029539852,
                     '118Sn': 117.9016065754,
                     '119Sn': 118.9033111778,
                     '120Sn': 119.9022016397,
                     '122Sn': 121.903443826,
                     '124Sn': 123.905276611,
                     '121Sb': 120.90381203,
                     '123Sb': 122.904213223,
                     '120Te': 119.904059333,
                     '122Te': 121.903043516,
                     '123Te': 122.904269816,
                     '124Te': 123.902817116,
                     '125Te': 124.904429916,
                     '126Te': 125.903310916,
                     '128Te': 127.9044612893,
                     '130Te': 129.90622274812,
                     '127I': 126.904471939,
                     '124Xe': 123.905892019,
                     '126Xe': 125.904298338,
                     '128Xe': 127.903531011,
                     '129Xe': 128.90478086116,
                     '130Xe': 129.9035093491,
                     '131Xe': 130.9050840624,
                     '132Xe': 131.904155085656,
                     '134Xe': 133.905394669,
                     '136Xe': 135.90721448411,
                     '133Cs': 132.90545196108,
                     '130Ba': 129.906320728,
                     '132Ba': 131.905061111,
                     '134Ba': 133.904508183,
                     '135Ba': 134.9056883829,
                     '136Ba': 135.9045757329,
                     '137Ba': 136.905827143,
                     '138Ba': 137.9052470031,
                     '138La': 137.907114937,
                     '139La': 138.906356324,
                     '136Ce': 135.9071292141,
                     '138Ce': 137.90599111,
                     '140Ce': 139.905443123,
                     '142Ce': 141.909250429,
                     '141Pr': 140.907657623,
                     '142Nd': 141.90772902,
                     '143Nd': 142.90982002,
                     '144Nd': 143.91009302,
                     '145Nd': 144.91257932,
                     '146Nd': 145.91312262,
                     '148Nd': 147.916899326,
                     '150Nd': 149.920902218,
                     '145Pm': 144.912755933,
                     '147Pm': 146.915145019,
                     '144Sm': 143.912006521,
                     '147Sm': 146.914904419,
                     '148Sm': 147.914829219,
                     '149Sm': 148.917192118,
                     '150Sm': 149.917282918,
                     '152Sm': 151.919739718,
                     '154Sm': 153.92221692,
                     '151Eu': 150.919857818,
                     '153Eu': 152.921238018,
                     '152Gd': 151.919799518,
                     '154Gd': 153.920874117,
                     '155Gd': 154.922630517,
                     '156Gd': 155.922131217,
                     '157Gd': 156.923968617,
                     '158Gd': 157.924112317,
                     '160Gd': 159.927062418,
                     '159Tb': 158.925354719,
                     '156Dy': 155.924284717,
                     '158Dy': 157.924415931,
                     '160Dy': 159.92520462,
                     '161Dy': 160.92694052,
                     '162Dy': 161.92680562,
                     '163Dy': 162.92873832,
                     '164Dy': 163.92918192,
                     '165Ho': 164.930328821,
                     '162Er': 161.92878842,
                     '164Er': 163.92920882,
                     '166Er': 165.930299522,
                     '167Er': 166.932054622,
                     '168Er': 167.932376722,
                     '170Er': 169.935470226,
                     '169Tm': 168.934217922,
                     '168Yb': 167.933889622,
                     '170Yb': 169.934766422,
                     '171Yb': 170.936330222,
                     '172Yb': 171.936385922,
                     '173Yb': 172.938215122,
                     '174Yb': 173.938866422,
                     '176Yb': 175.942576424,
                     '175Lu': 174.94077522,
                     '176Lu': 175.94268972,
                     '174Hf': 173.940046128,
                     '176Hf': 175.941407622,
                     '177Hf': 176.94322772,
                     '178Hf': 177.94370582,
                     '179Hf': 178.94582322,
                     '180Hf': 179.94655702,
                     '180Ta': 179.947464824,
                     '181Ta': 180.94799582,
                     '180W': 179.94671082,
                     '182W': 181.9482039491,
                     '183W': 182.950222759,
                     '184W': 183.9509309294,
                     '186W': 185.954362817,
                     '185Re': 184.952954513,
                     '187Re': 186.955750116,
                     '184Os': 183.952488514,
                     '186Os': 185.953835016,
                     '187Os': 186.955747416,
                     '188Os': 187.955835216,
                     '189Os': 188.958144217,
                     '190Os': 189.958443717,
                     '192Os': 191.961477029,
                     '191Ir': 190.960589321,
                     '193Ir': 192.962921621,
                     '190Pt': 189.959929763,
                     '192Pt': 191.961038732,
                     '194Pt': 193.96268091,
                     '195Pt': 194.96479171,
                     '196Pt': 195.9649520999,
                     '198Pt': 197.967894923,
                     '197Au': 196.9665687971,
                     '196Hg': 195.965832632,
                     '198Hg': 197.9667686052,
                     '199Hg': 198.9682806446,
                     '200Hg': 199.9683265947,
                     '201Hg': 200.9703028469,
                     '202Hg': 201.9706434069,
                     '204Hg': 203.9734939853,
                     '203Tl': 202.972344614,
                     '205Tl': 204.974427814,
                     '204Pb': 203.973044013,
                     '206Pb': 205.974465713,
                     '207Pb': 206.975897313,
                     '208Pb': 207.976652513,
                     '209Bi': 208.980399116,
                     '209Po': 208.98243082,
                     '210Po': 209.982874113,
                     '210At': 209.987147983,
                     '211At': 210.98749663,
                     '211Rn': 210.990601173,
                     '220Rn': 220.011394123,
                     '222Rn': 222.017578225,
                     '223Fr': 223.019736025,
                     '223Ra': 223.018502327,
                     '224Ra': 224.020212023,
                     '226Ra': 226.025410325,
                     '228Ra': 228.031070726,
                     '227Ac': 227.027752325,
                     '230Th': 230.033134119,
                     '232Th': 232.038055821,
                     '231Pa': 231.035884224,
                     '233U': 233.039635529,
                     '234U': 234.040952319,
                     '235U': 235.043930119,
                     '236U': 236.045568219,
                     '238U': 238.05078842,
                     '236Np': 236.04657054,
                     '237Np': 237.048173619,
                     '238Pu': 238.049560119,
                     '239Pu': 239.052163619,
                     '240Pu': 240.053813819,
                     '241Pu': 241.056851719,
                     '242Pu': 242.05874282,
                     '244Pu': 244.064205356,
                     '241Am': 241.056829319,
                     '243Am': 243.061381324,
                     '243Cm': 243.061389322,
                     '244Cm': 244.062752819,
                     '245Cm': 245.065491522,
                     '246Cm': 246.067223822,
                     '247Cm': 247.070354147,
                     '248Cm': 248.072349956,
                     '247Bk': 247.070307359,
                     '249Bk': 249.074987727,
                     '249Cf': 249.074853923,
                     '250Cf': 250.076406222,
                     '251Cf': 251.079588648,
                     '252Cf': 252.081627256,
                     '252Es': 252.08298054,
                     '257Fm': 257.095106169,
                     '258Md': 258.09843155,
                     '260Md': 260.1036534,
                     '259No': 259.1010311,
                     '262Lr': 262.1096122,
                     '267Rf': 267.1217962,
                     '268Db': 268.1256757,
                     '271Sg': 271.1339363,
                     '272Bh': 272.1382658,
                     '270Hs': 270.1342927,
                     '276Mt': 276.1515959,
                     '281Ds': 281.1645159,
                     '280Rg': 280.1651461,
                     '285Cn': 285.177126,
                     '284Nh': 284.1787362,
                     '289Fl': 289.190426,
                     '288Mc': 288.1927462,
                     '293Lv': 293.204496,
                     '292Ts': 292.2074675,
                     '294Og': 294.2139271}

    atoms_order = ['C', 'H', 'O', 'Cl', 'Na', 'S', 'N', '13C', '34S', '37Cl','Fe', 'Ca','P',
                        'V', 'I', 'Ac', 'Al', 'Ar', 'As', 'At', 'Au', 'Co', 'Cs', 'D', 'F', 'Fr','18O', '17O',
                        'He', 'Po', 'Ra', 'Rh', 'Rn', 'Be', 'Bi', 'Nb, 54Fe', '57Fe', '58Ni', '60Ni',
                        '61Ni', '62Ni', '10B', '11B', '6Li', '7Li', 'La', 'Mn', '107Ag', '109Ag', '100Mo',
                        '100Ru', '101Ru', '102Pd', '102Ru', '104Pd', '104Ru', '105Pd', '106Cd', '106Pd', '108Cd',
                        '108Pd', '110Cd', '110Pd', '111Cd', '112Cd', '112Sn', '113Cd', '113In', '114Cd', '114Sn',
                        '115In', '115Sn', '116Cd', '116Sn', '117Sn', '118Sn', '119Sn', '120Sn', '120Te', '121Sb',
                        '122Sn', '122Te', '123Sb', '123Te', '124Sn', '124Te', '124Xe', '125Te', '126Te', '126Xe',
                        '128Te', '128Xe', '129Xe', '130Ba', '130Te', '130Xe', '131Xe', '132Ba', '132Xe', '134Ba',
                        '134Xe', '135Ba', '136Ba', '136Xe', '137Ba', '138Ba', '15N', '174Hf', '176Hf', '177Hf', '178Hf',
                        '179Hf', '180Hf', '180W', '182W', '183W', '184Os', '184W', '185Re', '186Os', '186W', '187Os', '187Re',
                        '188Os', '189Os', '190Os', '190Pt', '191Ir', '192Ir', '192Os', '192Pt', '194Pt', '195Pt', '196Hg',
                        '196Pt', '198Hg', '198Pt', '199Hg', '200Hg', '201Hg', '202Hg', '203Tl', '204Hg', '204Pb', '205Tl', '206Pb',
                        '207Pb', '208Pb', '20Ne', '22Ne', '24Mg', '25Mg', '26Mg', '28Si', '29Si', '30Si', 'K', '40Ca', '41K', '44Ca',
                        '46Ti', '47Ti', '48Ti', '49Ti', '50Cr', '50Ti', '50V', '51V', '52Cr', '53Cr', '54Cr', 'Cu', '64Zn', '65Cu', '66Zn',
                        '67Zn', '68Zn', '69Ga', '70Ge', '71Ga', '72Ge', '73Ge', '74Ge', '76Ge', '76Se', '77Se', '78Se', 'Br', '81Br', '80Kr',
                        'Se', '82Kr', '82Se', '83Kr', '84Kr', '85Rb', '86Kr', '86Sr', '87Rb', '87Sr', '88Sr', '90Zr', '91Zr', '92Mo', '92Zr',
                        '94Mo', '94Zr', '95Mo', '96Mo', '96Ru', '96Zr', '97Mo', '98Mo', '98Ru', '99Ru']

    atoms_covalence = {'C': (4),
                     '13C': (4),
                     'N': (3),
                     'O': (2),
                     'S': (2),
                     'H': (1),
                     'F': (1, 0),
                     'Cl': (1, 0),
                     'Br': (1, 0),
                     'I': (1, 0),
                     'At': (1),
                     'Li': (1, 0),
                     'Na': (1, 0),
                     'K':  (1, 0),
                     'Rb': (1),
                     'Cs': (1),
                     'Fr': (1),
                     'B': (4, 3, 2, 1),
                     'In': (3, 2, 1),
                     'Al': (3, 1, 2),
                     'P': (3, 5, 4, 2, 1),
                     'Ga': (3, 1, 2),
                     'Mg': (2, 1),
                     'Be': (2, 1),
                     'Ca': (2, 1),
                     'Sr': (2, 1),
                     'Ba': (2),
                     'Ra': (2),
                     'V': (5, 4, 3, 2, 1),
                     'Fe': (3, 2, 4, 5, 6),
                     'Si': (4, 3, 2),
                     'Sc': (3, 2, 1),
                     'Ti': (4, 3, 2, 1),
                     'Cr': (1, 2, 3, 4, 5, 6),
                     'Mn': (1, 2, 3, 4, 5, 6, 7),
                     'Co': (1, 2, 3, 4, 5),
                     'Ni': (1, 2, 3, 4),
                     'Cu': (2, 1, 3, 4),
                     'Zn': (2, 1),
                     'Ge': (4, 3, 2, 1),
                     'As': (5, 3, 2, 1),
                     'Se': (6, 4, 2, 1),
                     'Y': (3, 2, 1),
                     'Zr': (4, 3, 2, 1),
                     'Nb': (5, 4, 3, 2, 1),
                     'Mo': (6, 5, 4, 3, 2, 1),
                     'Tc': (7, 6, 5, 4, 3, 2, 1),
                     'Ru': (8, 7, 6, 5, 4, 3, 2, 1),
                     'Rh': (6, 5, 4, 3, 2, 1),
                     'Pd': (4, 2, 1),
                     'Ag': (0, 1, 2, 3, 4),
                     'Cd': (2, 1),
                     'Sn': (4, 2),
                     'Sb': (5, 3),
                     'Te': (6, 5, 4, 2),
                     'La': (3, 2),
                     'Hf': (4, 3, 2),
                     'Ta': (5, 4, 3, 2),
                     'W': (6, 5, 4, 3, 2, 1),
                     'Re': (4, 7, 6, 5, 3, 2, 1),
                     'Os': (4, 8, 7, 6, 5, 3, 2, 1),
                     'Ir': (4, 8, 6, 5, 3, 2, 1),
                     'Pt': (4, 6, 5, 3, 2, 1),
                     'Au': (3, 5, 2, 1),
                     'Hg': (1, 2, 4),
                     'Tl': (3, 1),
                     'Pb': (4, 2),
                     'Bi': (3, 1, 5),
                     'Po': (2, 4, 6),
                     'Ac': (3, 2)
                     }

    isotopic_abundance = {'H': 0.9998857,
                          'D': 0.0001157,
                          'T': 0,
                          '3He': 1.343e-06,
                          'He': 0.999998663,
                          '6Li': 0.07594,
                          'Li': 0.92414,
                          '9Be': 1.0,
                          '10B': 0.1997,
                          '11B': 0.8017,
                          'C': 0.98938,
                          '13C': 0.01078,
                          '14C': 0,
                          'N': 0.996362,
                          '15N': 0.003642,
                          'O': 0.9975716,
                          '17O': 0.000381,
                          '18O': 0.0020514,
                          'F': 1.0,
                          '20Ne': 0.90483,
                          '21Ne': 0.00271,
                          '22Ne': 0.09253,
                          'Na': 1.0,
                          '24Mg': 0.78994,
                          '25Mg': 0.10001,
                          '26Mg': 0.11013,
                          '27Al': 1.0,
                          '28Si': 0.9222319,
                          '29Si': 0.046858,
                          '30Si': 0.0309211,
                          'P': 1.0,
                          'S': 0.949926,
                          '33S': 0.00752,
                          '34S': 0.042524,
                          '36S': 0.00011,
                          'Cl': 0.75761,
                          '37Cl': 0.24241,
                          '36Ar': 0.00333621,
                          '38Ar': 0.0006297,
                          '40Ar': 0.99603525,
                          'K': 0.93258144,
                          '40K': 0.0001171,
                          '41K': 0.06730244,
                          'Ca': 0.96941156,
                          '42Ca': 0.0064723,
                          '43Ca': 0.001351,
                          '44Ca': 0.0208611,
                          '46Ca': 4.3e-05,
                          '48Ca': 0.0018721,
                          '45Sc': 1.0,
                          '46Ti': 0.08253,
                          '47Ti': 0.07442,
                          '48Ti': 0.73723,
                          '49Ti': 0.05412,
                          '50Ti': 0.05182,
                          '50V': 0.002504,
                          'V': 0.997504,
                          '50Cr': 0.0434513,
                          '52Cr': 0.8378918,
                          '53Cr': 0.0950117,
                          '54Cr': 0.023657,
                          '55Mn': 1.0,
                          '54Fe': 0.0584535,
                          'Fe': 0.9175436,
                          '57Fe': 0.021191,
                          '58Fe': 0.002824,
                          '59Co': 1.0,
                          '58Ni': 0.6807719,
                          '60Ni': 0.2622315,
                          '61Ni': 0.01139913,
                          '62Ni': 0.0363464,
                          '64Ni': 0.00925519,
                          'Cu': 0.691515,
                          '65Cu': 0.308515,
                          '64Zn': 0.491775,
                          '66Zn': 0.277398,
                          '67Zn': 0.040416,
                          '68Zn': 0.184563,
                          '70Zn': 0.00611,
                          '69Ga': 0.601089,
                          '71Ga': 0.398929,
                          '70Ge': 0.205727,
                          '72Ge': 0.274532,
                          '73Ge': 0.077512,
                          '74Ge': 0.36502,
                          '76Ge': 0.077312,
                          '75As': 1.0,
                          '74Se': 0.00894,
                          '76Se': 0.093729,
                          '77Se': 0.076316,
                          '78Se': 0.237728,
                          'Se': 0.496141,
                          '82Se': 0.087322,
                          'Br': 0.50697,
                          '81Br': 0.49317,
                          '78Kr': 0.003553,
                          '80Kr': 0.022861,
                          '82Kr': 0.1159331,
                          '83Kr': 0.1150019,
                          '84Kr': 0.5698715,
                          '86Kr': 0.1727941,
                          '85Rb': 0.72172,
                          '87Rb': 0.27832,
                          '84Sr': 0.00561,
                          '86Sr': 0.09861,
                          '87Sr': 0.07001,
                          '88Sr': 0.82581,
                          '89Y': 1.0,
                          '90Zr': 0.51454,
                          '91Zr': 0.11225,
                          '92Zr': 0.17158,
                          '94Zr': 0.173828,
                          '96Zr': 0.02809,
                          '93Nb': 1.0,
                          '92Mo': 0.14533,
                          '94Mo': 0.09159,
                          '95Mo': 0.158411,
                          '96Mo': 0.166715,
                          '97Mo': 0.096014,
                          '98Mo': 0.243937,
                          '100Mo': 0.098231,
                          '97Tc': 0,
                          '98Tc': 0,
                          '99Tc': 0,
                          '96Ru': 0.055414,
                          '98Ru': 0.01873,
                          '99Ru': 0.127614,
                          '100Ru': 0.12607,
                          '101Ru': 0.17062,
                          '102Ru': 0.315514,
                          '104Ru': 0.186227,
                          '103Rh': 1.0,
                          '102Pd': 0.01021,
                          '104Pd': 0.11148,
                          '105Pd': 0.22338,
                          '106Pd': 0.27333,
                          '108Pd': 0.26469,
                          '110Pd': 0.11729,
                          '107Ag': 0.518398,
                          '109Ag': 0.481618,
                          '106Cd': 0.01256,
                          '108Cd': 0.00893,
                          '110Cd': 0.124918,
                          '111Cd': 0.128012,
                          '112Cd': 0.241321,
                          '113Cd': 0.122212,
                          '114Cd': 0.287342,
                          '116Cd': 0.074918,
                          '113In': 0.04295,
                          '115In': 0.95715,
                          '112Sn': 0.00971,
                          '114Sn': 0.00661,
                          '115Sn': 0.00341,
                          '116Sn': 0.14549,
                          '117Sn': 0.07687,
                          '118Sn': 0.24229,
                          '119Sn': 0.08594,
                          '120Sn': 0.32589,
                          '122Sn': 0.04633,
                          '124Sn': 0.05795,
                          '121Sb': 0.57215,
                          '123Sb': 0.42795,
                          '120Te': 0.00091,
                          '122Te': 0.025512,
                          '123Te': 0.00893,
                          '124Te': 0.047414,
                          '125Te': 0.070715,
                          '126Te': 0.188425,
                          '128Te': 0.31748,
                          '130Te': 0.340862,
                          '127I': 1.0,
                          '124Xe': 0.0009523,
                          '126Xe': 0.0008902,
                          '128Xe': 0.0191028,
                          '129Xe': 0.26400682,
                          '130Xe': 0.04071013,
                          '131Xe': 0.2123243,
                          '132Xe': 0.26908633,
                          '134Xe': 0.10435721,
                          '136Xe': 0.08857344,
                          '133Cs': 1.0,
                          '130Ba': 0.001061,
                          '132Ba': 0.001011,
                          '134Ba': 0.0241718,
                          '135Ba': 0.0659212,
                          '136Ba': 0.0785424,
                          '137Ba': 0.1123224,
                          '138Ba': 0.7169842,
                          '138La': 0.000888171,
                          '139La': 0.999111971,
                          '136Ce': 0.001852,
                          '138Ce': 0.002512,
                          '140Ce': 0.8845051,
                          '142Ce': 0.1111451,
                          '141Pr': 1.0,
                          '142Nd': 0.271524,
                          '143Nd': 0.1217426,
                          '144Nd': 0.2379819,
                          '145Nd': 0.0829312,
                          '146Nd': 0.1718932,
                          '148Nd': 0.0575621,
                          '150Nd': 0.0563828,
                          '145Pm': 0,
                          '147Pm': 0,
                          '144Sm': 0.03077,
                          '147Sm': 0.149918,
                          '148Sm': 0.11241,
                          '149Sm': 0.13827,
                          '150Sm': 0.07381,
                          '152Sm': 0.267516,
                          '154Sm': 0.227529,
                          '151Eu': 0.47816,
                          '153Eu': 0.52196,
                          '152Gd': 0.00201,
                          '154Gd': 0.02183,
                          '155Gd': 0.148012,
                          '156Gd': 0.20479,
                          '157Gd': 0.15652,
                          '158Gd': 0.24847,
                          '160Gd': 0.218619,
                          '159Tb': 1.0,
                          '156Dy': 0.000563,
                          '158Dy': 0.000953,
                          '160Dy': 0.0232918,
                          '161Dy': 0.1888942,
                          '162Dy': 0.2547536,
                          '163Dy': 0.2489642,
                          '164Dy': 0.2826054,
                          '165Ho': 1.0,
                          '162Er': 0.001395,
                          '164Er': 0.016013,
                          '166Er': 0.3350336,
                          '167Er': 0.228699,
                          '168Er': 0.2697818,
                          '170Er': 0.1491036,
                          '169Tm': 1.0,
                          '168Yb': 0.001233,
                          '170Yb': 0.0298239,
                          '171Yb': 0.140914,
                          '172Yb': 0.216813,
                          '173Yb': 0.1610363,
                          '174Yb': 0.320268,
                          '176Yb': 0.1299683,
                          '175Lu': 0.9740113,
                          '176Lu': 0.0259913,
                          '174Hf': 0.00161,
                          '176Hf': 0.05267,
                          '177Hf': 0.18609,
                          '178Hf': 0.27287,
                          '179Hf': 0.13622,
                          '180Hf': 0.350816,
                          '180Ta': 0.000120132,
                          '181Ta': 0.999879932,
                          '180W': 0.00121,
                          '182W': 0.265016,
                          '183W': 0.14314,
                          '184W': 0.30642,
                          '186W': 0.284319,
                          '185Re': 0.37402,
                          '187Re': 0.62602,
                          '184Os': 0.00021,
                          '186Os': 0.01593,
                          '187Os': 0.01962,
                          '188Os': 0.13248,
                          '189Os': 0.16155,
                          '190Os': 0.26262,
                          '192Os': 0.407819,
                          '191Ir': 0.3732,
                          '193Ir': 0.6272,
                          '190Pt': 0.000122,
                          '192Pt': 0.0078224,
                          '194Pt': 0.32864,
                          '195Pt': 0.337824,
                          '196Pt': 0.252134,
                          '198Pt': 0.0735613,
                          '197Au': 1.0,
                          '196Hg': 0.00151,
                          '198Hg': 0.09972,
                          '199Hg': 0.168722,
                          '200Hg': 0.231019,
                          '201Hg': 0.13189,
                          '202Hg': 0.298626,
                          '204Hg': 0.068715,
                          '203Tl': 0.29521,
                          '205Tl': 0.70481,
                          '204Pb': 0.0141,
                          '206Pb': 0.2411,
                          '207Pb': 0.2211,
                          '208Pb': 0.5241,
                          '209Bi': 1.0,
                          '209Po': 0,
                          '210Po': 0,
                          '210At': 0,
                          '211At': 0,
                          '211Rn': 0,
                          '220Rn': 0,
                          '222Rn': 0,
                          '223Fr': 0,
                          '223Ra': 0,
                          '224Ra': 0,
                          '226Ra': 0,
                          '228Ra': 0,
                          '227Ac': 0,
                          '230Th': 0,
                          '232Th': 1.0,
                          '231Pa': 1.0,
                          '233U': 0,
                          '234U': 5.45e-05,
                          '235U': 0.0072046,
                          '236U': 0,
                          '238U': 0.9927421,
                          '236Np': 0,
                          '237Np': 0,
                          '238Pu': 0,
                          '239Pu': 0,
                          '240Pu': 0,
                          '241Pu': 0,
                          '242Pu': 0,
                          '244Pu': 0,
                          '241Am': 0,
                          '243Am': 0,
                          '243Cm': 0,
                          '244Cm': 0,
                          '245Cm': 0,
                          '246Cm': 0,
                          '247Cm': 0,
                          '248Cm': 0,
                          '247Bk': 0,
                          '249Bk': 0,
                          '249Cf': 0,
                          '250Cf': 0,
                          '251Cf': 0,
                          '252Cf': 0,
                          '252Es': 0,
                          '257Fm': 0,
                          '258Md': 0,
                          '260Md': 0,
                          '259No': 0,
                          '262Lr': 0,
                          '267Rf': 0,
                          '268Db': 0,
                          '271Sg': 0,
                          '272Bh': 0,
                          '270Hs': 0,
                          '276Mt': 0,
                          '281Ds': 0,
                          '280Rg': 0,
                          '285Cn': 0,
                          '284Nh': 0,
                          '289Fl': 0,
                          '288Mc': 0,
                          '293Lv': 0,
                          '292Ts': 0,
                          '294Og': 0}

    isotopes = {'F': ['Flourine'],
                'Na': ['Sodium'],
                'Al': ['Aluminum'],
                'P': ['Phosphorus'],
                'Sc': ['Scandium'],
                'Co': ['Cobalt'],
                'He': ['Helium'],
                'Ar': ['Argon'],
                'H': ['Hydrogen', ['D']],
                'Cl': ['Chlorine', ['37Cl']],
                'Li': ['Lithium', ['6Li']],
                'Be': ['Beryllium'],
                'B': ['Boron', ['11B']],
                'C': ['Carbon', ['13C']],
                'O': ['Oxygen', ['18O', '17O']],
                'S': ['Sulfur', ['34S']],
                'N': ['Nitrogen', ['15N']],
                'V': ['Vanadium', ['50V']],
                'Ne': ['Neon', ['20Ne', '22Ne']],
                'Mg': ['Magnesium', ['24Mg', '26Mg', '25Mg']],
                'Si': ['Silicon', ['28Si', '29Si', '30Si']],
                'K': ['Potassium', ['40K', '41K']],
                'Ca': ['Calcium', ['43Ca', '44Ca']],
                'Ti': ['Titanium', ['48Ti', '46Ti', '47Ti', '49Ti', '50Ti']],
                'Cr': ['Chromium', ['52Cr', '53Cr', '50Cr', '54Cr']],
                'Fe': ['Iron', ['54Fe', '57Fe', '58Fe']],
                'Mn': ['Manganese'],
                'Ni': ['Nickel', ['58Ni', '60Ni', '62Ni', '61Ni']],
                'Cu': ['Copper', ['65Cu']],
                'Zn': ['Zinc', ['64Zn', '66Zn', '68Zn', '67Zn']],
                'Ga': ['Gallium', ['69Ga', '71Ga']],
                'Ge': ['Germanium', ['74Ge', '72Ge', '70Ge', '73Ge', '76Ge']],
                'As': ['Arsenic'],
                'Se': ['Selenium', ['78Se', '76Se', '82Se', '77Se']],
                'Br': ['Bromine', ['81Br']],
                'Kr': ['Krypton', ['84Kr', '86Kr', '82Kr', '83Kr', '80Kr']],
                'Rb': ['Rubidium', ['85Rb', '87Rb']],
                'Sr': ['Strontium', ['88Sr', '86Sr', '87Sr']],
                'Y': ['Yttrium'],
                'Zr': ['Zironium', ['90Zr', '94Zr', '92Zr', '91Zr', '96Zr']],
                'Nb': ['Niobium'],
                'Mo': ['Molybdenum', ['98Mo', '96Mo', '95Mo', '92Mo', '100Mo', '97Mo', '94Mo']],
                'Tc': ['Technetium'],
                'Ru': ['Ruthenium', ['102Ru', '104Ru', '101Ru', '99Ru', '100Ru', '96Ru', '98Ru']],
                'Rh': ['Rhodium'],
                'Pd': ['Palladium', ['106Pd', '108Pd', '105Pd', '110Pd', '104Pd', '102Pd']],
                'Ag': ['Silver', ['107Ag', '109Ag']],
                'Cd': ['Cadmium', ['114Cd', '112Cd', '111Cd', '110Cd', '113Cd', '116Cd', '106Cd', '108Cd']],
                'In': ['Indium', ['115In', '113In']],
                'Sn': ['Tin', ['120Sn', '118Sn', '116Sn', '119Sn', '117Sn', '124Sn', '122Sn', '112Sn']],
                'Sb': ['Antimony', ['121Sb', '123Sb']],
                'Te': ['Tellurium', ['130Te', '128Te', '126Te', '125Te', '124Te', '122Te']],
                'I': ['Iodine'],
                'Xe': ['Xenon', ['132Xe', '129Xe', '131Xe', '134Xe', '136Xe', '130Xe', '128Xe']],
                'Cs': ['Cesium'],
                'Ba': ['Barium', ['138Ba', '137Ba', '136Ba', '135Ba', '134Ba']],
                'La': ['Lanthanum'],
                'Hf': ['Hafnium', ['180Hf', '178Hf', '177Hf', '179Hf', '176Hf']],
                'Ta': ['Tantalum'],
                'W': ['Tungsten', ['184W', '186W', '182W', '183W']],
                'Re': ['Rhenium', ['187Re', '185Re']],
                'Os': ['Osmium', ['192OS', '190Os', '189Os', '188Os', '187Os', '186Os']],
                'Ir': ['Iridium', ['193Ir', '191Ir']],
                'Pt': ['Platinum', ['195Pt', '194Pt', '196Pt', '198Pt', '192Pt']],
                'Au': ['Gold'],
                'Hg': ['Mercury', ['202Hg', '200Hg', '199Hg', '201Hg', '198Hg', '204Hg']],
                'Tl': ['Thallium', ['205Tl', '203Tl']],
                'Pb': ['Lead', ['208Pb', '206Pb', '207Pb', '204Pb']],
                'Bi': ['Bismuth'],
                'Po': ['Polonium'],
                'At': ['Aslatine'],
                'Rn': ['Radon'],
                'Fr': ['Francium'],
                'Ra': ['Radium'],
                'Ac': ['Actinium']
                }
