# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DetectionDetectionEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'RimeUUID',
        'project_id': 'RimeUUID',
        'firewall_id': 'RimeUUID',
        'event_type': 'DetectionEventType',
        'severity': 'RimeSeverity',
        'event_object_id': 'str',
        'event_object_name': 'str',
        'event_time_range': 'RimeTimeInterval',
        'last_update_time': 'datetime',
        'risk_category_type': 'RiskscoreRiskCategoryType',
        'test_category': 'TestrunTestCategoryType',
        'description': 'str',
        'description_html': 'str',
        'resolution': 'DetectionResolution',
        'detail': 'DetectionEventDetail',
        'rca_role': 'RcaRCARole'
    }

    attribute_map = {
        'id': 'id',
        'project_id': 'projectId',
        'firewall_id': 'firewallId',
        'event_type': 'eventType',
        'severity': 'severity',
        'event_object_id': 'eventObjectId',
        'event_object_name': 'eventObjectName',
        'event_time_range': 'eventTimeRange',
        'last_update_time': 'lastUpdateTime',
        'risk_category_type': 'riskCategoryType',
        'test_category': 'testCategory',
        'description': 'description',
        'description_html': 'descriptionHtml',
        'resolution': 'resolution',
        'detail': 'detail',
        'rca_role': 'rcaRole'
    }

    def __init__(self, id=None, project_id=None, firewall_id=None, event_type=None, severity=None, event_object_id=None, event_object_name=None, event_time_range=None, last_update_time=None, risk_category_type=None, test_category=None, description=None, description_html=None, resolution=None, detail=None, rca_role=None):  # noqa: E501
        """DetectionDetectionEvent - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._project_id = None
        self._firewall_id = None
        self._event_type = None
        self._severity = None
        self._event_object_id = None
        self._event_object_name = None
        self._event_time_range = None
        self._last_update_time = None
        self._risk_category_type = None
        self._test_category = None
        self._description = None
        self._description_html = None
        self._resolution = None
        self._detail = None
        self._rca_role = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if project_id is not None:
            self.project_id = project_id
        if firewall_id is not None:
            self.firewall_id = firewall_id
        if event_type is not None:
            self.event_type = event_type
        if severity is not None:
            self.severity = severity
        if event_object_id is not None:
            self.event_object_id = event_object_id
        if event_object_name is not None:
            self.event_object_name = event_object_name
        if event_time_range is not None:
            self.event_time_range = event_time_range
        if last_update_time is not None:
            self.last_update_time = last_update_time
        if risk_category_type is not None:
            self.risk_category_type = risk_category_type
        if test_category is not None:
            self.test_category = test_category
        if description is not None:
            self.description = description
        if description_html is not None:
            self.description_html = description_html
        if resolution is not None:
            self.resolution = resolution
        if detail is not None:
            self.detail = detail
        if rca_role is not None:
            self.rca_role = rca_role

    @property
    def id(self):
        """Gets the id of this DetectionDetectionEvent.  # noqa: E501


        :return: The id of this DetectionDetectionEvent.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DetectionDetectionEvent.


        :param id: The id of this DetectionDetectionEvent.  # noqa: E501
        :type: RimeUUID
        """

        self._id = id

    @property
    def project_id(self):
        """Gets the project_id of this DetectionDetectionEvent.  # noqa: E501


        :return: The project_id of this DetectionDetectionEvent.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this DetectionDetectionEvent.


        :param project_id: The project_id of this DetectionDetectionEvent.  # noqa: E501
        :type: RimeUUID
        """

        self._project_id = project_id

    @property
    def firewall_id(self):
        """Gets the firewall_id of this DetectionDetectionEvent.  # noqa: E501


        :return: The firewall_id of this DetectionDetectionEvent.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._firewall_id

    @firewall_id.setter
    def firewall_id(self, firewall_id):
        """Sets the firewall_id of this DetectionDetectionEvent.


        :param firewall_id: The firewall_id of this DetectionDetectionEvent.  # noqa: E501
        :type: RimeUUID
        """

        self._firewall_id = firewall_id

    @property
    def event_type(self):
        """Gets the event_type of this DetectionDetectionEvent.  # noqa: E501


        :return: The event_type of this DetectionDetectionEvent.  # noqa: E501
        :rtype: DetectionEventType
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this DetectionDetectionEvent.


        :param event_type: The event_type of this DetectionDetectionEvent.  # noqa: E501
        :type: DetectionEventType
        """

        self._event_type = event_type

    @property
    def severity(self):
        """Gets the severity of this DetectionDetectionEvent.  # noqa: E501


        :return: The severity of this DetectionDetectionEvent.  # noqa: E501
        :rtype: RimeSeverity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this DetectionDetectionEvent.


        :param severity: The severity of this DetectionDetectionEvent.  # noqa: E501
        :type: RimeSeverity
        """

        self._severity = severity

    @property
    def event_object_id(self):
        """Gets the event_object_id of this DetectionDetectionEvent.  # noqa: E501

        The event object varies with the event type. CT and security events use a monitor. Offline Test events use the test run.  # noqa: E501

        :return: The event_object_id of this DetectionDetectionEvent.  # noqa: E501
        :rtype: str
        """
        return self._event_object_id

    @event_object_id.setter
    def event_object_id(self, event_object_id):
        """Sets the event_object_id of this DetectionDetectionEvent.

        The event object varies with the event type. CT and security events use a monitor. Offline Test events use the test run.  # noqa: E501

        :param event_object_id: The event_object_id of this DetectionDetectionEvent.  # noqa: E501
        :type: str
        """

        self._event_object_id = event_object_id

    @property
    def event_object_name(self):
        """Gets the event_object_name of this DetectionDetectionEvent.  # noqa: E501

        event_object_name to avoid extra query from UI to display, and allow easier search support with DB. If the event object is renamed, the event will not be updated.  # noqa: E501

        :return: The event_object_name of this DetectionDetectionEvent.  # noqa: E501
        :rtype: str
        """
        return self._event_object_name

    @event_object_name.setter
    def event_object_name(self, event_object_name):
        """Sets the event_object_name of this DetectionDetectionEvent.

        event_object_name to avoid extra query from UI to display, and allow easier search support with DB. If the event object is renamed, the event will not be updated.  # noqa: E501

        :param event_object_name: The event_object_name of this DetectionDetectionEvent.  # noqa: E501
        :type: str
        """

        self._event_object_name = event_object_name

    @property
    def event_time_range(self):
        """Gets the event_time_range of this DetectionDetectionEvent.  # noqa: E501


        :return: The event_time_range of this DetectionDetectionEvent.  # noqa: E501
        :rtype: RimeTimeInterval
        """
        return self._event_time_range

    @event_time_range.setter
    def event_time_range(self, event_time_range):
        """Sets the event_time_range of this DetectionDetectionEvent.


        :param event_time_range: The event_time_range of this DetectionDetectionEvent.  # noqa: E501
        :type: RimeTimeInterval
        """

        self._event_time_range = event_time_range

    @property
    def last_update_time(self):
        """Gets the last_update_time of this DetectionDetectionEvent.  # noqa: E501


        :return: The last_update_time of this DetectionDetectionEvent.  # noqa: E501
        :rtype: datetime
        """
        return self._last_update_time

    @last_update_time.setter
    def last_update_time(self, last_update_time):
        """Sets the last_update_time of this DetectionDetectionEvent.


        :param last_update_time: The last_update_time of this DetectionDetectionEvent.  # noqa: E501
        :type: datetime
        """

        self._last_update_time = last_update_time

    @property
    def risk_category_type(self):
        """Gets the risk_category_type of this DetectionDetectionEvent.  # noqa: E501


        :return: The risk_category_type of this DetectionDetectionEvent.  # noqa: E501
        :rtype: RiskscoreRiskCategoryType
        """
        return self._risk_category_type

    @risk_category_type.setter
    def risk_category_type(self, risk_category_type):
        """Sets the risk_category_type of this DetectionDetectionEvent.


        :param risk_category_type: The risk_category_type of this DetectionDetectionEvent.  # noqa: E501
        :type: RiskscoreRiskCategoryType
        """

        self._risk_category_type = risk_category_type

    @property
    def test_category(self):
        """Gets the test_category of this DetectionDetectionEvent.  # noqa: E501


        :return: The test_category of this DetectionDetectionEvent.  # noqa: E501
        :rtype: TestrunTestCategoryType
        """
        return self._test_category

    @test_category.setter
    def test_category(self, test_category):
        """Sets the test_category of this DetectionDetectionEvent.


        :param test_category: The test_category of this DetectionDetectionEvent.  # noqa: E501
        :type: TestrunTestCategoryType
        """

        self._test_category = test_category

    @property
    def description(self):
        """Gets the description of this DetectionDetectionEvent.  # noqa: E501

        Human-readable description of the event.  # noqa: E501

        :return: The description of this DetectionDetectionEvent.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DetectionDetectionEvent.

        Human-readable description of the event.  # noqa: E501

        :param description: The description of this DetectionDetectionEvent.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def description_html(self):
        """Gets the description_html of this DetectionDetectionEvent.  # noqa: E501

        Description of the event with HTML for nicer rendering.  # noqa: E501

        :return: The description_html of this DetectionDetectionEvent.  # noqa: E501
        :rtype: str
        """
        return self._description_html

    @description_html.setter
    def description_html(self, description_html):
        """Sets the description_html of this DetectionDetectionEvent.

        Description of the event with HTML for nicer rendering.  # noqa: E501

        :param description_html: The description_html of this DetectionDetectionEvent.  # noqa: E501
        :type: str
        """

        self._description_html = description_html

    @property
    def resolution(self):
        """Gets the resolution of this DetectionDetectionEvent.  # noqa: E501


        :return: The resolution of this DetectionDetectionEvent.  # noqa: E501
        :rtype: DetectionResolution
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution):
        """Sets the resolution of this DetectionDetectionEvent.


        :param resolution: The resolution of this DetectionDetectionEvent.  # noqa: E501
        :type: DetectionResolution
        """

        self._resolution = resolution

    @property
    def detail(self):
        """Gets the detail of this DetectionDetectionEvent.  # noqa: E501


        :return: The detail of this DetectionDetectionEvent.  # noqa: E501
        :rtype: DetectionEventDetail
        """
        return self._detail

    @detail.setter
    def detail(self, detail):
        """Sets the detail of this DetectionDetectionEvent.


        :param detail: The detail of this DetectionDetectionEvent.  # noqa: E501
        :type: DetectionEventDetail
        """

        self._detail = detail

    @property
    def rca_role(self):
        """Gets the rca_role of this DetectionDetectionEvent.  # noqa: E501


        :return: The rca_role of this DetectionDetectionEvent.  # noqa: E501
        :rtype: RcaRCARole
        """
        return self._rca_role

    @rca_role.setter
    def rca_role(self, rca_role):
        """Sets the rca_role of this DetectionDetectionEvent.


        :param rca_role: The rca_role of this DetectionDetectionEvent.  # noqa: E501
        :type: RcaRCARole
        """

        self._rca_role = rca_role

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DetectionDetectionEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DetectionDetectionEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
