# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DatasetDataset(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'dataset_id': 'str',
        'project_ids': 'list[RimeUUID]',
        'creator_id': 'RimeUUID',
        'creation_time': 'datetime',
        'user_metadata': 'SchemaregistryMetadata',
        'integration_id': 'RimeUUID',
        'data_info': 'TestrunSingleDataInfo',
        'ct_info': 'DatasetCTInfo'
    }

    attribute_map = {
        'name': 'name',
        'dataset_id': 'datasetId',
        'project_ids': 'projectIds',
        'creator_id': 'creatorId',
        'creation_time': 'creationTime',
        'user_metadata': 'userMetadata',
        'integration_id': 'integrationId',
        'data_info': 'dataInfo',
        'ct_info': 'ctInfo'
    }

    def __init__(self, name=None, dataset_id=None, project_ids=None, creator_id=None, creation_time=None, user_metadata=None, integration_id=None, data_info=None, ct_info=None):  # noqa: E501
        """DatasetDataset - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._dataset_id = None
        self._project_ids = None
        self._creator_id = None
        self._creation_time = None
        self._user_metadata = None
        self._integration_id = None
        self._data_info = None
        self._ct_info = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if dataset_id is not None:
            self.dataset_id = dataset_id
        if project_ids is not None:
            self.project_ids = project_ids
        if creator_id is not None:
            self.creator_id = creator_id
        if creation_time is not None:
            self.creation_time = creation_time
        if user_metadata is not None:
            self.user_metadata = user_metadata
        if integration_id is not None:
            self.integration_id = integration_id
        if data_info is not None:
            self.data_info = data_info
        if ct_info is not None:
            self.ct_info = ct_info

    @property
    def name(self):
        """Gets the name of this DatasetDataset.  # noqa: E501

        Name and dataset_id are both enforced to be unique. Name is user specified. dataset_id is internally generated. It is semantically determined as firewall_id#start_time#end_time in the case the CTInfo is provided.  # noqa: E501

        :return: The name of this DatasetDataset.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatasetDataset.

        Name and dataset_id are both enforced to be unique. Name is user specified. dataset_id is internally generated. It is semantically determined as firewall_id#start_time#end_time in the case the CTInfo is provided.  # noqa: E501

        :param name: The name of this DatasetDataset.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def dataset_id(self):
        """Gets the dataset_id of this DatasetDataset.  # noqa: E501


        :return: The dataset_id of this DatasetDataset.  # noqa: E501
        :rtype: str
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this DatasetDataset.


        :param dataset_id: The dataset_id of this DatasetDataset.  # noqa: E501
        :type: str
        """

        self._dataset_id = dataset_id

    @property
    def project_ids(self):
        """Gets the project_ids of this DatasetDataset.  # noqa: E501

        For now, a dataset will only have one project_id associated with it. We make this an array to allow dataset's to be shared in the future.  # noqa: E501

        :return: The project_ids of this DatasetDataset.  # noqa: E501
        :rtype: list[RimeUUID]
        """
        return self._project_ids

    @project_ids.setter
    def project_ids(self, project_ids):
        """Sets the project_ids of this DatasetDataset.

        For now, a dataset will only have one project_id associated with it. We make this an array to allow dataset's to be shared in the future.  # noqa: E501

        :param project_ids: The project_ids of this DatasetDataset.  # noqa: E501
        :type: list[RimeUUID]
        """

        self._project_ids = project_ids

    @property
    def creator_id(self):
        """Gets the creator_id of this DatasetDataset.  # noqa: E501


        :return: The creator_id of this DatasetDataset.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this DatasetDataset.


        :param creator_id: The creator_id of this DatasetDataset.  # noqa: E501
        :type: RimeUUID
        """

        self._creator_id = creator_id

    @property
    def creation_time(self):
        """Gets the creation_time of this DatasetDataset.  # noqa: E501


        :return: The creation_time of this DatasetDataset.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this DatasetDataset.


        :param creation_time: The creation_time of this DatasetDataset.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    @property
    def user_metadata(self):
        """Gets the user_metadata of this DatasetDataset.  # noqa: E501


        :return: The user_metadata of this DatasetDataset.  # noqa: E501
        :rtype: SchemaregistryMetadata
        """
        return self._user_metadata

    @user_metadata.setter
    def user_metadata(self, user_metadata):
        """Sets the user_metadata of this DatasetDataset.


        :param user_metadata: The user_metadata of this DatasetDataset.  # noqa: E501
        :type: SchemaregistryMetadata
        """

        self._user_metadata = user_metadata

    @property
    def integration_id(self):
        """Gets the integration_id of this DatasetDataset.  # noqa: E501


        :return: The integration_id of this DatasetDataset.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """Sets the integration_id of this DatasetDataset.


        :param integration_id: The integration_id of this DatasetDataset.  # noqa: E501
        :type: RimeUUID
        """

        self._integration_id = integration_id

    @property
    def data_info(self):
        """Gets the data_info of this DatasetDataset.  # noqa: E501


        :return: The data_info of this DatasetDataset.  # noqa: E501
        :rtype: TestrunSingleDataInfo
        """
        return self._data_info

    @data_info.setter
    def data_info(self, data_info):
        """Sets the data_info of this DatasetDataset.


        :param data_info: The data_info of this DatasetDataset.  # noqa: E501
        :type: TestrunSingleDataInfo
        """

        self._data_info = data_info

    @property
    def ct_info(self):
        """Gets the ct_info of this DatasetDataset.  # noqa: E501


        :return: The ct_info of this DatasetDataset.  # noqa: E501
        :rtype: DatasetCTInfo
        """
        return self._ct_info

    @ct_info.setter
    def ct_info(self, ct_info):
        """Sets the ct_info of this DatasetDataset.


        :param ct_info: The ct_info of this DatasetDataset.  # noqa: E501
        :type: DatasetCTInfo
        """

        self._ct_info = ct_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DatasetDataset, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatasetDataset):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
