# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_result.ipynb (unless otherwise specified).

__all__ = ['DetailLevel', 'SentenceResult']

# Cell
from flair.data import Sentence
from typing import List
import torch

#nbdev_comment _all_ = ['DetailLevel']

# Cell
from fastcore.basics import mk_class

mk_class('DetailLevel', **{o:o.lower() for o in 'High,Medium,Low'.split(',')},
         doc="All possible naming conventions for DetailLevel with typo-proofing")

# Cell
class SentenceResult:
    """
    A result class designed around Flair `Sentences`

    The base class has `tokenized_inputs` and `inputs`
    """
    def __init__(
        self,
        sentences:List[Sentence] # A list of `Sentence` objects
    ):
        self._sentences = sentences

    @property
    def tokenized_inputs(
        self
    ) -> List[str]:
        "The original tokenized inputs"
        return [s.to_tokenized_string() for s in self._sentences]

    @property
    def inputs(
        self
    ) -> List[str]:
        "The original text inputs"
        return [s.to_original_text() for s in self._sentences]