class key_codes:
    # ACTION_DOWN	getAction() value: the key has been pressed down.
    ACTION_DOWN: int = 0
    # ACTION_MULTIPLE	getAction() value: multiple duplicate key events have occurred in a row, or a complex string is being delivered.
    ACTION_MULTIPLE: int = 2
    # ACTION_UP	getAction() value: the key has been released.
    ACTION_UP: int = 1
    # FLAG_CANCELED	When associated with up key events, this indicates that the key press has been canceled.
    FLAG_CANCELED: int = 32
    # FLAG_CANCELED_LONG_PRESS	Set when a key event has FLAG_CANCELED set because a long press action was executed while it was down.
    FLAG_CANCELED_LONG_PRESS: int = 256
    # FLAG_EDITOR_ACTION	This mask is used for compatibility, to identify enter keys that are coming from an IME whose enter key has been auto-labelled "next" or "done".
    FLAG_EDITOR_ACTION: int = 16
    # FLAG_FALLBACK	Set when a key event has been synthesized to implement default behavior for an event that the application did not handle.
    FLAG_FALLBACK: int = 1024
    # FLAG_FROM_SYSTEM	This mask is set if an event was known to come from a trusted part of the system.
    FLAG_FROM_SYSTEM: int = 8
    # FLAG_KEEP_TOUCH_MODE	This mask is set if we don't want the key event to cause us to leave touch mode.
    FLAG_KEEP_TOUCH_MODE: int = 4
    # FLAG_LONG_PRESS	This flag is set for the first key repeat that occurs after the long press timeout.
    FLAG_LONG_PRESS: int = 128
    # FLAG_SOFT_KEYBOARD	This mask is set if the key event was generated by a software keyboard.
    FLAG_SOFT_KEYBOARD: int = 2
    # FLAG_TRACKING	Set for ACTION_UP when this event's key code is still being tracked from its initial down.
    FLAG_TRACKING: int = 512
    # FLAG_VIRTUAL_HARD_KEY	This key event was generated by a virtual (on-screen) hard key area.
    FLAG_VIRTUAL_HARD_KEY: int = 64
    # FLAG_WOKE_HERE	This mask is set if the device woke because of this key event.
    FLAG_WOKE_HERE: int = 1
    KEYCODE_0: int = 7  # KEYCODE_0	Key code constant: '0' key.
    KEYCODE_1: int = 8  # KEYCODE_1	Key code constant: '1' key.
    KEYCODE_2: int = 9  # KEYCODE_2	Key code constant: '2' key.
    KEYCODE_3: int = 10  # KEYCODE_3	Key code constant: '3' key.
    # KEYCODE_3D_MODE	Key code constant: 3D Mode key.
    KEYCODE_3D_MODE: int = 206
    KEYCODE_4: int = 11  # KEYCODE_4	Key code constant: '4' key.
    KEYCODE_5: int = 12  # KEYCODE_5	Key code constant: '5' key.
    KEYCODE_6: int = 13  # KEYCODE_6	Key code constant: '6' key.
    KEYCODE_7: int = 14  # KEYCODE_7	Key code constant: '7' key.
    KEYCODE_8: int = 15  # KEYCODE_8	Key code constant: '8' key.
    KEYCODE_9: int = 16  # KEYCODE_9	Key code constant: '9' key.
    KEYCODE_A: int = 29  # KEYCODE_A	Key code constant: 'A' key.
    # KEYCODE_ALT_LEFT	Key code constant: Left Alt modifier key.
    KEYCODE_ALT_LEFT: int = 57
    # KEYCODE_ALT_RIGHT	Key code constant: Right Alt modifier key.
    KEYCODE_ALT_RIGHT: int = 58
    KEYCODE_APOSTROPHE: int = 75  # KEYCODE_APOSTROPHE	Key code constant: ''' (apostrophe) key.
    KEYCODE_APP_SWITCH: int = 187  # KEYCODE_APP_SWITCH	Key code constant: App switch key.
    KEYCODE_ASSIST: int = 219  # KEYCODE_ASSIST	Key code constant: Assist key.
    KEYCODE_AT: int = 77  # KEYCODE_AT	Key code constant: '@' key.
    # KEYCODE_AVR_INPUT	Key code constant: A/V Receiver input key.
    KEYCODE_AVR_INPUT: int = 182
    # KEYCODE_AVR_POWER	Key code constant: A/V Receiver power key.
    KEYCODE_AVR_POWER: int = 181
    KEYCODE_B: int = 30  # KEYCODE_B	Key code constant: 'B' key.
    KEYCODE_BACK: int = 4  # KEYCODE_BACK	Key code constant: Back key.
    # KEYCODE_BACKSLASH	Key code constant: '\' key.
    KEYCODE_BACKSLASH: int = 73
    # KEYCODE_BOOKMARK	Key code constant: Bookmark key.
    KEYCODE_BOOKMARK: int = 174
    # KEYCODE_BREAK	Key code constant: Break / Pause key.
    KEYCODE_BREAK: int = 121
    # KEYCODE_BUTTON_1	Key code constant: Generic Game Pad Button 	1
    KEYCODE_BUTTON_1: int = 188
    # KEYCODE_BUTTON_10	Key code constant: Generic Game Pad Button 	10
    KEYCODE_BUTTON_10: int = 197
    # KEYCODE_BUTTON_11	Key code constant: Generic Game Pad Button 	11
    KEYCODE_BUTTON_11: int = 198
    # KEYCODE_BUTTON_12	Key code constant: Generic Game Pad Button 	12
    KEYCODE_BUTTON_12: int = 199
    # KEYCODE_BUTTON_13	Key code constant: Generic Game Pad Button 	13
    KEYCODE_BUTTON_13: int = 200
    # KEYCODE_BUTTON_14	Key code constant: Generic Game Pad Button 	14
    KEYCODE_BUTTON_14: int = 201
    # KEYCODE_BUTTON_15	Key code constant: Generic Game Pad Button 	15
    KEYCODE_BUTTON_15: int = 202
    # KEYCODE_BUTTON_16	Key code constant: Generic Game Pad Button 	16
    KEYCODE_BUTTON_16: int = 203
    # KEYCODE_BUTTON_2	Key code constant: Generic Game Pad Button 	2
    KEYCODE_BUTTON_2: int = 189
    # KEYCODE_BUTTON_3	Key code constant: Generic Game Pad Button 	3
    KEYCODE_BUTTON_3: int = 190
    # KEYCODE_BUTTON_4	Key code constant: Generic Game Pad Button 	4
    KEYCODE_BUTTON_4: int = 191
    # KEYCODE_BUTTON_5	Key code constant: Generic Game Pad Button 	5
    KEYCODE_BUTTON_5: int = 192
    # KEYCODE_BUTTON_6	Key code constant: Generic Game Pad Button 	6
    KEYCODE_BUTTON_6: int = 193
    # KEYCODE_BUTTON_7	Key code constant: Generic Game Pad Button 	7
    KEYCODE_BUTTON_7: int = 194
    # KEYCODE_BUTTON_8	Key code constant: Generic Game Pad Button 	8
    KEYCODE_BUTTON_8: int = 195
    # KEYCODE_BUTTON_9	Key code constant: Generic Game Pad Button 	9
    KEYCODE_BUTTON_9: int = 196
    # KEYCODE_BUTTON_A	Key code constant: A Button key.
    KEYCODE_BUTTON_A: int = 96
    # KEYCODE_BUTTON_B	Key code constant: B Button key.
    KEYCODE_BUTTON_B: int = 97
    # KEYCODE_BUTTON_C	Key code constant: C Button key.
    KEYCODE_BUTTON_C: int = 98
    # KEYCODE_BUTTON_L1	Key code constant: L1 Button key.
    KEYCODE_BUTTON_L1: int = 102
    # KEYCODE_BUTTON_L2	Key code constant: L2 Button key.
    KEYCODE_BUTTON_L2: int = 104
    # KEYCODE_BUTTON_MODE	Key code constant: Mode Button key.
    KEYCODE_BUTTON_MODE: int = 110
    # KEYCODE_BUTTON_R1	Key code constant: R1 Button key.
    KEYCODE_BUTTON_R1: int = 103
    # KEYCODE_BUTTON_R2	Key code constant: R2 Button key.
    KEYCODE_BUTTON_R2: int = 105
    # KEYCODE_BUTTON_SELECT	Key code constant: Select Button key.
    KEYCODE_BUTTON_SELECT: int = 109
    # KEYCODE_BUTTON_START	Key code constant: Start Button key.
    KEYCODE_BUTTON_START: int = 108
    # KEYCODE_BUTTON_THUMBL	Key code constant: Left Thumb Button key.
    KEYCODE_BUTTON_THUMBL: int = 106
    # KEYCODE_BUTTON_THUMBR	Key code constant: Right Thumb Button key.
    KEYCODE_BUTTON_THUMBR: int = 107
    # KEYCODE_BUTTON_X	Key code constant: X Button key.
    KEYCODE_BUTTON_X: int = 99
    # KEYCODE_BUTTON_Y	Key code constant: Y Button key.
    KEYCODE_BUTTON_Y: int = 100
    # KEYCODE_BUTTON_Z	Key code constant: Z Button key.
    KEYCODE_BUTTON_Z: int = 101
    KEYCODE_C: int = 31  # KEYCODE_C	Key code constant: 'C' key.
    # KEYCODE_CALCULATOR	Key code constant: Calculator special function key.
    KEYCODE_CALCULATOR: int = 210
    # KEYCODE_CALENDAR	Key code constant: Calendar special function key.
    KEYCODE_CALENDAR: int = 208
    KEYCODE_CALL: int = 5  # KEYCODE_CALL	Key code constant: Call key.
    KEYCODE_CAMERA: int = 27  # KEYCODE_CAMERA	Key code constant: Camera key.
    # KEYCODE_CAPS_LOCK	Key code constant: Caps Lock key.
    KEYCODE_CAPS_LOCK: int = 115
    # KEYCODE_CAPTIONS	Key code constant: Toggle captions key.
    KEYCODE_CAPTIONS: int = 175
    # KEYCODE_CHANNEL_DOWN	Key code constant: Channel down key.
    KEYCODE_CHANNEL_DOWN: int = 167
    # KEYCODE_CHANNEL_UP	Key code constant: Channel up key.
    KEYCODE_CHANNEL_UP: int = 166
    KEYCODE_CLEAR: int = 28  # KEYCODE_CLEAR	Key code constant: Clear key.
    KEYCODE_COMMA: int = 55  # KEYCODE_COMMA	Key code constant: ',' key.
    # KEYCODE_CONTACTS	Key code constant: Contacts special function key.
    KEYCODE_CONTACTS: int = 207
    # KEYCODE_CTRL_LEFT	Key code constant: Left Control modifier key.
    KEYCODE_CTRL_LEFT: int = 113
    # KEYCODE_CTRL_RIGHT	Key code constant: Right Control modifier key.
    KEYCODE_CTRL_RIGHT: int = 114
    KEYCODE_D: int = 32  # KEYCODE_D	Key code constant: 'D' key.
    KEYCODE_DEL: int = 67  # KEYCODE_DEL	Key code constant: Backspace key.
    # KEYCODE_DPAD_CENTER	Key code constant: Directional Pad Center key.
    KEYCODE_DPAD_CENTER: int = 23
    # KEYCODE_DPAD_DOWN	Key code constant: Directional Pad Down key.
    KEYCODE_DPAD_DOWN: int = 20
    # KEYCODE_DPAD_LEFT	Key code constant: Directional Pad Left key.
    KEYCODE_DPAD_LEFT: int = 21
    # KEYCODE_DPAD_RIGHT	Key code constant: Directional Pad Right key.
    KEYCODE_DPAD_RIGHT: int = 22
    # KEYCODE_DPAD_UP	Key code constant: Directional Pad Up key.
    KEYCODE_DPAD_UP: int = 19
    KEYCODE_DVR: int = 173  # KEYCODE_DVR	Key code constant: DVR key.
    KEYCODE_E: int = 33  # KEYCODE_E	Key code constant: 'E' key.
    # KEYCODE_EISU	Key code constant: Japanese alphanumeric key.
    KEYCODE_EISU: int = 212
    # KEYCODE_ENDCALL	Key code constant: End Call key.
    KEYCODE_ENDCALL: int = 6
    KEYCODE_ENTER: int = 66  # KEYCODE_ENTER	Key code constant: Enter key.
    # KEYCODE_ENVELOPE	Key code constant: Envelope special function key.
    KEYCODE_ENVELOPE: int = 65
    KEYCODE_EQUALS: int = 70  # KEYCODE_EQUALS	Key code constant: '=' key.
    KEYCODE_ESCAPE: int = 111  # KEYCODE_ESCAPE	Key code constant: Escape key.
    # KEYCODE_EXPLORER	Key code constant: Explorer special function key.
    KEYCODE_EXPLORER: int = 64
    KEYCODE_F: int = 34  # KEYCODE_F	Key code constant: 'F' key.
    KEYCODE_F1: int = 131  # KEYCODE_F1	Key code constant: F1 key.
    KEYCODE_F10: int = 140  # KEYCODE_F10	Key code constant: F10 key.
    KEYCODE_F11: int = 141  # KEYCODE_F11	Key code constant: F11 key.
    KEYCODE_F12: int = 142  # KEYCODE_F12	Key code constant: F12 key.
    KEYCODE_F2: int = 132  # KEYCODE_F2	Key code constant: F2 key.
    KEYCODE_F3: int = 133  # KEYCODE_F3	Key code constant: F3 key.
    KEYCODE_F4: int = 134  # KEYCODE_F4	Key code constant: F4 key.
    KEYCODE_F5: int = 135  # KEYCODE_F5	Key code constant: F5 key.
    KEYCODE_F6: int = 136  # KEYCODE_F6	Key code constant: F6 key.
    KEYCODE_F7: int = 137  # KEYCODE_F7	Key code constant: F7 key.
    KEYCODE_F8: int = 138  # KEYCODE_F8	Key code constant: F8 key.
    KEYCODE_F9: int = 139  # KEYCODE_F9	Key code constant: F9 key.
    # KEYCODE_FOCUS	Key code constant: Camera Focus key.
    KEYCODE_FOCUS: int = 80
    # KEYCODE_FORWARD	Key code constant: Forward key.
    KEYCODE_FORWARD: int = 125
    # KEYCODE_FORWARD_DEL	Key code constant: Forward Delete key.
    KEYCODE_FORWARD_DEL: int = 112
    # KEYCODE_FUNCTION	Key code constant: Function modifier key.
    KEYCODE_FUNCTION: int = 119
    KEYCODE_G: int = 35  # KEYCODE_G	Key code constant: 'G' key.
    # KEYCODE_GRAVE	Key code constant: '`' (backtick) key.
    KEYCODE_GRAVE: int = 68
    KEYCODE_GUIDE: int = 172  # KEYCODE_GUIDE	Key code constant: Guide key.
    KEYCODE_H: int = 36  # KEYCODE_H	Key code constant: 'H' key.
    # KEYCODE_HEADSETHOOK	Key code constant: Headset Hook key.
    KEYCODE_HEADSETHOOK: int = 79
    # KEYCODE_HENKAN	Key code constant: Japanese conversion key.
    KEYCODE_HENKAN: int = 214
    KEYCODE_HOME: int = 3  # KEYCODE_HOME	Key code constant: Home key.
    KEYCODE_I: int = 37  # KEYCODE_I	Key code constant: 'I' key.
    KEYCODE_INFO: int = 165  # KEYCODE_INFO	Key code constant: Info key.
    KEYCODE_INSERT: int = 124  # KEYCODE_INSERT	Key code constant: Insert key.
    KEYCODE_J: int = 38  # KEYCODE_J	Key code constant: 'J' key.
    KEYCODE_K: int = 39  # KEYCODE_K	Key code constant: 'K' key.
    # KEYCODE_KANA	Key code constant: Japanese kana key.
    KEYCODE_KANA: int = 218
    # KEYCODE_KATAKANA_HIRAGANA	Key code constant: Japanese katakana / hiragana key.
    KEYCODE_KATAKANA_HIRAGANA: int = 215
    KEYCODE_L: int = 40  # KEYCODE_L	Key code constant: 'L' key.
    # KEYCODE_LANGUAGE_SWITCH	Key code constant: Language Switch key.
    KEYCODE_LANGUAGE_SWITCH: int = 204
    # KEYCODE_LEFT_BRACKET	Key code constant: '[' key.
    KEYCODE_LEFT_BRACKET: int = 71
    KEYCODE_M: int = 41  # KEYCODE_M	Key code constant: 'M' key.
    # KEYCODE_MANNER_MODE	Key code constant: Manner Mode key.
    KEYCODE_MANNER_MODE: int = 205
    # KEYCODE_MEDIA_CLOSE	Key code constant: Close media key.
    KEYCODE_MEDIA_CLOSE: int = 128
    # KEYCODE_MEDIA_EJECT	Key code constant: Eject media key.
    KEYCODE_MEDIA_EJECT: int = 129
    # KEYCODE_MEDIA_FAST_FORWARD	Key code constant: Fast Forward media key.
    KEYCODE_MEDIA_FAST_FORWARD: int = 90
    # KEYCODE_MEDIA_NEXT	Key code constant: Play Next media key.
    KEYCODE_MEDIA_NEXT: int = 87
    # KEYCODE_MEDIA_PAUSE	Key code constant: Pause media key.
    KEYCODE_MEDIA_PAUSE: int = 127
    # KEYCODE_MEDIA_PLAY	Key code constant: Play media key.
    KEYCODE_MEDIA_PLAY: int = 126
    # KEYCODE_MEDIA_PLAY_PAUSE	Key code constant: Play/Pause media key.
    KEYCODE_MEDIA_PLAY_PAUSE: int = 85
    # KEYCODE_MEDIA_PREVIOUS	Key code constant: Play Previous media key.
    KEYCODE_MEDIA_PREVIOUS: int = 88
    # KEYCODE_MEDIA_RECORD	Key code constant: Record media key.
    KEYCODE_MEDIA_RECORD: int = 130
    # KEYCODE_MEDIA_REWIND	Key code constant: Rewind media key.
    KEYCODE_MEDIA_REWIND: int = 89
    # KEYCODE_MEDIA_STOP	Key code constant: Stop media key.
    KEYCODE_MEDIA_STOP: int = 86
    KEYCODE_MENU: int = 82  # KEYCODE_MENU	Key code constant: Menu key.
    # KEYCODE_META_LEFT	Key code constant: Left Meta modifier key.
    KEYCODE_META_LEFT: int = 117
    # KEYCODE_META_RIGHT	Key code constant: Right Meta modifier key.
    KEYCODE_META_RIGHT: int = 118
    KEYCODE_MINUS: int = 69  # KEYCODE_MINUS	Key code constant: '-'.
    # KEYCODE_MOVE_END	Key code constant: End Movement key.
    KEYCODE_MOVE_END: int = 123
    # KEYCODE_MOVE_HOME	Key code constant: Home Movement key.
    KEYCODE_MOVE_HOME: int = 122
    # KEYCODE_MUHENKAN	Key code constant: Japanese non-conversion key.
    KEYCODE_MUHENKAN: int = 213
    # KEYCODE_MUSIC	Key code constant: Music special function key.
    KEYCODE_MUSIC: int = 209
    KEYCODE_MUTE: int = 91  # KEYCODE_MUTE	Key code constant: Mute key.
    KEYCODE_N: int = 42  # KEYCODE_N	Key code constant: 'N' key.
    # KEYCODE_NOTIFICATION	Key code constant: Notification key.
    KEYCODE_NOTIFICATION: int = 83
    # KEYCODE_NUM	Key code constant: Number modifier key.
    KEYCODE_NUM: int = 78
    # KEYCODE_NUMPAD_0	Key code constant: Numeric keypad '0' key.
    KEYCODE_NUMPAD_0: int = 144
    # KEYCODE_NUMPAD_1	Key code constant: Numeric keypad '1' key.
    KEYCODE_NUMPAD_1: int = 145
    # KEYCODE_NUMPAD_2	Key code constant: Numeric keypad '2' key.
    KEYCODE_NUMPAD_2: int = 146
    # KEYCODE_NUMPAD_3	Key code constant: Numeric keypad '3' key.
    KEYCODE_NUMPAD_3: int = 147
    # KEYCODE_NUMPAD_4	Key code constant: Numeric keypad '4' key.
    KEYCODE_NUMPAD_4: int = 148
    # KEYCODE_NUMPAD_5	Key code constant: Numeric keypad '5' key.
    KEYCODE_NUMPAD_5: int = 149
    # KEYCODE_NUMPAD_6	Key code constant: Numeric keypad '6' key.
    KEYCODE_NUMPAD_6: int = 150
    # KEYCODE_NUMPAD_7	Key code constant: Numeric keypad '7' key.
    KEYCODE_NUMPAD_7: int = 151
    # KEYCODE_NUMPAD_8	Key code constant: Numeric keypad '8' key.
    KEYCODE_NUMPAD_8: int = 152
    # KEYCODE_NUMPAD_9	Key code constant: Numeric keypad '9' key.
    KEYCODE_NUMPAD_9: int = 153
    # KEYCODE_NUMPAD_ADD	Key code constant: Numeric keypad '+' key (for addition).
    KEYCODE_NUMPAD_ADD: int = 157
    # KEYCODE_NUMPAD_COMMA	Key code constant: Numeric keypad ',' key (for decimals or digit grouping).
    KEYCODE_NUMPAD_COMMA: int = 159
    # KEYCODE_NUMPAD_DIVIDE	Key code constant: Numeric keypad '/' key (for division).
    KEYCODE_NUMPAD_DIVIDE: int = 154
    # KEYCODE_NUMPAD_DOT	Key code constant: Numeric keypad '.' key (for decimals or digit grouping).
    KEYCODE_NUMPAD_DOT: int = 158
    # KEYCODE_NUMPAD_ENTER	Key code constant: Numeric keypad Enter key.
    KEYCODE_NUMPAD_ENTER: int = 160
    # KEYCODE_NUMPAD_EQUALS	Key code constant: Numeric keypad '=' key.
    KEYCODE_NUMPAD_EQUALS: int = 161
    # KEYCODE_NUMPAD_LEFT_PAREN	Key code constant: Numeric keypad '(' key.
    KEYCODE_NUMPAD_LEFT_PAREN: int = 162
    # KEYCODE_NUMPAD_MULTIPLY	Key code constant: Numeric keypad '*' key (for multiplication).
    KEYCODE_NUMPAD_MULTIPLY: int = 155
    # KEYCODE_NUMPAD_RIGHT_PAREN	Key code constant: Numeric keypad ')' key.
    KEYCODE_NUMPAD_RIGHT_PAREN: int = 163
    # KEYCODE_NUMPAD_SUBTRACT	Key code constant: Numeric keypad '-' key (for subtraction).
    KEYCODE_NUMPAD_SUBTRACT: int = 156
    # KEYCODE_NUM_LOCK	Key code constant: Num Lock key.
    KEYCODE_NUM_LOCK: int = 143
    KEYCODE_O: int = 43  # KEYCODE_O	Key code constant: 'O' key.
    KEYCODE_P: int = 44  # KEYCODE_P	Key code constant: 'P' key.
    # KEYCODE_PAGE_DOWN	Key code constant: Page Down key.
    KEYCODE_PAGE_DOWN: int = 93
    # KEYCODE_PAGE_UP	Key code constant: Page Up key.
    KEYCODE_PAGE_UP: int = 92
    KEYCODE_PERIOD: int = 56  # KEYCODE_PERIOD	Key code constant: '.' key.
    # KEYCODE_PICTSYMBOLS	Key code constant: Picture Symbols modifier key.
    KEYCODE_PICTSYMBOLS: int = 94
    KEYCODE_PLUS: int = 81  # KEYCODE_PLUS	Key code constant: '+' key.
    KEYCODE_POUND: int = 18  # KEYCODE_POUND	Key code constant: '	' key.
    KEYCODE_POWER: int = 26  # KEYCODE_POWER	Key code constant: Power key.
    # KEYCODE_PROG_BLUE	Key code constant: Blue "programmable" key.
    KEYCODE_PROG_BLUE: int = 186
    # KEYCODE_PROG_GREEN	Key code constant: Green "programmable" key.
    KEYCODE_PROG_GREEN: int = 184
    # KEYCODE_PROG_RED	Key code constant: Red "programmable" key.
    KEYCODE_PROG_RED: int = 183
    # KEYCODE_PROG_YELLOW	Key code constant: Yellow "programmable" key.
    KEYCODE_PROG_YELLOW: int = 185
    KEYCODE_Q: int = 45  # KEYCODE_Q	Key code constant: 'Q' key.
    KEYCODE_R: int = 46  # KEYCODE_R	Key code constant: 'R' key.
    # KEYCODE_RIGHT_BRACKET	Key code constant: ']' key.
    KEYCODE_RIGHT_BRACKET: int = 72
    KEYCODE_RO: int = 217  # KEYCODE_RO	Key code constant: Japanese Ro key.
    KEYCODE_S: int = 47  # KEYCODE_S	Key code constant: 'S' key.
    # KEYCODE_SCROLL_LOCK	Key code constant: Scroll Lock key.
    KEYCODE_SCROLL_LOCK: int = 116
    KEYCODE_SEARCH: int = 84  # KEYCODE_SEARCH	Key code constant: Search key.
    # KEYCODE_SEMICOLON	Key code constant: ';' key.
    KEYCODE_SEMICOLON: int = 74
    # KEYCODE_SETTINGS	Key code constant: Settings key.
    KEYCODE_SETTINGS: int = 176
    # KEYCODE_SHIFT_LEFT	Key code constant: Left Shift modifier key.
    KEYCODE_SHIFT_LEFT: int = 59
    # KEYCODE_SHIFT_RIGHT	Key code constant: Right Shift modifier key.
    KEYCODE_SHIFT_RIGHT: int = 60
    KEYCODE_SLASH: int = 76  # KEYCODE_SLASH	Key code constant: '/' key.
    # KEYCODE_SOFT_LEFT	Key code constant: Soft Left key.
    KEYCODE_SOFT_LEFT: int = 1
    # KEYCODE_SOFT_RIGHT	Key code constant: Soft Right key.
    KEYCODE_SOFT_RIGHT: int = 2
    KEYCODE_SPACE: int = 62  # KEYCODE_SPACE	Key code constant: Space key.
    KEYCODE_STAR: int = 17  # KEYCODE_STAR	Key code constant: '*' key.
    # KEYCODE_STB_INPUT	Key code constant: Set-top-box input key.
    KEYCODE_STB_INPUT: int = 180
    # KEYCODE_STB_POWER	Key code constant: Set-top-box power key.
    KEYCODE_STB_POWER: int = 179
    # KEYCODE_SWITCH_CHARSET	Key code constant: Switch Charset modifier key.
    KEYCODE_SWITCH_CHARSET: int = 95
    # KEYCODE_SYM	Key code constant: Symbol modifier key.
    KEYCODE_SYM: int = 63
    # KEYCODE_SYSRQ	Key code constant: System Request / Print Screen key.
    KEYCODE_SYSRQ: int = 120
    KEYCODE_T: int = 48  # KEYCODE_T	Key code constant: 'T' key.
    KEYCODE_TAB: int = 61  # KEYCODE_TAB	Key code constant: Tab key.
    KEYCODE_TV: int = 170  # KEYCODE_TV	Key code constant: TV key.
    # KEYCODE_TV_INPUT	Key code constant: TV input key.
    KEYCODE_TV_INPUT: int = 178
    # KEYCODE_TV_POWER	Key code constant: TV power key.
    KEYCODE_TV_POWER: int = 177
    KEYCODE_U: int = 49  # KEYCODE_U	Key code constant: 'U' key.
    # KEYCODE_UNKNOWN	Key code constant: Unknown key code.
    KEYCODE_UNKNOWN: int = 0
    KEYCODE_V: int = 50  # KEYCODE_V	Key code constant: 'V' key.
    # KEYCODE_VOLUME_DOWN	Key code constant: Volume Down key.
    KEYCODE_VOLUME_DOWN: int = 25
    # KEYCODE_VOLUME_MUTE	Key code constant: Volume Mute key.
    KEYCODE_VOLUME_MUTE: int = 164
    # KEYCODE_VOLUME_UP	Key code constant: Volume Up key.
    KEYCODE_VOLUME_UP: int = 24
    KEYCODE_W: int = 51  # KEYCODE_W	Key code constant: 'W' key.
    KEYCODE_WINDOW: int = 171  # KEYCODE_WINDOW	Key code constant: Window key.
    KEYCODE_X: int = 52  # KEYCODE_X	Key code constant: 'X' key.
    KEYCODE_Y: int = 53  # KEYCODE_Y	Key code constant: 'Y' key.
    KEYCODE_YEN: int = 216  # KEYCODE_YEN	Key code constant: Japanese Yen key.
    KEYCODE_Z: int = 54  # KEYCODE_Z	Key code constant: 'Z' key.
    # KEYCODE_ZENKAKU_HANKAKU	Key code constant: Japanese full-width / half-width key.
    KEYCODE_ZENKAKU_HANKAKU: int = 211
    # KEYCODE_ZOOM_IN	Key code constant: Zoom in key.
    KEYCODE_ZOOM_IN: int = 168
    # KEYCODE_ZOOM_OUT	Key code constant: Zoom out key.
    KEYCODE_ZOOM_OUT: int = 169

    # MAX_KEYCODE	This constant was deprecated in API level 3. There are now more than MAX_KEYCODE keycodes. Use getMaxKeyCode() instead.
    MAX_KEYCODE: int = 84
    # META_ALT_LEFT_ON This mask is is used to check whether the left ALT meta key is pressed.
    META_ALT_LEFT_ON: int = 16
    # META_ALT_MASK		This mask is is a combination of META_ALT_ON, META_ALT_LEFT_ON and META_ALT_RIGHT_ON.
    META_ALT_MASK: int = 50
    # META_ALT_ON This mask is is used to check whether one of the ALT meta keys is pressed.
    META_ALT_ON: int = 2
    # META_ALT_RIGHT_ON This mask is is used to check whether the right the ALT meta key is pressed.
    META_ALT_RIGHT_ON: int = 32
    # META_CAPS_LOCK_ON This mask is is used to check whether the CAPS LOCK meta key is on.
    META_CAPS_LOCK_ON: int = 1048576
    # META_CTRL_LEFT_ON This mask is is used to check whether the left CTRL meta key is pressed.
    META_CTRL_LEFT_ON: int = 8192
    # META_CTRL_MASK		This mask is is a combination of META_CTRL_ON, META_CTRL_LEFT_ON and META_CTRL_RIGHT_ON.
    META_CTRL_MASK: int = 28672
    # META_CTRL_ON This mask is is used to check whether one of the CTRL meta keys is pressed.
    META_CTRL_ON: int = 4096
    # META_CTRL_RIGHT_ON This mask is is used to check whether the right CTRL meta key is pressed.
    META_CTRL_RIGHT_ON: int = 16384
    # META_FUNCTION_ON This mask is is used to check whether the FUNCTION meta key is pressed.
    META_FUNCTION_ON: int = 8
    # META_META_LEFT_ON This mask is is used to check whether the left META meta key is pressed.
    META_META_LEFT_ON: int = 131072
    # META_META_MASK		This mask is is a combination of META_META_ON, META_META_LEFT_ON and META_META_RIGHT_ON.
    META_META_MASK: int = 458752
    # META_META_ON This mask is is used to check whether one of the META meta keys is pressed.
    META_META_ON: int = 65536
    # META_META_RIGHT_ON This mask is is used to check whether the right META meta key is pressed.
    META_META_RIGHT_ON: int = 262144
    # META_NUM_LOCK_ON This mask is is used to check whether the NUM LOCK meta key is on.
    META_NUM_LOCK_ON: int = 2097152
    # META_SCROLL_LOCK_ON This mask is is used to check whether the SCROLL LOCK meta key is on.
    META_SCROLL_LOCK_ON: int = 4194304
    # META_SHIFT_LEFT_ON This mask is is used to check whether the left SHIFT meta key is pressed.
    META_SHIFT_LEFT_ON: int = 64
    # META_SHIFT_MASK		This mask is is a combination of META_SHIFT_ON, META_SHIFT_LEFT_ON and META_SHIFT_RIGHT_ON.
    META_SHIFT_MASK: int = 193
    # META_SHIFT_ON This mask is is used to check whether one of the SHIFT meta keys is pressed.
    META_SHIFT_ON: int = 1
    # META_SHIFT_RIGHT_ON This mask is is used to check whether the right SHIFT meta key is pressed.
    META_SHIFT_RIGHT_ON: int = 128
    # META_SYM_ON This mask is is used to check whether the SYM meta key is pressed.
    META_SYM_ON: int = 4
