# -*- coding: utf-8 -*-
# Generated by Django 1.10.1 on 2016-09-28 08:46
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_userforeignkey.models.fields
import uuid


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ChangeRecord',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='Primary Key as Python UUID4 Field')),
                ('field_name', models.CharField(editable=False, max_length=255, verbose_name='Field name')),
                ('old_value', models.TextField(blank=True, editable=False, null=True, verbose_name='Old value')),
                ('new_value', models.TextField(blank=True, editable=False, null=True, verbose_name='New value')),
                ('is_related', models.BooleanField(default=False, editable=False, verbose_name='Is change on related entity')),
            ],
            options={
                'get_latest_by': 'change_set__date',
                'ordering': ['-change_set__date', 'field_name'],
            },
        ),
        migrations.CreateModel(
            name='ChangeSet',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='Primary Key as Python UUID4 Field')),
                ('changeset_type', models.CharField(choices=[('I', 'Insert'), ('U', 'Update'), ('D', 'Delete')], default='I', editable=False, max_length=1, verbose_name='Changeset Type')),
                ('date', models.DateTimeField(auto_now_add=True, verbose_name='Date')),
                ('object_uuid', models.CharField(editable=False, max_length=255, verbose_name='Object UUID')),
                ('object_type', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='Object type')),
                ('user', django_userforeignkey.models.fields.UserForeignKey(blank=True, null=True, editable=False, on_delete=django.db.models.deletion.SET_NULL, related_name='all_changes', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'get_latest_by': 'date',
                'ordering': ['-date'],
            },
        ),
        migrations.AddField(
            model_name='changerecord',
            name='change_set',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='change_records', to='django_changeset.ChangeSet'),
        ),
    ]
