# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['micropy',
 'micropy.config',
 'micropy.data',
 'micropy.lib.stubber',
 'micropy.packages',
 'micropy.project',
 'micropy.project.modules',
 'micropy.project.template.src',
 'micropy.pyd',
 'micropy.stubs',
 'micropy.stubs.repositories',
 'micropy.utils']

package_data = \
{'': ['*'],
 'micropy.data': ['schemas/*'],
 'micropy.project': ['template/*', 'template/.vscode/*']}

install_requires = \
['GitPython==3.1.30',
 'Jinja2==3.1.2',
 'MarkupSafe==2.1.2',
 'attrs==22.2.0',
 'boltons==21.0.0',
 'cachier==1.5.4',
 'click==8.1.3',
 'distlib==0.3.6',
 'dpath==1.5.0',
 'jsonschema==3.2.0',
 'mypy==0.991',
 'packaging==21.3',
 'pydantic==1.10.4',
 'python-minifier==2.8.0',
 'questionary==1.10.0',
 'requests==2.28.2',
 'requirements-parser==0.2.0',
 'tqdm==4.64.1',
 'typing-extensions==4.4.0',
 'upydevice==0.3.8']

extras_require = \
{':python_version < "3.10"': ['importlib-metadata==5.2.0'],
 ':python_version < "3.10" and sys_platform == "win32"': ['rshell>=0.0.31,<0.0.32'],
 ':sys_platform != "win32"': ['rshell>=0.0.31,<0.0.32'],
 ':sys_platform == "win32"': ['colorama==0.4.6']}

entry_points = \
{'console_scripts': ['micropy = micropy.cli:cli']}

setup_kwargs = {
    'name': 'micropy-cli',
    'version': '4.1.0b0',
    'description': 'Micropython Project Management Tool with VSCode support, Linting, Intellisense, Dependency Management, and more!',
    'long_description': '# Micropy Cli [![PyPI][pypi-img]][pypi-url] [![PyPI - Python Version][pypiv-img]][pypi-url] [![Github - Test Micropy Cli][build-img]][build-url] [![Coverage Status][cover-img]][cover-url]\n\n\nMicropy Cli is a project management/generation tool for writing [Micropython](https://micropython.org/) code in modern IDEs such as VSCode.\nIts primary goal is to automate the process of creating a workspace complete with:\n\n* **Linting** compatible with Micropython\n* VSCode **Intellisense**\n* **Autocompletion**\n* Dependency Management\n* VCS Compatibility\n\n\n<p align=\'center\'>\n    <img width=\'95%\' src=\'.github/img/micropy.svg\' alt="Micropy Demo SVG">\n</p>\n\n[pypi-img]: https://img.shields.io/pypi/v/micropy-cli?logo=pypi&logoColor=white&style=flat-square\n[pypi-url]: https://pypi.org/project/micropy-cli/\n[pypiv-img]: https://img.shields.io/pypi/pyversions/micropy-cli.svg?style=flat-square&logo=python&logoColor=green\n[build-img]: https://img.shields.io/github/workflow/status/BradenM/micropy-cli/Test%20MicropyCli/master?logo=github&style=flat-square\n[build-url]: https://github.com/BradenM/micropy-cli/actions\n[cover-img]: https://img.shields.io/coveralls/github/BradenM/micropy-cli/master?style=flat-square&logo=coveralls\n[cover-url]: https://coveralls.io/github/BradenM/micropy-cli\n\n# Getting Started\n\n## Installation\n\nYou can download and install the latest version of this software from the Python package index (PyPI) as follows:\n\n`pip install --upgrade micropy-cli`\n\nIf applicable, you can test out a pre-release by executing:\n\n`pip install --upgrade --pre micropy-cli`\n\n\n\n## Creating a Project\n\nCreating a new project folder is as simple as:\n\n1. Executing `micropy init <PROJECT NAME>`\n2. Selecting which features to enable\n3. Selecting your target device/firmware\n4. Boom. Your workspace is ready.\n\n<p align=\'center\'>\n    <img src=\'https://github.com/BradenM/micropy-cli/raw/master/.github/img/demo.gif\' alt="Micropy Demo">\n</p>\n\n\n## Micropy Project Environment\n\nWhen creating a project with `micropy-cli`, two special items are added:\n\n* A `.micropy/` folder\n* A `micropy.json` file\n\nThe `.micropy/` contains symlinks from your project to your `$HOME/.micropy/stubs` folder. By doing this, micropy can reference the required stub files for your project as relative to it, rather than using absolute paths to `$HOME/.micropy`. How does this benefit you? Thanks to this feature, you can feel free to push common setting files such as `settings.json` and `.pylint.rc` to your remote git repository. This way, others who clone your repo can achieve a matching workspace in their local environment.\n\n> Note: The generated `.micropy/` folder should be *IGNORED* by your VCS. It is created locally for each environment via the `micropy.json` file.\n\nThe `micropy.json` file contains information micropy needs in order to resolve your projects required files when other clone your repo. Think of it as a `package.json` for micropython.\n\n## Cloning a Micropy Environment\n\nTo setup a Micropy environment locally, simply:\n\n* Install `micropy-cli`\n* Navigate to the project directory\n* Execute `micropy`\n\nMicropy will automatically configure and install any stubs required by a project thanks to its `micropy.json` file.\n\n## Project Dependencies\n\nWhile all modules that are included in your targeted micropython firmware are available with autocompletion, intellisense, and linting, most projects require external dependencies.\n\nCurrently, handling dependencies with micropython is a bit tricky. Maybe you can install a cpython version of your requirement? Maybe you could just copy and paste it? What if it needs to be frozen?\n\nMicropy handles all these issues for you automatically. Not only does it track your project\'s dependencies, it keeps both `requirements.txt` and `dev-requirements.txt` updated, enables autocompletion/intellisense for each dep, and allows you to import them just as you would on your device.\n\nThis allows you to include your requirement however you want, whether that be as a frozen module in your custom built firmware, or simply in the `/lib` folder on your device.\n\n#### Installing Packages\n\nTo add a package as a requirement for your project, run:\n\n`micropy install <PACKAGE_NAMES>`\n\nwhile in your project\'s root directory.\n\nThis will automatically execute the following:\n\n* Source `PACKAGE_NAMES` from pypi, as a url, or a local path\n* Retrieve the module/package and stub it, adding it to your local `.micropy` folder.\n* Add requirement to your `micropy.json`\n* Update `requirements.txt`\n\nTo install dev packages that are not needed on your device, but are needed for local development, add the `--dev` flag. This will do everything above **except** stub the requirement.\n\nYou can also install all requirements found in `micropy.json`/`requirements.txt`/`dev-requirements.txt` by executing `micropy install` without passing any packages. Micropy will automatically do this when setting up a local environment of an existing micropy project.\n\n#### Example\n\nLets say your new project will depend on [picoweb](https://pypi.org/project/picoweb/) and [blynklib](https://pypi.org/project/blynklib/). Plus, you\'d like to use [rshell](https://pypi.org/project/rshell/) to communicate directly with your device. After creating your project via `micropy init`, you can install your requirements as so:\n\n<p align=\'center\'>\n    <img width="70%" src=\'.github/img/install_demo.svg\' alt="Micropy Pkg Install Demo">\n</p>\n\nNow you or anybody cloning your project can import those requirements normally, and have the benefits of all the features micropy brings:\n\n<p align=\'center\'>\n    <img width="70%" src=\'https://github.com/BradenM/micropy-cli/raw/master/.github/img/deps_demo.gif\' alt="Micropy Deps Demo">\n</p>\n\n\n## Stub Management\n\nStub files are the magic behind how micropy allows features such as linting, Intellisense, and autocompletion to work. To achieve the best results with MicropyCli, its important that you first add the appropriate stubs for the device/firmware your project uses.\n\n> Note: When working in a micropy project, all stub related commands will also be executed on the active project. (i.e if in a project and you run `micropy stubs add <stub-name>`, then that stub retrieved AND added to the active project.)\n\n### Adding Stubs\n\nAdding stubs to Micropy is a breeze. Simply run: `micropy stubs add <STUB_NAME>`\nBy sourcing [micropy-stubs](https://github.com/BradenM/micropy-stubs), MicroPy has several premade stub packages to choose from.\n\nThese packages generally use the following naming schema:\n\n`<device>-<firmware>-<version>`\n\nFor example, running `micropy stubs add esp32-micropython-1.11.0` will install the following:\n* Micropython Specific Stubs\n* ESP32 Micropython v1.11 Device Specific Stubs\n* Frozen Modules for both device and firmware\n\nYou can search stubs that are made available to Micropy via `micropy stubs search <QUERY>`\n\nAlternatively, using `micropy stubs add <PATH>`, you can manually add stubs to Micropy.\nFor manual stub generation, please see [Josvel/micropython-stubber](https://github.com/Josverl/micropython-stubber).\n\n### Creating Stubs\n\nUsing `micropy stubs create <PORT/IP_ADDRESS>`, MicropyCli can automatically generate and add stubs from any Micropython device you have on hand. This can be done over both USB and WiFi.\n\n> Note: For stub creation, micropy-cli has additional dependencies.\n>\n> These can be installed by executing: `pip install micropy-cli[create_stubs]`\n\n\n### Viewing Stubs\n\nTo list stubs you have installed, simply run `micropy stubs list`.\n\nTo search for stubs for your device, use `micropy stubs search <QUERY>`.\n\n# See Also\n\n* [VSCode IntelliSense, Autocompletion & Linting capabilities][lemariva-blog]\n    - An awesome article written by [lemariva](https://github.com/lemariva). It covers creating a micropython project environment from scratch using `micropy-cli` and [pymakr-vsc](pymakr-vsc). Great place to start if you\'re new to this!\n\n* [Developing for the Raspberry Pi Pico in VS Code][cpwood-medium]\n    - A getting started guide for developing in micropython on the Raspberry Pi Pico by [cpwood][cpwood-git].\n    - Also see: [Pico-Go: Micropy-Cli][cpwood-picogo]\n\n* [Awesome MicroPython][awesome-micropy]\n    - Collection of awesome micropython libraries / resources.\n    - Features `micropy-cli` along with several other great development tools under the [Development][awesome-micropy-develop] category.\n\n\n[lemariva-blog]: https://lemariva.com/blog/2019/08/micropython-vsc-ide-intellisense\n[lemariva-git]:  https://github.com/lemariva\n\n[cpwood-medium]: https://medium.com/all-geek-to-me/developing-for-the-raspberry-pi-pico-in-vs-code-getting-started-6dbb3da5ba97\n[cpwood-picogo]: http://pico-go.net/docs/help/micropy/\n[cpwood-git]: https://github.com/cpwood/\n\n[awesome-micropy]: https://awesome-micropython.com/\n[awesome-micropy-develop]: https://awesome-micropython.com/#development\n\n# Acknowledgements\n\n## Micropython-Stubber\n[Josvel/micropython-stubber](https://github.com/Josverl/micropython-stubber)\n\nJosverl\'s Repo is full of information regarding Micropython compatibility with VSCode and more. To find out more about how this process works, take a look at it.\n\nmicropy-cli and [micropy-stubs](https://github.com/BradenM/micropy-stubs) depend on micropython-stubber for its ability to generate frozen modules, create stubs on a pyboard, and more.\n',
    'author': 'Braden Mars',
    'author_email': 'bradenmars@bradenmars.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/BradenM/micropy-cli',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.12',
}


setup(**setup_kwargs)
