from setuptools import setup

setup(
    name="pyCHIPS",
    version="0.1.0",
    packages=["chips"],
    package_dir={"chips": "chips"},
    package_data={"chips": []},
    author="Shibaji Chakraborty",
    author_email="shibaji7@vt.edu",
    maintainer="Shibaji Chakraborty",
    maintainer_email="shibaji7@vt.edu",
    license="MIT License",
    description="CHIPS: Coronal Hole Identification using Probabilistic Scheme",
    long_description="Identify coronal holes and coronal hole boundaries using probabilistic schemes",
    install_requires=[
        "pandas",
        "matplotlib>=3.2",
        "loguru",
        "xarray",
        "SciencePlots",
        "sunpy",
        "aiapy",
    ],
    keywords=[
        "python",
        "coronal hole",
        "coronal hole boundary",
        "coronal hole identification",
    ],
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Education",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Operating System :: OS Independent",
    ],
    url="https://github.com/shibaji7/CHIPS",
)
