# ISWAT - International Space Weather Action Teams
## Welcome to Coronal Hole Boundary Detection using CHIPS Algorithm

This project is a part of [COSPAR ISWAT](https://www.iswat-cospar.org/iswat-cospar). The COSPAR ISWAT initiative is a global hub for collaborations addressing challenges across the field of space weather.


### The objectives of this work are following: 
- First, to build a `openCV` and `CNN` based automated coronal hole detection schemes. 
- Second, to develop strategies to quantitatively assess the spatial and temporal uncertainty of coronal hole boundary locations. 
- Third, to use this information to further improve the predictive capabilities of ambient solar wind models.

### Setup 
- Download this Repository via git-clone.
- Make sure you have anaconda environment and conda running.
- Run `conda env create -f chips.yml` command to create `chips` environment.
- Run `ipython kernel install --user --name chips` to install ipython kernel.
- Run Ipython notebooks inside docs under `chips` envioronment.

Example output is given 

![Image](https://github.com/shibaji7/ISWAT_CV/blob/main/iswat_mva/data/mva.Figure03.png)
