export default {
  // x86_64
  rax: "register a extended (64-bit)",
  rbx: "register b extended (64-bit)",
  rcx: "register c extended (64-bit)",
  rdx: "register d extended (64-bit)",
  rbp: "base pointer (start of stack) (64-bit)",
  rsp: "stack pointer (current location in stack, growing downwards) (64-bit)",
  rsi: "source index (source for data copies) (64-bit)",
  rdi: "destination index (destination for data copies) (64-bit)",
  r8: "register 8 (64-bit)",
  r9: "register 9 (64-bit)",
  r10: "register 10 (64-bit)",
  r11: "register 11 (64-bit)",
  r12: "register 12 (64-bit)",
  r13: "register 13 (64-bit)",
  r14: "register 14 (64-bit)",
  r15: "register 15 (64-bit)",
  rip: "instruction pointer (points to next instruction to execute) (64-bit)",
  eflags:
    "32-bit register used as a collection of bits representing Boolean values to store the results of operations and the state of the processor",
  cs: "",
  ss: "",
  ds: "",
  es: "",
  fs: "",
  gs: "",
  st0: "",
  st1: "",
  st2: "",
  st3: "",
  st4: "",
  st5: "",
  st6: "",
  st7: "",
  fctrl: "",
  fstat: "",
  ftag: "",
  fiseg: "",
  fioff: "",
  foseg: "",
  fooff: "",
  fop: "",
  xmm0: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm1: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm2: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm3: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm4: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm5: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm6: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm7: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm8: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm9: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm10: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm11: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm12: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm13: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm14: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  xmm15: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
  mxcsr: "",

  ymm0h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm1h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm2h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm3h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm4h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm5h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm6h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm7h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm8h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm9h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm10h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm11h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm12h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm13h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm14h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm15h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",

  ymm0: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm1: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm2: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm3: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm4: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm5: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm6: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm7: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm8: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm9: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm10: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm11: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm12: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm13: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm14: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
  ymm15: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",

  orig_rax: "",
  al: "",
  bl: "",
  cl: "",
  dl: "",
  sil: "",
  dil: "",
  bpl: "",
  spl: "",
  r8l: "",
  r9l: "",
  r10l: "",
  r11l: "",
  r12l: "",
  r13l: "",
  r14l: "",
  r15l: "",
  ah: "",
  bh: "",
  ch: "",
  dh: "",
  ax: "lower 16-bits of eax (accumulator register, used in arithmetic operations)",
  bx: "lower 16-bits of ebx (base register)",
  cx:
    "lower 16-bits of ecx (counter register, used in shift/rotate instructions and loops)",
  dx: "lower 16-bits of edx (data register, used in arithmetic and I/O)",
  si: "lower 16-bits of esi (source index register)",
  di: "lower 16-bits of edi (destination index register)",
  bp: "lower 16-bits of ebp (base pointer register, points to base of stack)",
  r8w: "",
  r9w: "",
  r10w: "",
  r11w: "",
  r12w: "",
  r13w: "",
  r14w: "",
  r15w: "",
  eax: "general purpose 32-bit register",
  ebx: "general purpose 32-bit register",
  ecx: "general purpose 32-bit register",
  edx: "general purpose 32-bit register",
  esi: "general purpose 32-bit register",
  edi: "general purpose 32-bit register",
  ebp: "32-bit base pointer",

  // ARM
  R0: "Argument1, Return Value (Temporary register)",
  R1:
    "Argument2, Second 32-bits if double or 64-bit int return value (Temporary register)",
  R2: "Arguments (Temporary register)",
  R3: "Arguments (Temporary register)",
  R4: "R7 is THUMB frame pointer (Permanent register)",
  R5: "R7 is THUMB frame pointer (Permanent register)",
  R6: "R7 is THUMB frame pointer (Permanent register)",
  R7: "R7 is THUMB frame pointer (Permanent register)",
  R8: "R7 is THUMB frame pointer (Permanent register)",
  R9: "R7 is THUMB frame pointer (Permanent register)",
  R10: "R7 is THUMB frame pointer (Permanent register)",
  R11: "ARM frame pointer (Permanent register)",
  R12: "(Temporary register)",
  R13: "Stack pointer (Permanent register)",
  R14: "Link register (Permanent register)",
  R15: "Program counter",

  s0: "VFP single-precision (Temporary register)",
  s1: "VFP single-precision (Temporary register)",
  s2: "VFP single-precision (Temporary register)",
  s3: "VFP single-precision (Temporary register)",
  s4: "VFP single-precision (Temporary register)",
  s5: "VFP single-precision (Temporary register)",
  s6: "VFP single-precision (Temporary register)",
  s7: "VFP single-precision (Temporary register)",
  s8: "VFP single-precision (Temporary register)",
  s9: "VFP single-precision (Temporary register)",
  s10: "VFP single-precision (Temporary register)",
  s11: "VFP single-precision (Temporary register)",
  s12: "VFP single-precision (Temporary register)",
  s13: "VFP single-precision (Temporary register)",
  s14: "VFP single-precision (Temporary register)",
  s15: "VFP single-precision (Temporary register)",

  s16: "VFP single-precision (Permanent register)",
  s17: "VFP single-precision (Permanent register)",
  s18: "VFP single-precision (Permanent register)",
  s19: "VFP single-precision (Permanent register)",
  s20: "VFP single-precision (Permanent register)",
  s21: "VFP single-precision (Permanent register)",
  s22: "VFP single-precision (Permanent register)",
  s23: "VFP single-precision (Permanent register)",
  s24: "VFP single-precision (Permanent register)",
  s25: "VFP single-precision (Permanent register)",
  s26: "VFP single-precision (Permanent register)",
  s27: "VFP single-precision (Permanent register)",
  s28: "VFP single-precision (Permanent register)",
  s29: "VFP single-precision (Permanent register)",
  s30: "VFP single-precision (Permanent register)",
  s31: "VFP single-precision (Permanent register)",

  d0: "VFP double-precision (Temporary register)",
  d1: "VFP double-precision (Temporary register)",
  d2: "VFP double-precision (Temporary register)",
  d3: "VFP double-precision (Temporary register)",
  d4: "VFP double-precision (Temporary register)",
  d5: "VFP double-precision (Temporary register)",
  d6: "VFP double-precision (Temporary register)",
  d7: "VFP double-precision (Temporary register)",

  d8: "VFP double-precision (Permanent register)",
  d9: "VFP double-precision (Permanent register)",
  d10: "VFP double-precision (Permanent register)",
  d11: "VFP double-precision (Permanent register)",
  d12: "VFP double-precision (Permanent register)",
  d13: "VFP double-precision (Permanent register)",
  d14: "VFP double-precision (Permanent register)",
  d15: "VFP double-precision (Permanent register)",

  fpsid: "VFP system ID register",
  fpscr: "VFP status and control register",
  fpexc: "VFP expception register",

  wr0: "WMMX SIMD data register",
  wr1: "WMMX SIMD data register",
  wr2: "WMMX SIMD data register",
  wr3: "WMMX SIMD data register",
  wr4: "WMMX SIMD data register",
  wr5: "WMMX SIMD data register",
  wr6: "WMMX SIMD data register",
  wr7: "WMMX SIMD data register",
  wr8: "WMMX SIMD data register",
  wr9: "WMMX SIMD data register",
  wr10: "WMMX SIMD data register",
  wr11: "WMMX SIMD data register",
  wr12: "WMMX SIMD data register",
  wr13: "WMMX SIMD data register",
  wr14: "WMMX SIMD data register",
  wr15: "WMMX SIMD data register",
  wr16: "WMMX SIMD data register",

  wc0: "WMMX status and control register",
  wc1: "WMMX status and control register",
  wc2: "WMMX status and control register",
  wc3: "WMMX status and control register",
  wc4: "WMMX status and control register",
  wc5: "WMMX status and control register",
  wc6: "WMMX status and control register",
  wc7: "WMMX status and control register",
  wc8: "WMMX status and control register",
  wc9: "WMMX status and control register",
  wc10: "WMMX status and control register",
  wc11: "WMMX status and control register",
  wc12: "WMMX status and control register",
  wc13: "WMMX status and control register",
  wc14: "WMMX status and control register",
  wc15: "WMMX status and control register",
  wc16: "WMMX status and control register",

  wcid: "WMMX coprocessor ID register, synonymous with wc0",
  wcon: "WMMX control register, synonymous with wc1",
  wcssf: "WMMX saturation SIMD flags, synonymous with wc2",
  wcasf: "WMMX saturation SIMD flags, synonymous with wc3",

  wcgr0: "WMMX control general-purpose register, synonymous with wc8",
  wcgr1: "WMMX control general-purpose register, synonymous with wc9",
  wcgr2: "WMMX control general-purpose register, synonymous with wc10",
  wcgr3: "WMMX control general-purpose register, synonymous with wc11"
};
