#### This library enables you to report the status of tasks in your model at runtime

#### publish:

```shell
python -m build
twine upload --repository-url https://test.pypi.org/legacy/ dist/*

```

#### install: `pip install apeman-model-client==0.1.8`

#### How to use

```shell
export apeman_meta_server_addr='localhost:9090'
```

```python


from apeman.model.openapi import apeman_open_api_client
from apeman.model.openapi.model_instance_task_status import TaskStatus
from apeman.model.openapi.model_instance_task_launch_type import TaskLaunchType
from apeman.model.openapi.model_instance_task_type import TaskType


endpoint = apeman_open_api_client.get_endpoint(model_instance_id='')
# cancel task
apeman_open_api_client.cancel_task(task_id='', force_delete=True, token='')

# report status
response = apeman_open_api_client.report_and_get_status(task_id='', status=TaskStatus.RUNNING, progress=0.1,
                                                        message='Task is running', token='')

if response.status == TaskStatus.CANCELED:
    raise Exception('Task has been cancelled.')

# add instance task
apeman_open_api_client.add_model_instance_task(model_instance_id='', tenant_id='', task_token='', task_parameters='',
                                               job_context='', start_time=1, end_time=2,
                                               launch_type=TaskLaunchType.TASK_ADHOC, task_type=TaskType.TASK_TRAIN)
# get instance task
task = apeman_open_api_client.get_instance_task(model_instance_task_id='test', token='token')
print(task.taskProgress)
print(task.taskMessage)
print(task.taskStatus)


# add instance task
apeman_open_api_client.add_model_instance_task(model_instance_id='', tenant_id='', task_token='', task_parameters='',
                                               job_context='', start_time=1, end_time=2,
                                               launch_type=TaskLaunchType.TASK_ADHOC, task_type=TaskType.TASK_TRAIN)

task_id_list = ['1', '2', '3']
task_list_response = apeman_open_api_client.batch_get_model_instance_task(task_id_list=task_id_list)
print(task_list_response.model_instance_task_list)
```
